/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDDataTypeFactory;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.util.logging.Logger;

public class LogicalDatatype
extends DesignObject {
    public static final String[] UNITS = new String[]{"", "BYTE", "CHAR"};
    public static final ObjectChangeEvent FILENAME_CHANGED = new ObjectChangeEvent(Messages.getString("LogicalDatatype.DomainFilenameChanged"));
    public static final String PARAM_SCALE = "scale";
    public static final String PARAM_PRECISION = "precision";
    public static final String PARAM_SIZE = "size";
    private static final Logger LOGGER = new Logger(LogicalDatatype.class);
    private static final String[] STRING_PROTO = new String[0];
    private Set requiredParameterNamesSet = new HashSet();
    private String[] requiredParameterNames = null;
    private Map toPhysical = new TreeMap();
    private Class javaType = String.class;
    private static final String DEFAULT_FILE = "types";
    private String fileName = "types";
    private boolean readonly = false;
    private Map defaultValues = new TreeMap();

    public LogicalDatatype(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return "Logical Datatype";
    }

    public void put(String string, String string2) {
        this.toPhysical.put(string, string2);
        this.addParameterNames(string2);
    }

    protected void addParameterNames(String string) {
        String[] stringArray = MDDataTypeFactory.tokenize(string);
        if (stringArray.length > 1) {
            this.requiredParameterNames = null;
        }
        this.requiredParameterNamesSet.clear();
        for (int i = 1; i < stringArray.length; ++i) {
            this.requiredParameterNamesSet.add(stringArray[i]);
        }
    }

    public MDDataType createDataType(String string, Map map) {
        if (!this.toPhysical.containsKey(string)) {
            throw new RuntimeException("rdbmsName not known: " + string);
        }
        MDDataTypeFactory mDDataTypeFactory = MDDataTypeFactory.getInstance(string, this.getDesign().getAppView().getSettings());
        String[] stringArray = this.substituteParametersByValue((String)this.toPhysical.get(string), map);
        return mDDataTypeFactory.createStringEncodedType(stringArray);
    }

    @Override
    public String getIDPrefix() {
        return this.getPreference("log datatype id prefix");
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    public void setJavaType(Class clazz) {
        this.javaType = clazz;
    }

    public boolean setJavaType(String string) {
        try {
            this.javaType = Class.forName(string);
        }
        catch (Exception exception) {
            LOGGER.error("setJavaType(String): ", exception);
            return false;
        }
        return true;
    }

    public Class getJavaType() {
        return this.javaType;
    }

    public String getJavaTypeClassName() {
        return this.javaType.getName();
    }

    @Override
    public int getNumberOfChildren() {
        return this.toPhysical.size();
    }

    @Override
    public Object getChildPlain(int n) {
        Iterator iterator = this.toPhysical.keySet().iterator();
        for (int i = 0; i <= n && iterator.hasNext(); ++i) {
            Object v = this.toPhysical.get(iterator.next());
            if (i != n) continue;
            return v;
        }
        return null;
    }

    @Override
    public int getIndexForChild(Object object) {
        Iterator iterator = this.toPhysical.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ModelObject modelObject = (ModelObject)this.toPhysical.get(iterator.next());
            if (modelObject.equals(object)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public String getLongName() {
        return this.getName();
    }

    protected String[] substituteParametersByValue(String string, Map map) {
        String[] stringArray = MDDataTypeFactory.tokenize(string);
        return this.substituteParametersByValue(stringArray, map);
    }

    protected String[] substituteParametersByValue(String[] stringArray, Map map) {
        String[] stringArray2 = new String[stringArray.length];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            Object v = map.get(stringArray[i]);
            if (v == null) continue;
            stringArray2[i] = (String)v;
        }
        return stringArray2;
    }

    public String[] getRequiredParameters() {
        if (this.requiredParameterNames == null) {
            this.requiredParameterNames = this.requiredParameterNamesSet.toArray(STRING_PROTO);
        }
        return this.requiredParameterNames;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        if (!this.fileName.equals(string)) {
            this.fileName = string;
            if (DEFAULT_FILE.equals(string)) {
                this.setOwnerDesignName(Design.getSystemDesignName());
            }
            this.fireChange(FILENAME_CHANGED);
        }
    }

    public Map getToPhysical() {
        return this.toPhysical;
    }

    @Override
    public void showPropertyDialog() {
    }

    public static LogicalDatatype getLogicalDatatype(Design design, String string, String string2) {
        LogicalDatatype logicalDatatype = null;
        if (string2 != null) {
            logicalDatatype = (LogicalDatatype)design.getDesignObject(string2);
        }
        if (logicalDatatype == null && string != null) {
            logicalDatatype = design.getLogicalDatatypeSet().getLogTypeByName(string);
        }
        if (logicalDatatype == null && string2 != null) {
            if ("LOGDT002".equals(string2) || "LOGDT004".equals(string2) || "LOGDT012".equals(string2)) {
                logicalDatatype = design.getLogicalDatatypeSet().getLogTypeByName("VARCHAR");
            } else if ("LOGDT001".equals(string2) || "LOGDT003".equals(string2)) {
                logicalDatatype = design.getLogicalDatatypeSet().getLogTypeByName("CHAR");
            }
        }
        return logicalDatatype;
    }

    @Override
    public boolean isReadOnly() {
        return this.readonly;
    }

    @Override
    public void setReadOnly(boolean bl) {
        this.readonly = bl;
    }

    public void addDefaults(String string, TreeMap treeMap) {
        this.defaultValues.put(string, treeMap);
    }

    public Map getDefaultValues() {
        return this.defaultValues;
    }

    public void setDefaultValues(Map map) {
        this.defaultValues = map;
    }

    public Map getLTDefaultValues() {
        Map map;
        Design design = this.getDesign();
        Integer n = design.getAppView().getSettings().getDefaultRDBMSType();
        TreeMap<Integer, String> treeMap = new TreeMap<Integer, String>();
        Iterator iterator = design.getDefaultRDBMSTypeSet().iterator();
        while (iterator.hasNext()) {
            map = (RDBMSType)iterator.next();
            treeMap.put(((RDBMSType)((Object)map)).getType(), ((RDBMSType)((Object)map)).getName());
        }
        map = (Map)this.getDefaultValues().get(treeMap.get(n));
        if (map == null) {
            map = Collections.emptyMap();
        }
        return map;
    }

    public static boolean canBeUsedForPK(String string) {
        return !string.equalsIgnoreCase("BINARY") && !string.equalsIgnoreCase("BLOB") && !string.equalsIgnoreCase("CLOB") && !string.equalsIgnoreCase("NCLOB") && !string.equalsIgnoreCase("BFILE") && !string.equalsIgnoreCase("XML") && !string.equalsIgnoreCase("XMLTYPE") && !string.equalsIgnoreCase("URITYPE") && !string.equalsIgnoreCase("DBURITYPE") && !string.equalsIgnoreCase("HTTPURITYPE") && !string.equalsIgnoreCase("LONG") && !string.equalsIgnoreCase("LONG RAW") && !string.equalsIgnoreCase("XDBURITYPE") && !string.equalsIgnoreCase("SYS.ANYDATA") && !string.equalsIgnoreCase("SYS.ANYTYPE") && !string.equalsIgnoreCase("SYS.ANYDATASET") && !string.equalsIgnoreCase("ORDAudio") && !string.equalsIgnoreCase("ORDDoc") && !string.equalsIgnoreCase("ORDImage") && !string.equalsIgnoreCase("ORDImageSignature") && !string.equalsIgnoreCase("ORDSYS.ORDAudio") && !string.equalsIgnoreCase("ORDSYS.ORDDoc") && !string.equalsIgnoreCase("ORDSYS.ORDImage") && !string.equalsIgnoreCase("ORDSYS.ORDImageSignature") && !string.equalsIgnoreCase("ORDSYS.ORDVideo") && !string.equalsIgnoreCase("ORDVideo") && !string.equalsIgnoreCase("DATALINK") && !string.equalsIgnoreCase("GRAPHIC") && !string.equalsIgnoreCase("DBCLOB") && !string.equalsIgnoreCase("LONG VARCHAR") && !string.equalsIgnoreCase("LONG VARGRAPHIC") && !string.equalsIgnoreCase("VARGRAPHIC") && !string.equalsIgnoreCase("IMAGE") && !string.equalsIgnoreCase("XDBURITYPE");
    }

    public boolean isNumeric() {
        String string = this.getName();
        return string.equalsIgnoreCase("BIGINT") || string.equalsIgnoreCase("BINARY_DOUBLE") || string.equalsIgnoreCase("BINARY_FLOAT") || string.equalsIgnoreCase("DECIMAL") || string.equalsIgnoreCase("DOUBLE") || string.equalsIgnoreCase("FLOAT") || string.equalsIgnoreCase("INTEGER") || string.equalsIgnoreCase("MONEY") || string.equalsIgnoreCase("NUMERIC") || string.equalsIgnoreCase("REAL") || string.equalsIgnoreCase("SMALLINT") || string.equalsIgnoreCase("SMALLMONEY") || string.equalsIgnoreCase("TINYINT");
    }

    public static void clearEvents() {
        FILENAME_CHANGED.setAffected(null);
    }
}

