/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.MultiShapedDesignObject;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.editor.LegendPropertiesDialog;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;
import oracle.ide.Ide;

public class Legend
extends MultiShapedDesignObject {
    public static final int ATTRIBUTE_AUTHOR = 2;
    public static final int ATTRIBUTE_CREATED_ON = 4;
    public static final int ATTRIBUTE_MODIFIED_ON = 8;
    public static final int ATTRIBUTE_CHANGED_BY = 16;
    public static final int ATTRIBUTE_DESIGN = 32;
    public static final int ATTRIBUTE_MODEL = 64;
    public static final int ALL_ATTRIBUTES = 126;
    private static final Logger LOGGER = new Logger(Legend.class);
    public static final String TYPE_NAME = "Legend";
    private DesignPartView dpv;

    public Legend(DesignPartView designPartView) {
        super(designPartView.getDesignPart());
        this.dpv = designPartView;
    }

    public FontObject getTextFontObject() {
        DefaultFontAndColor defaultFontAndColor;
        if (this.getDesignPart() != null && (defaultFontAndColor = this.getDesignPart().getDesign().getDLSettings().getDefaultFCObject(TYPE_NAME)) != null) {
            return defaultFontAndColor.getFontObject(EditableFonts.FO_TEXT);
        }
        return null;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    private ModelIDObject getObject() {
        if (this.dpv.isMainDiagram() && this.dpv.isMasterDPV()) {
            return this.dpv.getDesignPart().getMainDPVPlaceHolder();
        }
        return this.dpv.getPlaceHolder();
    }

    @Override
    public String getName() {
        return "Diagram Properties";
    }

    public String getDiagramName() {
        return this.dpv.getName();
    }

    public String getDiagramAuthor() {
        return this.getObject().getCreatedBy();
    }

    public String getTimeCreated() {
        return this.getObject().getCreationTime();
    }

    public String getTimeChanged() {
        return this.getObject().getChange().getTimeString();
    }

    public String getModifiedBy() {
        return this.getObject().getChange().getUser().getName();
    }

    public String getDesignName() {
        return this.dpv.getDesign().getName();
    }

    public String getModelName() {
        return this.dpv.getDesignPart().getName();
    }

    public Dimension getSize() {
        int n = 180;
        try {
            Font font = this.getTextFontObject().getFont();
            FontMetrics fontMetrics = Ide.getMainWindow().getGraphics().getFontMetrics(font);
            int n2 = fontMetrics.stringWidth("Changed by:") + 30;
            n = this.getWidth(fontMetrics);
            int n3 = 1;
            if (this.showAuthor()) {
                ++n3;
            }
            if (this.showCreatedOn()) {
                ++n3;
            }
            if (this.showModifiedOn()) {
                ++n3;
            }
            if (this.showChangedBy()) {
                ++n3;
            }
            if (this.showDesignName()) {
                ++n3;
            }
            if (this.showModelName()) {
                ++n3;
            }
            int n4 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
            int n5 = n4 / 3 + 1;
            return new Dimension(10 + n2 + n + 10, (n4 += n5) * n3 + 2);
        }
        catch (Exception exception) {
            LOGGER.warn(exception.getMessage(), exception);
            return new Dimension(n, 113);
        }
    }

    private int getWidth(FontMetrics fontMetrics) {
        int n = 100;
        try {
            n = Math.max(n, fontMetrics.stringWidth(this.getDiagramName()));
            if (this.showAuthor()) {
                n = Math.max(n, fontMetrics.stringWidth(this.getDiagramAuthor()));
            }
            if (this.showCreatedOn()) {
                n = Math.max(n, fontMetrics.stringWidth(this.getTimeCreated()));
            }
            if (this.showModifiedOn()) {
                n = Math.max(n, fontMetrics.stringWidth(this.getTimeChanged()));
            }
            if (this.showChangedBy()) {
                n = Math.max(n, fontMetrics.stringWidth(this.getModifiedBy()));
            }
            if (this.showDesignName()) {
                n = Math.max(n, fontMetrics.stringWidth(this.getDesignName()));
            }
            if (this.showModelName()) {
                n = Math.max(n, fontMetrics.stringWidth(this.getModelName()));
            }
        }
        catch (Exception exception) {
            LOGGER.warn(exception.getMessage(), exception);
        }
        return n;
    }

    public DesignPartView getDesignPartView() {
        return this.dpv;
    }

    public boolean showAuthor() {
        return (this.dpv.getLegendAttributes() & 2) != 0;
    }

    public boolean showCreatedOn() {
        return (this.dpv.getLegendAttributes() & 4) != 0;
    }

    public boolean showModifiedOn() {
        return (this.dpv.getLegendAttributes() & 8) != 0;
    }

    public boolean showChangedBy() {
        return (this.dpv.getLegendAttributes() & 0x10) != 0;
    }

    public boolean showDesignName() {
        return (this.dpv.getLegendAttributes() & 0x20) != 0;
    }

    public boolean showModelName() {
        return (this.dpv.getLegendAttributes() & 0x40) != 0;
    }

    @Override
    public void showPropertyDialog() {
        LegendPropertiesDialog legendPropertiesDialog = new LegendPropertiesDialog(this.getDesign().getAppView(), this.dpv);
        legendPropertiesDialog.showDialog();
    }
}

