/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.util.ArrayList;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.SetListener;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerObjectEvent;
import oracle.dbtools.crest.model.design.ContainerObjectListener;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.KeyObject;

public abstract class GlobalKeyObjectSet
extends ModelObjectSet
implements ContainerObjectListener,
SetListener {
    private DesignPart designPart;

    public GlobalKeyObjectSet(DesignObjectSet designObjectSet) {
        designObjectSet.addSetListener(this);
        this.setDesign(designObjectSet.getDesign());
    }

    @Override
    public void add(ModelObject modelObject) {
        super.add(modelObject);
    }

    @Override
    public String getDefaultNamePrefix() {
        return "IDX";
    }

    protected void synchronizeWith(DesignObjectSet designObjectSet) {
        ContainerWithKeyObject[] containerWithKeyObjectArray = (ContainerWithKeyObject[])designObjectSet.toArray();
        for (int i = 0; i < containerWithKeyObjectArray.length; ++i) {
            this.add(containerWithKeyObjectArray[i]);
        }
    }

    @Override
    public void changed(ContainerObject containerObject, ContainerObjectEvent containerObjectEvent) {
        if (containerObjectEvent.isType(5)) {
            this.addKey((KeyObject)containerObjectEvent.getAffectedElement());
        } else if (containerObjectEvent.isType(4)) {
            KeyObject keyObject = (KeyObject)containerObjectEvent.getAffectedElement();
            this.removeKey(keyObject);
        }
    }

    @Override
    public void changed(DesignObjectSet designObjectSet, SetEvent setEvent) {
        if (setEvent.getAffected() instanceof ContainerWithKeyObject) {
            if (setEvent.isAdded()) {
                this.addContainer((ContainerWithKeyObject)setEvent.getAffected());
            } else if (setEvent.isRemoved()) {
                this.removeContainer((ContainerWithKeyObject)setEvent.getAffected());
            }
        }
    }

    protected void addContainer(ContainerWithKeyObject containerWithKeyObject) {
        containerWithKeyObject.addContainerListener(this);
        KeyObject[] keyObjectArray = containerWithKeyObject.getKeys();
        for (int i = 0; i < keyObjectArray.length; ++i) {
            this.addKey(keyObjectArray[i]);
        }
    }

    protected void addKey(KeyObject keyObject) {
        keyObject.setParent(this);
        this.add(keyObject);
    }

    protected void removeContainer(ContainerWithKeyObject containerWithKeyObject) {
        containerWithKeyObject.removeContainerListener(this);
        KeyObject[] keyObjectArray = containerWithKeyObject.getKeys();
        for (int i = 0; i < keyObjectArray.length; ++i) {
            this.removeKey(keyObjectArray[i]);
        }
    }

    protected void removeKey(KeyObject keyObject) {
        this.remove(keyObject);
    }

    public Object[] getPKUK() {
        ArrayList<KeyObject> arrayList = new ArrayList<KeyObject>();
        KeyObject[] keyObjectArray = (KeyObject[])this.toArray();
        for (int i = 0; i < keyObjectArray.length; ++i) {
            if (!keyObjectArray[i].isUnique() && !keyObjectArray[i].isPK()) continue;
            arrayList.add(keyObjectArray[i]);
        }
        return arrayList.toArray();
    }

    public DesignPart getDesignPart() {
        return this.designPart;
    }

    public void setDesignPart(DesignPart designPart) {
        this.designPart = designPart;
    }
}

