/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;

public class DomainSet
extends DesignObjectSet {
    private static final Object[] PROTO_DOMAIN = new Domain[0];
    public static final String DEFAULT_DOMAIN = "Unknown";
    private Domain defDomain;

    public DomainSet(DesignPart designPart) {
        super(designPart);
        this.requireSort = true;
    }

    public Domain createUnknownDomain() {
        Domain domain = this.createDomain("DOM3000004");
        domain.setName(DEFAULT_DOMAIN);
        domain.setReadOnly(true);
        domain.setLogicalDatatype(this.getDesign().getLogicalDatatypeSet().getDefaultType());
        return domain;
    }

    @Override
    protected Object[] getProtoTypeArray() {
        return PROTO_DOMAIN;
    }

    @Override
    protected String getDefaultNamePrefix() {
        return this.getPreference("default domain name");
    }

    public Domain createDomain() {
        return this.createDomain(null);
    }

    public Domain createDomain(String string) {
        Domain domain = new Domain(this.getDesignPart());
        if (string != null) {
            domain.setObjectID(string);
        }
        this.getDesign().addDesignObject(domain);
        this.add(domain);
        return domain;
    }

    @Override
    public Object getParent() {
        return this.getDesign();
    }

    public Set getUsedDomainFiles() {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Domain domain = (Domain)iterator.next();
            if (hashSet.contains(domain.getFileName())) continue;
            hashSet.add(domain.getFileName());
        }
        return hashSet;
    }

    public void loadDomainFile(String string) {
        if (!this.getUsedDomainFiles().contains(string)) {
            this.getAppView().getPersistenceManager().read(string, this.getDesign());
        }
    }

    public Domain getDefaultDomain() {
        if (this.defDomain != null && DEFAULT_DOMAIN.equalsIgnoreCase(this.defDomain.getName())) {
            return this.defDomain;
        }
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Domain domain = (Domain)iterator.next();
            if (!DEFAULT_DOMAIN.equalsIgnoreCase(domain.getName())) continue;
            this.defDomain = domain;
            return domain;
        }
        this.defDomain = this.createUnknownDomain();
        return this.defDomain;
    }

    @Override
    public void remove(DesignObject designObject) {
        if (this.defDomain != null && designObject == this.defDomain) {
            this.defDomain = null;
        }
        super.remove(designObject);
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.createUnknownDomain();
    }

    public String getStoragePath() {
        try {
            return new File(this.getDesign().getStoragePath(), "domains").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getStorageName(String string) {
        try {
            if (string != null) {
                return new File(this.getStoragePath(), string + ".xml").getCanonicalPath();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

