/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.ModelIDObjectSet;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.DomainSet;
import oracle.dbtools.crest.util.GUID;

public class DomainFileWrapper {
    private Design design;
    private String fileName;
    private List domains = new ArrayList();
    private DomainSet domainSet;
    private boolean useDomainSet = true;

    public DomainFileWrapper(Design design) {
        this.design = design;
        this.domainSet = design.getDomainSet();
    }

    public DomainFileWrapper(Design design, String string) {
        this(design);
        this.fileName = string;
        this.synchronizeWithdomainSet();
    }

    public DomainFileWrapper(Design design, String string, boolean bl) {
        this(design);
        this.fileName = string;
        this.useDomainSet = bl;
        if (bl) {
            this.synchronizeWithdomainSet();
        }
    }

    public DomainFileWrapper(Design design, String string, DomainSet domainSet) {
        this.design = design;
        this.domainSet = domainSet;
        this.fileName = string;
        this.synchronizeWithdomainSet();
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public List getDomains() {
        return this.domains;
    }

    public Domain createDomain() {
        Domain domain = null;
        if (this.useDomainSet) {
            domain = this.domainSet.createDomain();
        } else {
            domain = new Domain(this.design.getLogicalDesign());
            domain.setObjectID(new GUID().toString());
        }
        return domain;
    }

    private void synchronizeWithdomainSet() {
        if (this.fileName != null && !"".equals(this.fileName)) {
            Iterator iterator = this.domainSet.iterator();
            while (iterator.hasNext()) {
                Domain domain = (Domain)iterator.next();
                if (!this.fileName.equals(domain.getFileName())) continue;
                this.domains.add(domain);
            }
        }
    }

    public List getIDSortedDomains() {
        Collections.sort(this.domains, ModelIDObjectSet.OBJECT_ID_COMPARATOR);
        return this.domains;
    }

    public Domain getDomainByID(String string) {
        if (string != null && !"".equals(string)) {
            if (this.useDomainSet) {
                return (Domain)this.domainSet.getObjectByID(string);
            }
            for (Domain domain : this.domains) {
                if (!string.equals(domain.getObjectID())) continue;
                return domain;
            }
        }
        return null;
    }

    public void presetDomainsFileName() {
        if (this.fileName != null && !"".equals(this.fileName)) {
            for (Domain domain : this.domains) {
                domain.setFileName(this.fileName);
            }
        }
    }

    public void removeDomain(Domain domain) {
        this.domains.remove(domain);
        domain.remove();
    }
}

