/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.ide.Ide;

public class DesignUtilities {
    public static boolean checkUsedInAttributes(Design design, DesignObject designObject, short s) {
        Iterator iterator = design.getLogicalDesign().getEntitySet().iterator();
        while (iterator.hasNext()) {
            Entity entity = (Entity)iterator.next();
            ContainedObject[] containedObjectArray = entity.getElements();
            for (int i = 0; i < containedObjectArray.length; ++i) {
                Attribute attribute = (Attribute)containedObjectArray[i];
                if (!DesignUtilities.isUsedIn(designObject, attribute, s)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<AttributeRef> extractUsedInAttributes(Design design, DesignObject designObject, short s) {
        ArrayList<AttributeRef> arrayList = new ArrayList<AttributeRef>();
        Iterator iterator = design.getLogicalDesign().getEntitySet().iterator();
        while (iterator.hasNext()) {
            Entity entity = (Entity)iterator.next();
            ContainedObject[] containedObjectArray = entity.getElements();
            for (int i = 0; i < containedObjectArray.length; ++i) {
                Attribute attribute = (Attribute)containedObjectArray[i];
                if (!DesignUtilities.isUsedIn(designObject, attribute, s)) continue;
                arrayList.add(new AttributeRef(entity, attribute));
            }
        }
        return arrayList;
    }

    public static boolean checkUsedInColumns(Design design, DesignObject designObject, short s) {
        Iterator iterator = design.getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
            Iterator iterator2 = relationalDesign.getTableSet().iterator();
            while (iterator2.hasNext()) {
                Table table = (Table)iterator2.next();
                ContainedObject[] containedObjectArray = table.getElements();
                for (int i = 0; i < containedObjectArray.length; ++i) {
                    Column column = (Column)containedObjectArray[i];
                    if (!DesignUtilities.isUsedIn(designObject, column, s)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static List<ColumnRef> extractUsedInColumns(Design design, DesignObject designObject, short s) {
        ArrayList<ColumnRef> arrayList = new ArrayList<ColumnRef>();
        Iterator iterator = design.getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
            Iterator iterator2 = relationalDesign.getTableSet().iterator();
            while (iterator2.hasNext()) {
                Table table = (Table)iterator2.next();
                ContainedObject[] containedObjectArray = table.getElements();
                for (int i = 0; i < containedObjectArray.length; ++i) {
                    Column column = (Column)containedObjectArray[i];
                    if (!DesignUtilities.isUsedIn(designObject, column, s)) continue;
                    arrayList.add(new ColumnRef(relationalDesign, table, column));
                }
            }
        }
        return arrayList;
    }

    public static boolean checkUsedInTables(Design design, DesignObject designObject) {
        Iterator iterator = design.getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
            Iterator iterator2 = relationalDesign.getTableSet().iterator();
            while (iterator2.hasNext()) {
                Table table = (Table)iterator2.next();
                if (!DesignUtilities.isUsedIn(designObject, table, null)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<Table> extractUsedInTables(Design design, DesignObject designObject, short s) {
        ArrayList<Table> arrayList = new ArrayList<Table>();
        Iterator iterator = design.getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
            Iterator iterator2 = relationalDesign.getTableSet().iterator();
            while (iterator2.hasNext()) {
                Table table = (Table)iterator2.next();
                if (!DesignUtilities.isUsedIn(designObject, table, s)) continue;
                arrayList.add(table);
            }
        }
        return arrayList;
    }

    public static boolean checkUsedInEntities(Design design, DesignObject designObject) {
        Iterator iterator = design.getLogicalDesign().getEntitySet().iterator();
        while (iterator.hasNext()) {
            Entity entity = (Entity)iterator.next();
            if (!DesignUtilities.isUsedIn(designObject, entity, null)) continue;
            return true;
        }
        return false;
    }

    public static List<Entity> extractUsedInEntities(Design design, DesignObject designObject, short s) {
        ArrayList<Entity> arrayList = new ArrayList<Entity>();
        Iterator iterator = design.getLogicalDesign().getEntitySet().iterator();
        while (iterator.hasNext()) {
            Entity entity = (Entity)iterator.next();
            if (!DesignUtilities.isUsedIn(designObject, entity, s)) continue;
            arrayList.add(entity);
        }
        return arrayList;
    }

    public static boolean checkUsedInStructuredTypes(Design design, DesignObject designObject) {
        Iterator iterator = design.getDataTypesDesign().getStructuredTypeSet().iterator();
        while (iterator.hasNext()) {
            StructuredType structuredType = (StructuredType)iterator.next();
            if (!DesignUtilities.isUsedIn(designObject, structuredType, null)) continue;
            return true;
        }
        return false;
    }

    public static List<StructuredType> extractUsedInStructuredTypes(Design design, DesignObject designObject) {
        ArrayList<StructuredType> arrayList = new ArrayList<StructuredType>();
        Iterator iterator = design.getDataTypesDesign().getStructuredTypeSet().iterator();
        while (iterator.hasNext()) {
            StructuredType structuredType = (StructuredType)iterator.next();
            if (!DesignUtilities.isUsedIn(designObject, structuredType, null)) continue;
            arrayList.add(structuredType);
        }
        return arrayList;
    }

    public static boolean checkUsedInStructuredTypeAttributes(Design design, DesignObject designObject) {
        Iterator iterator = design.getDataTypesDesign().getStructuredTypeSet().iterator();
        while (iterator.hasNext()) {
            StructuredType structuredType = (StructuredType)iterator.next();
            for (TypeElement typeElement : structuredType.getElements()) {
                if (!DesignUtilities.isUsedIn(designObject, typeElement, null)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<TypeElement> extractUsedInStructuredTypeAttributes(Design design, DesignObject designObject) {
        ArrayList<TypeElement> arrayList = new ArrayList<TypeElement>();
        Iterator iterator = design.getDataTypesDesign().getStructuredTypeSet().iterator();
        while (iterator.hasNext()) {
            StructuredType structuredType = (StructuredType)iterator.next();
            for (TypeElement typeElement : structuredType.getElements()) {
                if (!DesignUtilities.isUsedIn(designObject, typeElement, null)) continue;
                arrayList.add(typeElement);
            }
        }
        return arrayList;
    }

    public static boolean checkUsedInCollectionTypes(Design design, DesignObject designObject) {
        Iterator iterator = design.getDataTypesDesign().getCollectionTypeSet().iterator();
        while (iterator.hasNext()) {
            CollectionType collectionType = (CollectionType)iterator.next();
            if (!DesignUtilities.isUsedIn(designObject, collectionType.getElementType(), null)) continue;
            return true;
        }
        return false;
    }

    public static List<CollectionType> extractUsedInCollectionTypes(Design design, DesignObject designObject) {
        ArrayList<CollectionType> arrayList = new ArrayList<CollectionType>();
        Iterator iterator = design.getDataTypesDesign().getCollectionTypeSet().iterator();
        while (iterator.hasNext()) {
            CollectionType collectionType = (CollectionType)iterator.next();
            if (!DesignUtilities.isUsedIn(designObject, collectionType.getElementType(), null)) continue;
            arrayList.add(collectionType);
        }
        return arrayList;
    }

    public static boolean checkUsedInViews(Design design, DesignObject designObject) {
        Iterator iterator = design.getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
            Iterator iterator2 = relationalDesign.getTableViewSet().iterator();
            while (iterator2.hasNext()) {
                TableView tableView = (TableView)iterator2.next();
                if (!DesignUtilities.isUsedIn(designObject, tableView, null)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<TableView> extractUsedInViews(Design design, DesignObject designObject) {
        ArrayList<TableView> arrayList = new ArrayList<TableView>();
        Iterator iterator = design.getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
            Iterator iterator2 = relationalDesign.getTableViewSet().iterator();
            while (iterator2.hasNext()) {
                TableView tableView = (TableView)iterator2.next();
                if (!DesignUtilities.isUsedIn(designObject, tableView, null)) continue;
                arrayList.add(tableView);
            }
        }
        return arrayList;
    }

    public static int checkNotUsedIn(Design design, DesignObject designObject) {
        boolean bl;
        boolean bl2 = bl = DesignUtilities.checkUsedInAttributes(design, designObject, (short)3) || DesignUtilities.checkUsedInColumns(design, designObject, (short)3) || DesignUtilities.checkUsedInTables(design, designObject) || DesignUtilities.checkUsedInEntities(design, designObject) || DesignUtilities.checkUsedInStructuredTypes(design, designObject) || DesignUtilities.checkUsedInStructuredTypeAttributes(design, designObject) || DesignUtilities.checkUsedInCollectionTypes(design, designObject) || DesignUtilities.checkUsedInViews(design, designObject);
        if (bl) {
            return JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("DesignUtilities.StructuredTypeIsUsed"), designObject.getName()), Messages.getString("DesignUtilities.DeletingStructuredType"), 0);
        }
        return -1;
    }

    public static boolean isUsedIn(DesignObject designObject, DesignObject designObject2, Short s) {
        if (designObject2 instanceof ContainedObjectWithDomain) {
            ContainedObjectWithDomain containedObjectWithDomain = (ContainedObjectWithDomain)designObject2;
            if (containedObjectWithDomain.getUse() == s.shortValue()) {
                switch (s) {
                    case 0: {
                        return containedObjectWithDomain.getDomain() == designObject;
                    }
                    case 3: {
                        return containedObjectWithDomain.getStructuredType() == designObject;
                    }
                    case 2: {
                        return containedObjectWithDomain.getDistinctType() == designObject;
                    }
                    case 4: {
                        return containedObjectWithDomain.getCollectionType() == designObject;
                    }
                }
                return false;
            }
        } else if (designObject instanceof StructuredType) {
            StructuredType structuredType = (StructuredType)designObject;
            if (designObject2 instanceof ContainerObject) {
                return ((ContainerObject)designObject2).getBasedOnStructuredType() == structuredType;
            }
            if (designObject2 instanceof StructuredType) {
                return structuredType.getAllSubTypes().contains(designObject2);
            }
            if (designObject2 instanceof TypeElement) {
                return ((TypeElement)designObject2).getType() == structuredType;
            }
        } else if (designObject instanceof Domain && designObject2 instanceof TypeElement && ((TypeElement)designObject2).getDomain() != null) {
            return ((TypeElement)designObject2).getDomain() == designObject;
        }
        return false;
    }

    public static class ColumnRef {
        Column column;
        RelationalDesign design;
        Table table;

        public ColumnRef(RelationalDesign relationalDesign, Table table, Column column) {
            this.design = relationalDesign;
            this.table = table;
            this.column = column;
        }

        public RelationalDesign getModel() {
            return this.design;
        }

        public void setModel(RelationalDesign relationalDesign) {
            this.design = relationalDesign;
        }

        public Table getTable() {
            return this.table;
        }

        public void setTable(Table table) {
            this.table = table;
        }

        public Column getColumn() {
            return this.column;
        }

        public void setColumn(Column column) {
            this.column = column;
        }
    }

    public static class AttributeRef {
        Entity entity;
        Attribute attribute;

        public AttributeRef(Entity entity, Attribute attribute) {
            this.entity = entity;
            this.attribute = attribute;
        }

        public Entity getEntity() {
            return this.entity;
        }

        public void setEntity(Entity entity) {
            this.entity = entity;
        }

        public Attribute getAttribute() {
            return this.attribute;
        }

        public void setAttribute(Attribute attribute) {
            this.attribute = attribute;
        }
    }
}

