/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.SwingUtilities;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import oracle.dbtools.crest.fcp.DMDiagramEditor;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.model.ClassificationType;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIDObjectSet;
import oracle.dbtools.crest.model.NamingOptionsHolder;
import oracle.dbtools.crest.model.SetListener;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.SubViewObjectSet;
import oracle.dbtools.crest.model.Task;
import oracle.dbtools.crest.model.businessinfo.BIDocument;
import oracle.dbtools.crest.model.businessinfo.BIResponsibleParty;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignEvent;
import oracle.dbtools.crest.model.design.DesignListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPartListener;
import oracle.dbtools.crest.model.design.DiagramView;
import oracle.dbtools.crest.model.design.DiagramViewListener;
import oracle.dbtools.crest.model.design.DiagramViewSet;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.LabelSet;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.NoteSet;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.undo.DP_UndoManager;
import oracle.dbtools.crest.model.design.undo.NoteCreateEdit;
import oracle.dbtools.crest.model.design.undo.NoteRemoveEdit;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.db.RepDeleteDescr;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.editor.ModelPropertiesDialogEx;
import oracle.dbtools.crest.util.Extension;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;

public abstract class DesignPart
extends ModelIDObject
implements SetListener {
    public static final String SUB_VIEW_TYPE = "SUB_VIEW_TYPE";
    public static final String DISPLAY_TYPE = "DISPLAY_TYPE";
    private List tasks = Collections.synchronizedList(new ArrayList());
    private boolean loaded = true;
    private boolean shouldBeOpen = false;
    protected Set designListeners = new HashSet();
    private Set listeners = new HashSet();
    private Set undoListeners = new HashSet();
    private Set dvListeners = new HashSet();
    protected DesignPartView mainView;
    protected SubViewObjectSet subViews;
    protected DesignPartViewPlaceHolder dpvPlaceHolder;
    private boolean isVisible = false;
    private TreeMap filesMap = new TreeMap();
    private TreeMap repositoryMap = new TreeMap();
    private List documents;
    private List responsibleParties = new ArrayList();
    private DiagramViewSet dvSet;
    private List namingOptionsHolderList = new ArrayList();
    private List exportedSubViews = new ArrayList();
    private boolean fullExport = false;
    private boolean newModel = true;
    private LabelSet labelSet;
    private boolean isDeleting = false;
    private DP_UndoManager undoManager = new DP_UndoManager();
    protected boolean listOfObjectsChanged = false;
    private boolean objectListChanged = false;
    protected Map f2tMap = null;
    protected Map dfMap = null;
    private String mainViewID = null;
    private static final Logger LOGGER = new Logger(DesignPart.class);
    protected List typeOrder;

    public DesignPart() {
        this.subViews = new SubViewObjectSet(this, Messages.getString("DesignPart.Subviews"));
        this.subViews.setParent(this);
        this.subViews.setElementDescriptor(SUB_VIEW_TYPE);
    }

    public void addDesignPartListener(DesignPartListener designPartListener) {
        this.listeners.add(designPartListener);
    }

    public void removeDesignPartListener(DesignPartListener designPartListener) {
        this.listeners.remove(designPartListener);
    }

    public void addDiagramViewListener(DiagramViewListener diagramViewListener) {
        this.dvListeners.add(diagramViewListener);
    }

    public void removeDiagramViewListener(DiagramViewListener diagramViewListener) {
        this.dvListeners.remove(diagramViewListener);
    }

    public void fireDeleted() {
        DiagramViewListener[] diagramViewListenerArray = this.dvListeners.toArray(new DiagramViewListener[0]);
        for (int i = 0; i < diagramViewListenerArray.length; ++i) {
            DiagramViewListener diagramViewListener = diagramViewListenerArray[i];
            diagramViewListener.designPartDeleted(this);
        }
    }

    protected void fireAdded(DesignObject designObject) {
        DesignPartListener[] designPartListenerArray = this.listeners.toArray(new DesignPartListener[0]);
        for (int i = 0; i < designPartListenerArray.length; ++i) {
            DesignPartListener designPartListener = designPartListenerArray[i];
            designPartListener.objectAdded(this, designObject);
        }
        this.setObjectListChanged(true);
    }

    protected void fireRemoved(DesignObject designObject) {
        for (DesignPartListener designPartListener : this.listeners) {
            designPartListener.objectRemoved(this, designObject);
        }
        this.setObjectListChanged(true);
    }

    public abstract Collection getAllTopLevelObjects();

    public abstract StorableObject createObject(String var1, String var2, String var3);

    public abstract void clearAll();

    protected abstract DesignPartView createDesignPartSubView(String var1);

    public DesignPartView createDesignPartSubView() {
        DesignPartView designPartView = this.createDesignPartSubView(this.getName() + " - " + this.getSubViewTypeName());
        designPartView.setDPVId(this.getAppView().getIDGenerator().createNewID());
        designPartView.getTabbedPane().setName(designPartView.getName());
        designPartView.getTabbedPane().add(designPartView);
        designPartView.getTabbedPane().setSelectedComponent(designPartView);
        designPartView.getTabbedPane().addChangeListener(this.getAppView());
        this.setDirty(true);
        return designPartView;
    }

    private boolean componentsCollectionContainsName(SubViewObjectSet subViewObjectSet, String string) {
        Iterator iterator = subViewObjectSet.iterator();
        while (iterator.hasNext()) {
            if (!string.equalsIgnoreCase(((DesignObject)iterator.next()).getName())) continue;
            return true;
        }
        return false;
    }

    public String getNameVersion(SubViewObjectSet subViewObjectSet, String string) {
        boolean bl = false;
        String string2 = string;
        int n = 0;
        while (!bl) {
            string = new StringBuffer(string2).append('_').append(String.valueOf(++n)).toString();
            if (this.componentsCollectionContainsName(subViewObjectSet, string)) continue;
            bl = true;
        }
        return string;
    }

    public abstract DesignPartView getMainView();

    public abstract boolean isEmpty();

    public void clearDesignPart() {
        this.clearAll();
        this.fullExport = false;
        this.getExportedSubViews().clear();
        if (this.getMainView() != null) {
            this.getMainView().clearDPV();
            this.getMainView().actualSize();
            this.setMainViewVisible(false);
            this.removeDesignPartListener(this.getMainView());
        }
        Object[] objectArray = this.subViews.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)objectArray[i];
            DesignPartView designPartView = designPartViewPlaceHolder.getDesignPartView();
            designPartViewPlaceHolder.setVisible(false);
            designPartView.clearDPV();
            this.removeDesignPartListener(designPartView);
            this.getDesign().removeDesignPartView(designPartView);
            this.deleteSubview(designPartView);
        }
        this.subViews.clear();
        this.filesMap.clear();
        this.mainView = null;
        this.dpvPlaceHolder = null;
        this.undoManager.discardAllEdits();
        this.listOfObjectsChanged = false;
        this.setRepositoryOID(null);
        this.setRepositoryOVID(null);
        this.setDirty(false);
        this.setCheckedOut(false);
        this.setCheckedOutByMe(false);
        this.setCheckedOutBy("");
        this.setNewModel(true);
    }

    public void deleteSubview(DesignPartView designPartView) {
        if (this.subViews.containsObject(designPartView)) {
            designPartView.clearDPV();
            designPartView.closeEditor();
            designPartView.clearCellRefsToObjects();
            this.subViews.removePlaceHolderFor(designPartView);
            this.setDirty(true);
            DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)designPartView.getPlaceHolder();
            this.fireRemoved(designPartViewPlaceHolder);
        }
    }

    public DesignPartViewPlaceHolder getMainDPVPlaceHolder() {
        if (this.dpvPlaceHolder == null) {
            this.dpvPlaceHolder = new DesignPartViewPlaceHolder(this, this.getMainView());
            this.dpvPlaceHolder.setParent(this);
        }
        return this.dpvPlaceHolder;
    }

    private void doSetMainViewVisible(boolean bl) {
        DesignPartView designPartView = this.getMainView();
        if (bl) {
            designPartView.setName(this.getName());
            if (!this.isMainViewVisible()) {
                if (designPartView.canCreateDisplays()) {
                    int n = designPartView.getTabbedPane().indexOfComponent(designPartView);
                    if (n < 0) {
                        designPartView.getTabbedPane().setName(designPartView.getName());
                        designPartView.getTabbedPane().add((Component)designPartView, 0);
                        designPartView.getTabbedPane().setSelectedComponent(designPartView);
                    }
                    Editor editor = DMDiagramEditor.openNewDiagram(designPartView.getTabbedPane());
                    designPartView.setContext(editor.getContext());
                    designPartView.getTabbedPane().addChangeListener(this.getAppView());
                } else {
                    Editor editor = DMDiagramEditor.openNewDiagram(designPartView);
                    designPartView.setContext(editor.getContext());
                }
            } else {
                designPartView.activateEditor();
            }
        } else {
            if (designPartView != null && designPartView.canCreateDisplays()) {
                designPartView.getTabbedPane().removeChangeListener(this.getAppView());
            }
            if (designPartView != null) {
                designPartView.closeEditor();
            }
        }
        this.setVisible(bl);
        if (designPartView != null) {
            if (bl) {
                if (!this.getDesign().isLoading()) {
                    designPartView.setVisible(bl);
                }
            } else {
                designPartView.setVisible(bl);
            }
        }
    }

    public void setMainViewVisible(boolean bl, boolean bl2) {
        this.doSetMainViewVisible(bl);
        if (bl2) {
            this.getMainView().setDirty(false);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            if (EditorManager.getEditorManager().getCurrentEditor() != null) {
                EditorManager.getEditorManager().getCurrentEditor().getGUI().requestFocusInWindow();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
                        if (editor != null) {
                            editor.getGUI().requestFocusInWindow();
                        }
                    }
                });
            }
        }
    }

    public void setMainViewVisible(boolean bl) {
        this.setMainViewVisible(bl, false);
    }

    private void doSetMainViewVisible(boolean bl, ProgressDialog progressDialog) {
        DesignPartView designPartView = this.getMainView();
        designPartView.setVisible(bl, progressDialog);
        if (bl) {
            designPartView.setName(this.getName());
            if (!this.isMainViewVisible()) {
                if (designPartView.canCreateDisplays()) {
                    int n = designPartView.getTabbedPane().indexOfComponent(designPartView);
                    if (n < 0) {
                        designPartView.getTabbedPane().setName(designPartView.getName());
                        designPartView.getTabbedPane().add(designPartView);
                        for (DesignPartView designPartView2 : designPartView.getSubordinateViews()) {
                            if (!designPartView2.isDisplay()) continue;
                            designPartView.getTabbedPane().add(designPartView2);
                        }
                        designPartView.getTabbedPane().setSelectedComponent(designPartView);
                    }
                    Editor editor = DMDiagramEditor.openNewDiagram(designPartView.getTabbedPane());
                    designPartView.setContext(editor.getContext());
                    this.getAppView().updateIdeToolbar(designPartView.getController().getJToolBar());
                    designPartView.getTabbedPane().addChangeListener(this.getAppView());
                } else {
                    Editor editor = DMDiagramEditor.openNewDiagram(designPartView);
                    designPartView.setContext(editor.getContext());
                    this.getAppView().updateIdeToolbar(designPartView.getController().getJToolBar());
                }
            } else {
                designPartView.activateEditor();
            }
        } else {
            if (designPartView.canCreateDisplays()) {
                designPartView.getTabbedPane().removeChangeListener(this.getAppView());
            }
            designPartView.closeEditor();
        }
        this.setVisible(bl);
        if (SwingUtilities.isEventDispatchThread()) {
            EditorManager.getEditorManager().getCurrentEditor().getGUI().requestFocusInWindow();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EditorManager.getEditorManager().getCurrentEditor().getGUI().requestFocusInWindow();
                }
            });
        }
    }

    public void setMainViewVisible(final boolean bl, final ProgressDialog progressDialog) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doSetMainViewVisible(bl, progressDialog);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DesignPart.this.doSetMainViewVisible(bl, progressDialog);
                }
            });
        }
    }

    public boolean isMainViewVisible() {
        DesignPartView designPartView = this.getMainView();
        if (designPartView == null) {
            return false;
        }
        return designPartView.isEditorVisible();
    }

    @Override
    public boolean setName(String string) {
        if (super.setName(string)) {
            ApplicationView applicationView;
            if (this.getMainView() != null) {
                this.getMainView().setName(string);
            }
            if ((applicationView = this.getAppView()) != null) {
                // empty if block
            }
            this.fireDesignPartNameChanged(new DesignEvent(DesignEvent.DESIGNPART_NAME_CHANGED));
            this.getDesign().setModelListChanged(true);
            return true;
        }
        return false;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean bl) {
        this.loaded = bl;
    }

    public void doBeforeLoad() {
    }

    public void doAfterLoad() {
        this.createFilesMap();
        this.setLoaded(true);
        this.getMainDPVPlaceHolder().setDirty(false);
        this.getMainView().setDirty(false);
        this.setDirty(false);
        this.setObjectListChanged(false);
        this.checkAndSetIDGenerator();
    }

    public void load() {
        System.out.println("Load start " + this.getName() + "   " + System.currentTimeMillis());
        XMLPersistenceManager xMLPersistenceManager = this.getAppView().getPersistenceManager();
        AbstractXMLReader abstractXMLReader = xMLPersistenceManager.getDesignPartReader(this);
        if (abstractXMLReader != null) {
            abstractXMLReader.recreateDesign("Logical", this, false);
        }
        this.createFilesMap();
        this.setLoaded(true);
        this.getMainDPVPlaceHolder().setDirty(false);
        this.getMainView().setDirty(false);
        this.setDirty(false);
        this.setObjectListChanged(false);
        this.checkAndSetIDGenerator();
        System.out.println("Load end " + this.getName() + "   " + System.currentTimeMillis());
    }

    public void checkAndSetIDGenerator() {
    }

    public static long getCounter(String string) {
        int n = 9;
        int n2 = string.length();
        long l = 0L;
        if (n > n2) {
            n = n2 - 1;
        }
        while (true) {
            try {
                l = Integer.parseInt(string.substring(n2 - n));
                return l;
            }
            catch (NumberFormatException numberFormatException) {
                if (--n >= 1) continue;
                return 0L;
            }
            break;
        }
    }

    public void doAfterSave() {
        int n = this.getDesign().getCurrentOperation();
        if (n != 4 && n != 5) {
            this.removeDeletedObjects(true);
        }
        if (n != 5) {
            this.createFilesMap();
        }
        if (this.getMainDPVPlaceHolder() != null) {
            this.getMainDPVPlaceHolder().setDirty(false);
        }
        if (this.getMainView() != null) {
            this.getMainView().setDirty(false);
        }
        this.setNewModel(false);
        this.setDirty(false);
    }

    public void save() {
        if (this.getDesign().isOldRepositoryType()) {
            MessageDialogs.showWarningMessage("This design is saved in an old format and can't be overwritten!\nPlease use \"Save As..\" option to save it as new design.");
        } else {
            this.getAppView().setCurrentDesign(this.getDesign());
            this.getAppView().getXMLTransformationManager().saveDesignPart(this);
        }
    }

    public void synchronizeFilesMap(boolean bl) {
        this.removeDeletedObjects(bl);
        this.createFilesMap();
    }

    protected void createFilesMap() {
        this.filesMap.clear();
        Collection collection = this.getStorableDesignObjects();
        collection.addAll(this.getAllDPVPlaceHolders());
        for (DesignObject designObject : collection) {
            if (designObject.getStorageName() == null) continue;
            this.filesMap.put(designObject.getObjectID(), designObject.getSegmentedStorageName());
        }
    }

    public void createRepositoryMap() {
        this.repositoryMap.clear();
        Collection collection = this.getStorableDesignObjects();
        collection.addAll(this.getAllDPVPlaceHolders());
        for (DesignObject designObject : collection) {
            if (designObject.getRepositoryOID() == null) continue;
            RepDeleteDescr repDeleteDescr = new RepDeleteDescr();
            repDeleteDescr.objectType = designObject.getObjectTypeName();
            repDeleteDescr.repOID = designObject.getRepositoryOID();
            repDeleteDescr.repOVID = designObject.getRepositoryOVID();
            repDeleteDescr.objectID = designObject.getObjectID();
            this.repositoryMap.put(designObject.getObjectID(), repDeleteDescr);
        }
    }

    public List getObjectsToDeleteFromRepository() {
        Object object22;
        Collection collection = this.getStorableDesignObjects();
        collection.addAll(this.getAllDPVPlaceHolders());
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (Object object22 : collection) {
            if (((ModelIDObject)object22).getRepositoryOID() == null) continue;
            treeMap.put(((ModelIDObject)object22).getObjectID(), ((ModelIDObject)object22).getObjectID());
        }
        object22 = new ArrayList();
        for (Map.Entry entry : this.repositoryMap.entrySet()) {
            Object v = treeMap.get(entry.getKey());
            if (v != null) continue;
            object22.add(entry.getValue());
        }
        return object22;
    }

    private void removeDeletedObjects(boolean bl) {
        Object object22;
        Collection collection = this.getStorableDesignObjects();
        collection.addAll(this.getAllDPVPlaceHolders());
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (Object object22 : collection) {
            treeMap.put(((ModelIDObject)object22).getObjectID(), ((ModelIDObject)object22).getObjectID());
        }
        object22 = new ArrayList();
        for (Map.Entry entry : this.filesMap.entrySet()) {
            Object v = treeMap.get(entry.getKey());
            if (v != null) continue;
            object22.add(entry.getValue());
        }
        if (object22.size() > 0) {
            if (bl && this.getDesign().isVersioned()) {
                if (Extension.isSVNExtensionLoaded()) {
                    SVNClientHelper.getInstance().doRemove((List<String>)object22);
                }
            } else {
                this.getAppView().getXMLTransformationManager().deleteFiles((List)object22);
            }
        }
    }

    public boolean isShouldBeOpen() {
        return this.shouldBeOpen;
    }

    public void setShouldBeOpen(boolean bl) {
        this.shouldBeOpen = bl;
    }

    public DesignPartView getSubViewGeneratedByDPV(String string) {
        return this.subViews.getSubViewGeneratedByDPV(string);
    }

    public DesignPartView getSubViewByID(String string) {
        return this.subViews.getSubViewByID(string);
    }

    public DesignPartView getSubViewByName(String string) {
        return this.subViews.getSubViewByName(string);
    }

    public DesignPartView[] getMainViewAndSubViews() {
        return this.subViews.getMainViewAndSubViews();
    }

    public SubViewObjectSet getDesignSubviews() {
        return this.subViews;
    }

    public List<DesignPartView> getAllDiagrams() {
        ArrayList<DesignPartView> arrayList = new ArrayList<DesignPartView>();
        DesignPartView designPartView = this.getMainView();
        if (designPartView != null) {
            arrayList.add(designPartView);
        }
        Iterator iterator = this.subViews.iterator();
        while (iterator.hasNext()) {
            DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)iterator.next();
            arrayList.add(designPartViewPlaceHolder.getDesignPartView());
        }
        return arrayList;
    }

    public List<DesignPartView> getAllSubviews() {
        ArrayList<DesignPartView> arrayList = new ArrayList<DesignPartView>();
        Iterator iterator = this.subViews.iterator();
        while (iterator.hasNext()) {
            DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)iterator.next();
            arrayList.add(designPartViewPlaceHolder.getDesignPartView());
        }
        return arrayList;
    }

    public List getListOfSubviews() {
        if (this.subViews.size() > 0) {
            ArrayList<DesignPartView> arrayList = new ArrayList<DesignPartView>();
            ArrayList arrayList2 = new ArrayList();
            this.subViews.addAllElementsTo(arrayList2);
            Collections.sort(arrayList2, ModelIDObjectSet.OBJECT_ID_COMPARATOR);
            for (DesignPartViewPlaceHolder designPartViewPlaceHolder : arrayList2) {
                DesignPartView designPartView = designPartViewPlaceHolder.getDesignPartView();
                if (designPartView == null) continue;
                arrayList.add(designPartView);
            }
            return arrayList;
        }
        return Collections.EMPTY_LIST;
    }

    public Collection getStorableDesignObjects() {
        ArrayList arrayList = new ArrayList();
        for (DesignObjectSet designObjectSet : this.getStorableSets()) {
            designObjectSet.addAllElementsTo(arrayList);
        }
        return arrayList;
    }

    public abstract List getStorableSets();

    public void sortCollections() {
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ModelPropertiesDialogEx modelPropertiesDialogEx = new ModelPropertiesDialogEx(this.getAppView(), this);
            modelPropertiesDialogEx.initProperties(this);
            modelPropertiesDialogEx.show();
        }
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean bl) {
        this.isVisible = bl;
    }

    public void addDesignListener(DesignListener designListener) {
        this.designListeners.add(designListener);
    }

    public void removeDesignListener(DesignListener designListener) {
        this.designListeners.remove(designListener);
    }

    protected void fireDesignPartNameChanged(DesignEvent designEvent) {
        designEvent.setDesignPart(this);
        DesignListener[] designListenerArray = this.designListeners.toArray(new DesignListener[0]);
        for (int i = 0; i < designListenerArray.length; ++i) {
            try {
                if (designListenerArray[i] == null) continue;
                designListenerArray[i].designChanged(designEvent);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public List getDocuments() {
        if (this.documents == null) {
            this.documents = new ArrayList();
        }
        return this.documents;
    }

    public void addDocument(BIDocument bIDocument) {
        if (!this.getDocuments().contains(bIDocument)) {
            this.getDocuments().add(bIDocument);
        }
    }

    public void clearDocuments() {
        this.getDocuments().clear();
    }

    public List getResponsibleParties() {
        return this.responsibleParties;
    }

    public void addResponsibleParty(BIResponsibleParty bIResponsibleParty) {
        if (!this.getResponsibleParties().contains(bIResponsibleParty)) {
            this.getResponsibleParties().add(bIResponsibleParty);
        }
    }

    public void clearResponsibleParties() {
        this.getResponsibleParties().clear();
    }

    public boolean canCreateDPSubview() {
        return false;
    }

    public String getSubViewTypeName() {
        return "SubView";
    }

    public DiagramViewSet getDiagramViewSet() {
        if (this.dvSet == null) {
            this.dvSet = new DiagramViewSet(this);
            this.dvSet.setDesign(this.getDesign());
            this.dvSet.setName(Messages.getString("DesignPart.DiagramViews"));
            this.dvSet.setParent(this);
            this.dvSet.addSetListener(this);
        }
        return this.dvSet;
    }

    public DiagramView createDiagramView() {
        return this.getDiagramViewSet().createDiagramView(null);
    }

    public DiagramView recreateDiagramView(String string) {
        DiagramView diagramView = (DiagramView)this.getDiagramViewSet().getObjectByID(string);
        if (diagramView != null) {
            return diagramView;
        }
        return this.getDiagramViewSet().createDiagramView(string);
    }

    public abstract Note createNote();

    @Override
    public void setDirty(boolean bl) {
        DesignPartViewPlaceHolder designPartViewPlaceHolder;
        super.setDirty(bl);
        if (bl && (designPartViewPlaceHolder = this.getMainDPVPlaceHolder()) != null) {
            designPartViewPlaceHolder.setDirty(bl);
        }
    }

    public List getNamingOptionsHolderList() {
        return this.namingOptionsHolderList;
    }

    public NamingOptionsHolder getNamingOptionsHolderFor(String string) {
        for (NamingOptionsHolder namingOptionsHolder : this.getNamingOptionsHolderList()) {
            if (!namingOptionsHolder.getClassName().getName().equals(string)) continue;
            return namingOptionsHolder;
        }
        return new NamingOptionsHolder(string.getClass());
    }

    public NamingOptionsHolder getNamingOptionsHolderFor(Class clazz) {
        for (NamingOptionsHolder namingOptionsHolder : this.getNamingOptionsHolderList()) {
            if (!namingOptionsHolder.getClassName().equals(clazz)) continue;
            return namingOptionsHolder.copy();
        }
        return null;
    }

    public void setMaxLength(int n, int n2, int n3) {
        this.getNamingOptionsHolderFor(Table.class).setMaxNameLength(n);
        this.getNamingOptionsHolderFor(Column.class).setMaxNameLength(n2);
        this.getNamingOptionsHolderFor(TableView.class).setMaxNameLength(n3);
    }

    public LabelSet getLabelSet() {
        if (this.labelSet == null) {
            this.labelSet = new LabelSet(this);
            this.labelSet.setDesign(this.getDesign());
            this.labelSet.setName(Messages.getString("DesignPart.Labels"));
            this.labelSet.setParent(this);
            this.labelSet.addSetListener(this);
        }
        return this.labelSet;
    }

    public Label createLabel() {
        Label label = this.getLabelSet().createLabel(null);
        return label;
    }

    public boolean isFullExport() {
        return this.fullExport;
    }

    public void setFullExport(boolean bl) {
        this.fullExport = bl;
    }

    public List getExportedSubViews() {
        return this.exportedSubViews;
    }

    public boolean isIncludedInExport() {
        return this.isFullExport() || this.getExportedSubViews().size() > 0;
    }

    public NoteSet getNoteSet() {
        return null;
    }

    public boolean isDeleting() {
        return this.isDeleting;
    }

    public void setIsDeleting(boolean bl) {
        this.isDeleting = bl;
    }

    public DP_UndoManager getUndoManager() {
        return this.getDesign().getUndoManager();
    }

    public synchronized void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.undoListeners.add(undoableEditListener);
    }

    public synchronized void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.undoListeners.remove(undoableEditListener);
    }

    protected void fireUndoableEditHappened(UndoableEdit undoableEdit) {
        UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, undoableEdit);
        Object[] objectArray = this.undoListeners.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            UndoableEditListener undoableEditListener = (UndoableEditListener)objectArray[i];
            undoableEditListener.undoableEditHappened(undoableEditEvent);
        }
    }

    public void postUndoableEdit(UndoableEdit undoableEdit) {
        if (undoableEdit instanceof CompoundEdit) {
            ((CompoundEdit)undoableEdit).end();
        }
        this.fireUndoableEditHappened(undoableEdit);
    }

    public void postNoteCreateEdit(Note note) {
        NoteCreateEdit noteCreateEdit = new NoteCreateEdit(note);
        noteCreateEdit.end();
        this.postUndoableEdit(noteCreateEdit);
    }

    public void postNoteRemoveEdit(Note note) {
        NoteRemoveEdit noteRemoveEdit = new NoteRemoveEdit(note);
        noteRemoveEdit.end();
        this.postUndoableEdit(noteRemoveEdit);
    }

    public void postUndoableRemoveEditForObject(DesignObject designObject) {
        if (designObject instanceof Note) {
            this.postNoteRemoveEdit((Note)designObject);
        }
    }

    public List getTypeOrder() {
        if (this.typeOrder == null) {
            this.typeOrder = this.createTypeOrder();
        }
        return this.typeOrder;
    }

    public List getOrderedTypes(List list) {
        ArrayList arrayList = new ArrayList(list);
        List list2 = this.getTypeOrder();
        if (list2.size() == 0) {
            return list;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String string : list2) {
            String string2 = null;
            for (int i = 0; i < list.size(); ++i) {
                String string3 = (String)list.get(i);
                if (!string3.equalsIgnoreCase(string)) continue;
                string2 = string3;
                arrayList.remove(string3);
                break;
            }
            if (string2 == null) continue;
            arrayList2.add(string2);
        }
        arrayList2.addAll(arrayList);
        return arrayList2;
    }

    protected List createTypeOrder() {
        return new ArrayList();
    }

    public Note recreateNote(String string) {
        NoteSet noteSet = this.getNoteSet();
        if (noteSet != null) {
            return noteSet.createNote(string);
        }
        return null;
    }

    @Override
    public void setCheckedOutByMe(boolean bl) {
        super.setCheckedOutByMe(bl);
        this.updateActions();
    }

    public void updateActions() {
        this.getAppView().updateActionsFor(this);
    }

    public boolean hasDirtyStorableObjects() {
        DesignPartView designPartView = this.getMainView();
        if (designPartView != null && designPartView.isDirty()) {
            return true;
        }
        Iterator iterator = this.getDesignSubviews().iterator();
        while (iterator.hasNext()) {
            DesignObject designObject = (DesignPartViewPlaceHolder)iterator.next();
            if (!((DesignPartViewPlaceHolder)designObject).getDesignPartView().isDirty()) continue;
            return true;
        }
        for (DesignObject designObject : this.getStorableDesignObjects()) {
            if (!designObject.isDirty()) continue;
            return true;
        }
        return this.hasDeletedObjects();
    }

    public List getAllDPVPlaceHolders() {
        ArrayList<DesignPartViewPlaceHolder> arrayList = new ArrayList<DesignPartViewPlaceHolder>();
        DesignPartView designPartView = this.getMainView();
        if (designPartView != null && this.getMainDPVPlaceHolder() != null) {
            arrayList.add(this.getMainDPVPlaceHolder());
        }
        this.subViews.addAllElementsTo(arrayList);
        return arrayList;
    }

    public boolean isListOfObjectsChanged() {
        return this.listOfObjectsChanged;
    }

    public boolean hasDeletedObjects() {
        Collection collection = this.getStorableDesignObjects();
        collection.addAll(this.getAllDPVPlaceHolders());
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (DesignObject object : collection) {
            treeMap.put(object.getObjectID(), object.getObjectID());
        }
        for (Map.Entry entry : this.filesMap.entrySet()) {
            Object v = treeMap.get(entry.getKey());
            if (v != null) continue;
            return true;
        }
        return false;
    }

    public boolean isNewModel() {
        return this.newModel;
    }

    public void setNewModel(boolean bl) {
        this.newModel = bl;
    }

    public void setObjectListChanged(boolean bl) {
        this.objectListChanged = bl;
    }

    public boolean isObjectListChanged() {
        return this.objectListChanged;
    }

    public void addTask(Task task) {
        this.tasks.add(task);
    }

    public boolean hasWaitingTasks() {
        return this.tasks.size() > 0;
    }

    public void executeTasks() {
        Iterator iterator = this.tasks.iterator();
        while (iterator.hasNext()) {
            boolean bl = false;
            Task task = (Task)iterator.next();
            try {
                bl = task.execute();
            }
            catch (Exception exception) {
                LOGGER.error("DesignPart: can not execute task: " + task.toString(), exception);
            }
            if (!bl) continue;
            iterator.remove();
        }
    }

    public Map getFolderToTypeMap() {
        if (this.f2tMap == null) {
            this.f2tMap = new LinkedHashMap();
        }
        return this.f2tMap;
    }

    public Map getDiagramFolderMap() {
        if (this.dfMap == null) {
            this.dfMap = new LinkedHashMap();
            this.dfMap.put("subviews", "");
        }
        return this.dfMap;
    }

    public String getMainViewID() {
        if (this.getMainView() != null) {
            return this.getMainView().getDPVId();
        }
        return this.mainViewID;
    }

    public void setMainViewID(String string) {
        this.mainViewID = string;
        if (this.getMainView() != null) {
            this.getMainView().setDPVId(string);
        }
    }

    public abstract void doAfterExternalLoad();

    public abstract List getObjectsWithMeasurements();

    @Override
    public RDBMSSite getSelectedRDBMSSite() {
        return this.getDesign().getSelectedRDBMSSite();
    }

    @Override
    public String getShortObjectID() {
        int n;
        if (this.id != null && !"".equalsIgnoreCase(this.id) && (n = this.id.indexOf(45)) > -1) {
            String string = this.id.substring(0, n);
            n = this.id.lastIndexOf(45);
            String string2 = this.id.substring(n + 1);
            return string + '-' + string2;
        }
        return this.id;
    }

    public List getUsedClassificationTypes() {
        Design.DLSettings dLSettings = this.getDesign().getDLSettings();
        HashMap<String, ClassificationType> hashMap = new HashMap<String, ClassificationType>();
        ArrayList<ClassificationType> arrayList = null;
        for (ContainerWithKeyObject containerWithKeyObject : this.getObjectWichAllowClassificationTypes()) {
            String string = containerWithKeyObject.getTypeID();
            if ("".equals(string)) continue;
            boolean bl = true;
            ClassificationType classificationType = (ClassificationType)hashMap.get(string);
            if (classificationType == null) {
                bl = false;
                classificationType = dLSettings.getClassificationTypeByID(string);
            }
            if (classificationType == null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<ClassificationType>();
            }
            arrayList.add(classificationType);
            if (bl) continue;
            hashMap.put(string, classificationType);
        }
        if (arrayList != null) {
            return arrayList;
        }
        return Collections.EMPTY_LIST;
    }

    protected List getObjectWichAllowClassificationTypes() {
        return Collections.EMPTY_LIST;
    }
}

