/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.util.Collections;
import java.util.Iterator;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIDObjectSet;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.SetListener;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.swingui.ApplicationView;

public class DesignObjectCollection
extends ModelIDObjectSet
implements SetListener {
    private static final DesignObject[] PROTO_ARRAY = new DesignObject[0];
    protected boolean requireSort = false;
    Object elDescriptor;
    private boolean canCreateElement = false;

    public DesignObjectCollection() {
        this.requireSort = false;
    }

    public DesignObjectCollection(boolean bl) {
        this.requireSort = bl;
    }

    @Override
    public Object[] getProtoTypeArray() {
        return PROTO_ARRAY;
    }

    @Override
    public ModelIDObject createElement(String string) {
        return null;
    }

    @Override
    public String getDefaultNamePrefix() {
        return "DesignObject";
    }

    @Override
    public boolean canCreateElement() {
        return this.canCreateElement;
    }

    public void setCanCreateElement(boolean bl) {
        this.canCreateElement = bl;
    }

    @Override
    public void add(ModelObject modelObject) {
        if (modelObject instanceof DesignObjectPlaceHolder) {
            modelObject.setParent(this);
        }
        super.add(modelObject);
    }

    @Override
    public void doAdd() {
        if (this.requireSort && ApplicationView.canLogging) {
            this.sort();
        }
    }

    @Override
    public void sort() {
        Collections.sort(this.elements, ModelObjectSet.NAME_COMPARATOR);
    }

    public DesignObjectPlaceHolder removePlaceHolderFor(DesignObject designObject) {
        DesignObject[] designObjectArray = (DesignObject[])this.toArray();
        for (int i = 0; i < designObjectArray.length; ++i) {
            DesignObject designObject2 = designObjectArray[i];
            if (!(designObject2 instanceof DesignObjectPlaceHolder) || ((DesignObjectPlaceHolder)designObject2).getDesignObject() != designObject) continue;
            this.remove(designObject2);
            designObject.removeObjectListener((DesignObjectPlaceHolder)designObject2);
            if (designObject instanceof ContainerObject) {
                ((ContainerObject)designObject).removeContainerListener((DesignObjectPlaceHolder)designObject2);
            }
            return (DesignObjectPlaceHolder)designObject2;
        }
        return null;
    }

    public boolean containsPlaceHolderFor(DesignObject designObject) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            DesignObject designObject2 = (DesignObject)iterator.next();
            if (!(designObject2 instanceof DesignObjectPlaceHolder) || ((DesignObjectPlaceHolder)designObject2).getDesignObject() != designObject) continue;
            return true;
        }
        return false;
    }

    public DesignObjectPlaceHolder getPlaceHolderFor(DesignObject designObject) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            DesignObject designObject2 = (DesignObject)iterator.next();
            if (!(designObject2 instanceof DesignObjectPlaceHolder) || ((DesignObjectPlaceHolder)designObject2).getDesignObject() != designObject) continue;
            return (DesignObjectPlaceHolder)designObject2;
        }
        return null;
    }

    public void setElementDescriptor(Object object) {
        this.elDescriptor = object;
    }

    public Object getElementDescriptor() {
        return this.elDescriptor;
    }

    @Override
    public void changed(DesignObjectSet designObjectSet, SetEvent setEvent) {
        if (SetEvent.SORT_COLLECTION.equals(setEvent)) {
            this.sort();
        }
    }
}

