/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.ChangeRequest;
import oracle.dbtools.crest.model.ElementSet;
import oracle.dbtools.crest.model.LongNameObject;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.TopViewCollection;
import oracle.dbtools.crest.model.businessinfo.BIDocument;
import oracle.dbtools.crest.model.businessinfo.BIResponsibleParty;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.FontObjectWr;
import oracle.dbtools.crest.model.design.Measurement;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.util.logging.Logger;

public abstract class DesignObject
extends ModelIDObject
implements LongNameObject {
    protected String name;
    protected String oldName = null;
    protected DesignObjectSet containerSet = DesignObjectSet.NULL_SET;
    private boolean isBeingRemoved = false;
    private boolean removed = false;
    private TopView topView = null;
    private DesignPart designPart;
    private ArrayList measurements;
    private ArrayList requests;
    private List documents;
    private List responsibleParties;
    private Design importedDesign;
    private String importedId;
    private boolean visible = true;
    private static final Logger LOGGER = new Logger(DesignObject.class);
    private Map engineerTo = new Hashtable();
    private Color backgroundColor = null;
    private Color foregroundColor = null;
    private boolean useDefaultColor = true;
    private int lineWidth = 1;
    protected boolean backup = false;
    protected boolean selected;
    private float loadedVersion = 0.0f;
    public static final DesignObject[] PROTOTYPE = new DesignObject[0];

    public DesignObject(DesignPart designPart) {
        this.designPart = designPart;
        if (designPart != null) {
            this.setDesign(designPart.getDesign());
            if (designPart.isLoaded()) {
                this.setDirty(true);
            }
        }
    }

    public void setDesignObjectSet(DesignObjectSet designObjectSet) {
        this.containerSet = designObjectSet;
        if (designObjectSet == null) {
            this.containerSet = DesignObjectSet.NULL_SET;
        }
    }

    public DesignObjectSet getDesignObjectSet() {
        return this.containerSet;
    }

    public float getVersion() {
        return 1.0f;
    }

    @Override
    public boolean setName(String string) {
        if (this.isWriteable()) {
            Object object;
            String string2;
            String string3;
            if (string != null && string.equals(this.name)) {
                return true;
            }
            boolean bl = this instanceof ContainerObject && !(this instanceof Table) && !(this instanceof TableView);
            String string4 = bl ? this.getName() : this.getLongName();
            String string5 = this.name;
            this.name = string;
            String string6 = string3 = bl ? this.getName() : this.getLongName();
            if (this instanceof Column && ((Column)this).getContainer() != null && !"".equals(string2 = ((Column)this).getContainer().getSchema())) {
                string4 = string2 + "." + string4;
                string3 = string2 + "." + string3;
            }
            if (string3.equalsIgnoreCase(string5)) {
                return true;
            }
            if (this.isBackup()) {
                return true;
            }
            if (!string3.endsWith(string) && !(this instanceof Relation)) {
                this.name = string5;
                return false;
            }
            if (this.containerSet.changeName(string4, string3, this)) {
                this.oldName = string5;
                this.fireChange(ObjectChangeEvent.NAME_CHANGED);
                return true;
            }
            string2 = null;
            if (this instanceof ContainerObject && ((ContainerObject)(object = (ContainerObject)this)).getSchemaObject() != null) {
                string2 = ((ContainerObject)object).getSchemaObject().getName();
            }
            if ((object = this.attemptNameVariant(string2, string3)) != null) {
                String string7;
                int n = string3.length() - string.length();
                this.name = string7 = ((String)object).substring(n);
                if (this.containerSet.changeName(string4, (String)object, this)) {
                    this.oldName = string5;
                    this.fireChange(ObjectChangeEvent.NAME_CHANGED);
                    return true;
                }
                this.name = string5;
                return false;
            }
            this.name = string5;
        }
        return false;
    }

    protected String attemptNameVariant(String string, String string2) {
        if (this.getDesignObjectSet() != null && this.getDesignObjectSet().getCreateNameVariants()) {
            String string3 = this.getDesignObjectSet().createNameVariant(string, string2);
            return string3;
        }
        return null;
    }

    protected String attemptNameVariant(String string) {
        if (this.getDesignObjectSet() != null && this.getDesignObjectSet().getCreateNameVariants()) {
            String string2 = this.getDesignObjectSet().createNameVariant(string);
            return string2;
        }
        return null;
    }

    @Override
    public String getName() {
        if (this.name == null && this.containerSet != null) {
            this.name = this.containerSet.createName(this);
        }
        return this.name;
    }

    public String getOldName() {
        if (this.oldName == null) {
            return this.getName();
        }
        return this.oldName;
    }

    public void setOldName(String string) {
        this.oldName = string;
    }

    public static DesignObject[] getDesignObjectPrototypeArray() {
        return PROTOTYPE;
    }

    @Override
    public String getLongName() {
        return this.getName();
    }

    public String getVeryLongName() {
        return this.getLongName();
    }

    @Override
    public String toString() {
        return this.getLongName();
    }

    public List getMeasurements() {
        if (this.measurements == null) {
            this.measurements = new ArrayList();
        }
        return this.measurements;
    }

    public void addMeasurement(Measurement measurement) {
        this.getMeasurements().add(measurement);
        if (!this.isBackup()) {
            if (measurement.getDesignPart() instanceof LogicalDesign) {
                ((LogicalDesign)measurement.getDesignPart()).getMeasurementSet().add(measurement);
            } else if (measurement.getDesignPart() instanceof RelationalDesign) {
                ((RelationalDesign)measurement.getDesignPart()).getMeasurementSet().add(measurement);
            } else if (measurement.getDesignPart() instanceof ProcessModel) {
                ((ProcessModel)measurement.getDesignPart()).getMeasurementSet().add(measurement);
            }
            this.getDesign().addDesignObject(measurement);
        }
    }

    public void removeMeasurement(Measurement measurement) {
        this.getDesign().removeDesignObject(measurement);
        if (measurement.getDesignPart() instanceof LogicalDesign) {
            ((LogicalDesign)measurement.getDesignPart()).getMeasurementSet().remove(measurement);
        } else if (measurement.getDesignPart() instanceof RelationalDesign) {
            ((RelationalDesign)measurement.getDesignPart()).getMeasurementSet().remove(measurement);
        } else if (measurement.getDesignPart() instanceof ProcessModel) {
            ((ProcessModel)measurement.getDesignPart()).getMeasurementSet().remove(measurement);
        }
        this.getMeasurements().remove(measurement);
    }

    public Measurement createMeasurement() {
        Measurement measurement = new Measurement(this.getDesignPart());
        this.addMeasurement(measurement);
        return measurement;
    }

    public Measurement getMeasurementByID(String string) {
        for (Measurement measurement : this.getMeasurements()) {
            if (!measurement.getObjectID().equals(string)) continue;
            return measurement;
        }
        return null;
    }

    public List getRequests() {
        if (this.requests == null) {
            this.requests = new ArrayList();
        }
        return this.requests;
    }

    public void addRequest(ChangeRequest changeRequest) {
        changeRequest.setObject(this);
        this.getRequests().add(changeRequest);
    }

    public void removeRequest(ChangeRequest changeRequest) {
        this.getRequests().remove(changeRequest);
    }

    public ChangeRequest getRequestByID(String string) {
        for (DesignObject designObject : this.getRequests()) {
            if (!designObject.getObjectID().equals(string)) continue;
            return (ChangeRequest)designObject;
        }
        return null;
    }

    public void clearRequests() {
        for (int i = 0; i < this.getRequests().size(); ++i) {
            ChangeRequest changeRequest = (ChangeRequest)this.getRequests().get(i);
            changeRequest.removeObject(this);
        }
        this.getRequests().clear();
    }

    public List getDocuments() {
        if (this.documents == null) {
            this.documents = new ArrayList();
        }
        return this.documents;
    }

    public void addDocument(BIDocument bIDocument) {
        if (!this.getDocuments().contains(bIDocument)) {
            this.getDocuments().add(bIDocument);
            bIDocument.addElement(this);
        }
    }

    public void removeDocument(BIDocument bIDocument) {
        this.getDocuments().remove(bIDocument);
        bIDocument.removeElement(this);
    }

    public BIDocument getDocumentByID(String string) {
        for (DesignObject designObject : this.getDocuments()) {
            if (!designObject.getObjectID().equals(string)) continue;
            return (BIDocument)designObject;
        }
        return null;
    }

    public void clearDocuments() {
        for (int i = 0; i < this.getDocuments().size(); ++i) {
            BIDocument bIDocument = (BIDocument)this.getDocuments().get(i);
            bIDocument.removeElement(this);
        }
        this.getDocuments().clear();
    }

    public List getResponsibleParties() {
        if (this.responsibleParties == null) {
            this.responsibleParties = new ArrayList();
        }
        return this.responsibleParties;
    }

    public void addResponsibleParty(BIResponsibleParty bIResponsibleParty) {
        if (!this.getResponsibleParties().contains(bIResponsibleParty)) {
            this.getResponsibleParties().add(bIResponsibleParty);
            bIResponsibleParty.addElement(this);
        }
    }

    public void removeResponsibleParty(BIResponsibleParty bIResponsibleParty) {
        this.getResponsibleParties().remove(bIResponsibleParty);
        bIResponsibleParty.removeElement(this);
    }

    public void clearResponsibleParties() {
        for (int i = 0; i < this.getResponsibleParties().size(); ++i) {
            BIResponsibleParty bIResponsibleParty = (BIResponsibleParty)this.getResponsibleParties().get(i);
            bIResponsibleParty.removeElement(this);
        }
        this.getResponsibleParties().clear();
    }

    public BIResponsibleParty getPartyByID(String string) {
        for (DesignObject designObject : this.getResponsibleParties()) {
            if (!designObject.getObjectID().equals(string)) continue;
            return (BIResponsibleParty)designObject;
        }
        return null;
    }

    @Override
    public abstract String getObjectTypeName();

    public abstract boolean isDesignLevelAccessibleObject();

    @Override
    public void remove() {
        if (!this.getIsBeingRemoved()) {
            this.setIsBeingRemoved(true);
            if (this.getDesignObjectSet() != null) {
                this.getDesignObjectSet().remove(this);
            }
            ObjectChangeEvent objectChangeEvent = ObjectChangeEvent.OBJECT_REMOVED;
            objectChangeEvent.setAffected(this);
            this.fireChange(objectChangeEvent);
            this.setIsBeingRemoved(false);
            this.removed = true;
            RepositoryObject repositoryObject = this.getPAC_Element();
            if (repositoryObject != null) {
                repositoryObject.setDirty(true);
            }
            this.closePropertiesDialog();
        }
    }

    public void removeViewSynonim(TopView topView) {
    }

    protected void setIsBeingRemoved(boolean bl) {
        this.isBeingRemoved = bl;
    }

    public boolean getIsBeingRemoved() {
        return this.isBeingRemoved;
    }

    public void addObjectListener(ObjectListener objectListener) {
        if (!this.getListeners().contains(objectListener)) {
            this.getListeners().add(objectListener);
        }
    }

    public void removeObjectListener(ObjectListener objectListener) {
        this.getListeners().remove(objectListener);
    }

    @Override
    protected void fireChange(ObjectChangeEvent objectChangeEvent) {
        if (this.getDesignPart() != null && this.getDesignPart().isLoaded() && !this.getDesign().isLoading()) {
            this.setDirty(true);
            this.getDesignPart().setObjectListChanged(true);
            this.getChange().setTimeNow();
        }
        if (objectChangeEvent.getAffected() == null) {
            objectChangeEvent.setAffected(this);
        }
        ObjectListener[] objectListenerArray = this.getListeners().toArray(new ObjectListener[0]);
        for (int i = 0; i < objectListenerArray.length; ++i) {
            try {
                if (objectListenerArray[i] == null) continue;
                objectListenerArray[i].changed(this, objectChangeEvent);
                continue;
            }
            catch (Exception exception) {
                LOGGER.error("Listener caused exception: ", exception);
            }
        }
    }

    protected void fireChangeNoDirty(ObjectChangeEvent objectChangeEvent) {
        objectChangeEvent.setAffected(this);
        Object[] objectArray = this.getListeners().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            ObjectListener objectListener = (ObjectListener)objectArray[i];
            objectListener.changed(this, objectChangeEvent);
        }
    }

    public void fireNameChangedNoDirty() {
        this.fireChangeNoDirty(ObjectChangeEvent.NAME_CHANGED);
    }

    @Override
    public void setDirty(boolean bl) {
        super.setDirty(bl);
    }

    public String getGeneratorLongName() {
        DesignObject designObject = this.getDesign().getDesignObject(this.getGeneratorID());
        if (designObject != null) {
            return ((ModelObject)designObject).getLongName();
        }
        return "None";
    }

    public boolean isContainedObject() {
        return false;
    }

    public void setTopView(TopView topView) {
        this.topView = topView;
    }

    public TopView getTopView() {
        return this.getFirstViewForDPV(this.getDesignPart().getMainView());
    }

    public TopView getFirstViewForDPV(DesignPartView designPartView) {
        return this.topView;
    }

    public int getViewNumber(TopView topView) {
        return 0;
    }

    public int getViewsCountForDPV(DesignPartView designPartView) {
        return 0;
    }

    public void resetViewNumbers() {
        TopView topView = this.getTopView();
        if (topView != null) {
            topView.setViewNumber(this.getViewNumber(topView));
        }
    }

    public int getTopViewsCount() {
        return 1;
    }

    public DesignPart getDesignPart() {
        return this.designPart;
    }

    public void setDesignPart(DesignPart designPart) {
        this.designPart = designPart;
    }

    public String getDesignPartId() {
        return this.getDesignPart().getObjectID();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public boolean hasAliveGenerator() {
        return true;
    }

    public boolean shouldBeEngineered() {
        if (this.getShouldEngineer()) {
            if (this.getDesign().isEngineerGenerated()) {
                return true;
            }
            if (ModelIDObject.USER_GENERATED.equalsIgnoreCase(this.getGeneratorID())) {
                return true;
            }
        }
        return false;
    }

    public boolean hasRepresentationInDPV(DesignPartView designPartView) {
        return false;
    }

    public boolean hasGUIView() {
        return true;
    }

    public Design getImportedDesign() {
        return this.importedDesign;
    }

    public void setImportedDesign(Design design) {
        if (this.importedDesign != design) {
            this.importedDesign = design;
        }
    }

    public String getImportedId() {
        return this.importedId;
    }

    public void setImportedId(String string) {
        if (string != null && string.equals(this.importedId)) {
            return;
        }
        this.importedId = string;
    }

    protected void copyFormatOptions(DesignObject designObject) {
        if (this.useDefaultColor()) {
            designObject.setUseDefaultColor(true);
        } else {
            designObject.setUseDefaultColor(false);
            designObject.setBackgroundColor(this.getBackgroundColor());
            designObject.setForegroundColor(this.getForegroundColor());
            designObject.setLineWidth(this.getLineWidth());
        }
        if (this instanceof EditableFonts) {
            ((EditableFonts)((Object)designObject)).getEditableFonts().clear();
            for (FontObject fontObject : ((EditableFonts)((Object)this)).getEditableFonts()) {
                ((EditableFonts)((Object)designObject)).getEditableFonts().add(fontObject.copy());
            }
        }
    }

    public void copy(DesignObject designObject) {
        this.copyDefaults(designObject);
        DesignObject.copySourceStamp(this, designObject);
    }

    public void copyDefaults(DesignObject designObject) {
        int n;
        designObject.setName(this.getName());
        designObject.setMarkedGenerate(this.isMarkedGenerate());
        designObject.setComment(this.getComment());
        designObject.setCommentInRDBMS(this.getCommentInRDBMS());
        designObject.setNotes(this.getNotes());
        designObject.setShouldEngineer(this.getShouldEngineer());
        designObject.getMeasurements().clear();
        designObject.getRequests().clear();
        designObject.getResponsibleParties().clear();
        designObject.getDocuments().clear();
        for (n = 0; n < this.getMeasurements().size(); ++n) {
            designObject.addMeasurement((Measurement)this.getMeasurements().get(n));
        }
        for (n = 0; n < this.getRequests().size(); ++n) {
            designObject.addRequest((ChangeRequest)this.getRequests().get(n));
        }
        for (n = 0; n < this.getResponsibleParties().size(); ++n) {
            designObject.addResponsibleParty((BIResponsibleParty)this.getResponsibleParties().get(n));
        }
        for (n = 0; n < this.getDocuments().size(); ++n) {
            designObject.addDocument((BIDocument)this.getDocuments().get(n));
        }
        designObject.clearProperties();
        Iterator iterator = this.getPropertyNames();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = this.getProperty(string);
            if (string2 == null) continue;
            designObject.setProperty(string, string2);
        }
        this.copyFormatOptions(designObject);
    }

    private static void copySourceStamp(ModelObject modelObject, ModelObject modelObject2) {
        if (modelObject != null && modelObject2 != null) {
            if (!"".equals(modelObject.getSourceConnName()) && "".equals(modelObject2.getSourceConnName())) {
                modelObject2.setSourceConnName(modelObject.getSourceConnName());
                modelObject2.setSourceObjName(modelObject.getSourceObjName());
                modelObject2.setSourceObjSchema(modelObject.getSourceObjSchema());
            }
            if (!"".equals(modelObject.getSourceDDLFile()) && "".equals(modelObject2.getSourceDDLFile())) {
                modelObject2.setSourceDDLFile(modelObject.getSourceDDLFile());
            }
        }
    }

    private void applyChangesInDefaultsTo(DesignObject designObject) {
        this.copyDefaults(designObject);
    }

    public void applyChangesTo(DesignObject designObject) {
        this.applyChangesInDefaultsTo(designObject);
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canPaste() {
        return false;
    }

    public void paste() {
    }

    public float getLoadedVersion() {
        return this.loadedVersion;
    }

    public void setLoadedVersion(float f) {
        this.loadedVersion = f;
    }

    public void clearEngineerTo() {
        this.engineerTo.clear();
    }

    public Map getEngineerTo() {
        if (this.getDesignPart() instanceof LogicalDesign && !(this instanceof Domain)) {
            Object object;
            Object[] objectArray = this.engineerTo.keySet().toArray();
            for (int i = objectArray.length - 1; i >= 0; --i) {
                object = objectArray[i];
                if (this.getDesign().getRelationalDesigns().getById((String)object) != null) continue;
                this.engineerTo.remove(object);
            }
            Iterator iterator = this.getDesign().getRelationalDesigns().iterator();
            while (iterator.hasNext()) {
                object = (RelationalDesign)iterator.next();
                if (this.engineerTo.containsKey(((ModelIDObject)object).getObjectID())) continue;
                this.setEngineerTo(((ModelIDObject)object).getObjectID(), true);
            }
        } else {
            this.engineerTo.clear();
        }
        return this.engineerTo;
    }

    public void setEngineerTo(String string, boolean bl) {
        this.engineerTo.put(string, bl);
    }

    @Override
    public void setShouldEngineer(boolean bl) {
        if (this.getDesignPart() instanceof LogicalDesign && !(this instanceof Domain)) {
            String string = this.getDesign().getRelationalDesign().getObjectID();
            this.getEngineerTo().put(string, bl);
        }
        super.setShouldEngineer(bl);
    }

    @Override
    public boolean getShouldEngineer() {
        if (this.getDesignPart() instanceof LogicalDesign) {
            String string = this.getDesign().getRelationalDesign().getObjectID();
            Object v = this.getEngineerTo().get(string);
            if (v != null) {
                return "true".equals(v.toString());
            }
            return true;
        }
        return super.getShouldEngineer();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public TopViewCollection getViewsForDPV(DesignPartView designPartView) {
        TopViewCollection topViewCollection = new TopViewCollection();
        topViewCollection.setDPV(designPartView);
        return topViewCollection;
    }

    public TopView getTopViewByID(DesignPartView designPartView, String string, int n) {
        TopViewCollection topViewCollection = this.getViewsForDPV(designPartView);
        for (TopView topView : topViewCollection) {
            if (!topView.getViewID().equals(string)) continue;
            return topView;
        }
        int n2 = 0;
        for (TopView topView : topViewCollection) {
            if (n == n2) {
                topView.setViewNumber(n);
                return topView;
            }
            ++n2;
        }
        return null;
    }

    public TopView getTopViewByID(DesignPartView designPartView, String string) {
        int n;
        int n2 = 0;
        if (this.getDesign().getLoadedVersion() < 2.4f && (n = string.indexOf(35)) > -1 && n < string.length() - 1) {
            String string2 = string.substring(n + 1);
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getTopViewByID(designPartView, string, n2);
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(Color color) {
        this.foregroundColor = color;
    }

    public boolean useDefaultColor() {
        return this.useDefaultColor;
    }

    public void setUseDefaultColor(boolean bl) {
        this.useDefaultColor = bl;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int n) {
        this.lineWidth = n;
    }

    @Override
    public boolean canBedeleted() {
        if (this.getDesign().isRepositoryRelated()) {
            return this.getDesignPart().isCheckedOutByMe();
        }
        return true;
    }

    public boolean isBackup() {
        return this.backup;
    }

    public void setBackup(boolean bl) {
        this.backup = bl;
    }

    public List getFontObjectWrappers() {
        EditableFonts editableFonts;
        List list;
        if (this instanceof EditableFonts && (list = (editableFonts = (EditableFonts)((Object)this)).getEditableFonts()).size() > 0) {
            ArrayList<FontObjectWr> arrayList = new ArrayList<FontObjectWr>();
            for (FontObject fontObject : list) {
                FontObjectWr fontObjectWr = new FontObjectWr(fontObject);
                arrayList.add(fontObjectWr);
            }
            return arrayList;
        }
        return Collections.EMPTY_LIST;
    }

    public FontObjectWr createFontObjectWr() {
        return new FontObjectWr();
    }

    public void addFontObjectWrapper(FontObjectWr fontObjectWr) {
        if (this instanceof EditableFonts) {
            EditableFonts editableFonts = (EditableFonts)((Object)this);
            List list = editableFonts.getEditableFonts();
            String string = fontObjectWr.getFoType();
            if (string != null) {
                FontObject fontObject = editableFonts.getFontObject(string);
                if (fontObject != null) {
                    list.remove(fontObject);
                }
                fontObject = new FontObject(string, new Font(fontObjectWr.getFontName(), fontObjectWr.getFontStyle(), fontObjectWr.getFontSize()), new Color(fontObjectWr.getColor_RGB()));
                list.add(fontObject);
            }
        }
    }

    @Override
    public String getDirectorySegmentName() {
        if ("".equals(this.directorySegmentName)) {
            this.directorySegmentName = this.getDesignObjectSet().getSegmentName(this);
        }
        return this.directorySegmentName;
    }

    @Override
    public String getSegmentedStorageName() {
        if (this.segmentedStorageName == null) {
            String string = this.getDesignObjectSet().getSegmentName(this);
            if (!"".equals(string)) {
                File file = new File(this.getStorageName());
                String string2 = file.getName();
                this.segmentedStorageName = file.getParent() + "/" + string + "/" + string2;
            } else {
                return super.getSegmentedStorageName();
            }
        }
        return this.segmentedStorageName;
    }

    @Override
    public void setDirectorySegmentName(String string, boolean bl) {
        if (string != null && !"".equals(string)) {
            this.getDesignObjectSet().addSegmentEntry(string, this.getObjectID(), bl);
        }
        this.directorySegmentName = string;
    }

    @Override
    public void setDirectorySegmentName(String string) {
        this.setDirectorySegmentName(string, false);
    }

    public String getSchema() {
        return "";
    }

    public boolean hasProxyToDelete() {
        return false;
    }

    @Override
    public RDBMSSite getSelectedRDBMSSite() {
        return this.getDesignPart().getSelectedRDBMSSite();
    }

    @Override
    public ElementSet getSet() {
        return this.getDesignObjectSet();
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean bl) {
        this.removed = bl;
    }

    @Override
    public void setObjectID(String string) {
        String string2 = this.id;
        super.setObjectID(string);
        if (string2 != null && !string2.equals(string)) {
            this.fireChange(ObjectChangeEvent.OBJECT_ID_CHANED);
        }
    }
}

