/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.util.Iterator;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignPart;

public class ContainerObjectPlaceHolderRecursive
extends DesignObjectPlaceHolder {
    private DesignObjectCollection elements = new DesignObjectCollection();

    public ContainerObjectPlaceHolderRecursive(DesignPart designPart, DesignObject designObject) {
        super(designPart, designObject);
        this.loadElements(designObject);
    }

    public ContainerObjectPlaceHolderRecursive(DesignPart designPart, String string) {
        super(designPart, string);
    }

    public ContainerObjectPlaceHolderRecursive(DesignPart designPart, DesignObject designObject, boolean bl) {
        this(designPart, designObject);
        this.propagate = bl;
    }

    public void loadElements(DesignObject designObject) {
        int n = designObject.getNumberOfChildren();
        for (int i = 0; i < n; ++i) {
            ModelObject modelObject;
            ModelObject modelObject2;
            ModelObject modelObject3 = designObject.getChild(i);
            if (modelObject3 instanceof DesignObjectCollection) {
                modelObject2 = (DesignObjectCollection)modelObject3;
                modelObject = new DesignObjectCollection();
                modelObject.setName(((ModelObjectSet)modelObject2).getName());
                modelObject.setParent(this);
                ((DesignObjectCollection)modelObject).setElementDescriptor(((DesignObjectCollection)modelObject2).getElementDescriptor());
                this.elements.add(modelObject);
                Iterator iterator = ((ModelObjectSet)modelObject2).iterator();
                while (iterator.hasNext()) {
                    modelObject3 = iterator.next();
                    if (!(modelObject3 instanceof DesignObject)) continue;
                    DesignObject designObject2 = modelObject3 instanceof DesignObjectPlaceHolder ? ((DesignObjectPlaceHolder)modelObject3).getDesignObject() : (DesignObject)modelObject3;
                    DesignObjectPlaceHolder designObjectPlaceHolder = new DesignObjectPlaceHolder(designObject2.getDesignPart(), designObject2);
                    designObjectPlaceHolder.setParent(modelObject);
                    ((DesignObjectCollection)modelObject).add(designObjectPlaceHolder);
                }
                continue;
            }
            if (!(modelObject3 instanceof DesignObject)) continue;
            modelObject2 = (DesignObject)modelObject3;
            modelObject = new DesignObjectPlaceHolder(((DesignObject)modelObject2).getDesignPart(), (DesignObject)modelObject2);
            ((DesignObjectPlaceHolder)modelObject).setParent(this);
            this.elements.add(modelObject);
            ((DesignObjectPlaceHolder)modelObject).setParent(this);
        }
    }

    @Override
    public void setShouldEngineer(boolean bl) {
        if (this.getDesignObject() != null) {
            this.getDesignObject().setShouldEngineer(bl);
            if (this.propagate) {
                this.propagateShouldEngineer(bl);
            }
        }
    }

    @Override
    public void propagateShouldEngineer(boolean bl) {
        int n = this.getNumberOfChildren();
        for (int i = 0; i < n; ++i) {
            ModelObject modelObject;
            ModelObject modelObject2 = this.getChild(i);
            if (modelObject2 instanceof DesignObject) {
                modelObject = (DesignObject)modelObject2;
                ((DesignObject)modelObject).setShouldEngineer(bl);
                continue;
            }
            if (!(modelObject2 instanceof DesignObjectCollection)) continue;
            modelObject = (DesignObjectCollection)modelObject2;
            Iterator iterator = ((ModelObjectSet)modelObject).iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof DesignObject)) continue;
                DesignObject designObject = (DesignObject)e;
                designObject.setShouldEngineer(bl);
            }
        }
    }

    public int getIndexOf(ContainedObject containedObject) {
        return ((ContainerObject)this.getDesignObject()).getIndexOf(containedObject);
    }

    @Override
    public int getNumberOfChildren() {
        return this.elements.size();
    }

    @Override
    public ModelObject getChild(int n) {
        return (ModelObject)this.elements.getChildPlain(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        return this.elements.getIndexForChild(modelObject);
    }

    @Override
    public boolean isLeaf() {
        return this.getNumberOfChildren() < 1;
    }
}

