/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import oracle.dbtools.crest.model.design.DesignObject;

public class ContainerObjectEvent {
    public static final int ELEMENT_ADDED = 0;
    public static final int ELEMENT_REMOVED = 1;
    public static final int PK_REMOVED = 2;
    public static final int PK_SET = 3;
    public static final int CAND_KEY_REMOVED = 4;
    public static final int CAND_KEY_ADDED = 5;
    public static final int ELEMENT_HAS_CHANGED = 6;
    public static final int ELEMENT_HAS_MOVED = 7;
    public static final int ELEMENT_HAS_RENAMED = 8;
    public static final int STRUCTURE_CHANGED = 9;
    public static final int UNDEFINED = -1;
    private DesignObject element;
    private int type = -1;

    public void setElement(DesignObject designObject) {
        this.element = designObject;
    }

    public DesignObject getElement() {
        return this.element;
    }

    public void setType(int n) {
        this.type = n;
    }

    public boolean isType(int n) {
        return this.type == n;
    }

    public void clear() {
        this.type = -1;
    }

    public DesignObject getAffectedElement() {
        return this.element;
    }

    public String toString() {
        switch (this.type) {
            case 0: {
                return "ELEMENT_ADDED";
            }
            case 1: {
                return "ELEMENT_REMOVED";
            }
            case 2: {
                return "PK_REMOVED";
            }
            case 3: {
                return "PK_SET";
            }
            case 4: {
                return "CAND_KEY_REMOVED";
            }
            case 5: {
                return "CAND_KEY_ADDED";
            }
            case 6: {
                return "ELEMENT_HAS_CHANGED";
            }
            case 7: {
                return "ELEMENT_HAS_MOVED";
            }
            case 8: {
                return "ELEMENT_HAS_RENAMED";
            }
            case 9: {
                return "STRUCTURE_CHANGED";
            }
            case -1: {
                return "UNDEFINED";
            }
        }
        super.toString();
        return super.toString();
    }
}

