/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.dbtools.crest.model.IDGenerator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.MultiShapedDesignObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.SetListener;
import oracle.dbtools.crest.model.SubsetCO;
import oracle.dbtools.crest.model.Task;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObjectEvent;
import oracle.dbtools.crest.model.design.ContainerObjectListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.StructuredTypeSet;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.SchemaObjectSet;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.LongNameComparator;

public abstract class ContainerObject
extends MultiShapedDesignObject
implements ObjectListener,
SetListener {
    public static Comparator longNameSorter = new LongNameComparator();
    private List elements = new ArrayList();
    private Set containerListeners = new HashSet();
    protected ContainerObjectEvent sharedEvent = new ContainerObjectEvent();
    private IDGenerator localIDGenerator;
    private Map localIDs = new TreeMap();
    protected List typeSubstitutions = new ArrayList();
    private TypeSubstitution typeSubstitution;
    private String typeSubstitutionID;
    private String typeSubstitutionParentID;
    protected List nestedElements = new ArrayList();
    private String beforeDrop = "";
    private String beforeCreate = "";
    private String beforeAlter = "";
    private String afterCreate = "";
    private String afterAlter = "";
    private String endOfScript = "";
    private boolean beforeAlterAdded = false;
    private boolean afterAlterAdded = false;
    private boolean shouldGenerateScript = false;
    private boolean allowTypeSubstitution = true;
    private String schema;
    protected SchemaObject schemaObject;
    private SchemaObject oldSchemaObject;
    protected StructuredType basedOnStructuredType = null;
    private static final Logger LOGGER = new Logger(ContainerObject.class);
    public static final String TYPE_FACT = Messages.getString("ContainerObject.TypeFact");
    public static final String TYPE_DIMENSION = Messages.getString("ContainerObject.TypeDimension");
    public static final String TYPE_CONSOLIDATED = Messages.getString("ContainerObject.TypeConsolidated");
    public static final String TYPE_SUMMARY = Messages.getString("ContainerObject.TypeSummary");
    public static final String TYPE_TEMPORARY = Messages.getString("ContainerObject.TypeTemporary");
    public static final String TYPE_LOGGING = Messages.getString("ContainerObject.TypeLogging");

    public ContainerObject(DesignPart designPart) {
        super(designPart);
    }

    public abstract DesignObjectSet getContainedSet();

    public abstract ContainedObject createContainedObject(String var1);

    public ContainedObject createContainedObject() {
        return this.createContainedObject(null);
    }

    public void add(ContainedObject containedObject) {
        if (containedObject == null || this.isReadOnly()) {
            return;
        }
        if (!this.acceptDoubles() && this.contains(containedObject)) {
            return;
        }
        if (this.getContainedClass().isAssignableFrom(containedObject.getClass())) {
            ContainedObjectWithDomain containedObjectWithDomain;
            this.assignLocalID(containedObject);
            if (!containedObject.isNested()) {
                this.elements.add(containedObject);
            } else {
                this.nestedElements.add(containedObject);
            }
            if (!(this instanceof SubsetCO)) {
                containedObject.setContainer(this);
            }
            containedObject.addObjectListener(this);
            if (!this.isBackup()) {
                this.getDesign().addDesignObject(containedObject);
            }
            this.sharedEvent.setElement(containedObject);
            this.sharedEvent.setType(0);
            this.fireChange(this.sharedEvent);
            if (containedObject instanceof ContainedObjectWithDomain && (containedObjectWithDomain = (ContainedObjectWithDomain)containedObject).getDataType() instanceof StructuredType) {
                ((StructuredType)containedObjectWithDomain.getDataType()).removeObjectListener(this);
                ((StructuredType)containedObjectWithDomain.getDataType()).addObjectListener(this);
                this.updateStructure();
            }
        } else {
            LOGGER.error("Class: " + containedObject.getClass());
            LOGGER.error("Expected: " + this.getContainedClass());
            throw new RuntimeException("Wrong class added to container.");
        }
    }

    public boolean contains(ContainedObject containedObject) {
        return this.elements.contains(containedObject);
    }

    public Map getReferIDMap() {
        return null;
    }

    public boolean containsAll(Collection collection) {
        return this.elements.containsAll(collection);
    }

    public boolean acceptDoubles() {
        return false;
    }

    public ContainerObject getTopLevelContainer() {
        return this;
    }

    @Override
    public void remove() {
        if (this.basedOnStructuredType != null) {
            this.basedOnStructuredType.removeObjectListener(this);
            this.getDesign().getDataTypesDesign().getStructuredTypeSet().removeSetListener(this);
        }
        if (this.typeSubstitution != null) {
            this.typeSubstitution.remove();
        }
        Object[] objectArray = this.typeSubstitutions.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            ((TypeSubstitution)objectArray[i]).remove();
        }
        this.removeAll();
        this.localIDs.clear();
        super.remove();
        this.basedOnStructuredType = null;
    }

    public void remove(ContainedObject containedObject) {
        if (containedObject != null && this.isWriteable()) {
            this.elements.remove(containedObject);
            this.removeNestedCOFor(containedObject);
            this.nestedElements.remove(containedObject);
            if (!(this instanceof SubsetCO)) {
                containedObject.setContainer(null);
            }
            this.localIDs.remove(containedObject.getObjectID());
            containedObject.removeObjectListener(this);
            containedObject.setParent(this);
            this.getDesign().removeDesignObject(containedObject);
            this.sharedEvent.setElement(containedObject);
            this.sharedEvent.setType(1);
            this.fireChange(this.sharedEvent);
        }
    }

    public void removeNestedCOFor(ContainedObject containedObject) {
        Object[] objectArray = this.nestedElements.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            ContainedObject containedObject2 = (ContainedObject)objectArray[i];
            if (containedObject2.getParentObject() != containedObject) continue;
            this.removeNestedCOFor(containedObject2);
            containedObject2.remove();
            this.nestedElements.remove(containedObject2);
        }
    }

    public ContainedObject[] removeAll() {
        ContainedObject[] containedObjectArray = this.getElements();
        for (int i = 0; i < containedObjectArray.length; ++i) {
            containedObjectArray[i].remove();
        }
        return containedObjectArray;
    }

    public Collection getElementsCollection() {
        return this.elements;
    }

    public Collection getElementsCollectionImmutable() {
        return Collections.unmodifiableList(this.elements);
    }

    protected void removeLocalId(String string) {
        this.localIDs.remove(string);
    }

    public ContainedObject[] getElements() {
        return this.toContainedObjectArray(this.elements);
    }

    public ContainedObject getElement(int n) {
        return (ContainedObject)this.elements.get(n);
    }

    public ContainedObject[] toContainedObjectArray(Collection collection) {
        return (ContainedObject[])collection.toArray((Object[])Array.newInstance(this.getContainedClass(), 0));
    }

    public Class getContainedClass() {
        return ContainedObject.class;
    }

    public void addContainerListener(ContainerObjectListener containerObjectListener) {
        this.containerListeners.add(containerObjectListener);
    }

    public void removeContainerListener(ContainerObjectListener containerObjectListener) {
        this.containerListeners.remove(containerObjectListener);
    }

    public Collection getContainerListeners() {
        return this.containerListeners;
    }

    protected void fireChange(ContainerObjectEvent containerObjectEvent) {
        Object[] objectArray = this.containerListeners.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                ((ContainerObjectListener)objectArray[i]).changed(this, containerObjectEvent);
                continue;
            }
            catch (Exception exception) {
                LOGGER.error("ContainerListener caused exception", exception);
            }
        }
    }

    protected void assignLocalID(ModelIDObject modelIDObject) {
        String string = modelIDObject.getObjectID();
        if (string == null) {
            while (this.localIDs.containsKey(string = this.getLocalIDGenerator().createNewID())) {
            }
            this.localIDs.put(string, modelIDObject);
            modelIDObject.setObjectID(string);
        } else if (this.localIDs.containsKey(string)) {
            while (this.localIDs.containsKey(string = this.getLocalIDGenerator().createNewID())) {
            }
        }
    }

    public ModelIDObject getLocalObject(String string) {
        ModelIDObject modelIDObject = (ModelIDObject)this.localIDs.get(string);
        if (modelIDObject == null) {
            modelIDObject = this.getElementByID(string);
        }
        return modelIDObject;
    }

    public void updateLocalObjectId(String string, String string2) {
        Object v = this.localIDs.get(string);
        if (v != null) {
            this.localIDs.remove(string);
            this.localIDs.put(string2, v);
        }
    }

    public void putInLocalIDMap(String string, ModelIDObject modelIDObject) {
        this.localIDs.put(string, modelIDObject);
    }

    public IDGenerator getLocalIDGenerator() {
        if (this.localIDGenerator == null) {
            this.localIDGenerator = new IDGenerator();
            this.localIDGenerator.initializeWith(10000L, 3000000L);
        }
        return this.localIDGenerator;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    public int size() {
        return this.elements.size();
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
        ContainedObjectWithDomain containedObjectWithDomain;
        if (designObject instanceof StructuredType) {
            this.updateStructure();
        }
        this.sharedEvent.setElement(designObject);
        this.sharedEvent.setType(6);
        this.fireChange(this.sharedEvent);
        if (designObject instanceof ContainedObjectWithDomain && (containedObjectWithDomain = (ContainedObjectWithDomain)designObject).getDataType() instanceof StructuredType) {
            if (ObjectChangeEvent.OBJECT_REMOVED == objectChangeEvent) {
                ((StructuredType)containedObjectWithDomain.getDataType()).removeObjectListener(this);
            } else {
                ((StructuredType)containedObjectWithDomain.getDataType()).removeObjectListener(this);
                ((StructuredType)containedObjectWithDomain.getDataType()).addObjectListener(this);
            }
        }
    }

    @Override
    public void changed(DesignObjectSet designObjectSet, SetEvent setEvent) {
        if (designObjectSet instanceof StructuredTypeSet && setEvent.isRemoved() && setEvent.getAffected() == this.basedOnStructuredType) {
            this.basedOnStructuredType.removeObjectListener(this);
            this.getDesign().getDataTypesDesign().getStructuredTypeSet().removeSetListener(this);
            this.clearTypeSubstitutions();
            this.clearStructure();
            this.basedOnStructuredType = null;
        }
        if (this.schemaObject != null && designObjectSet instanceof SchemaObjectSet && setEvent.isRemoved() && setEvent.getAffected() == this.schemaObject) {
            this.schemaObject = null;
            designObjectSet.removeSetListener(this);
            this.setDirty(true);
        }
    }

    public ContainedObject getElementGeneratedBy(DesignObject designObject) {
        return this.getElementGeneratedBy(designObject.getObjectID());
    }

    public ContainedObject getElementGeneratedBy(String string) {
        Iterator iterator = this.elements.iterator();
        while (iterator.hasNext()) {
            ContainedObject containedObject = (ContainedObject)iterator.next();
            if (!string.equals(containedObject.getGeneratorID())) continue;
            iterator = null;
            return containedObject;
        }
        iterator = null;
        return null;
    }

    public ContainedObject[] getAllElementsGeneratedBy(DesignObject designObject) {
        return this.getAllElementsGeneratedBy(designObject.getObjectID());
    }

    public ContainedObject[] getAllElementsGeneratedBy(String string) {
        List list = this.getAllElementsListGeneratedBy(string);
        return this.toContainedObjectArray(list);
    }

    public List getAllElementsListGeneratedBy(ModelIDObject modelIDObject) {
        return this.getAllElementsListGeneratedBy(modelIDObject.getObjectID());
    }

    public List getAllElementsListGeneratedBy(String string) {
        ArrayList<ContainedObject> arrayList = new ArrayList<ContainedObject>();
        for (ContainedObject containedObject : this.elements) {
            if (!string.equals(containedObject.getGeneratorID())) continue;
            arrayList.add(containedObject);
        }
        return arrayList;
    }

    public ContainedObject getElementByID(String string) {
        if (string == null) {
            return null;
        }
        Iterator iterator = this.elements.iterator();
        while (iterator.hasNext()) {
            ContainedObject containedObject = (ContainedObject)iterator.next();
            if (!string.equals(containedObject.getObjectID())) continue;
            iterator = null;
            return containedObject;
        }
        iterator = null;
        return null;
    }

    public ContainedObject getElementByName(String string) {
        if (string == null) {
            return null;
        }
        for (ContainedObject containedObject : this.elements) {
            if (!string.equalsIgnoreCase(containedObject.getName())) continue;
            return containedObject;
        }
        return null;
    }

    public boolean moveAfter(ContainedObject containedObject, ContainedObject containedObject2) {
        if (this.elements.contains(containedObject) && this.elements.contains(containedObject2) && !containedObject.equals(containedObject2)) {
            this.elements.remove(containedObject);
            int n = this.elements.indexOf(containedObject2) + 1;
            this.elements.add(n, containedObject);
            this.sharedEvent.setType(7);
            this.sharedEvent.setElement(containedObject);
            this.fireChange(this.sharedEvent);
            return true;
        }
        return false;
    }

    public boolean moveToIndex(ContainedObject containedObject, int n) {
        if (this.elements.contains(containedObject) && this.elements.size() > n && n >= 0) {
            this.elements.remove(containedObject);
            this.elements.add(n, containedObject);
            this.sharedEvent.setType(7);
            this.sharedEvent.setElement(containedObject);
            this.fireChange(this.sharedEvent);
            return true;
        }
        return false;
    }

    public int getIndexOf(ContainedObject containedObject) {
        return this.elements.indexOf(containedObject);
    }

    @Override
    public int getNumberOfChildren() {
        return this.elements.size();
    }

    @Override
    public ModelObject getChild(int n) {
        return (ModelObject)this.elements.get(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        return this.elements.indexOf(modelObject);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public int getNumberOfNullsAllowingElements() {
        int n = 0;
        ContainedObject[] containedObjectArray = this.getElements();
        for (int i = 0; i < containedObjectArray.length; ++i) {
            if (!containedObjectArray[i].getNullsAllowed()) continue;
            ++n;
        }
        return n;
    }

    protected int getByteSize(String string) {
        if (this.getContainedClass().isAssignableFrom(ContainedObjectWithDomain.class)) {
            int n = 0;
            ContainedObjectWithDomain[] containedObjectWithDomainArray = (ContainedObjectWithDomain[])this.getElements();
            for (int i = 0; i < containedObjectWithDomainArray.length; ++i) {
                n += containedObjectWithDomainArray[i].getDomain().getDataType(string).getByteSize();
            }
            return n;
        }
        throw new IllegalStateException("Only ContainerObjects containing ContainedObjectWithDomain elements can calculate bytesizes");
    }

    public StructuredType getBasedOnStructuredType() {
        return this.basedOnStructuredType;
    }

    public void setBasedOnStructuredType(StructuredType structuredType) {
        if (this.basedOnStructuredType != structuredType && !this.getDesign().isLoading()) {
            if (this.basedOnStructuredType != null) {
                this.basedOnStructuredType.removeObjectListener(this);
                this.getDesign().getDataTypesDesign().getStructuredTypeSet().removeSetListener(this);
            }
            this.clearTypeSubstitutions();
            this.clearStructure();
            this.basedOnStructuredType = structuredType;
            if (this.basedOnStructuredType != null) {
                if (!this.isBackup()) {
                    this.basedOnStructuredType.addObjectListener(this);
                    this.getDesign().getDataTypesDesign().getStructuredTypeSet().addSetListener(this);
                }
                this.updateStructure();
            }
        } else if (this.basedOnStructuredType != structuredType && this.getDesign().isLoading()) {
            if (this.basedOnStructuredType != null) {
                this.basedOnStructuredType.removeObjectListener(this);
                this.getDesign().getDataTypesDesign().getStructuredTypeSet().removeSetListener(this);
            }
            this.basedOnStructuredType = structuredType;
            if (this.basedOnStructuredType != null) {
                this.basedOnStructuredType.addObjectListener(this);
                this.getDesign().getDataTypesDesign().getStructuredTypeSet().addSetListener(this);
            }
        }
        this.basedOnStructuredType = structuredType;
    }

    public boolean isBST() {
        return this.basedOnStructuredType != null;
    }

    protected abstract void clearStructure();

    protected abstract void updateStructure();

    public ContainedObject getElementByStructAttributeID(String string) {
        if (string != null) {
            for (ContainedObject containedObject : this.elements) {
                if (!containedObject.getStructAttributeID().equalsIgnoreCase(string)) continue;
                return containedObject;
            }
        }
        return null;
    }

    public ContainedObject getElementByStructAttributeID(String string, ContainedObject containedObject) {
        if (string != null) {
            for (ContainedObject containedObject2 : this.elements) {
                if (!containedObject2.getStructAttributeID().equalsIgnoreCase(string) || containedObject2.getParentObject() != containedObject) continue;
                return containedObject2;
            }
            for (ContainedObject containedObject2 : this.nestedElements) {
                if (!containedObject2.getStructAttributeID().equalsIgnoreCase(string) || containedObject2.getParentObject() != containedObject) continue;
                return containedObject2;
            }
        }
        return null;
    }

    public ContainedObject getOidElement() {
        if (this.isBST()) {
            for (ContainedObject containedObject : this.getElementsCollection()) {
                if (!containedObject.isOid()) continue;
                return containedObject;
            }
        }
        return null;
    }

    public List getSubTypeSubstitutions() {
        return this.typeSubstitutions;
    }

    public TypeSubstitution getTypeSubstitution() {
        return this.typeSubstitution;
    }

    public void setTypeSubstitution(TypeSubstitution typeSubstitution) {
        if (this.typeSubstitution != typeSubstitution) {
            this.typeSubstitution = typeSubstitution;
            this.fireChange(ObjectChangeEvent.ROOT_CHANGED);
        }
    }

    public void clearTypeSubstitution(TypeSubstitution typeSubstitution) {
        if (this.typeSubstitution == typeSubstitution) {
            this.typeSubstitution = null;
            this.typeSubstitutionID = null;
            this.typeSubstitutionParentID = null;
            if (typeSubstitution != null) {
                this.fireChange(ObjectChangeEvent.ROOT_CHANGED);
            }
        }
    }

    public boolean isSubstitutable() {
        return this.hasTypeSubstitutionChildren() || this.isAllowTypeSubstitution();
    }

    public boolean hasTypeSubstitutionChildren() {
        return this.getSubTypeSubstitutions().size() > 0;
    }

    public boolean isRoot() {
        if (this.isBST()) {
            if (this.hasTypeSubstitutionChildren()) {
                return this.getTypeSubstitution() == null;
            }
            return this.getTypeSubstitution() == null;
        }
        return false;
    }

    public boolean isPartOfTypeSubstHierarchy() {
        return this.hasTypeSubstitutionChildren() || this.getTypeSubstitution() != null;
    }

    public List getNestedElements() {
        return this.nestedElements;
    }

    public static String getContainerID_From(String string) {
        int n = string.lastIndexOf(35);
        if (n > 0) {
            return string.substring(0, n);
        }
        return "null";
    }

    public String getAfterAlter() {
        return this.afterAlter;
    }

    public void setAfterAlter(String string) {
        this.afterAlter = string;
    }

    public String getAfterCreate() {
        return this.afterCreate;
    }

    public void setAfterCreate(String string) {
        this.afterCreate = string;
    }

    public String getBeforeAlter() {
        return this.beforeAlter;
    }

    public void setBeforeAlter(String string) {
        this.beforeAlter = string;
    }

    public String getBeforeCreate() {
        return this.beforeCreate;
    }

    public void setBeforeCreate(String string) {
        this.beforeCreate = string;
    }

    public String getBeforeDrop() {
        return this.beforeDrop;
    }

    public void setBeforeDrop(String string) {
        this.beforeDrop = string;
    }

    public String getEndOfScript() {
        return this.endOfScript;
    }

    public void setEndOfScript(String string) {
        this.endOfScript = string;
    }

    public boolean isAfterAlterAdded() {
        return this.afterAlterAdded;
    }

    public void setAfterAlterAdded(boolean bl) {
        this.afterAlterAdded = bl;
    }

    public boolean isBeforeAlterAdded() {
        return this.beforeAlterAdded;
    }

    public void setBeforeAlterAdded(boolean bl) {
        this.beforeAlterAdded = bl;
    }

    public boolean getShouldGenerateScript() {
        return this.shouldGenerateScript;
    }

    public void setShouldGenerateScript(boolean bl) {
        this.shouldGenerateScript = bl;
    }

    public boolean isAllowTypeSubstitution() {
        return this.allowTypeSubstitution;
    }

    public void setAllowTypeSubstitution(boolean bl) {
        this.allowTypeSubstitution = bl;
    }

    public List getElementsByStructuredType(StructuredType structuredType) {
        ArrayList<ContainedObject> arrayList = new ArrayList<ContainedObject>();
        if (structuredType != null) {
            TypeElement[] typeElementArray = structuredType.getElements();
            for (int i = 0; i < typeElementArray.length; ++i) {
                ContainedObject containedObject = this.getElementByStructAttributeID(typeElementArray[i].getObjectID());
                if (containedObject == null) continue;
                arrayList.add(containedObject);
            }
        }
        return arrayList;
    }

    @Override
    public String getSchema() {
        if (this.getSchemaObject() != null) {
            return this.getSchemaObject().getName();
        }
        if (this.schema == null) {
            return "";
        }
        return this.schema;
    }

    public void setSchema(String string) {
        this.schema = string;
        if (this.getDesignPart() instanceof RelationalDesign && this.getSchemaObject() == null && string != null && !"".equals(string)) {
            RelationalDesign relationalDesign = (RelationalDesign)this.getDesignPart();
            SchemaObject schemaObject = (SchemaObject)relationalDesign.getSchemaObjectSet().getByName(string);
            if (schemaObject == null) {
                schemaObject = relationalDesign.getSchemaObjectSet().createSchemaObject(null);
                schemaObject.setName(string);
            }
            this.setSchemaObject(schemaObject);
        }
    }

    public String getTypeSubstitutionParentID() {
        if (this.typeSubstitution != null && this.typeSubstitution.getParentContainerObject() != null) {
            this.typeSubstitutionParentID = this.typeSubstitution.getParentContainerObject().getObjectID();
        }
        return this.typeSubstitutionParentID;
    }

    public void setTypeSubstitutionParentID(String string) {
        this.typeSubstitutionParentID = string;
    }

    public String getTypeSubstitutionID() {
        if (this.typeSubstitution != null) {
            this.typeSubstitutionID = this.typeSubstitution.getObjectID();
        }
        return this.typeSubstitutionID;
    }

    private void createTypeSubstitution() {
        ContainerObject containerObject = (ContainerObject)this.getDesign().getDesignObject(this.typeSubstitutionParentID);
        if (containerObject != null) {
            TypeSubstitution typeSubstitution = (TypeSubstitution)this.getDesign().getDesignObject(this.typeSubstitutionID);
            if (typeSubstitution == null) {
                DesignPart designPart = this.getDesignPart();
                if (designPart instanceof LogicalDesign) {
                    typeSubstitution = ((LogicalDesign)designPart).createTypeSubstitution(this.typeSubstitutionID);
                } else if (designPart instanceof RelationalDesign) {
                    typeSubstitution = ((RelationalDesign)designPart).createTypeSubstitution(this.typeSubstitutionID);
                }
            }
            if (typeSubstitution != null) {
                typeSubstitution.setChildContainerObject(this);
                typeSubstitution.setParentContainerObject(containerObject);
            }
        }
    }

    public void setTypeSubstitutionID(String string) {
        this.typeSubstitutionID = string;
        if (string != null && !"".equals(string)) {
            ContainerObject containerObject;
            if (this.typeSubstitution != null && !this.typeSubstitution.getObjectID().equals(string)) {
                this.typeSubstitution.remove();
            }
            if ((containerObject = (ContainerObject)this.getDesign().getDesignObject(this.typeSubstitutionParentID)) != null) {
                this.createTypeSubstitution();
            } else {
                this.getDesignPart().addTask(new CreateTypeSubstitutionTask(this));
            }
        } else if (this.typeSubstitution != null) {
            this.typeSubstitution.remove();
        }
    }

    public SchemaObject getSchemaObject() {
        return this.schemaObject;
    }

    public SchemaObject getOldSchemaObject() {
        return this.oldSchemaObject;
    }

    public void setSchemaObject(SchemaObject schemaObject) {
        this.oldSchemaObject = this.getSchemaObject();
        String string = this.getName();
        if (this.schemaObject != schemaObject) {
            this.setDirty(true);
        }
        this.schemaObject = schemaObject;
        if (!this.isBackup() && !this.getDesignObjectSet().updateNamesMap(this.oldSchemaObject, string, schemaObject, string, this)) {
            String string2 = null;
            string2 = schemaObject != null ? this.attemptNameVariant(schemaObject.getName(), string) : this.attemptNameVariant(string);
            if (string2 != null) {
                this.name = string2;
                this.getDesignObjectSet().updateNamesMap(this.oldSchemaObject, string, schemaObject, string2, this);
            }
        }
        if (schemaObject != null) {
            schemaObject.getDesignObjectSet().addSetListener(this);
        }
        this.schema = null;
        this.fireChange(ObjectChangeEvent.SCHEMA_CHANGED);
    }

    @Override
    public void copy(DesignObject designObject) {
        super.copy(designObject);
        this.copySchemaObject((ContainerObject)designObject);
    }

    private void copySchemaObject(ContainerObject containerObject) {
        if (this.getDesignPart() == containerObject.getDesignPart()) {
            containerObject.setSchemaObject(this.getSchemaObject());
        } else if (this.getDesignPart() instanceof RelationalDesign && this.getSchemaObject() != null) {
            RelationalDesign relationalDesign = (RelationalDesign)containerObject.getDesignPart();
            SchemaObject schemaObject = (SchemaObject)relationalDesign.getSchemaObjectSet().getByName(this.getSchemaObject().getName());
            if (schemaObject == null) {
                schemaObject = relationalDesign.getSchemaObjectSet().createSchemaObject(null);
                schemaObject.setName(this.getSchemaObject().getName());
            }
            containerObject.setSchemaObject(schemaObject);
        }
    }

    private void clearTypeSubstitutions() {
        Object[] objectArray = this.getSubTypeSubstitutions().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof TypeSubstitution)) continue;
            ((TypeSubstitution)objectArray[i]).remove();
        }
        if (this.getTypeSubstitution() != null) {
            this.getTypeSubstitution().remove();
        }
    }

    public class CreateTypeSubstitutionTask
    implements Task {
        private static final String TASK_NAME = "create TypeSubstitution task";
        ContainerObject co;

        CreateTypeSubstitutionTask(ContainerObject containerObject2) {
            this.co = containerObject2;
        }

        @Override
        public boolean execute() {
            this.co.createTypeSubstitution();
            return this.co.typeSubstitution != null;
        }

        public String toString() {
            return TASK_NAME;
        }
    }
}

