/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.LongNameObject;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;

public abstract class ContainedObjectWithDomain
extends ContainedObject
implements ObjectListener {
    public static final short DOMAIN = 0;
    public static final short LOGICAL_TYPE = 1;
    public static final short DISTINCT_TYPE = 2;
    public static final short STRUCTURED_TYPE = 3;
    public static final short COLLECTION_TYPE = 4;
    public static final String SUBST_NONE = "NONE";
    public static final String SUBST_ALL = "ALL";
    public static final String SUBST_RESTRICTED = "RESTRICTED";
    public static final String[] SUBST_OPTIONS = new String[]{"NONE", "ALL", "RESTRICTED"};
    private short use = 0;
    private boolean reference = false;
    private Domain domain;
    private LogicalDatatype logicalDatatype = null;
    private DistinctType distinctType = null;
    private boolean allowSubtypeSubstitution = true;
    private Map parameters = new TreeMap();
    private boolean restrictedTypeSubstitution = false;
    private List permittedSubTypes = new ArrayList();
    private boolean usesDefault;
    private String defaultValue;
    private String separatedCheckConstraint = "";
    private String separatedRangeConstraint = "";
    private String separatedValueConstraint = "";

    public ContainedObjectWithDomain(DesignPart designPart) {
        super(designPart);
    }

    public void setDomain(Domain domain) {
        if (this.domain == domain) {
            return;
        }
        if (this.domain != null) {
            this.domain.removeObjectListener(this);
        }
        this.domain = domain;
        if (domain != null) {
            if (this.logicalDatatype != domain.getLogicalDatatype()) {
                this.logicalDatatype = domain.getLogicalDatatype();
            }
            if (!"Unknown".equalsIgnoreCase(domain.getName())) {
                domain.addObjectListener(this);
            }
            ObjectChangeEvent objectChangeEvent = ObjectChangeEvent.DOMAIN_CHANGED;
            objectChangeEvent.setAffected(domain);
            this.fireChange(objectChangeEvent);
        } else if (this.getUse() == 0) {
            this.setUse((short)1);
        } else {
            this.logicalDatatype = null;
        }
    }

    public Domain getDomain() {
        if (this.domain == null || this.use != 0) {
            this.domain = this.getDesign().getDomainSet().getDefaultDomain();
        }
        return this.domain;
    }

    public Datatype getDataType() {
        if (this.use == 0 && this.getDomain() != null) {
            return this.getDomain().getDataType();
        }
        if (this.use == 1) {
            String string = this.getSelectedRDBMSType().toString();
            MDDataType mDDataType = (MDDataType)this.getDataType(string);
            return mDDataType;
        }
        if (this.use == 2) {
            if (this.distinctType == null) {
                return this.getDesign().getDomainSet().getDefaultDomain().getDataType();
            }
            return this.distinctType;
        }
        if (this.use == 3) {
            if (this.getStructuredType() == null) {
                return this.getDesign().getDomainSet().getDefaultDomain().getDataType();
            }
            return this.getStructuredType();
        }
        if (this.use == 4) {
            if (this.getCollectionType() == null) {
                return this.getDesign().getDomainSet().getDefaultDomain().getDataType();
            }
            return this.getCollectionType();
        }
        return this.getPreferences().getDefaultType(this.getDesign().getAppView().getSettings());
    }

    public Datatype getDataType(String string) {
        if (this.use == 0) {
            if (this.getDomain() == null) {
                return this.getPreferences().getDefaultType(this.getDesign().getAppView().getSettings());
            }
            return this.getDomain().getDataType(string);
        }
        if (this.use == 1) {
            String string2;
            String string3;
            if (this.logicalDatatype == null) {
                this.logicalDatatype = (LogicalDatatype)this.getDesign().getLogicalDatatypeSet().getByName("unknown", false);
            }
            Map map = this.logicalDatatype.getDefaultValues();
            Map map2 = (Map)map.get(string);
            int n = 0;
            String string4 = "";
            int n2 = 0;
            if (map2 != null) {
                String string5;
                string3 = (String)map2.get("precision_default_value");
                n = string3 != "" && string3 != null ? new Integer(string3) : 0;
                string4 = string5 = (String)map2.get("size_default_value");
                string2 = (String)map2.get("scale_default_value");
                int n3 = n2 = string2 != "" && string2 != null ? new Integer(string2) : 0;
            }
            string3 = (string3 = (String)this.parameters.get("precision")) != null && string3 != "" ? (string3.indexOf(" ") > 0 ? string3.substring(0, string3.indexOf(" ")) : string3).trim() : "0";
            int n4 = new Integer(string3);
            string2 = (String)this.parameters.get("size");
            String string6 = (String)this.parameters.get("scale");
            string6 = string6 != null && string6 != "" ? (string6.indexOf(" ") > 0 ? string6.substring(0, string6.indexOf(" ")) : string6).trim() : "0";
            int n5 = new Integer(string6);
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.putAll(this.parameters);
            if (string2 != null && !"0".equals(string2) && !"".equals(string2)) {
                treeMap.put("size", string2);
            } else if (string4 != null && !"0".equals(string4) && !"".equals(string4)) {
                treeMap.put("size", string4);
            }
            if (n2 > 0) {
                if (n5 == 0) {
                    treeMap.put("scale", String.valueOf(n2));
                } else if (n2 != n5) {
                    treeMap.put("scale", String.valueOf(n5));
                }
            }
            if (n > 0) {
                if (n4 == 0) {
                    treeMap.put("precision", String.valueOf(n));
                } else if (n != n4) {
                    treeMap.put("precision", String.valueOf(n4));
                }
            }
            MDDataType mDDataType = this.getLogicalDatatype().createDataType(string, treeMap);
            return mDDataType;
        }
        if (this.use == 2) {
            LogicalDatatype logicalDatatype;
            if (this.distinctType != null && !string.startsWith("DB2") && (logicalDatatype = this.distinctType.getLogicalDataType()) != null) {
                int n;
                int n6;
                TreeMap<String, String> treeMap = new TreeMap<String, String>();
                String string7 = this.distinctType.getSize();
                if (string7 != null && string7.length() > 0 && !string7.equals("0")) {
                    treeMap.put("size", string7);
                }
                if ((n6 = this.distinctType.getPrecision()) != 0) {
                    treeMap.put("precision", String.valueOf(n6));
                }
                if ((n = this.distinctType.getScale()) != 0) {
                    treeMap.put("scale", String.valueOf(n));
                }
                MDDataType mDDataType = logicalDatatype.createDataType(string, treeMap);
                return mDDataType;
            }
            return this.distinctType;
        }
        if (this.use == 3) {
            return this.getStructuredType();
        }
        if (this.use == 4) {
            return this.getCollectionType();
        }
        return null;
    }

    public String getDatatypeString(String string) {
        Datatype datatype = this.getDataType(string);
        if (datatype == null) {
            return this.getPreferences().getDefaultType(this.getDesign().getAppView().getSettings()).getName();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (string.indexOf("DB2/UDB") > -1) {
            if (this.use == 3 && this.isReference()) {
                stringBuffer.append("REF (");
                stringBuffer.append(datatype.toString()).append(')');
            } else {
                stringBuffer.append(datatype.toString());
            }
        } else {
            if (this.use == 3 && this.isReference()) {
                stringBuffer.append("REF ");
            }
            stringBuffer.append(datatype.toString());
        }
        return stringBuffer.toString();
    }

    public String getGenericDatatypeString() {
        if (this.getUse() == 0) {
            Domain domain = this.getDomain();
            if (domain != null) {
                return domain.getName();
            }
        } else {
            if (this.getUse() == 1) {
                LogicalDatatype logicalDatatype = this.getLogicalDatatype();
                String string = logicalDatatype.toString();
                String string2 = this.getSelectedRDBMSType().toString();
                MDDataType mDDataType = logicalDatatype.createDataType(string2, this.parameters);
                if (mDDataType == null) {
                    return string;
                }
                if (string.startsWith("INTERVAL")) {
                    return mDDataType.toString();
                }
                StringBuffer stringBuffer = new StringBuffer(string);
                if (mDDataType.hasSize() && !"".equals(this.getSize())) {
                    stringBuffer.append(' ');
                    stringBuffer.append('(');
                    stringBuffer.append(this.getSize());
                    stringBuffer.append(')');
                } else if (mDDataType.hasPrecision() && mDDataType.getPrecision() > 0) {
                    stringBuffer.append(' ');
                    stringBuffer.append('(');
                    stringBuffer.append(mDDataType.getPrecision());
                    if (mDDataType.hasScale() && mDDataType.getScale() != 0) {
                        stringBuffer.append(',');
                        stringBuffer.append(' ');
                        stringBuffer.append(mDDataType.getScale());
                    }
                    stringBuffer.append(')');
                }
                return stringBuffer.toString();
            }
            if (this.getUse() == 2) {
                if (this.getDistinctType() != null) {
                    return this.getDistinctType().getName();
                }
            } else if (this.getUse() == 3) {
                if (this.getStructuredType() != null) {
                    if (this.isReference()) {
                        return "REF " + this.getStructuredType().getName();
                    }
                    return this.getStructuredType().getName();
                }
            } else if (this.getUse() == 4 && this.getCollectionType() != null) {
                return this.getCollectionType().getName();
            }
        }
        return "";
    }

    public LogicalDatatype getLogicalDatatype() {
        if (this.getUse() == 0 && this.getDomain() != null) {
            return this.getDomain().getLogicalDatatype();
        }
        if (this.logicalDatatype == null) {
            return this.getDomain().getLogicalDatatype();
        }
        return this.logicalDatatype;
    }

    public void setLogicalDatatype(LogicalDatatype logicalDatatype) {
        if (this.logicalDatatype == logicalDatatype) {
            return;
        }
        if (this.logicalDatatype != null) {
            this.logicalDatatype.removeObjectListener(this);
        }
        this.logicalDatatype = logicalDatatype;
        if (logicalDatatype != null) {
            logicalDatatype.addObjectListener(this);
            ObjectChangeEvent objectChangeEvent = ObjectChangeEvent.LOGICALDATATYPE_CHANGED;
            objectChangeEvent.setAffected(this.domain);
            this.fireChange(objectChangeEvent);
        }
    }

    public Map getParameters() {
        return this.parameters;
    }

    public void setParameters(Map map) {
        this.parameters = map;
    }

    public String getPrecision() {
        if (this.use == 0 && this.getDomain() != null) {
            return this.getDomain().getPrecision();
        }
        return this.getDataTypeParameter("precision");
    }

    public String getScale() {
        if (this.use == 0 && this.getDomain() != null) {
            return this.getDomain().getScale();
        }
        return this.getDataTypeParameter("scale");
    }

    @Override
    public String getSize() {
        if (this.use == 0 && this.getDomain() != null) {
            return this.getDomain().getSize();
        }
        return this.getDataTypeParameter("size");
    }

    public void setDataTypeParameter(String string, String string2) {
        if (string2 == null || "".equals(string2)) {
            this.parameters.remove(string);
        } else {
            this.parameters.put(string, string2);
        }
    }

    public String getSizeOnly() {
        String string = this.getSize();
        String[] stringArray = string.split(" ");
        if (stringArray.length > 0) {
            return stringArray[0];
        }
        return "";
    }

    public String getUnits() {
        String string = this.getSize();
        String[] stringArray = string.split(" ");
        if (stringArray.length == 2) {
            return stringArray[1];
        }
        return "";
    }

    public String getDataTypeParameter(String string) {
        Object object = this.parameters.get(string);
        if (object == null) {
            object = "";
        }
        return (String)object;
    }

    public ContainerWithKeyObject getContainerWithKeyObject() {
        return (ContainerWithKeyObject)this.getContainer();
    }

    public boolean isPKElement() {
        ContainerWithKeyObject containerWithKeyObject = this.getContainerWithKeyObject();
        return containerWithKeyObject != null && containerWithKeyObject.getPK() != null && containerWithKeyObject.getPK().contains(this);
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
        this.fireChange(objectChangeEvent);
    }

    public void setUsesDefaultValue(boolean bl) {
        boolean bl2 = this.usesDefault;
        this.usesDefault = bl;
        if (bl2 != bl) {
            this.fireChange(ObjectChangeEvent.USE_DEFAULT_CHANGED);
        }
    }

    public boolean getUsesDefaultValue() {
        return this.usesDefault;
    }

    public void setDefaultValue(String string) {
        String string2;
        if (string != null && !"".equals(string) && this.domain != null && this.use == 0 && (string2 = this.domain.getDefaultValue()) != null && string2.equals(string)) {
            this.defaultValue = null;
        }
        this.defaultValue = string;
    }

    public String getDefaultValue() {
        String string = this.defaultValue;
        if (string == null || "".equals(string)) {
            if (this.domain != null && this.use == 0) {
                string = this.domain.getDefaultValue();
                if (string == null) {
                    return "";
                }
                return string;
            }
            return "";
        }
        return this.defaultValue;
    }

    public int getPositionInPK() {
        if (this.getContainerWithKeyObject() != null && this.getContainerWithKeyObject().hasPK()) {
            return this.getContainerWithKeyObject().getPK().getIndexOf(this);
        }
        return -1;
    }

    @Override
    public boolean getUseDomainConstraints() {
        return this.use == 0 && super.getUseDomainConstraints();
    }

    @Override
    public void setUseDomainConstraints(boolean bl) {
        super.setUseDomainConstraints(bl);
    }

    public DistinctType getDistinctType() {
        return this.distinctType;
    }

    public void setDistinctType(DistinctType distinctType) {
        this.distinctType = distinctType;
    }

    public short getUse() {
        return this.use;
    }

    public void setUse(short s) {
        if (s >= 0 && s <= 4) {
            this.use = s;
        }
    }

    public boolean isReference() {
        return this.reference;
    }

    public boolean isRefToStructuredType(StructuredType structuredType) {
        Datatype datatype = this.getDataType();
        if (this.reference && datatype != null && datatype instanceof StructuredType) {
            for (StructuredType structuredType2 = structuredType; structuredType2 != null; structuredType2 = structuredType2.getParentType()) {
                if (structuredType2 != datatype) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isExactRefToStructuredType(StructuredType structuredType) {
        Datatype datatype = this.getDataType();
        return this.reference && datatype != null && datatype instanceof StructuredType && datatype == structuredType;
    }

    public void setReference(boolean bl) {
        this.reference = bl;
    }

    public boolean isAllowSubtypeSubstitution() {
        return this.allowSubtypeSubstitution;
    }

    @Override
    public void setStructuredType(StructuredType structuredType) {
        StructuredType structuredType2 = this.getStructuredType();
        super.setStructuredType(structuredType);
        if (structuredType != structuredType2) {
            this.removeNestedObjects();
            this.setAllowSubtypeSubstitution(true);
        }
    }

    public void setAllowSubtypeSubstitution(boolean bl) {
        this.allowSubtypeSubstitution = bl;
    }

    @Override
    public boolean isUnique() {
        Iterator iterator = this.getContainerWithKeyObject().getKeySet().iterator();
        while (iterator.hasNext()) {
            KeyObject keyObject = (KeyObject)iterator.next();
            if (!keyObject.isUnique() || !keyObject.contains(this)) continue;
            return true;
        }
        return false;
    }

    public boolean isRestrictedTypeSubstitution() {
        return this.restrictedTypeSubstitution;
    }

    public void setRestrictedTypeSubstitution(boolean bl) {
        this.restrictedTypeSubstitution = bl;
    }

    public List getPermittedSubTypes() {
        Object[] objectArray = this.permittedSubTypes.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            DesignObject designObject = (DesignObject)objectArray[i];
            if (this.getDesign().getDesignObject(designObject.getObjectID()) != null) continue;
            this.permittedSubTypes.remove(designObject);
        }
        return this.permittedSubTypes;
    }

    public void copyParametersFrom(ContainedObjectWithDomain containedObjectWithDomain) {
        this.parameters.clear();
        Map map = containedObjectWithDomain.getParameters();
        for (Object k : map.keySet()) {
            Object v = map.get(k);
            if (v == null) continue;
            this.parameters.put(k, v);
        }
    }

    public boolean hasConstraintsDefined() {
        if (this.getUseDomainConstraints()) {
            Domain domain = this.getDomain();
            if (domain != null) {
                if (domain.getCheck() != null && !domain.getCheck().isEmpty()) {
                    return true;
                }
                if (domain.getValueList() != null && !domain.getValueList().isEmpty()) {
                    return true;
                }
                if (!domain.getAVTs().isEmpty()) {
                    return true;
                }
            }
        } else {
            if (this.getCheck() != null && !this.getCheck().isEmpty()) {
                return true;
            }
            if (this.getValueList() != null && !this.getValueList().isEmpty()) {
                return true;
            }
            if (!this.getAVTs().isEmpty()) {
                return true;
            }
        }
        return false;
    }

    public String getConstraintsText() {
        return this.getConstraintsText(this.getName());
    }

    public String getConstraintsText(String string) {
        LongNameObject longNameObject;
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        CheckConstraint checkConstraint = this.getCheck();
        boolean bl = true;
        if (checkConstraint != null && !checkConstraint.isEmpty() && !(string2 = checkConstraint.getImplementation(longNameObject = this.getDesignPart().getSelectedRDBMSSite().getType())).trim().equalsIgnoreCase("")) {
            string2 = string2.replaceAll("%COLUMN%", string);
            stringBuffer.append(string2).append(' ');
            bl = false;
        }
        if (!this.getAVTs().isEmpty()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append("OR").append(' ');
            }
            this.appendAVTs(stringBuffer, string);
        }
        if ((longNameObject = this.getValueList()) != null && !((ConstraintEnumeration)longNameObject).isEmpty()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append("OR").append(' ');
            }
            this.appendStringEnumeration(stringBuffer, string);
        }
        return stringBuffer.toString().trim();
    }

    private void appendAVTs(StringBuffer stringBuffer, String string) {
        String string2 = this.getDataType().getName().toUpperCase();
        boolean bl = string2.indexOf("CHAR") > -1 || string2.indexOf("CLOB") > -1;
        Iterator iterator = this.getAVTs().iterator();
        boolean bl2 = false;
        while (iterator.hasNext()) {
            AVT aVT = (AVT)iterator.next();
            if (bl2) {
                stringBuffer.append("OR").append(' ');
            }
            stringBuffer.append(string).append(' ');
            String string3 = aVT.getEndValue();
            if (!"".equals(string3)) {
                stringBuffer.append("BETWEEN").append(' ');
                this.appendString(stringBuffer, aVT.getBeginValue(), bl);
                stringBuffer.append(' ').append("AND").append(' ');
                this.appendString(stringBuffer, string3, bl);
            } else {
                stringBuffer.append("=").append(' ');
                this.appendString(stringBuffer, aVT.getBeginValue(), bl);
            }
            stringBuffer.append(' ');
            bl2 = true;
        }
    }

    private void appendStringEnumeration(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string).append(' ').append("IN").append(' ').append("(");
        String string2 = this.getDataType().getName().toUpperCase();
        boolean bl = string2.indexOf("CHAR") > -1 || string2.indexOf("CLOB") > -1;
        int n = 0;
        Iterator iterator = this.getValueIterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if ("".equals(string3)) continue;
            if (++n > 1) {
                stringBuffer.append(',').append(' ');
            }
            this.appendString(stringBuffer, string3, bl);
        }
        stringBuffer.append(")");
    }

    private void appendString(StringBuffer stringBuffer, String string, boolean bl) {
        if (bl && !string.startsWith("'") && !string.endsWith("'")) {
            stringBuffer.append('\'').append(string).append('\'');
        } else {
            stringBuffer.append(string);
        }
    }

    public String getSeparatedCheckConstraint() {
        return this.separatedCheckConstraint;
    }

    public String getSeparatedRangeConstraint() {
        return this.separatedRangeConstraint;
    }

    public String getSeparatedValueConstraint() {
        return this.separatedValueConstraint;
    }

    public boolean setSeparatedConstraints(String string) {
        this.separatedCheckConstraint = "";
        this.separatedRangeConstraint = "";
        this.separatedValueConstraint = "";
        StringBuffer stringBuffer = new StringBuffer();
        if ("".equals(string.trim())) {
            return false;
        }
        String string2 = string;
        String string3 = this.getName();
        boolean bl = false;
        while (!bl) {
            String string4;
            String string5 = Token.getStringBeforeToken(string2, "OR");
            if ("".equals(string5)) {
                string5 = string2;
                bl = true;
            }
            boolean bl2 = false;
            String string6 = Token.getStringBeforeToken(string5, "BETWEEN");
            String string7 = Token.getStringBeforeToken(string5, "IN");
            if (!"".equals(string6)) {
                if (string3.equalsIgnoreCase(string6.trim()) && !"".equals(string4 = this.parseRangeConstraint(string5))) {
                    this.separatedRangeConstraint = this.separatedRangeConstraint.concat(string4);
                    bl2 = true;
                }
            } else if (!"".equals(string7) && string3.equalsIgnoreCase(string7.trim()) && !"".equals(string4 = this.parseValueConstraint(string5))) {
                if (!"".equals(this.separatedValueConstraint)) {
                    this.separatedValueConstraint = this.separatedValueConstraint.concat(String.valueOf(','));
                }
                this.separatedValueConstraint = this.separatedValueConstraint.concat(string4);
                bl2 = true;
            }
            if (!bl2) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(' ').append("OR").append(' ');
                }
                stringBuffer.append(string5);
            }
            if (bl) continue;
            string2 = Token.getStringAfterToken(string2, "OR");
        }
        this.separatedCheckConstraint = stringBuffer.toString();
        if (this.separatedRangeConstraint.endsWith(String.valueOf(','))) {
            this.separatedRangeConstraint = this.separatedRangeConstraint.substring(0, this.separatedRangeConstraint.length() - 1);
        }
        return !"".equals(this.separatedRangeConstraint) || !"".equals(this.separatedValueConstraint);
    }

    private String parseRangeConstraint(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = Token.getStringAfterToken(string, "BETWEEN");
        String string3 = Token.getStringBeforeToken(string2, "AND");
        String string4 = Token.getStringAfterToken(string2, "AND");
        if ("".equals(string4)) {
            string4 = string3;
        }
        stringBuffer.append(string3).append(',');
        stringBuffer.append(string4).append(',');
        return stringBuffer.toString();
    }

    private String parseValueConstraint(String string) {
        String string2 = Token.getStringAfterToken(string, "IN");
        return Token.getValBetweenBrackets(string2);
    }

    @Override
    public Object translateIdToObject(String string, String string2) {
        ModelIDObject modelIDObject = null;
        modelIDObject = this.getDesign().getDesignObject(string2);
        if (modelIDObject != null) {
            return modelIDObject;
        }
        if ("domain".equalsIgnoreCase(string)) {
            modelIDObject = this.getDesign().getDomainSet().getObjectByID(string2);
            if (modelIDObject == null) {
                modelIDObject = this.getDesign().getDomainSet().getObjectByImportedID(string2);
            }
        } else if ("logicalDatatype".equalsIgnoreCase(string)) {
            modelIDObject = this.getDesign().getLogicalDatatypeSet().getObjectByID(string2);
        } else if ("distinctType".equalsIgnoreCase(string)) {
            modelIDObject = this.getDesign().getDataTypesDesign().getDistinctTypeSet().getObjectByID(string2);
        }
        if (modelIDObject != null) {
            return modelIDObject;
        }
        return super.translateIdToObject(string, string2);
    }

    public void setDataTypeSize(String string) {
        this.setDataTypeParameter("size", string);
    }

    public String getDataTypeSize() {
        return this.getDataTypeParameter("size");
    }

    public void setDataTypePrecision(String string) {
        this.setDataTypeParameter("precision", string);
    }

    public String getDataTypePrecision() {
        return this.getDataTypeParameter("precision");
    }

    public void setDataTypeScale(String string) {
        this.setDataTypeParameter("scale", string);
    }

    public String getDataTypeScale() {
        return this.getDataTypeParameter("scale");
    }

    public ConstraintEnumeration getOwnValueList() {
        if (this.getUseDomainConstraints()) {
            return null;
        }
        return super.getValueList();
    }

    public void setOwnValueList(ConstraintEnumeration constraintEnumeration) {
        if (this.getUseDomainConstraints()) {
            super.setValueList(null);
        } else if (constraintEnumeration != null && constraintEnumeration.isEmpty()) {
            super.setValueList(null);
        } else {
            super.setValueList(constraintEnumeration);
        }
    }

    public void clearOwnValueList() {
        super.setValueList(null);
    }

    public Iterator getValueIterator() {
        return this.getValues().iterator();
    }

    public Set getValues() {
        if (this.getUseDomainConstraints()) {
            return this.getDomain().getValues();
        }
        ConstraintEnumeration constraintEnumeration = this.getValueList();
        if (constraintEnumeration != null) {
            LogicalDatatype logicalDatatype;
            Set set = constraintEnumeration.getValues();
            if (set.size() > 1 && (logicalDatatype = this.getLogicalDatatype()) != null && logicalDatatype.isNumeric()) {
                TreeSet treeSet = new TreeSet(new ValueComparator());
                treeSet.addAll(set);
                return treeSet;
            }
            return set;
        }
        return new TreeSet();
    }

    public CheckConstraint getOwnCheck() {
        if (this.getUseDomainConstraints()) {
            return null;
        }
        return super.getCheck();
    }

    public void setOwnCheck(CheckConstraint checkConstraint) {
        if (this.getUseDomainConstraints()) {
            super.setCheck(null);
        } else if (checkConstraint != null && checkConstraint.isEmpty()) {
            super.setCheck(null);
        } else {
            super.setCheck(checkConstraint);
        }
    }

    public void clearOwnCheckConstraint() {
        super.setCheck(null);
    }

    public ConstraintEnumeration createConstraintEnumeration() {
        ConstraintEnumeration constraintEnumeration = new ConstraintEnumeration();
        constraintEnumeration.setDesign(this.getDesign());
        return constraintEnumeration;
    }

    public CheckConstraint createCheckConstraint() {
        CheckConstraint checkConstraint = new CheckConstraint();
        checkConstraint.setDesign(this.getDesign());
        return checkConstraint;
    }

    public boolean hasEqulaDataType(ContainedObjectWithDomain containedObjectWithDomain) {
        String string;
        String string2 = this.getSelectedRDBMSType().toString();
        String string3 = this.getDatatypeString(string2);
        return string3.equalsIgnoreCase(string = containedObjectWithDomain.getDatatypeString(string2));
    }

    private class ValueComparator
    implements Comparator {
        private ValueComparator() {
        }

        public int compare(Object object, Object object2) {
            try {
                double d = Double.parseDouble((String)object);
                double d2 = Double.parseDouble((String)object2);
                if (d > d2) {
                    return 1;
                }
                if (d < d2) {
                    return -1;
                }
                return 0;
            }
            catch (Exception exception) {
                return ((String)object).compareTo((String)object2);
            }
        }
    }
}

