/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;

public abstract class AbstractViewElement
extends ContainedObject {
    private String alias = "";
    private ContainedObjectWithDomain referencedColumn;
    private String expression = "";
    private String dataType = "";
    private AbstractView view = null;
    private ContainerWithKeyObject table = null;
    private String tableAlias = "";
    private boolean reference = false;
    private ContainedObject referencedColumnView;
    private String referencedColumnViewID;
    private TypeElement typeElement;
    private String viewID;

    public AbstractViewElement(DesignPart designPart) {
        super(designPart);
    }

    public String getDataType() {
        return this.getDataType(0);
    }

    private String getDataType(int n) {
        if (this.getReferencedColumn() != null) {
            return this.getReferencedColumn().getDatatypeString(this.getDesignPart().getSelectedRDBMSType().getName());
        }
        if (this.getReferencedColumnView() != null && n < 10) {
            return ((AbstractViewElement)this.getReferencedColumnView()).getDataType(n + 1);
        }
        if (this.typeElement != null) {
            return this.typeElement.getDataType(this.getDesignPart().getSelectedRDBMSType().getName());
        }
        return this.dataType;
    }

    public void setDataType(String string) {
        this.dataType = string;
    }

    public ContainedObjectWithDomain getReferencedColumn() {
        return this.referencedColumn;
    }

    public void setReferencedColumn(ContainedObjectWithDomain containedObjectWithDomain) {
        if (this.referencedColumn != containedObjectWithDomain) {
            if (this.referencedColumn != null) {
                this.referencedColumn.removeObjectListener(this);
            }
            this.referencedColumn = containedObjectWithDomain;
            if (containedObjectWithDomain != null) {
                containedObjectWithDomain.addObjectListener(this);
                if (this.getContainer() != null) {
                    containedObjectWithDomain.addObjectListener(this.getContainer());
                }
            }
        }
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String string) {
        String string2 = this.alias;
        this.alias = string == null ? "" : string;
        if (!string2.equals(this.alias)) {
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String string) {
        this.expression = string;
    }

    public AbstractView getView() {
        if (this.view == null && this.viewID != null && !"".equals(this.viewID)) {
            this.view = (AbstractView)this.getDesign().getDesignObject(this.viewID);
        }
        return this.view;
    }

    public void setView(AbstractView abstractView) {
        this.view = abstractView;
    }

    public ContainerWithKeyObject getTable() {
        return this.table;
    }

    public void setTable(ContainerWithKeyObject containerWithKeyObject) {
        this.table = containerWithKeyObject;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public void setTableAlias(String string) {
        this.tableAlias = string == null ? "" : string;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.tableAlias.trim().equalsIgnoreCase("")) {
            stringBuffer.append(this.tableAlias);
            stringBuffer.append('.');
        }
        stringBuffer.append(this.getName());
        return stringBuffer.toString();
    }

    public boolean isReference() {
        return this.reference;
    }

    public void setReference(boolean bl) {
        this.reference = bl;
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
        super.changed(designObject, objectChangeEvent);
        if (designObject instanceof ContainedObject && objectChangeEvent.isType(ObjectChangeEvent.NAME_CHANGED) && designObject == this.getReferencedColumn()) {
            this.setName(designObject.getName());
        }
    }

    public ContainedObject getReferencedColumnView() {
        ContainedObject containedObject;
        if (this.referencedColumnView == null && this.referencedColumnViewID != null && (containedObject = (ContainedObject)this.getDesign().getDesignObject(this.referencedColumnViewID)) != null) {
            this.setReferencedColumnView(containedObject);
        }
        return this.referencedColumnView;
    }

    public void setReferencedColumnView(ContainedObject containedObject) {
        if (this.referencedColumnView != containedObject) {
            if (this.referencedColumnView != null) {
                this.referencedColumnView.removeObjectListener(this);
            }
            this.referencedColumnView = containedObject;
            if (containedObject != null) {
                containedObject.addObjectListener(this);
                if (this.getContainer() != null) {
                    containedObject.addObjectListener(this.getContainer());
                }
            }
        }
    }

    public String getReferencedColumnViewID() {
        if (this.referencedColumnView != null) {
            this.referencedColumnViewID = this.referencedColumnView.getObjectID();
        }
        return this.referencedColumnViewID;
    }

    public void setReferencedColumnViewID(String string) {
        this.referencedColumnViewID = string;
    }

    public String getReferencedName() {
        if (this.getReferencedColumnView() != null) {
            AbstractViewElement abstractViewElement = (AbstractViewElement)this.getReferencedColumnView();
            if (!"".equals(abstractViewElement.getAlias())) {
                return abstractViewElement.getAlias();
            }
            return abstractViewElement.getName();
        }
        if (this.getReferencedColumn() != null) {
            return this.getReferencedColumn().getName();
        }
        if (!"".equals(this.getAlias())) {
            return this.getAlias();
        }
        return this.getName();
    }

    public ContainerObject getReferencedContainer() {
        if (this.getReferencedColumnView() != null) {
            return this.getReferencedColumnView().getContainer();
        }
        if (this.getReferencedColumn() != null) {
            return this.getReferencedColumn().getContainer();
        }
        return null;
    }

    public String getViewID() {
        if (this.view != null) {
            this.viewID = this.view.getObjectID();
        }
        return this.viewID;
    }

    public void setViewID(String string) {
        this.viewID = string;
    }

    public TypeElement getTypeElement() {
        return this.typeElement;
    }

    public void setTypeElement(TypeElement typeElement) {
        this.typeElement = typeElement;
    }
}

