/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.datatype.sqlserver;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDPackedSized;

public class MDFloatSqlServer
extends MDPackedSized {
    protected String name = "FLOAT";

    @Override
    public String getName() {
        return this.name;
    }

    public void setNumericSynonym() {
        this.name = "NUMERIC";
    }

    @Override
    public String getMaxSize() {
        return "8";
    }

    @Override
    public MDDataType deepCopy() {
        MDFloatSqlServer mDFloatSqlServer = new MDFloatSqlServer();
        mDFloatSqlServer.setPrecision(this.getPrecision());
        mDFloatSqlServer.setScale(this.getScale());
        if (this.getName().equals("NUMERIC")) {
            mDFloatSqlServer.setNumericSynonym();
        }
        return mDFloatSqlServer;
    }

    @Override
    public int getByteSize() {
        int n = 0;
        if (this.getPrecision() == 7) {
            n = 4;
        } else if (this.getPrecision() == 15) {
            n = 8;
        }
        return n;
    }

    @Override
    public String getScaleText() {
        return Messages.getString("MDFloatSqlServer.NA");
    }

    @Override
    public boolean hasScale() {
        return false;
    }
}

