/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.datatype.sqlserver;

import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDDataTypeFactory;
import oracle.dbtools.crest.model.datatype.MDExplicitSized;
import oracle.dbtools.crest.model.datatype.MDUnknown;
import oracle.dbtools.crest.model.datatype.sqlserver.MDBigIntSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDBinarySqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDBitSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDCharSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDDateTimeSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDDecimalSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDFloatSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDImageSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDIntSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDMoneySqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDNCharSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDNTextSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDNVarCharSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDNumericSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDRealSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDRowIDSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDSmallDateTimeSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDSmallIntSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDSmallMoneySqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDSqlVariantSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDSysNameSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDTextSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDTimestampSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDTinyIntSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDUniqueidentifierSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDVarBinarySqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDVarCharSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDXMLTypeSqlServer;

public class MDDataTypeFactorySqlServer
extends MDDataTypeFactory {
    @Override
    public MDDataType createType(String string, String string2) {
        MDExplicitSized mDExplicitSized = null;
        if ("CHAR".equals(string)) {
            mDExplicitSized = new MDCharSqlServer();
        } else if ("VARCHAR".equals(string)) {
            mDExplicitSized = new MDVarCharSqlServer();
        } else if ("VARBINARY".equals(string)) {
            mDExplicitSized = new MDVarBinarySqlServer();
        } else if ("NCHAR".equals(string)) {
            mDExplicitSized = new MDNCharSqlServer();
        } else if ("NVARCHAR".equals(string)) {
            mDExplicitSized = new MDNVarCharSqlServer();
        } else if ("BINARY".equals(string)) {
            mDExplicitSized = new MDBinarySqlServer();
        } else {
            if ("DECIMAL".equals(string)) {
                mDExplicitSized = new MDDecimalSqlServer();
                mDExplicitSized.setPrecision(MDDataTypeFactory.stringToInt(string2));
                return mDExplicitSized;
            }
            if ("NUMERIC".equals(string)) {
                MDDecimalSqlServer mDDecimalSqlServer = new MDDecimalSqlServer();
                mDDecimalSqlServer.setNumericSynonym();
                mDDecimalSqlServer.setPrecision(MDDataTypeFactory.stringToInt(string2));
                return mDDecimalSqlServer;
            }
            if ("FLOAT".equals(string)) {
                mDExplicitSized = new MDFloatSqlServer();
                mDExplicitSized.setPrecision(MDDataTypeFactory.stringToInt(string2));
                return mDExplicitSized;
            }
            if ("REAL".equals(string)) {
                mDExplicitSized = new MDRealSqlServer();
                mDExplicitSized.setPrecision(MDDataTypeFactory.stringToInt(string2));
                return mDExplicitSized;
            }
        }
        if (mDExplicitSized != null) {
            mDExplicitSized.setSize(string2);
        }
        return mDExplicitSized;
    }

    @Override
    public MDDataType createType(String string, int n, int n2) {
        if ("DECIMAL".equals(string)) {
            MDDecimalSqlServer mDDecimalSqlServer = new MDDecimalSqlServer();
            mDDecimalSqlServer.setPrecision(n);
            mDDecimalSqlServer.setScale(n2);
            return mDDecimalSqlServer;
        }
        if ("NUMERIC".equals(string)) {
            MDDecimalSqlServer mDDecimalSqlServer = new MDDecimalSqlServer();
            mDDecimalSqlServer.setNumericSynonym();
            mDDecimalSqlServer.setPrecision(n);
            mDDecimalSqlServer.setScale(n2);
            return mDDecimalSqlServer;
        }
        return null;
    }

    @Override
    protected void initFlyWeights() {
        MDDecimalSqlServer mDDecimalSqlServer = new MDDecimalSqlServer();
        mDDecimalSqlServer.setNumericSynonym();
        this.flyweights.put("INT", new MDIntSqlServer());
        this.flyweights.put("INTEGER", new MDIntSqlServer());
        this.flyweights.put("BIGINT", new MDBigIntSqlServer());
        this.flyweights.put("UNIQUEIDENTIFIER", new MDUniqueidentifierSqlServer());
        this.flyweights.put("REAL", new MDRealSqlServer());
        this.flyweights.put("FLOAT", new MDFloatSqlServer());
        this.flyweights.put("SMALLDATETIME", new MDSmallDateTimeSqlServer());
        this.flyweights.put("TIMESTAMP", new MDTimestampSqlServer());
        this.flyweights.put("DATETIME", new MDDateTimeSqlServer());
        this.flyweights.put("TINYINT", new MDTinyIntSqlServer());
        this.flyweights.put("SMALLINT", new MDSmallIntSqlServer());
        this.flyweights.put("BIT", new MDBitSqlServer());
        this.flyweights.put("MONEY", new MDMoneySqlServer());
        this.flyweights.put("SMALLMONEY", new MDSmallMoneySqlServer());
        this.flyweights.put("MONEY", new MDMoneySqlServer());
        this.flyweights.put("UNKNOWN", new MDUnknown());
        this.flyweights.put("VARCHAR", new MDVarCharSqlServer());
        this.flyweights.put("SYSNAME", new MDSysNameSqlServer());
    }

    @Override
    protected void initHeavyWeights() {
        this.heavyweights.put("CHAR", MDCharSqlServer.class);
        this.heavyweights.put("DECIMAL", MDDecimalSqlServer.class);
        this.heavyweights.put("NUMERIC", MDNumericSqlServer.class);
        this.heavyweights.put("IMAGE", MDImageSqlServer.class);
        this.heavyweights.put("TEXT", MDTextSqlServer.class);
        this.heavyweights.put("NVARCHAR", MDNVarCharSqlServer.class);
        this.heavyweights.put("NTEXT", MDNTextSqlServer.class);
        this.heavyweights.put("BINARY", MDBinarySqlServer.class);
        this.heavyweights.put("VARBINARY", MDVarBinarySqlServer.class);
        this.heavyweights.put("SQL_VARIANT", MDSqlVariantSqlServer.class);
        this.heavyweights.put("NCHAR", MDNCharSqlServer.class);
        this.heavyweights.put("ROWID", MDRowIDSqlServer.class);
        this.heavyweights.put("XML", MDXMLTypeSqlServer.class);
    }
}

