/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.datatype.oracle.v9i;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDPackedSized;

public class MDTimestampOraclev9i
extends MDPackedSized {
    protected String name = "TIMESTAMP";

    public MDTimestampOraclev9i() {
        this.precision = 6;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected String getNameFirstPart() {
        return "TIMESTAMP";
    }

    protected String getNameSecondPart() {
        return "";
    }

    @Override
    public String getMaxSize() {
        return "31";
    }

    @Override
    public MDDataType deepCopy() {
        MDTimestampOraclev9i mDTimestampOraclev9i = new MDTimestampOraclev9i();
        mDTimestampOraclev9i.setPrecision(this.getPrecision());
        return mDTimestampOraclev9i;
    }

    @Override
    public void setPrecision(int n) {
        if (n >= 0 && n <= 9) {
            this.precision = n;
            this.fireSizeChange();
        }
    }

    @Override
    public boolean hasScale() {
        return false;
    }

    public void setPrecision(String string) {
        try {
            int n = Integer.parseInt(string);
            if (n >= 0 && n <= 9) {
                this.precision = n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.precision = 6;
        }
    }

    @Override
    public void appendTo(StringBuffer stringBuffer) {
        stringBuffer.append(this.getNameFirstPart());
        if (this.getPrecision() != 6) {
            stringBuffer.append(" (");
            stringBuffer.append(this.getPrecision());
            stringBuffer.append(")");
        }
        stringBuffer.append(this.getNameSecondPart());
    }

    @Override
    public String getPrecisionText() {
        return Messages.getString("MDTimestampOracle.FractionalSecondsPrecision");
    }
}

