/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.datatype.oracle;

import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDPackedSized;

public class MDNumberOracle
extends MDPackedSized {
    private String name = "NUMBER";

    public MDNumberOracle() {
        this.precision = 0;
    }

    @Override
    public String getMaxSize() {
        return "31";
    }

    public void setNumericSynonym() {
        this.name = "NUMERIC";
    }

    public void setDecimalSynonym() {
        this.name = "DECIMAL";
    }

    public void setDecSynonym() {
        this.name = "DEC";
    }

    public void setIntegerSynonym() {
        this.name = "INTEGER";
    }

    public void setFloatSynonym() {
        this.name = "FLOAT";
    }

    public void setRealSynonym() {
        this.name = "REAL";
    }

    public void setDoubleSynonym() {
        this.name = "DOUBLE";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setScale(int n) {
        if (n >= -84 && n <= 127) {
            this.scale = n;
            this.fireSizeChange();
        }
    }

    @Override
    public void setPrecision(int n) {
        if (n >= 1 && n <= 38) {
            this.precision = n;
            this.fireSizeChange();
        }
    }

    @Override
    public MDDataType deepCopy() {
        MDNumberOracle mDNumberOracle = new MDNumberOracle();
        mDNumberOracle.setPrecision(this.getPrecision());
        mDNumberOracle.setScale(this.getScale());
        return mDNumberOracle;
    }

    @Override
    public void appendTo(StringBuffer stringBuffer) {
        stringBuffer.append(this.getName());
        boolean bl = false;
        if (this.getPrecision() > 0) {
            stringBuffer.append(" (");
            if (this.getPrecision() > 0) {
                stringBuffer.append(this.getPrecision());
                bl = true;
            }
            if (this.getScale() != 0) {
                if (bl) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.getScale());
            }
            stringBuffer.append(')');
        }
    }
}

