/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.datatype.db2;

import java.util.Map;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDDataTypeFactory;
import oracle.dbtools.crest.model.datatype.MDExplicitSized;
import oracle.dbtools.crest.model.datatype.MDFloat;
import oracle.dbtools.crest.model.datatype.db2.MDBlob;
import oracle.dbtools.crest.model.datatype.db2.MDChar;
import oracle.dbtools.crest.model.datatype.db2.MDClob;
import oracle.dbtools.crest.model.datatype.db2.MDDBClob;
import oracle.dbtools.crest.model.datatype.db2.MDDate;
import oracle.dbtools.crest.model.datatype.db2.MDDecimal;
import oracle.dbtools.crest.model.datatype.db2.MDDouble;
import oracle.dbtools.crest.model.datatype.db2.MDGraphic;
import oracle.dbtools.crest.model.datatype.db2.MDInteger;
import oracle.dbtools.crest.model.datatype.db2.MDLongVarCharDB2;
import oracle.dbtools.crest.model.datatype.db2.MDLongVarGraphicDB2;
import oracle.dbtools.crest.model.datatype.db2.MDNumeric;
import oracle.dbtools.crest.model.datatype.db2.MDReal;
import oracle.dbtools.crest.model.datatype.db2.MDRowIDDB2;
import oracle.dbtools.crest.model.datatype.db2.MDSmallInt;
import oracle.dbtools.crest.model.datatype.db2.MDTime;
import oracle.dbtools.crest.model.datatype.db2.MDTimeStamp;
import oracle.dbtools.crest.model.datatype.db2.MDUnknown;
import oracle.dbtools.crest.model.datatype.db2.MDVarChar;
import oracle.dbtools.crest.model.datatype.db2.MDVarGraphic;

public class MDDataTypeFactoryDB2
extends MDDataTypeFactory {
    @Override
    protected void initFlyWeights() {
        Map map = this.getFlyWeights();
        map.put("UNKNOWN", new MDUnknown());
        map.put("REAL", new MDReal());
        MDDouble mDDouble = new MDDouble();
        mDDouble.setFloatSynonym();
        map.put("DATE", new MDDate());
        map.put("DOUBLE", new MDDouble());
        map.put("INTEGER", new MDInteger());
        map.put("REAL", new MDReal());
        map.put("SMALLINT", new MDSmallInt());
        map.put("TIME", new MDTime());
        map.put("TIMESTAMP", new MDTimeStamp());
        MDBlob mDBlob = new MDBlob();
        mDBlob.setBinaryLargeObjectSynonym();
        map.put("BINARY LARGE OBJECT", mDBlob);
        MDClob mDClob = new MDClob();
        mDClob.setCharLargeObjectSynonym();
        map.put("CHAR LARGE OBJECT", mDClob);
        MDClob mDClob2 = new MDClob();
        mDClob2.setCharacterLargeObjectSynonym();
        map.put("CHARACTER LARGE OBJECT", mDClob2);
        MDVarChar mDVarChar = new MDVarChar();
        mDVarChar.setCharVaryingSynonym();
        map.put("CHAR VARYING", mDVarChar);
        MDVarChar mDVarChar2 = new MDVarChar();
        mDVarChar2.setCharacterVaryingSynonym();
        map.put("CHARACTER VARYING", mDVarChar2);
        map.put("UNKNOWN", new MDUnknown());
    }

    @Override
    protected void initHeavyWeights() {
        Map map = this.getHeavyWeights();
        map.put("BLOB", MDBlob.class);
        map.put("CLOB", MDClob.class);
        map.put("CHAR", MDChar.class);
        map.put("DECIMAL", MDDecimal.class);
        map.put("NUMERIC", MDNumeric.class);
        map.put("VARCHAR", MDVarChar.class);
        map.put("GRAPHIC", MDGraphic.class);
        map.put("VARGRAPHIC", MDVarGraphic.class);
        map.put("DBCLOB", MDDBClob.class);
        map.put("ROWID", MDRowIDDB2.class);
        map.put("LONG VARCHAR", MDLongVarCharDB2.class);
        map.put("LONG VARGRAPHIC", MDLongVarGraphicDB2.class);
        map.put("FLOAT", MDFloat.class);
    }

    @Override
    public MDDataType createType(String string, String string2) {
        MDExplicitSized mDExplicitSized = null;
        if ("CHAR".equals(string)) {
            mDExplicitSized = new MDChar();
        } else if ("VARCHAR".equals(string)) {
            mDExplicitSized = new MDVarChar();
        } else if ("GRAPHIC".equals(string)) {
            mDExplicitSized = new MDGraphic();
        } else if ("BLOB".equals(string)) {
            mDExplicitSized = new MDBlob();
        } else if ("CLOB".equals(string)) {
            mDExplicitSized = new MDClob();
        } else if ("DBCLOB".equals(string)) {
            mDExplicitSized = new MDDBClob();
        } else if ("VARGRAPHIC".equals(string)) {
            mDExplicitSized = new MDVarGraphic();
        } else {
            if ("DECIMAL".equals(string)) {
                mDExplicitSized = new MDDecimal();
                mDExplicitSized.setPrecision(MDDataTypeFactory.stringToInt(string2));
                return mDExplicitSized;
            }
            if ("NUMERIC".equals(string)) {
                MDNumeric mDNumeric = new MDNumeric();
                mDNumeric.setNumericSynonym();
                mDNumeric.setPrecision(MDDataTypeFactory.stringToInt(string2));
                return mDNumeric;
            }
            if ("FLOAT".equals(string)) {
                mDExplicitSized = new MDFloat();
                mDExplicitSized.setPrecision(MDDataTypeFactory.stringToInt(string2));
                return mDExplicitSized;
            }
        }
        if (mDExplicitSized != null) {
            mDExplicitSized.setSize(string2);
        }
        return mDExplicitSized;
    }

    @Override
    public MDDataType createType(String string, int n, int n2) {
        if ("DECIMAL".equals(string)) {
            MDDecimal mDDecimal = new MDDecimal();
            mDDecimal.setPrecision(n);
            mDDecimal.setScale(n2);
            return mDDecimal;
        }
        if ("NUMERIC".equals(string)) {
            MDNumeric mDNumeric = new MDNumeric();
            mDNumeric.setNumericSynonym();
            mDNumeric.setPrecision(n);
            mDNumeric.setScale(n2);
            return mDNumeric;
        }
        return null;
    }
}

