/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.datatype;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import oracle.dbtools.crest.model.datatype.AbstractDataType;
import oracle.dbtools.crest.model.datatype.DataTypeListener;

public abstract class MDExplicitSized
extends AbstractDataType {
    protected String size;
    private Set listeners;

    @Override
    public void setSize(String string) {
        this.size = !"".equals(string) && !string.substring(0, 1).equals("-") ? string.trim() : this.getMaxSize();
    }

    @Override
    public String getSize() {
        if (this.size == null) {
            return this.getMaxSize();
        }
        String string = this.size;
        if (string != null && string.indexOf(32) > 0) {
            String[] stringArray = string.split(" ");
            string = stringArray[0];
            return string;
        }
        return this.size;
    }

    public abstract String getMaxSize();

    @Override
    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendTo(stringBuffer);
        return stringBuffer.toString();
    }

    @Override
    public void appendTo(StringBuffer stringBuffer) {
        String string = this.size;
        if (string != null && string.indexOf(32) > 0) {
            String[] stringArray = string.split(" ");
            string = stringArray[0];
        }
        if (string == null || "".equalsIgnoreCase(string) || "0".equalsIgnoreCase(string)) {
            stringBuffer.append(this.getName());
        } else {
            stringBuffer.append(this.getName());
            stringBuffer.append(" (");
            stringBuffer.append(string);
            stringBuffer.append(')');
        }
    }

    @Override
    public void addDataTypeListener(DataTypeListener dataTypeListener) {
        this.getListeners().add(dataTypeListener);
    }

    @Override
    public void removeDataTypeListener(DataTypeListener dataTypeListener) {
        if (this.listeners != null) {
            this.listeners.remove(dataTypeListener);
        }
    }

    protected void fireSizeChange() {
        if (this.listeners != null) {
            Iterator iterator = this.getListeners().iterator();
            while (iterator.hasNext()) {
                ((DataTypeListener)iterator.next()).changed(this);
            }
        }
    }

    protected Set getListeners() {
        if (this.listeners == null) {
            this.listeners = new HashSet();
        }
        return this.listeners;
    }
}

