/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.datatype;

import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.datatype.AbstractDataType;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDDataTypeNames;
import oracle.dbtools.crest.model.datatype.MDUserDefined_NoParams;
import oracle.dbtools.crest.model.datatype.MDUserDefined_PS;
import oracle.dbtools.crest.model.datatype.MDUserDefined_Sized;
import oracle.dbtools.crest.model.datatype.NativeDBType;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.datatype.db2.MDDataTypeFactoryDB2;
import oracle.dbtools.crest.model.datatype.oracle.v10g.MDDataTypeFactoryOraclev10g;
import oracle.dbtools.crest.model.datatype.oracle.v9i.MDDataTypeFactoryOraclev9i;
import oracle.dbtools.crest.model.datatype.sqlserver.MDDataTypeFactorySqlServer;
import oracle.dbtools.crest.model.datatype.udb.MDDataTypeFactoryUDB;
import oracle.dbtools.crest.model.design.LogicalDatatypeSet;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.util.options.Settings;

public abstract class MDDataTypeFactory
implements MDDataTypeNames {
    protected static MDDataTypeFactory instance = null;
    protected static Map instances = new TreeMap();
    protected Map flyweights = null;
    protected Map heavyweights = null;
    protected RDBMSType dbtype = null;

    protected MDDataTypeFactory() {
    }

    public static MDDataTypeFactory getInstance(Settings settings) {
        return MDDataTypeFactory.getInstance("Oracle Database 11g", settings);
    }

    public static MDDataTypeFactory getInstance(String string, Settings settings) {
        RDBMSType rDBMSType = MDDataTypeFactory.getRDBMSType(string);
        return MDDataTypeFactory.getInstance(rDBMSType, settings);
    }

    static RDBMSType getRDBMSType(String string) {
        if (string.equalsIgnoreCase("DB2/390 7")) {
            return StorageDesignDB2v70.RDBMS_TYPE;
        }
        if (string.equalsIgnoreCase("DB2/390 8")) {
            return StorageDesignDB2v80.RDBMS_TYPE;
        }
        if (string.equalsIgnoreCase("DB2/UDB 7.1")) {
            return StorageDesignUDBv71.RDBMS_TYPE;
        }
        if (string.equalsIgnoreCase("DB2/UDB 8.1")) {
            return StorageDesignUDBv81.RDBMS_TYPE;
        }
        if (string.equalsIgnoreCase("Oracle9i")) {
            return StorageDesignOraclev9i.RDBMS_TYPE;
        }
        if (string.equalsIgnoreCase("Oracle Database 10g")) {
            return StorageDesignOraclev10g.RDBMS_TYPE;
        }
        if (string.equalsIgnoreCase("Oracle Database 11g")) {
            return StorageDesignOraclev11g.RDBMS_TYPE;
        }
        if (string.equalsIgnoreCase("SQL Server 2000")) {
            return StorageDesignSqlServerv2k.RDBMS_TYPE;
        }
        if (string.equalsIgnoreCase("SQL Server 2005")) {
            return StorageDesignSqlServerv2k5.RDBMS_TYPE;
        }
        return StorageDesignOraclev11g.RDBMS_TYPE;
    }

    public static MDDataTypeFactory getInstance(RDBMSType rDBMSType, Settings settings) {
        if (instances.containsKey(rDBMSType)) {
            return (MDDataTypeFactory)instances.get(rDBMSType);
        }
        instance = rDBMSType == StorageDesignDB2v70.RDBMS_TYPE ? new MDDataTypeFactoryDB2() : (rDBMSType == StorageDesignDB2v80.RDBMS_TYPE ? new MDDataTypeFactoryDB2() : (rDBMSType == StorageDesignUDBv71.RDBMS_TYPE ? new MDDataTypeFactoryUDB() : (rDBMSType == StorageDesignUDBv81.RDBMS_TYPE ? new MDDataTypeFactoryUDB() : (rDBMSType == StorageDesignOraclev9i.RDBMS_TYPE ? new MDDataTypeFactoryOraclev9i(settings) : (rDBMSType == StorageDesignOraclev10g.RDBMS_TYPE ? new MDDataTypeFactoryOraclev10g(settings) : (rDBMSType == StorageDesignOraclev11g.RDBMS_TYPE ? new MDDataTypeFactoryOraclev10g(settings) : (rDBMSType == StorageDesignSqlServerv2k.RDBMS_TYPE ? new MDDataTypeFactorySqlServer() : (rDBMSType == StorageDesignSqlServerv2k5.RDBMS_TYPE ? new MDDataTypeFactorySqlServer() : new MDDataTypeFactoryOraclev10g(settings)))))))));
        MDDataTypeFactory.instance.dbtype = rDBMSType;
        instances.put(rDBMSType, instance);
        return instance;
    }

    public MDDataType createType(String string) {
        if (this.getFlyWeights().containsKey(string)) {
            try {
                return (MDDataType)this.getFlyWeights().get(string);
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (this.getHeavyWeights().containsKey(string)) {
            try {
                return (MDDataType)((Class)this.getHeavyWeights().get(string)).newInstance();
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (!LogicalDatatypeSet.UNKNOWN.equalsIgnoreCase(string)) {
            NativeDBType nativeDBType;
            RDBMSType rDBMSType = this.dbtype;
            if (rDBMSType == null) {
                rDBMSType = StorageDesignOraclev11g.RDBMS_TYPE;
            }
            if ((nativeDBType = StandardDatatypeNames.getNativeDBType(rDBMSType, string)) != null && nativeDBType.isHasPrecision()) {
                MDUserDefined_PS mDUserDefined_PS = new MDUserDefined_PS(string);
                if (!nativeDBType.isHasScale()) {
                    mDUserDefined_PS.setHasScale(false);
                }
                return mDUserDefined_PS;
            }
            if (nativeDBType != null && nativeDBType.isHasSize()) {
                return new MDUserDefined_Sized(string);
            }
            if (nativeDBType != null) {
                return new MDUserDefined_NoParams(string);
            }
        }
        return null;
    }

    public MDDataType createStringEncodedType(String string) {
        String[] stringArray = MDDataTypeFactory.tokenize(string);
        return this.createStringEncodedType(stringArray);
    }

    public MDDataType createStringEncodedType(String[] stringArray) {
        switch (stringArray.length) {
            case 1: {
                return this.createType(stringArray[0]);
            }
            case 2: {
                String[] stringArray2;
                String string = stringArray[1];
                if (string.indexOf(32) > 0 && (stringArray2 = string.split(" ")).length == 2 && (stringArray2[1].equalsIgnoreCase("BYTE") || stringArray2[1].equalsIgnoreCase("CHAR"))) {
                    return this.createType(stringArray[0], string);
                }
                if ("size".equals(string)) {
                    return this.createType(stringArray[0], "0");
                }
                return this.createType(stringArray[0], stringArray[1]);
            }
            case 3: {
                return this.createType(stringArray[0], MDDataTypeFactory.parseSafely(stringArray[1]), MDDataTypeFactory.parseSafely(stringArray[2]));
            }
        }
        throw new RuntimeException(Messages.getString("MDDataTypeFactory.Expected1to3Parts"));
    }

    public static int parseSafely(String string) {
        try {
            int n = AbstractDataType.parseSize(string.trim());
            if (n != -1) {
                return n;
            }
            return 0;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static int parse(String string) {
        try {
            return Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException(numberFormatException.toString());
        }
    }

    public static String[] tokenize(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",;", false);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken().trim());
        }
        return arrayList.toArray(new String[0]);
    }

    protected Map getFlyWeights() {
        if (this.flyweights == null) {
            this.flyweights = new TreeMap();
            this.initFlyWeights();
        }
        return this.flyweights;
    }

    protected Map getHeavyWeights() {
        if (this.heavyweights == null) {
            this.heavyweights = new TreeMap();
            this.initHeavyWeights();
        }
        return this.heavyweights;
    }

    public static int stringToInt(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public MDDataType createUDNativeType(String string, String string2) {
        if (!LogicalDatatypeSet.UNKNOWN.equalsIgnoreCase(string)) {
            NativeDBType nativeDBType;
            RDBMSType rDBMSType = this.dbtype;
            if (rDBMSType == null) {
                rDBMSType = StorageDesignOraclev11g.RDBMS_TYPE;
            }
            if ((nativeDBType = StandardDatatypeNames.getNativeDBType(rDBMSType, string)) != null && nativeDBType.isHasSize()) {
                MDUserDefined_Sized mDUserDefined_Sized = new MDUserDefined_Sized(string);
                mDUserDefined_Sized.setSize(string2);
                return mDUserDefined_Sized;
            }
            if (nativeDBType != null && nativeDBType.isHasPrecision()) {
                MDUserDefined_PS mDUserDefined_PS = new MDUserDefined_PS(string);
                mDUserDefined_PS.setPrecision(MDDataTypeFactory.parseSafely(string2));
                return mDUserDefined_PS;
            }
            if (nativeDBType != null) {
                return new MDUserDefined_NoParams(string);
            }
        }
        return null;
    }

    public MDDataType createUDNativeType(String string, int n, int n2) {
        if (!LogicalDatatypeSet.UNKNOWN.equalsIgnoreCase(string)) {
            NativeDBType nativeDBType;
            RDBMSType rDBMSType = this.dbtype;
            if (rDBMSType == null) {
                rDBMSType = StorageDesignOraclev11g.RDBMS_TYPE;
            }
            if ((nativeDBType = StandardDatatypeNames.getNativeDBType(rDBMSType, string)) != null && nativeDBType.isHasPrecision()) {
                MDUserDefined_PS mDUserDefined_PS = new MDUserDefined_PS(string);
                mDUserDefined_PS.setPrecision(n);
                mDUserDefined_PS.setScale(n2);
                return mDUserDefined_PS;
            }
            if (nativeDBType != null) {
                return new MDUserDefined_NoParams(string);
            }
        }
        return null;
    }

    protected abstract void initFlyWeights();

    protected abstract void initHeavyWeights();

    public abstract MDDataType createType(String var1, String var2);

    public abstract MDDataType createType(String var1, int var2, int var3);

    public RDBMSType getRDBMSType() {
        return this.dbtype;
    }

    public void setRDBMSType(RDBMSType rDBMSType) {
        this.dbtype = rDBMSType;
    }
}

