/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.datatype;

import java.util.Arrays;
import java.util.List;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.datatype.DataTypeListener;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.util.logging.Logger;

public abstract class AbstractDataType
implements MDDataType {
    private static final Logger LOGGER = new Logger(Token.class);

    @Override
    public String getName() {
        throw new RuntimeException("Should be overriden, getName() should return the name constant in MDDataTypeNames");
    }

    @Override
    public boolean isFixedLength() {
        return false;
    }

    @Override
    public boolean isFlyweight() {
        return this.isImplicitSized();
    }

    @Override
    public boolean isImplicitSized() {
        return false;
    }

    @Override
    public boolean isVarSized() {
        return false;
    }

    @Override
    public boolean isPacked() {
        return false;
    }

    @Override
    public String getType() {
        if (this.isImplicitSized()) {
            return "builtin";
        }
        if (this.isFixedLength()) {
            return "fixed";
        }
        if (this.isVarSized()) {
            return "var";
        }
        if (this.isPacked()) {
            return "packed";
        }
        return "";
    }

    @Override
    public int getPrecision() {
        throw new RuntimeException("Class that is not packed type, getPrecision() invalid.");
    }

    @Override
    public void setPrecision(int n) {
        throw new RuntimeException("Class that is not packed type, setPrecision() invalid.");
    }

    @Override
    public int getScale() {
        throw new RuntimeException("Class that is not packed type, getScale() invalid.");
    }

    @Override
    public void setScale(int n) {
        throw new RuntimeException("Class that is not packed type, setScale() invalid.");
    }

    @Override
    public String getSize() {
        throw new RuntimeException("Should be overriden, getSize() invalid.");
    }

    @Override
    public void setSize(String string) {
        throw new RuntimeException("Should be overriden, setSize() invalid.");
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public MDDataType deepCopy() {
        if (this.isFlyweight()) {
            return this;
        }
        throw new RuntimeException("Should be overriden for non-flyweights, deepCopy() invalid.");
    }

    @Override
    public String getSQL() {
        return this.getName();
    }

    @Override
    public void appendTo(StringBuffer stringBuffer) {
        stringBuffer.append(this.getName());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendTo(stringBuffer);
        return stringBuffer.toString();
    }

    @Override
    public void addDataTypeListener(DataTypeListener dataTypeListener) {
    }

    @Override
    public void removeDataTypeListener(DataTypeListener dataTypeListener) {
    }

    @Override
    public int getByteSize() {
        return AbstractDataType.parseSize(this.getSize());
    }

    public static int parseSize(String string) {
        try {
            int n = -1;
            String[] stringArray = new String[]{"k", "K"};
            List<String> list = Arrays.asList(stringArray);
            String[] stringArray2 = new String[]{"m", "M"};
            List<String> list2 = Arrays.asList(stringArray2);
            String[] stringArray3 = new String[]{"g", "G"};
            List<String> list3 = Arrays.asList(stringArray3);
            String[] stringArray4 = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
            List<String> list4 = Arrays.asList(stringArray4);
            if (string.equalsIgnoreCase("")) {
                return 0;
            }
            if (list.contains(string.substring(string.length() - 1))) {
                n = Integer.parseInt(string.substring(0, string.length() - 1));
                return n * 1024;
            }
            if (list2.contains(string.substring(string.length() - 1))) {
                n = Integer.parseInt(string.substring(0, string.length() - 1));
                return n * 1026;
            }
            if (list3.contains(string.substring(string.length() - 1))) {
                n = Integer.parseInt(string.substring(0, string.length() - 1));
                return n * 1027;
            }
            if (list4.contains(string.substring(string.length() - 1))) {
                n = Integer.parseInt(string);
                return n;
            }
            return -1;
        }
        catch (Exception exception) {
            LOGGER.error("Error in parsing datatype size", exception);
            return -1;
        }
    }

    @Override
    public boolean hasPrecision() {
        return false;
    }

    @Override
    public boolean hasScale() {
        return false;
    }

    @Override
    public boolean hasSize() {
        return false;
    }

    public String getPrecisionText() {
        return Messages.getString("AbstractDataType.NotApplicable");
    }

    public String getScaleText() {
        return Messages.getString("AbstractDataType.NotApplicable");
    }

    public String getSizeText() {
        return Messages.getString("AbstractDataType.NotApplicable");
    }
}

