/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.businessinfo;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.businessinfo.BIContact;
import oracle.dbtools.crest.model.businessinfo.BIResponsiblePartySet;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.swingui.editor.businessinfo.ResponsiblePartyPropertiesDialogEx;

public class BIResponsibleParty
extends DesignObject {
    private String responsibility = "";
    private List contacts = new ArrayList();
    private List elements = new ArrayList();
    private BIResponsibleParty parentParty = null;
    private List subParties = new ArrayList();
    public static final String TYPE_NAME = "ResponsibleParty";

    public BIResponsibleParty(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return "RP";
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ResponsiblePartyPropertiesDialogEx responsiblePartyPropertiesDialogEx = new ResponsiblePartyPropertiesDialogEx(this.getDesign().getAppView(), this);
            responsiblePartyPropertiesDialogEx.initProperties(this);
            responsiblePartyPropertiesDialogEx.show();
        }
    }

    public String getResponsibility() {
        return this.responsibility;
    }

    public void setResponsibility(String string) {
        this.responsibility = string;
    }

    public List getContacts() {
        return this.contacts;
    }

    public void addContact(BIContact bIContact) {
        if (!this.contacts.contains(bIContact)) {
            this.contacts.add(bIContact);
            bIContact.addResParty(this);
        }
    }

    public void removeContact(BIContact bIContact) {
        this.contacts.remove(bIContact);
        bIContact.removeResParty(this);
    }

    public void clearContacts() {
        for (BIContact bIContact : this.contacts) {
            bIContact.removeResParty(this);
        }
        this.contacts.clear();
    }

    public List getElements() {
        return this.elements;
    }

    public void addElement(DesignObject designObject) {
        if (!this.elements.contains(designObject)) {
            this.elements.add(designObject);
        }
    }

    public void removeElement(DesignObject designObject) {
        this.elements.remove(designObject);
    }

    public BIResponsibleParty getParentParty() {
        return this.parentParty;
    }

    public void setParentParty(BIResponsibleParty bIResponsibleParty) {
        if (this.parentParty != bIResponsibleParty) {
            if (this.parentParty != null) {
                this.parentParty.removeSubParty(this);
            }
            if (bIResponsibleParty != null) {
                bIResponsibleParty.addSubParty(this);
            }
            this.parentParty = bIResponsibleParty;
            BIResponsiblePartySet bIResponsiblePartySet = (BIResponsiblePartySet)this.getParent();
            bIResponsiblePartySet.fireChange(SetEvent.STRUCTURE_CHANGED);
        }
    }

    public List getSubParties() {
        return this.subParties;
    }

    public void setSubParties(List list) {
        this.subParties = list;
    }

    public void addSubParty(BIResponsibleParty bIResponsibleParty) {
        if (!this.subParties.contains(bIResponsibleParty)) {
            this.subParties.add(bIResponsibleParty);
        }
    }

    public void removeSubParty(BIResponsibleParty bIResponsibleParty) {
        if (this.subParties.contains(bIResponsibleParty)) {
            this.subParties.remove(bIResponsibleParty);
        }
    }

    @Override
    public boolean isLeaf() {
        return this.subParties.size() <= 0;
    }

    @Override
    public int getNumberOfChildren() {
        return this.subParties.size();
    }

    @Override
    public ModelObject getChild(int n) {
        return (BIResponsibleParty)this.subParties.get(n);
    }

    @Override
    public void copy(DesignObject designObject) {
        super.copy(designObject);
        ((BIResponsibleParty)designObject).setResponsibility(this.getResponsibility());
        Iterator iterator = this.getElements().iterator();
        while (iterator.hasNext()) {
            ((BIResponsibleParty)designObject).addElement((DesignObject)iterator.next());
        }
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "party/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

