/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.businessinfo;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.businessinfo.BIContact;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.swingui.editor.businessinfo.UrlPropertiesDialogEx;

public class BIResourceLocator
extends DesignObject {
    private String url = "";
    private List contacts = new ArrayList();
    public static final String TYPE_NAME = "ResLocator";

    public BIResourceLocator(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return "ResLoc";
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            UrlPropertiesDialogEx urlPropertiesDialogEx = new UrlPropertiesDialogEx(this.getDesign().getAppView(), this);
            urlPropertiesDialogEx.initProperties(this);
            urlPropertiesDialogEx.show();
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public List getContacts() {
        return this.contacts;
    }

    public void addContact(BIContact bIContact) {
        if (!this.contacts.contains(bIContact)) {
            this.contacts.add(bIContact);
        }
    }

    public void removeContact(BIContact bIContact) {
        this.contacts.remove(bIContact);
    }

    @Override
    public void copy(DesignObject designObject) {
        super.copy(designObject);
        ((BIResourceLocator)designObject).setUrl(this.getUrl());
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "url/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

