/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.businessinfo;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.businessinfo.BIDocumentSet;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.swingui.editor.businessinfo.DocumentPropertiesDialogEx;

public class BIDocument
extends DesignObject {
    private String reference = "";
    private String type = "";
    private List elements = new ArrayList();
    private BIDocument parentDocument = null;
    private List subDocuments = new ArrayList();
    public static final String TYPE_NAME = "Document";

    public BIDocument(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            DocumentPropertiesDialogEx documentPropertiesDialogEx = new DocumentPropertiesDialogEx(this.getDesign().getAppView(), this);
            documentPropertiesDialogEx.initProperties(this);
            documentPropertiesDialogEx.show();
        }
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return "Doc";
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String string) {
        this.reference = string;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public List getElements() {
        return this.elements;
    }

    public void addElement(DesignObject designObject) {
        if (designObject instanceof Table ? ((Table)designObject).isBackup() : designObject instanceof FKIndexAssociation && ((FKIndexAssociation)designObject).isBackupFK()) {
            return;
        }
        if (!this.elements.contains(designObject) && designObject.getObjectID() != null) {
            DesignObject designObject2 = this.getByID(designObject);
            if (designObject2 != null) {
                this.elements.remove(designObject2);
            }
            this.elements.add(designObject);
        }
    }

    public void addElement(DesignPart designPart) {
        if (!this.elements.contains(designPart)) {
            this.elements.add(designPart);
        }
    }

    public void removeElement(DesignObject designObject) {
        this.elements.remove(designObject);
    }

    public BIDocument getParentDocument() {
        return this.parentDocument;
    }

    public void setParentDocument(BIDocument bIDocument) {
        if (this.parentDocument != bIDocument) {
            if (this.parentDocument != null) {
                this.parentDocument.removeSubDocument(this);
            }
            if (bIDocument != null) {
                bIDocument.addSubDocument(this);
            }
            this.parentDocument = bIDocument;
            BIDocumentSet bIDocumentSet = (BIDocumentSet)this.getParent();
            bIDocumentSet.fireChange(SetEvent.STRUCTURE_CHANGED);
        }
    }

    public List getSubDocuments() {
        return this.subDocuments;
    }

    public void setSubDocuments(List list) {
        this.subDocuments = list;
    }

    public void addSubDocument(BIDocument bIDocument) {
        if (!this.subDocuments.contains(bIDocument)) {
            this.subDocuments.add(bIDocument);
        }
    }

    public void removeSubDocument(BIDocument bIDocument) {
        if (this.subDocuments.contains(bIDocument)) {
            this.subDocuments.remove(bIDocument);
        }
    }

    @Override
    public boolean isLeaf() {
        return this.subDocuments.size() <= 0;
    }

    @Override
    public int getNumberOfChildren() {
        return this.subDocuments.size();
    }

    @Override
    public ModelObject getChild(int n) {
        return (BIDocument)this.subDocuments.get(n);
    }

    @Override
    public void copy(DesignObject designObject) {
        super.copy(designObject);
        ((BIDocument)designObject).setReference(this.getReference());
        ((BIDocument)designObject).setType(this.getType());
        Iterator iterator = this.getElements().iterator();
        while (iterator.hasNext()) {
            ((BIDocument)designObject).addElement((DesignObject)iterator.next());
        }
    }

    private DesignObject getByID(DesignObject designObject) {
        for (DesignObject designObject2 : this.elements) {
            if (!designObject2.getObjectID().equalsIgnoreCase(designObject.getObjectID())) continue;
            return designObject2;
        }
        return null;
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "document/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

