/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.businessinfo;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.businessinfo.BIEmail;
import oracle.dbtools.crest.model.businessinfo.BILocation;
import oracle.dbtools.crest.model.businessinfo.BIPhone;
import oracle.dbtools.crest.model.businessinfo.BIResourceLocator;
import oracle.dbtools.crest.model.businessinfo.BIResponsibleParty;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.swingui.editor.businessinfo.ContactPropertiesDialogEx;

public class BIContact
extends DesignObject {
    private List emails = new ArrayList();
    private List locations = new ArrayList();
    private List parties = new ArrayList();
    private List phones = new ArrayList();
    private List urls = new ArrayList();
    public static final String TYPE_NAME = "Contact";

    public BIContact(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ContactPropertiesDialogEx contactPropertiesDialogEx = new ContactPropertiesDialogEx(this.getDesign().getAppView(), this);
            contactPropertiesDialogEx.initProperties(this);
            contactPropertiesDialogEx.show();
        }
    }

    public List getEmails() {
        return this.emails;
    }

    public void addEmail(BIEmail bIEmail) {
        if (!this.emails.contains(bIEmail)) {
            this.emails.add(bIEmail);
            bIEmail.addContact(this);
        }
    }

    public void removeEmail(BIEmail bIEmail) {
        this.emails.remove(bIEmail);
        bIEmail.removeContact(this);
    }

    public void clearEmails() {
        for (BIEmail bIEmail : this.emails) {
            bIEmail.removeContact(this);
        }
        this.emails.clear();
    }

    public List getLocations() {
        return this.locations;
    }

    public void addLocation(BILocation bILocation) {
        if (!this.locations.contains(bILocation)) {
            this.locations.add(bILocation);
            bILocation.addContact(this);
        }
    }

    public void removeLocation(BILocation bILocation) {
        this.locations.remove(bILocation);
        bILocation.removeContact(this);
    }

    public void clearLocations() {
        for (BILocation bILocation : this.locations) {
            bILocation.removeContact(this);
        }
        this.locations.clear();
    }

    public List getParties() {
        return this.parties;
    }

    public void addResParty(BIResponsibleParty bIResponsibleParty) {
        if (!this.parties.contains(bIResponsibleParty)) {
            this.parties.add(bIResponsibleParty);
        }
    }

    public void removeResParty(BIResponsibleParty bIResponsibleParty) {
        this.parties.remove(bIResponsibleParty);
    }

    public List getPhones() {
        return this.phones;
    }

    public void addPhone(BIPhone bIPhone) {
        if (!this.phones.contains(bIPhone)) {
            this.phones.add(bIPhone);
            bIPhone.addContact(this);
        }
    }

    public void removePhone(BIPhone bIPhone) {
        this.phones.remove(bIPhone);
        bIPhone.removeContact(this);
    }

    public void clearPhones() {
        for (BIPhone bIPhone : this.phones) {
            bIPhone.removeContact(this);
        }
        this.phones.clear();
    }

    public List getUrls() {
        return this.urls;
    }

    public void addUrl(BIResourceLocator bIResourceLocator) {
        if (!this.urls.contains(bIResourceLocator)) {
            this.urls.add(bIResourceLocator);
            bIResourceLocator.addContact(this);
        }
    }

    public void removeUrl(BIResourceLocator bIResourceLocator) {
        this.urls.remove(bIResourceLocator);
        bIResourceLocator.removeContact(this);
    }

    public void clearUrls() {
        for (BIResourceLocator bIResourceLocator : this.urls) {
            bIResourceLocator.removeContact(this);
        }
        this.urls.clear();
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "contact/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

