/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model;

import java.text.MessageFormat;
import oracle.dbtools.crest.model.LongNameObject;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerObjectEvent;
import oracle.dbtools.crest.model.design.ContainerObjectListener;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.util.logging.Logger;

public abstract class SubsetCO
extends ContainerObject
implements ContainerObjectListener,
LongNameObject {
    private ContainerObject container;
    private StringBuffer buffer = new StringBuffer();
    private static final Logger LOGGER = new Logger(SubsetCO.class);

    public SubsetCO(DesignPart designPart) {
        super(designPart);
    }

    public void setContainerObject(ContainerObject containerObject) {
        if (this.container != null) {
            this.container.removeContainerListener(this);
            this.container.removeObjectListener(this);
        }
        if (containerObject != null) {
            containerObject.addContainerListener(this);
            containerObject.addObjectListener(this);
        }
        this.container = containerObject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void add(ContainedObject containedObject) {
        if (this.shouldCheckContainer()) {
            if (this.container == null) {
                throw new IllegalStateException(Messages.getString("SubsetCO.0"));
            }
            if (!containedObject.belongsTo(this.container)) throw new IllegalArgumentException(MessageFormat.format(Messages.getString("SubsetCO.TryingToAddElement"), this.getClass(), this.container.getLongName(), containedObject.getLongName()));
            super.add(containedObject);
            return;
        } else {
            super.add(containedObject);
        }
    }

    protected boolean shouldCheckContainer() {
        return true;
    }

    @Override
    public void changed(ContainerObject containerObject, ContainerObjectEvent containerObjectEvent) {
        if (containerObjectEvent.isType(1)) {
            this.remove((ContainedObject)containerObjectEvent.getElement());
        }
    }

    @Override
    public Class getContainedClass() {
        if (this.getContainerObject() == null) {
            LOGGER.error("SubsetCO container null in: " + this.getClass());
            LOGGER.error("\tdo not use container.remove(subset) but subset.remove()");
            return ContainedObject.class;
        }
        return this.getContainerObject().getContainedClass();
    }

    @Override
    public String getLongName() {
        this.buffer.setLength(0);
        if (this.container != null) {
            this.buffer.append(this.container.getName());
            this.buffer.append('.');
        }
        this.buffer.append(this.getName());
        return this.buffer.toString();
    }

    @Override
    public ContainerObject getTopLevelContainer() {
        return this.container;
    }

    public ContainerObject getContainerObject() {
        return this.container;
    }

    @Override
    public ContainedObject createContainedObject(String string) {
        return null;
    }

    @Override
    public void remove() {
        if (!this.getIsBeingRemoved()) {
            this.setIsBeingRemoved(true);
            this.clearElements();
            if (this.getDesignObjectSet() != null) {
                this.getDesignObjectSet().remove(this);
            }
            ObjectChangeEvent objectChangeEvent = ObjectChangeEvent.OBJECT_REMOVED;
            objectChangeEvent.setAffected(this);
            this.fireChange(objectChangeEvent);
        }
    }

    public void clearElements() {
        this.getElementsCollection().clear();
        this.fireChange(this.sharedEvent);
    }

    @Override
    public void remove(ContainedObject containedObject) {
        if (containedObject != null && this.isWriteable() && this.getElementsCollection().contains(containedObject)) {
            this.getElementsCollection().remove(containedObject);
            this.removeLocalId(containedObject.getObjectID());
            containedObject.removeObjectListener(this);
            this.sharedEvent.setElement(containedObject);
            this.sharedEvent.setType(1);
            this.fireChange(this.sharedEvent);
        }
    }
}

