/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model;

import java.util.Collections;
import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.model.placeholder.PlaceHolder;
import oracle.dbtools.crest.swingui.DesignPartView;

public class SubViewObjectSet
extends DesignObjectSet {
    private static final Object[] PROTO_DESIGNOBJECT = new DesignObject[0];
    String name = Messages.getString("SubViewObjectSet.SubView");
    Object parent;
    Object elDescriptor;
    private boolean containsDisplays = false;

    public SubViewObjectSet(DesignPart designPart, String string) {
        super(designPart);
        this.setName(string);
        this.requireSort = true;
    }

    public SubViewObjectSet(DesignPart designPart, String string, boolean bl) {
        this(designPart, string);
        this.containsDisplays = bl;
    }

    @Override
    protected Object[] getProtoTypeArray() {
        return PROTO_DESIGNOBJECT;
    }

    @Override
    protected String getDefaultNamePrefix() {
        return Messages.getString("SubViewObjectSet.SubView");
    }

    @Override
    public boolean setName(String string) {
        this.name = string;
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void clear() {
        this.removeAll();
    }

    @Override
    public void setParent(Object object) {
        this.parent = object;
    }

    @Override
    public Object getParent() {
        if (this.parent != null) {
            return this.parent;
        }
        return super.getParent();
    }

    public void removePlaceHolderFor(Object object) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            PlaceHolder placeHolder = (PlaceHolder)iterator.next();
            if (!object.equals(placeHolder.getObject())) continue;
            this.remove(placeHolder);
            return;
        }
    }

    public boolean containsObject(Object object) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            PlaceHolder placeHolder = (PlaceHolder)iterator.next();
            if (!object.equals(placeHolder.getObject())) continue;
            return true;
        }
        return false;
    }

    public void setElementDescriptor(Object object) {
        this.elDescriptor = object;
    }

    public Object getElementDescriptor() {
        return this.elDescriptor;
    }

    public DesignPartView getSubViewGeneratedByDPV(String string) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)iterator.next();
            DesignPartView designPartView = designPartViewPlaceHolder.getDesignPartView();
            if (designPartView == null || string == null || !string.equals(designPartView.getGeneratorId())) continue;
            return designPartView;
        }
        return null;
    }

    public DesignPartView getSubViewByID(String string) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)iterator.next();
            DesignPartView designPartView = designPartViewPlaceHolder.getDesignPartView();
            if (designPartView == null || !string.equals(designPartView.getDPVId())) continue;
            return designPartView;
        }
        return null;
    }

    public DesignPartView getSubViewByName(String string) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)iterator.next();
            DesignPartView designPartView = designPartViewPlaceHolder.getDesignPartView();
            if (designPartView == null || !string.equalsIgnoreCase(designPartView.getName())) continue;
            return designPartView;
        }
        return null;
    }

    public DesignPartView[] getMainViewAndSubViews() {
        DesignPartView[] designPartViewArray = new DesignPartView[this.size() + 1];
        designPartViewArray[0] = this.getDesignPart().getMainView();
        Iterator iterator = this.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ++n;
            DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)iterator.next();
            DesignPartView designPartView = designPartViewPlaceHolder.getDesignPartView();
            if (designPartView == null) continue;
            designPartViewArray[n] = designPartView;
        }
        return designPartViewArray;
    }

    @Override
    public Design getDesign() {
        return this.getDesignPart().getDesign();
    }

    public boolean isContainsDisplays() {
        return this.containsDisplays;
    }

    @Override
    public void sort() {
        Collections.sort(this.elements, ModelObjectSet.NAME_IGNORE_CASE_COMPARATOR);
        this.fireChange(SetEvent.OBJECT_ADDED);
    }
}

