/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.ModelIDObject;

public class SegmentNameManager {
    private static int seg_size = 70;
    private List maps = new ArrayList();
    public static String NAME_PREFIX = "seg_";

    public String getSegmentName(ModelIDObject modelIDObject) {
        return this.getSegmentName(modelIDObject.getObjectID());
    }

    public String getSegmentName(String string) {
        return NAME_PREFIX + this.getMapIndex(string);
    }

    private int getMapIndex(String string) {
        for (int i = 0; i < this.maps.size(); ++i) {
            Object v;
            Map map = (Map)this.maps.get(i);
            if (map == null || (v = map.get(string)) == null) continue;
            return i;
        }
        return this.addToMaps(string);
    }

    private int addToMaps(String string) {
        for (int i = 0; i < this.maps.size(); ++i) {
            Map map = (Map)this.maps.get(i);
            if (map == null || map.keySet().size() >= seg_size) continue;
            map.put(string, string);
            return i;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(seg_size + 30);
        hashMap.put(string, string);
        this.maps.add(hashMap);
        return this.maps.indexOf(hashMap);
    }

    public void add(String string, String string2) {
        int n = this.getSegmentIndex(string);
        if (n >= this.maps.size()) {
            for (int i = this.maps.size(); i <= n; ++i) {
                this.maps.add(new HashMap());
            }
        }
        Map map = (Map)this.maps.get(n);
        map.put(string2, string2);
    }

    private int getSegmentIndex(String string) {
        int n = string.indexOf(NAME_PREFIX);
        if (n == 0) {
            int n2 = -1;
            try {
                n2 = Integer.valueOf(string.substring(NAME_PREFIX.length()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n2 > -1) {
                return n2;
            }
        }
        throw new RuntimeException("Error in segment name");
    }

    public void removeAll() {
        for (int i = 0; i < this.maps.size(); ++i) {
            Map map = (Map)this.maps.get(i);
            map.clear();
        }
    }

    public void removeID(String string) {
        for (int i = 0; i < this.maps.size(); ++i) {
            Object v;
            Map map = (Map)this.maps.get(i);
            if (map == null || (v = map.get(string)) == null) continue;
            map.remove(string);
        }
    }
}

