/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.TopViewCollection;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;

public abstract class MultiShapedDesignObject
extends DesignObject {
    protected Collection allViews = new ArrayList();

    public MultiShapedDesignObject(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public void setTopView(TopView topView) {
        this.addTopView(topView);
    }

    public void addTopView(TopView topView) {
        DesignPartView designPartView = topView.getDesignPartView();
        TopViewCollection topViewCollection = this.getViewsForDPV(designPartView);
        if (!topViewCollection.contains(topView)) {
            topViewCollection.add(topView);
            this.resetViewNumbers();
            this.addObjectListener(topView);
        }
    }

    public void removeTopView(TopView topView, boolean bl) {
        DesignPartView designPartView = topView.getDesignPartView();
        TopViewCollection topViewCollection = this.getViewsForDPV(designPartView);
        if (designPartView == this.getDesignPart().getMainView()) {
            if (topViewCollection.size() > 1 || bl) {
                topViewCollection.remove(topView);
                topView.setCellView(null);
                this.removeObjectListener(topView);
                this.resetViewNumbers();
            }
            if (!this.isAlwaysVisibleInMainView()) {
                topView.setCellView(null);
            }
        } else {
            topViewCollection.remove(topView);
            topView.setCellView(null);
            this.removeObjectListener(topView);
            this.resetViewNumbers();
        }
        if (topViewCollection.size() == 0) {
            this.allViews.remove(topViewCollection);
        }
    }

    public void removeTopView(TopView topView) {
        this.removeTopView(topView, false);
    }

    @Override
    public TopView getTopView() {
        if (this.allViews.isEmpty()) {
            return null;
        }
        Iterator iterator = this.allViews.iterator();
        TopViewCollection topViewCollection = (TopViewCollection)iterator.next();
        if (topViewCollection.isEmpty()) {
            return null;
        }
        Iterator iterator2 = topViewCollection.iterator();
        return (TopView)iterator2.next();
    }

    @Override
    public TopView getTopViewByID(DesignPartView designPartView, String string, int n) {
        if (string != null) {
            Collection collection = this.getAllViews(designPartView);
            for (TopView topView : collection) {
                if (!string.equalsIgnoreCase(topView.getViewID())) continue;
                return topView;
            }
            int n2 = 0;
            for (TopView topView : collection) {
                if (n == n2) {
                    topView.setViewNumber(n);
                    return topView;
                }
                ++n2;
            }
        }
        return null;
    }

    public TopView getTopViewByGeneratorID(DesignPartView designPartView, String string) {
        if (string != null) {
            Collection collection = this.getAllViews(designPartView);
            for (TopView topView : collection) {
                if (!string.equalsIgnoreCase(topView.getGeneratorID())) continue;
                return topView;
            }
        }
        return null;
    }

    @Override
    public int getViewNumber(TopView topView) {
        DesignPartView designPartView = topView.getDesignPartView();
        TopViewCollection topViewCollection = this.getViewsForDPV(designPartView);
        if (topViewCollection.isEmpty()) {
            return -100;
        }
        Iterator iterator = topViewCollection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            TopView topView2 = (TopView)iterator.next();
            if (topView2 == topView) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void moveViewToPosition(TopView topView, int n) {
        DesignPartView designPartView = topView.getDesignPartView();
        TopViewCollection topViewCollection = this.getViewsForDPV(designPartView);
        int n2 = topViewCollection.indexOf(topView);
        if (n2 > -1 && n2 != n && topViewCollection.remove(topView)) {
            topViewCollection.add(n, topView);
            this.resetViewNumbers();
        }
    }

    public Collection getViewSynonims(DesignPartView designPartView) {
        TopViewCollection topViewCollection = this.getViewsForDPV(designPartView);
        ArrayList arrayList = new ArrayList();
        if (topViewCollection.size() > 1) {
            Iterator iterator = topViewCollection.iterator();
            iterator.next();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        }
        return arrayList;
    }

    public Collection getAllViews(DesignPartView designPartView) {
        ArrayList arrayList = new ArrayList();
        TopViewCollection topViewCollection = this.getViewsForDPV(designPartView);
        if (topViewCollection.size() > 0) {
            Iterator iterator = topViewCollection.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        }
        return arrayList;
    }

    public void removeAllViews() {
    }

    public TopView getAnotherView(TopView topView) {
        DesignPartView designPartView = topView.getDesignPartView();
        TopViewCollection topViewCollection = this.getViewsForDPV(designPartView);
        for (TopView topView2 : topViewCollection) {
            if (topView2 == topView) continue;
            return topView2;
        }
        return null;
    }

    @Override
    public void removeViewSynonim(TopView topView) {
        this.removeTopView(topView);
    }

    @Override
    public void resetViewNumbers() {
        for (TopViewCollection topViewCollection : this.allViews) {
            for (TopView topView : topViewCollection) {
                topView.setViewNumber(this.getViewNumber(topView));
            }
        }
    }

    @Override
    public int getTopViewsCount() {
        int n = 0;
        for (TopViewCollection topViewCollection : this.allViews) {
            n += topViewCollection.size();
        }
        return n;
    }

    @Override
    public int getViewsCountForDPV(DesignPartView designPartView) {
        for (TopViewCollection topViewCollection : this.allViews) {
            if (topViewCollection.getDPV() != designPartView) continue;
            return topViewCollection.size();
        }
        return 0;
    }

    @Override
    public TopView getFirstViewForDPV(DesignPartView designPartView) {
        for (TopViewCollection topViewCollection : this.allViews) {
            if (topViewCollection.getDPV() != designPartView) continue;
            if (topViewCollection.size() > 0) {
                return (TopView)topViewCollection.get(0);
            }
            return null;
        }
        return null;
    }

    @Override
    public TopViewCollection getViewsForDPV(DesignPartView designPartView) {
        TopViewCollection topViewCollection2;
        for (TopViewCollection topViewCollection2 : this.allViews) {
            if (topViewCollection2.getDPV() != designPartView) continue;
            return topViewCollection2;
        }
        topViewCollection2 = new TopViewCollection();
        topViewCollection2.setDPV(designPartView);
        this.allViews.add(topViewCollection2);
        return topViewCollection2;
    }

    public Collection getAffectedDPVs() {
        HashSet<DesignPartView> hashSet = new HashSet<DesignPartView>();
        for (TopViewCollection topViewCollection : this.allViews) {
            if (topViewCollection.dpv == null || topViewCollection.size() <= 0) continue;
            hashSet.add(topViewCollection.dpv);
        }
        return hashSet;
    }

    @Override
    public boolean hasRepresentationInDPV(DesignPartView designPartView) {
        TopViewCollection topViewCollection = this.getViewsForDPV(designPartView);
        return topViewCollection.size() > 0;
    }

    public boolean isAlwaysVisibleInMainView() {
        return true;
    }

    public boolean isVisibleInMainView() {
        for (TopView topView : this.getViewsForDPV(this.getDesignPart().getMainView())) {
            if (topView.getCellView() == null) continue;
            return true;
        }
        return false;
    }

    public List getAllViewsWithCellViews() {
        ArrayList<TopView> arrayList = new ArrayList<TopView>();
        for (TopViewCollection topViewCollection : this.allViews) {
            for (TopView topView : topViewCollection) {
                if (topView.getCellView() == null) continue;
                arrayList.add(topView);
            }
        }
        return arrayList;
    }

    public List getAllTopViews() {
        ArrayList<TopView> arrayList = new ArrayList<TopView>();
        for (TopViewCollection topViewCollection : this.allViews) {
            for (TopView topView : topViewCollection) {
                arrayList.add(topView);
            }
        }
        return arrayList;
    }

    @Override
    public void remove() {
        super.remove();
        for (TopViewCollection topViewCollection : this.allViews) {
            topViewCollection.dpv = null;
            topViewCollection.clear();
        }
        this.allViews.clear();
    }

    public void resetAllTopViewsCustomFormat() {
        for (TopView topView : this.getAllTopViews()) {
            topView.setUseCustomFormat(false);
        }
    }
}

