/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JDialog;
import oracle.dbtools.crest.model.ElementSet;
import oracle.dbtools.crest.model.MDUser;
import oracle.dbtools.crest.model.MDUserFactory;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ObjectChange;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.propertymap.PropertyMap;
import oracle.dbtools.crest.util.propertymap.PropertyMapImplementation;
import oracle.dbtools.crest.util.string.StringUtilities;

public abstract class ModelIDObject
extends ModelObject
implements PropertyMap,
RepositoryObject,
ID_ObjectPropertyTranslator,
StorableObject {
    private ObjectChange creation = new ObjectChange();
    private ObjectChange change = new ObjectChange();
    public boolean dirty = false;
    private String comment = "";
    private String notes = "";
    protected String id;
    protected String shortID;
    protected int pathID = 0;
    public static final String USER_GENERATED = Messages.getString("ModelIDObject.UserGenerated");
    private String generatorID = USER_GENERATED;
    private Set listeners = new HashSet();
    private boolean shouldEngineer = true;
    private PropertyMap properties;
    private boolean temporaryWriteable = false;
    private String ownerDesignName;
    private boolean existsInRepository;
    private boolean nameFixed;
    private String commentInRDBMS;
    private boolean markedGenerate = true;
    private boolean dropEnabled = false;
    private boolean isDialogVisible = false;
    public boolean showModal = false;
    private boolean shouldMerge = true;
    protected transient boolean readOnly;
    private boolean showForFirstTime = false;
    private int numID;
    private JDialog propsDialog = null;
    private String repositoryOID = null;
    private String repositoryOVID = null;
    private boolean checkedOut = false;
    private String checkedOutBy = "";
    private boolean checkedOutByMe = false;
    protected RepositoryObject pac_Element;
    protected String segmentedStorageName;
    protected String directorySegmentName = "";
    private static StringBuffer idbuf = new StringBuffer();
    private static final Logger LOGGER = new Logger(ModelIDObject.class);

    public abstract String getObjectTypeName();

    public String getOldObjectTypeName() {
        return this.getObjectTypeName();
    }

    public void setComment(String string) {
        if (this.isWriteable()) {
            this.comment = string != null ? string : "";
        }
    }

    public void setNotes(String string) {
        if (this.isWriteable()) {
            this.notes = string != null ? string : "";
        }
    }

    public String getComment() {
        return this.comment;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setCommentInRDBMS(String string) {
        if (string != null && !"null".equalsIgnoreCase(string)) {
            this.commentInRDBMS = string;
        }
    }

    public String getCommentInRDBMS() {
        String string = this.commentInRDBMS;
        string = string == null ? "" : string;
        return string;
    }

    public ObjectChange getCreation() {
        return this.creation;
    }

    public String getCreationTime() {
        return this.getCreation().getTimeString();
    }

    public MDUser getCreator() {
        return this.getCreation().getUser();
    }

    public void setCreator(MDUser mDUser) {
        if (this.isWriteable()) {
            this.getCreation().setUser(mDUser);
        }
    }

    public ObjectChange getChange() {
        return this.change;
    }

    public MDUser getChanger() {
        return this.getChange().getUser();
    }

    public void setChanger(MDUser mDUser) {
        if (this.isWriteable() && !this.getChange().getUser().getName().equals(mDUser.getName())) {
            this.getChange().setUser(mDUser);
            this.fireChange(ObjectChangeEvent.CHANGER_CHANGED);
        }
    }

    public String getChangeTime() {
        return this.getChange().getTimeString();
    }

    public void setObjectID(String string) {
        if (this.id != null && !this.id.equals(string)) {
            this.getDesign().updateDesignObjectId(this.id, string);
        }
        this.id = string;
        this.resetShortID();
    }

    protected void resetShortID() {
        if (this.id == null) {
            this.id = this.getObjectID();
        }
        this.shortID = ModelIDObject.getShortID(this.id);
    }

    public static String getShortID(String string) {
        String string2 = string;
        if (string != null && !"".equalsIgnoreCase(string)) {
            String[] stringArray = string.split("-");
            if (stringArray.length == 6) {
                idbuf.setLength(0);
                idbuf.append(stringArray[0]).append('-').append(stringArray[1]).append('-').append(stringArray[5]);
                string2 = idbuf.toString();
                idbuf.setLength(0);
            } else if (stringArray.length == 5) {
                idbuf.setLength(0);
                idbuf.append(stringArray[0]).append('-').append(stringArray[4]);
                string2 = idbuf.toString();
                idbuf.setLength(0);
            } else {
                string2 = string;
            }
        }
        return string2;
    }

    public String getObjectID() {
        return this.id;
    }

    public String getShortObjectID() {
        if (this.shortID == null) {
            this.resetShortID();
        }
        return this.shortID;
    }

    public int getPathID() {
        return this.pathID;
    }

    public void setPathID(int n) {
        this.pathID = n;
    }

    public String getPathIDString() {
        return String.valueOf(this.getPathID());
    }

    public String createGlobalID() {
        this.setObjectID(this.getAppView().getIDGenerator().createNewID());
        return this.getObjectID();
    }

    public String getGeneratorID() {
        return this.generatorID;
    }

    public DesignObject getGenerator() {
        return this.getDesign().getDesignObject(this.getGeneratorID());
    }

    public void setGeneratorID(String string) {
        if (this.isWriteable()) {
            this.generatorID = string;
        }
    }

    public abstract String getIDPrefix();

    public void setReadOnly(boolean bl) {
        if (this.isReadOnly() != bl) {
            this.readOnly = bl;
        }
    }

    public void setTemporaryWriteable(boolean bl) {
        this.temporaryWriteable = bl;
    }

    public boolean isTemporaryWriteable() {
        return this.temporaryWriteable;
    }

    public final void setReadWritable(boolean bl) {
        this.setReadOnly(!bl);
    }

    public boolean isReadOnly() {
        if (this.getRepositoryOID() != null && this.getDesign().isLoadFromDB() && !this.getDesign().isLoading()) {
            return !this.isCheckedOutByMe();
        }
        return this.readOnly;
    }

    @Override
    public final boolean isWriteable() {
        return !this.isReadOnly();
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean bl) {
        this.dirty = bl;
        if (bl) {
            this.getChange().setTimeNow();
            this.getChange().setUser(MDUserFactory.getInstance().getCurrentUser());
        }
    }

    @Override
    public boolean setName(String string) {
        if (super.setName(string)) {
            ElementSet elementSet = this.getSet();
            if (elementSet != null && elementSet.canSort()) {
                elementSet.sort();
            }
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
            return true;
        }
        return false;
    }

    public void setNameFixed(boolean bl) {
        this.nameFixed = bl;
    }

    public boolean isNameFixed() {
        return this.nameFixed;
    }

    public void setShouldEngineer(boolean bl) {
        if (this.shouldEngineer != bl) {
            this.shouldEngineer = bl;
            this.setDirty(true);
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    public boolean getShouldEngineer() {
        return this.shouldEngineer;
    }

    protected Set getListeners() {
        return this.listeners;
    }

    protected abstract void fireChange(ObjectChangeEvent var1);

    public void addReplaceLabeledComment(String string, String string2) {
        String string3 = this.getComment();
        string3 = StringUtilities.removeAllBetween(string3, StringUtilities.labeledStart(string), StringUtilities.labeledEnd());
        this.setComment(new StringBuffer(string3).append(StringUtilities.labeledComment(string, string2)).toString());
    }

    public void removeLabeledComment(String string) {
        String string2 = this.getComment();
        this.setComment(StringUtilities.removeAllBetween(string2, StringUtilities.labeledStart(string), StringUtilities.labeledEnd()));
    }

    public boolean isSystemObject() {
        return false;
    }

    public boolean belongsToDesign() {
        return this.belongsToDesign(this.getDesign());
    }

    public boolean shouldBeDroppedIndirectly() {
        return false;
    }

    public boolean belongsToDesign(Design design) {
        if (design.getCurrentOperation() == 5) {
            return true;
        }
        return this.getOwnerDesignName().equals(design.getName());
    }

    public String getOwnerDesignName() {
        if (this.isSystemObject()) {
            return Design.getSystemDesignName();
        }
        String string = this.ownerDesignName;
        if (string == null) {
            return this.getDesign().getFileName();
        }
        return string;
    }

    public void setOwnerDesignName(String string) {
        if (!this.isSystemObject()) {
            this.ownerDesignName = string;
        }
    }

    public boolean hasOwnerDesignName() {
        return !this.getDesign().isNewDesign() && this.ownerDesignName != null;
    }

    @Override
    public void setProperty(String string, String string2) {
        this.getProperties().setProperty(string, string2);
    }

    public void setOwnerDesign() {
        this.setOwnerDesign(this.getDesign());
    }

    public void setOwnerDesign(Design design) {
        this.setOwnerDesignName(design.getFileName());
    }

    @Override
    public String getProperty(String string) {
        return this.getProperties().getProperty(string);
    }

    @Override
    public boolean hasProperty(String string) {
        if (this.properties == null) {
            return false;
        }
        return this.getProperties().hasProperty(string);
    }

    @Override
    public boolean hasProperty(String string, String string2) {
        if (this.properties == null) {
            return false;
        }
        return this.getProperties().hasProperty(string, string2);
    }

    @Override
    public void removeProperty(String string) {
        if (this.properties == null) {
            this.getProperties().removeProperty(string);
        }
    }

    @Override
    public void clearProperties() {
        this.getProperties().clearProperties();
        this.properties = null;
    }

    @Override
    public Iterator getPropertyNames() {
        if (this.properties == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.getProperties().getPropertyNames();
    }

    protected PropertyMap getProperties() {
        if (this.properties == null) {
            this.properties = new PropertyMapImplementation();
        }
        return this.properties;
    }

    protected void finalize() throws Throwable {
        this.listeners.clear();
        super.finalize();
    }

    public void setPersisted(boolean bl) {
        this.existsInRepository = bl;
    }

    public boolean getPersisted() {
        return this.existsInRepository;
    }

    public void remove() {
        LOGGER.error("Remove not implemented for " + this.getObjectTypeName());
    }

    public int getMaxNameLength() {
        return 18;
    }

    public String getFilePath() {
        return this.getStorageName();
    }

    public void setFilePath(String string) {
    }

    public boolean isDropEnabled() {
        if (!ApplicationView.DROP_GENERATED_OBJECTS_ONLY) {
            return this.dropEnabled;
        }
        return this.dropEnabled && this.isMarkedGenerate();
    }

    public void setDropEnabled(boolean bl) {
        this.dropEnabled = bl;
    }

    public boolean isMarkedGenerate() {
        return this.markedGenerate;
    }

    public void setMarkedGenerate(boolean bl) {
        this.markedGenerate = bl;
    }

    public boolean isDialogVisible() {
        if (this.isDialogVisible && this.propsDialog != null) {
            this.propsDialog.toFront();
        }
        return this.isDialogVisible;
    }

    public void setDialogVisible(boolean bl, JDialog jDialog) {
        this.isDialogVisible = bl;
        this.propsDialog = jDialog;
    }

    public void showPropertyDialog() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showPropertyDialogOnNew() {
        if (this.getAppView().getSettings().showPropertiesDialogOnNew()) {
            this.showForFirstTime = true;
            try {
                this.showPropertyDialog();
            }
            finally {
                this.showForFirstTime = false;
            }
        }
    }

    public boolean shouldBeMerge() {
        return this.shouldMerge;
    }

    public void setShouldMerge(boolean bl) {
        this.shouldMerge = bl;
    }

    public boolean showForFirstTime() {
        return this.showForFirstTime;
    }

    public void setShowForFirstTime(boolean bl) {
        this.showForFirstTime = bl;
    }

    public int getNumID() {
        return this.numID;
    }

    public void setNumID(int n) {
        this.numID = n;
    }

    public void closePropertiesDialog() {
        if (this.propsDialog != null) {
            try {
                this.propsDialog.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public JDialog getPropertiesDialog() {
        return this.propsDialog;
    }

    @Override
    public String getRepositoryOID() {
        return this.repositoryOID;
    }

    @Override
    public void setRepositoryOID(String string) {
        this.repositoryOID = string;
    }

    @Override
    public String getRepositoryOVID() {
        return this.repositoryOVID;
    }

    @Override
    public void setRepositoryOVID(String string) {
        this.repositoryOVID = string;
    }

    @Override
    public boolean isCheckedOut() {
        return this.checkedOut;
    }

    @Override
    public void setCheckedOut(boolean bl) {
        this.checkedOut = bl;
    }

    @Override
    public String getCheckedOutBy() {
        return this.checkedOutBy;
    }

    @Override
    public void setCheckedOutBy(String string) {
        this.checkedOutBy = string;
    }

    @Override
    public boolean isCheckedOutByMe() {
        return this.checkedOutByMe;
    }

    @Override
    public void setCheckedOutByMe(boolean bl) {
        this.checkedOutByMe = bl;
    }

    @Override
    public boolean canBedeleted() {
        return true;
    }

    @Override
    public RepositoryObject getPAC_Element() {
        return this.pac_Element;
    }

    @Override
    public boolean isPAC_Element() {
        return this.pac_Element == null;
    }

    @Override
    public void setPAC_Element(RepositoryObject repositoryObject) {
        this.pac_Element = repositoryObject;
    }

    public String getCreatedBy() {
        return this.getCreator().getName();
    }

    public void setCreatedBy(String string) {
        this.getCreation().setUser(MDUserFactory.getInstance().getUser(string));
    }

    public String getChangedBy() {
        return this.getChanger().getName();
    }

    public void setChangedBy(String string) {
        this.getChange().setUser(MDUserFactory.getInstance().getUser(string));
    }

    public String getCreatedTime() {
        return this.getCreation().getTimeString("UTC");
    }

    public void setCreatedTime(String string) {
        if (string != null && !"".equals(string)) {
            this.getCreation().setTimeString(string);
        }
    }

    public String getChangedTime() {
        return this.getChange().getTimeString("UTC");
    }

    public void setChangedTime(String string) {
    }

    @Override
    public Object translateIdToObject(String string, String string2) {
        Design design = this.getDesign();
        if (design != null) {
            DesignObject designObject = design.getDesignObject(string2);
            if (designObject == null) {
                Map map = design.getCorrespondenceMap();
                if (map != null) {
                    return map.get(string2);
                }
            } else {
                return designObject;
            }
        }
        return null;
    }

    @Override
    public String translateObjectToID(String string, Object object) {
        if (object != null && object instanceof ModelIDObject) {
            return ((ModelIDObject)object).getObjectID();
        }
        return null;
    }

    @Override
    public String getStoragePath() {
        return null;
    }

    @Override
    public String getStorageName() {
        return null;
    }

    public String getSegmentedStorageName() {
        if (this.segmentedStorageName == null) {
            return this.getStorageName();
        }
        return this.segmentedStorageName;
    }

    public void setSegmentedStorageName(String string) {
        this.segmentedStorageName = string;
    }

    public String getDirectorySegmentName() {
        return this.directorySegmentName;
    }

    public void setDirectorySegmentName(String string) {
        this.directorySegmentName = string;
    }

    public void setDirectorySegmentName(String string, boolean bl) {
        this.directorySegmentName = string;
    }

    public String replaceIDsInValue(String string) {
        if (string != null && !"".equals(string)) {
            String string2 = "";
            Map map = this.getDesign().getCorrespondenceMap();
            if (map != null) {
                StringTokenizer stringTokenizer = null;
                if (string.indexOf(44) > 0) {
                    stringTokenizer = new StringTokenizer(string, ",");
                } else if (string.trim().indexOf(32) > 0) {
                    stringTokenizer = new StringTokenizer(string.trim(), " ");
                }
                if (stringTokenizer != null) {
                    boolean bl = true;
                    while (stringTokenizer.hasMoreTokens()) {
                        String string3 = stringTokenizer.nextToken();
                        String string4 = string3.trim();
                        ModelIDObject modelIDObject = (ModelIDObject)map.get(string4);
                        if (modelIDObject != null && modelIDObject.getObjectID() != string4) {
                            string3 = modelIDObject.getObjectID();
                        }
                        if (bl) {
                            string2 = string3;
                            bl = false;
                            continue;
                        }
                        string2 = string2 + "," + string3;
                    }
                    return string2;
                }
                ModelIDObject modelIDObject = (ModelIDObject)map.get(string);
                if (modelIDObject != null) {
                    String string5 = modelIDObject.getObjectID();
                    return string5;
                }
            }
        }
        return string;
    }

    public ElementSet getSet() {
        return null;
    }
}

