/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.xmla;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.Messages;
import oracle.dbtools.crest.imports.xmla.XMLAConstants;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.SubsetCO;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.CalculatedAttribute;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.SlowChangingAttribute;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.LogReport;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.dbtools.crest.swingui.multidimensional.AbstractMDTV;
import oracle.dbtools.crest.swingui.multidimensional.DPVMultidimensional;
import oracle.dbtools.crest.swingui.multidimensional.TVLink;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;
import oracle.ide.util.IdeUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLAHandler
implements XMLAConstants {
    private static final Logger LOGGER = new Logger(XMLAHandler.class);
    private ApplicationView appView;
    private ProgressDialog monitor;
    private File currentFile;
    private boolean inExistingDesign;
    private String oldDesignPath;
    private String designName;
    private Design design;
    private Map handledObjects = new TreeMap();
    private Map dimensionAttributes = new TreeMap();

    public XMLAHandler(ApplicationView applicationView, boolean bl) {
        this.appView = applicationView;
        this.inExistingDesign = bl;
        this.design = applicationView.getCurrentDesign();
    }

    private void setDesignName(String string) {
        this.designName = !this.inExistingDesign ? string : this.appView.getDesignName();
        this.appView.getCurrentDesign().setDesignPath(ApplicationView.TEMP_DIR);
        if (this.appView.designExists(string)) {
            this.appView.deleteDesign(string);
        }
        if (this.appView != null && !this.inExistingDesign) {
            this.appView.setDesignName(string);
        }
        if (!this.inExistingDesign) {
            this.design.setFileName(this.designName);
        }
    }

    public void parse(File file) {
        if (file.isFile()) {
            try {
                this.oldDesignPath = this.appView.getCurrentDesign().getDesignPath();
                this.currentFile = file;
                new Thread(new Runner()).start();
            }
            catch (Exception exception) {
                LOGGER.error("XMLAHandler - Unable to parse file: " + file.getAbsolutePath(), exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseFile(File file, ImportLogger importLogger) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            InputSource inputSource = new InputSource(new InputStreamReader((InputStream)fileInputStream, IdeUtil.getIdeEncoding()));
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = null;
            try {
                Document document;
                NodeList nodeList;
                try {
                    documentBuilder = documentBuilderFactory.newDocumentBuilder();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    LOGGER.error(parserConfigurationException);
                }
                if (documentBuilder != null && (nodeList = (document = documentBuilder.parse(inputSource)).getElementsByTagName("Database")).getLength() > 0) {
                    Element element = (Element)nodeList.item(0);
                    String string = this.getElementValue(element, "Name");
                    String string2 = this.getElementValue(element, "Description");
                    if (string != null) {
                        this.setDesignName(string);
                        MultidimensionalDesign multidimensionalDesign = this.design.addMultidimensionalDesign(string);
                        multidimensionalDesign.setComment(string2);
                        this.design.setMultidimensionalDesign(multidimensionalDesign);
                        this.monitor.setNote(Messages.getString("XMLAHandler.ParseTables"));
                        this.monitor.setProgress(20);
                        this.parseTables(element, importLogger);
                        this.monitor.setNote(Messages.getString("XMLAHandler.ParseDimensions"));
                        this.monitor.setProgress(40);
                        this.parseDimensions(element, importLogger);
                        this.monitor.setNote(Messages.getString("XMLAHandler.ParseCubes"));
                        this.monitor.setProgress(60);
                        this.parseCubes(element, importLogger);
                    } else {
                        this.appView.getCurrentDesign().setDesignPath(this.oldDesignPath);
                        this.design = null;
                        System.gc();
                    }
                }
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
        }
        catch (Exception exception) {
            LOGGER.error("XMLAHandler - Unable to parse file: " + file.getAbsolutePath(), exception);
            importLogger.addError("Error parsing File...");
        }
    }

    private void addToHandledObjects(Object object, Object object2) {
        if (!this.handledObjects.containsKey(object)) {
            this.handledObjects.put(object, object2);
        } else {
            System.out.println(object + " - " + object2);
        }
    }

    private String getElementValue(Element element, String string) {
        return this.getElementValue(element, string, false);
    }

    private String getElementValue(Element element, String string, boolean bl) {
        try {
            NodeList nodeList = element.getElementsByTagName(string);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2 = (Element)nodeList.item(i);
                if (!bl) {
                    String string2 = element2.getFirstChild().getNodeValue();
                    return string2;
                }
                if (element2.getParentNode() != element) continue;
                String string3 = element2.getFirstChild().getNodeValue();
                return string3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void parseTables(Element element, ImportLogger importLogger) {
        NodeList nodeList = element.getElementsByTagName("DataSourceViews");
        if (nodeList.getLength() > 0) {
            Element element2 = (Element)nodeList.item(0);
            NodeList nodeList2 = element2.getElementsByTagName("DataSourceView");
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                Object object7;
                Iterator iterator;
                Object object8;
                Object object9;
                Object object10;
                String string;
                String string2;
                Element element3 = (Element)nodeList2.item(i);
                NodeList nodeList3 = element3.getElementsByTagName("Schema");
                if (nodeList3.getLength() <= 0) continue;
                Element element4 = (Element)nodeList3.item(0);
                List list = this.getTableElements(element4);
                for (Element element5 : list) {
                    string2 = element5.getAttribute("name");
                    string = element5.getAttribute("msprop:DbTableName");
                    if (this.design.getLogicalDesign().getEntitySet().getByName(string) != null) continue;
                    object10 = this.design.getLogicalDesign().createEntity();
                    ((DesignObject)object10).setName(string);
                    this.addToHandledObjects(string2, object10);
                    object9 = this.getColumnsElements(element5);
                    object8 = object9.iterator();
                    while (object8.hasNext()) {
                        iterator = (Element)object8.next();
                        object7 = iterator.getAttribute("name");
                        object6 = null;
                        if (iterator.hasAttribute("msprop:IsLogical")) {
                            object6 = iterator.getAttribute("msprop:IsLogical");
                        }
                        object5 = iterator.hasAttribute("msprop:DbColumnName") ? iterator.getAttribute("name") : object7;
                        object4 = iterator.getAttribute("type");
                        object3 = this.getColumnMaxLength((Element)((Object)iterator));
                        object2 = "";
                        if (iterator.hasAttribute("msprop:ComputedColumnExpression")) {
                            object2 = iterator.getAttribute("msprop:ComputedColumnExpression");
                        }
                        if (object6 != null && "True".equalsIgnoreCase((String)object6)) {
                            object = new DummyObject((String)object5);
                            ((DummyObject)object).setProperty("msprop:IsLogical", Boolean.TRUE);
                            ((DummyObject)object).setProperty("msprop:ComputedColumnExpression", object2);
                            this.addToHandledObjects(string2 + ":" + (String)object7, object);
                            continue;
                        }
                        object = ((Entity)object10).createAttribute();
                        ((Attribute)object).setName((String)object5);
                        this.addToHandledObjects(string2 + ":" + (String)object7, object);
                        this.setAttributeDataType((Attribute)object, (String)object4, (String)object3);
                    }
                }
                list = this.getUniqueElements(element4);
                for (Element element5 : list) {
                    string2 = element5.getAttribute("name");
                    string = element5.getAttribute("msdata:ConstraintName");
                    object10 = element5.getAttribute("msdata:PrimaryKey");
                    object9 = this.getTableForKey(element5);
                    if (object9 == null || (object8 = (Entity)this.handledObjects.get(object9)) == null) continue;
                    iterator = ((Entity)object8).createCandidateKey();
                    if (!"".equalsIgnoreCase(string)) {
                        ((DesignObject)((Object)iterator)).setName(string);
                    } else {
                        ((DesignObject)((Object)iterator)).setName(string2);
                    }
                    this.addToHandledObjects(string2, iterator);
                    object7 = this.getColumnsForKey(element5);
                    object5 = object7.iterator();
                    while (object5.hasNext()) {
                        object6 = (String)object5.next();
                        object4 = (Attribute)((ContainerObject)object8).getElementByName((String)object6);
                        if (object4 == null) continue;
                        ((CandidateKey)((Object)iterator)).add((ContainedObject)object4);
                    }
                    if (!"true".equalsIgnoreCase((String)object10)) continue;
                    ((KeyObject)((Object)iterator)).makePK();
                }
                list = this.getKeyRefElements(element4);
                for (Element element5 : list) {
                    string2 = element5.getAttribute("name");
                    string = element5.getAttribute("refer");
                    object10 = this.getTableForKey(element5);
                    if (object10 == null) continue;
                    object9 = (Entity)this.handledObjects.get(object10);
                    object8 = (CandidateKey)this.handledObjects.get(string);
                    iterator = null;
                    if (object8 != null) {
                        iterator = (Entity)((SubsetCO)object8).getContainerObject();
                    } else {
                        System.out.println(string);
                    }
                    if (iterator == null || object9 == null) continue;
                    object7 = this.design.getLogicalDesign().createRelation();
                    ((Relation)object7).setName(string2);
                    this.addToHandledObjects((String)object10 + ":" + string2, object7);
                    object5 = this.getColumnsForKey(element5);
                    if (((CandidateKey)object8).getElements().length >= object5.size()) {
                        for (int j = 0; j < object5.size(); ++j) {
                            object4 = (String)object5.get(j);
                            object3 = (Attribute)((ContainerObject)object9).getElementByName((String)object4);
                            if (object3 == null) continue;
                            object2 = (Attribute)((CandidateKey)object8).getElement(j);
                            ((ContainedObject)object3).setReferedAttribute(((ModelIDObject)object2).getObjectID());
                            ((ModelIDObject)object3).setGeneratorID(((ModelIDObject)object7).getObjectID());
                        }
                    }
                    ((Relation)object7).setSourceEntity((Entity)((Object)iterator));
                    ((Relation)object7).setTargetEntity((Entity)object9);
                    ((Relation)object7).setFireCardinalityChange(false);
                    ((Relation)object7).setSourceCardinality(Relation.CARDINALITY_CHOICES[1]);
                    ((Relation)object7).setFireCardinalityChange(true);
                    ((Relation)object7).setTargetCardinality(Relation.CARDINALITY_CHOICES[0]);
                    object6 = (TVRelation)((Relation)object7).getTopView();
                    if (object6 == null) continue;
                    ((TVRelation)object6).addConnection();
                    ((TVRelation)object6).resetEdgeParams();
                }
                list = this.getViewElements(element4);
                for (Element element5 : list) {
                    string2 = element5.getAttribute("name");
                    string = element5.getAttribute("msprop:DbTableName");
                    object10 = element5.getAttribute("msprop:QueryDefinition");
                    if (string == null || "".equalsIgnoreCase(string)) {
                        string = string2;
                    }
                    object9 = this.design.getLogicalDesign().createEntityView();
                    ((DesignObject)object9).setName(string);
                    this.addToHandledObjects(string2, object9);
                    if (object10 != null && !"".equalsIgnoreCase((String)object10)) {
                        ((EntityView)object9).setViewType("NAMED QUERY");
                    }
                    object8 = this.getColumnsElements(element5);
                    iterator = object8.iterator();
                    while (iterator.hasNext()) {
                        String string3;
                        String string4;
                        object7 = (Element)iterator.next();
                        object5 = object7.getAttribute("name");
                        object4 = null;
                        if (object7.hasAttribute("msprop:IsLogical")) {
                            object4 = object7.getAttribute("msprop:IsLogical");
                        }
                        object6 = object7.hasAttribute("msprop:DbColumnName") ? object7.getAttribute("name") : object5;
                        object3 = object7.getAttribute("type");
                        object2 = "";
                        if (object7.hasAttribute("msprop:ComputedColumnExpression")) {
                            object2 = object7.getAttribute("msprop:ComputedColumnExpression");
                        }
                        if (object4 != null && "True".equalsIgnoreCase((String)object4)) {
                            object = (AttributeView)((EntityView)object9).createContainedObject(null);
                            ((AttributeView)object).setEntityAlias(((DesignObject)object9).getName());
                            ((DesignObject)object).setName((String)object5);
                            ((ContainedObject)object).setSourceType("Derived");
                            ((ContainedObject)object).setFormulaDesc((String)object2);
                            this.addToHandledObjects(string2 + ":" + (String)object5, object);
                            continue;
                        }
                        object = (AttributeView)((EntityView)object9).createContainedObject(null);
                        ((AttributeView)object).setEntityAlias(((DesignObject)object9).getName());
                        ((DesignObject)object).setName((String)object6);
                        this.addToHandledObjects(string2 + ":" + (String)object5, object);
                        if (!"".equalsIgnoreCase((String)object2)) {
                            this.setAttributeExpression((ContainedObject)object, (String)object2);
                            continue;
                        }
                        if ("".equalsIgnoreCase((String)object3)) {
                            object3 = "STRING";
                        }
                        if (((String)object3).startsWith("xs:")) {
                            object3 = ((String)object3).substring(3);
                        }
                        if ((string4 = MappingDatatypeNameLogicalDataType.getNameLogicalDatatype(StorageDesignSqlServerv2k5.RDBMS_TYPE, string3 = StandardDatatypeNames.getUsedDatatypeName((String)object3))) != null) {
                            ((AbstractViewElement)object).setDataType(string4);
                            continue;
                        }
                        ((AbstractViewElement)object).setDataType(string3);
                    }
                }
            }
        }
    }

    private String getTableForKey(Element element) {
        Element element2;
        String string;
        NodeList nodeList = element.getElementsByTagName("selector");
        if (nodeList.getLength() > 0 && !"".equalsIgnoreCase(string = (element2 = (Element)nodeList.item(0)).getAttribute("xpath"))) {
            if (string.startsWith(".//")) {
                string = string.substring(3);
            }
            return string;
        }
        return null;
    }

    private List getColumnsForKey(Element element) {
        ArrayList<String> arrayList = new ArrayList<String>();
        NodeList nodeList = element.getElementsByTagName("field");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = element2.getAttribute("xpath");
            if ("".equalsIgnoreCase(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private List getTableElements(Element element) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NodeList nodeList = element.getElementsByTagName("element");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            if (element2 == null || !element2.hasAttribute("msprop:TableType") || !"Table".equalsIgnoreCase(element2.getAttribute("msprop:TableType"))) continue;
            arrayList.add(element2);
        }
        return arrayList;
    }

    private List getViewElements(Element element) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NodeList nodeList = element.getElementsByTagName("element");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            if (element2 == null) continue;
            if (element2.hasAttribute("msprop:TableType") && "View".equalsIgnoreCase(element2.getAttribute("msprop:TableType"))) {
                arrayList.add(element2);
                continue;
            }
            if (!element2.hasAttribute("msprop:QueryDefinition")) continue;
            arrayList.add(element2);
        }
        return arrayList;
    }

    private List getUniqueElements(Element element) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NodeList nodeList = element.getElementsByTagName("unique");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            arrayList.add(element2);
        }
        return arrayList;
    }

    private List getKeyRefElements(Element element) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NodeList nodeList = element.getElementsByTagName("keyref");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            arrayList.add(element2);
        }
        return arrayList;
    }

    private List getColumnsElements(Element element) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NodeList nodeList = element.getElementsByTagName("element");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            if (element2 == null) continue;
            arrayList.add(element2);
        }
        return arrayList;
    }

    private String getColumnMaxLength(Element element) {
        NodeList nodeList = element.getElementsByTagName("maxLength");
        if (nodeList.getLength() > 0) {
            Element element2 = (Element)nodeList.item(0);
            return element2.getAttribute("value");
        }
        return "";
    }

    private void setAttributeDataType(Attribute attribute, String string, String string2) {
        String string3;
        LogicalDatatype logicalDatatype;
        if ("".equalsIgnoreCase(string)) {
            string = "STRING";
        }
        if (string.startsWith("xs:")) {
            string = string.substring(3).trim();
        }
        if ((logicalDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(StorageDesignSqlServerv2k5.RDBMS_TYPE, string3 = StandardDatatypeNames.getUsedDatatypeName(string))) != null) {
            attribute.setUse((short)1);
            attribute.setLogicalDatatype(logicalDatatype);
            if (!"".equalsIgnoreCase(string2)) {
                attribute.setDataTypeParameter("size", string2);
            }
        } else {
            LOGGER.warn("XMLAHandler.setAttributeDataType() - Unable to find Logical DataType for: " + string3);
        }
    }

    private void setAttributeExpression(ContainedObject containedObject, String string) {
        if (!"".equalsIgnoreCase(string)) {
            containedObject.setSourceType("Derived");
            containedObject.setFormulaDesc(string);
        }
    }

    private void parseDimensions(Element element, ImportLogger importLogger) {
        NodeList nodeList = element.getElementsByTagName("Dimensions");
        if (nodeList.getLength() > 0) {
            Element element2 = (Element)nodeList.item(0);
            NodeList nodeList2 = element2.getElementsByTagName("Dimension");
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Object object;
                List list;
                String string;
                Object[] objectArray;
                Object object2;
                Object object3;
                Element element3 = (Element)nodeList2.item(i);
                String string2 = this.getElementValue(element3, "ID");
                String string3 = this.getElementValue(element3, "Name");
                oracle.dbtools.crest.model.design.multidimensional.Dimension dimension = this.design.getMultidimensionalDesign().createDimension();
                dimension.setName(string3);
                this.addToHandledObjects(string2, dimension);
                String string4 = this.getElementValue(element3, "Type", true);
                if (string4 != null && "Time".equalsIgnoreCase(string4)) {
                    dimension.setTimeDimension(true);
                }
                List list2 = this.getDimensionAttributes(element3);
                Iterator iterator = list2.iterator();
                TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
                while (iterator.hasNext()) {
                    object3 = (Element)iterator.next();
                    object2 = this.getElementValue((Element)object3, "ID");
                    treeMap.put((String)object2, object3);
                    this.dimensionAttributes.put(string2 + ":" + (String)object2, object3);
                }
                object3 = this.getAttributeIDByUsage(element3, "Key");
                object2 = null;
                if (object3 != null) {
                    object2 = this.getKeyLevel((String)object3, this.getDimensionHierachies(element3), string2, importLogger, treeMap);
                }
                TreeMap<String, Object[]> treeMap2 = new TreeMap<String, Object[]>();
                list2 = this.getDimensionHierachies(element3);
                Iterator iterator2 = list2.iterator();
                while (iterator2.hasNext()) {
                    objectArray = new ArrayList();
                    Element element4 = (Element)iterator2.next();
                    string = this.getElementValue(element4, "Name");
                    list = this.getHierachyLevels(element4);
                    TopView topView = null;
                    for (int j = list.size() - 1; j >= 0; --j) {
                        AbstractMDTV abstractMDTV;
                        boolean bl = false;
                        Element element5 = (Element)list.get(j);
                        String string5 = this.getElementValue(element5, "Name");
                        String string6 = this.getElementValue(element5, "SourceAttributeID");
                        Level level = (Level)this.handledObjects.get(this.generateUniqueID(string6, treeMap));
                        if (level == null) {
                            level = this.design.getMultidimensionalDesign().createLevel();
                            level.setName(string5);
                            this.addToHandledObjects(this.generateUniqueID(string6, treeMap), level);
                        } else {
                            bl = true;
                            if (!level.getName().equalsIgnoreCase(string5)) {
                                level.setComment(level.getComment() + "\n" + string5);
                            }
                        }
                        boolean bl2 = false;
                        if (topView == null) {
                            if (object2 != null && !string6.equalsIgnoreCase((String)object3)) {
                                object = (AbstractMDTV)((AbstractMDObject)object2).getTopView();
                                bl2 = ((AbstractMDObject)object2).getFirstLinkToTarget(level) != null;
                            } else {
                                object = (AbstractMDTV)dimension.getTopView();
                                boolean bl3 = bl2 = dimension.getFirstLinkToTarget(level) != null;
                                if (object2 == null) {
                                    object2 = level;
                                    ((Level)object2).getLevelKey().clear();
                                    this.initLevelAttributes((Level)object2, (String)object3, treeMap, importLogger);
                                }
                            }
                            abstractMDTV = (AbstractMDTV)level.getTopView();
                        } else {
                            object = topView;
                            abstractMDTV = (AbstractMDTV)level.getTopView();
                            boolean bl4 = bl2 = ((AbstractMDObject)topView.getModel()).getFirstLinkToTarget(level) != null;
                        }
                        if (!bl2 && object != null && abstractMDTV != null && object != abstractMDTV) {
                            Link link = this.design.getMultidimensionalDesign().createLink();
                            link.setSourceTV((AbstractMDTV)object);
                            link.setTargetTV(abstractMDTV);
                            ((TVLink)link.getTopView()).addConnection();
                        }
                        topView = abstractMDTV;
                        if (!objectArray.contains(object2)) {
                            objectArray.add(object2);
                        }
                        if (!objectArray.contains(level)) {
                            objectArray.add(level);
                        }
                        if (bl) continue;
                        this.initLevelAttributes(level, string6, treeMap, importLogger);
                    }
                    treeMap2.put(string, objectArray);
                }
                objectArray = treeMap2.keySet().toArray();
                for (int j = 0; j < objectArray.length; ++j) {
                    string = (String)objectArray[j];
                    list = (List)treeMap2.get(string);
                    if (list == null || (object = this.design.getMultidimensionalDesign().getHierarchyDefinedByLevels(list)) == null) continue;
                    ((DesignObject)object).setName(string);
                }
                this.initParentChildHierarchy(element3, treeMap, importLogger, dimension);
            }
            this.initFKLinks();
        }
    }

    private void initFKLinks() {
        Iterator iterator = this.design.getMultidimensionalDesign().getLinkSet().iterator();
        while (iterator.hasNext()) {
            Link link = (Link)iterator.next();
            AbstractMDObject abstractMDObject = link.getSourceMDObject();
            AbstractMDObject abstractMDObject2 = link.getTargetMDObject();
            if (!(abstractMDObject instanceof Level) || !(abstractMDObject2 instanceof Level)) continue;
            Level level = (Level)abstractMDObject;
            Level level2 = (Level)abstractMDObject2;
            ContainerObject containerObject = level.getLevelEntity();
            ContainerObject containerObject2 = level2.getLevelEntity();
            if (containerObject == null || containerObject2 == null || containerObject == containerObject2) continue;
            ContainedObject[] containedObjectArray = containerObject.getElements();
            for (int i = 0; i < containedObjectArray.length; ++i) {
                Attribute attribute;
                ContainedObject containedObject = containedObjectArray[i];
                if (!containedObject.isFKElement() || (attribute = (Attribute)containedObject).getDelegate() == null || attribute.getDelegate().getContainer() != containerObject2) continue;
                SlowChangingAttribute slowChangingAttribute = level.getSlowChangingAttribute(attribute, attribute.getName());
                if (slowChangingAttribute != null) {
                    level.getSlowChangingAttributes().remove(slowChangingAttribute);
                }
                if (link.getRollupLink() == null) continue;
                link.getRollupLink().addChildToParentAttribute(attribute);
            }
        }
    }

    private void initParentChildHierarchy(Element element, Map map, ImportLogger importLogger, oracle.dbtools.crest.model.design.multidimensional.Dimension dimension) {
        Element element2;
        String string = this.getAttributeIDByUsage(element, "Parent");
        if (string != null && (element2 = (Element)map.get(string)) != null) {
            Object object;
            String string2 = this.getElementValue(element2, "Name");
            String string3 = this.getElementValue(element2, "RootMemberIf");
            Level level = this.design.getMultidimensionalDesign().createLevel();
            level.setName(string2);
            level.setValueBasedHierarchy(true);
            this.initLevelAttributes(level, string, map, importLogger, true);
            String string4 = this.getAttributeIDByUsage(element, "Key");
            if (string4 != null) {
                this.initLevelAttributes(level, string4, map, importLogger);
            }
            if (string3 != null) {
                level.setRootIdentification(string3);
            }
            AbstractMDTV abstractMDTV = (AbstractMDTV)dimension.getTopView();
            AbstractMDTV abstractMDTV2 = (AbstractMDTV)level.getTopView();
            if (abstractMDTV != null && abstractMDTV2 != null) {
                object = this.design.getMultidimensionalDesign().createLink();
                ((Link)object).setSourceTV(abstractMDTV);
                ((Link)object).setTargetTV(abstractMDTV2);
                ((TVLink)((Link)object).getTopView()).addConnection();
            }
            object = new ArrayList<Level>();
            object.add(level);
            Hierarchy hierarchy = this.design.getMultidimensionalDesign().getHierarchyDefinedByLevels((List)object);
            if (hierarchy != null) {
                hierarchy.setName(string2);
            }
        }
    }

    private String generateUniqueID(String string, Map map) {
        Element element = (Element)map.get(string);
        if (element != null) {
            String string2 = "";
            List list = this.getKeyColumns(element);
            for (Element element2 : list) {
                String string3 = this.getElementValue(element2, "TableID");
                String string4 = this.getElementValue(element2, "ColumnID");
                string2 = string2 + string3 + "." + string4 + ";";
            }
            return string2;
        }
        return "";
    }

    private void initLevelAttributes(Level level, String string, Map map, ImportLogger importLogger) {
        this.initLevelAttributes(level, string, map, importLogger, false);
    }

    private void initLevelAttributes(Level level, String string, Map map, ImportLogger importLogger, boolean bl) {
        Element element = (Element)map.get(string);
        if (element != null) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            Element element22;
            List list = this.getKeyColumns(element);
            for (Element element22 : list) {
                object7 = this.getElementValue(element22, "TableID");
                object6 = this.getElementValue(element22, "ColumnID");
                object5 = (ContainerObject)this.handledObjects.get(object7);
                if (object5 == null) {
                    importLogger.addWarning("Entity: " + (String)object7 + " Not Found", true);
                    continue;
                }
                if (level.getLevelEntity() == null) {
                    level.setLevelEntity((ContainerObject)object5);
                }
                if ((object4 = ((ContainerObject)object5).getElementByName((String)object6)) != null) {
                    if (bl) {
                        level.addToParentKey((ContainedObject)object4);
                        continue;
                    }
                    level.addToLevelKey((ContainedObject)object4);
                    continue;
                }
                importLogger.addWarning("Entity Attribute: " + (String)object6 + " Not Found", true);
            }
            element22 = this.getNameColumn(element);
            if (element22 != null) {
                object7 = this.getElementValue(element22, "TableID");
                object6 = this.getElementValue(element22, "ColumnID");
                object5 = (ContainerObject)this.handledObjects.get(object7);
                object4 = this.handledObjects.get((String)object7 + ":" + (String)object6);
                if (object4 != null && object4 instanceof DummyObject && ((DummyObject)object4).hasProperty("msprop:IsLogical")) {
                    object3 = (String)((DummyObject)object4).getProperty("msprop:ComputedColumnExpression");
                    if (object3 != null && !level.hasCalculatedAttribute((String)object6, ((String)object3).trim())) {
                        object2 = level.createCalculatedAttribute();
                        ((DesignObject)object2).setName((String)object6);
                        ((CalculatedAttribute)object2).setFunction(((String)object3).trim());
                        level.addCalculatedAttribute((CalculatedAttribute)object2);
                    }
                } else if (object5 == null) {
                    importLogger.addWarning("Entity: " + (String)object7 + " Not Found", true);
                } else {
                    if (level.getLevelEntity() == null) {
                        level.setLevelEntity((ContainerObject)object5);
                    } else if (level.getLevelEntity() != object5) {
                        importLogger.addWarning("NameColumn Entity: " + (String)object7 + " is differ from Level Entity: " + level.getLevelEntity().getName(), true);
                        return;
                    }
                    object3 = ((ContainerObject)object5).getElementByName((String)object6);
                    if (object3 != null) {
                        if (level.getSlowChangingAttribute((ContainedObject)object3, ((ContainedObject)object3).getName()) == null) {
                            object2 = new SlowChangingAttribute(level, (ContainedObject)object3);
                            level.addDescriptiveAttribute((SlowChangingAttribute)object2);
                        }
                        level.setNameColumn((ContainedObject)object3);
                    } else {
                        importLogger.addWarning("Entity Attribute: " + (String)object6 + " Not Found", true);
                    }
                }
            }
            if ((object7 = this.getValueColumn(element)) != null) {
                object6 = this.getElementValue((Element)object7, "TableID");
                object5 = this.getElementValue((Element)object7, "ColumnID");
                object4 = (ContainerObject)this.handledObjects.get(object6);
                object3 = this.handledObjects.get((String)object6 + ":" + (String)object5);
                if (object3 != null && object3 instanceof DummyObject && ((DummyObject)object3).hasProperty("msprop:IsLogical")) {
                    object2 = (String)((DummyObject)object3).getProperty("msprop:ComputedColumnExpression");
                    if (object2 != null && !level.hasCalculatedAttribute((String)object5, ((String)object2).trim())) {
                        object = level.createCalculatedAttribute();
                        ((DesignObject)object).setName((String)object5);
                        ((CalculatedAttribute)object).setFunction(((String)object2).trim());
                        level.addCalculatedAttribute((CalculatedAttribute)object);
                    }
                } else if (object4 == null) {
                    importLogger.addWarning("Entity: " + (String)object6 + " Not Found", true);
                } else {
                    if (level.getLevelEntity() == null) {
                        level.setLevelEntity((ContainerObject)object4);
                    } else if (level.getLevelEntity() != object4) {
                        importLogger.addWarning("ValueColumn Entity: " + (String)object6 + " is differ from Level Entity: " + level.getLevelEntity().getName(), true);
                        return;
                    }
                    object2 = ((ContainerObject)object4).getElementByName((String)object5);
                    if (object2 != null) {
                        if (level.getSlowChangingAttribute((ContainedObject)object2, ((ContainedObject)object2).getName()) == null) {
                            object = new SlowChangingAttribute(level, (ContainedObject)object2);
                            level.addDescriptiveAttribute((SlowChangingAttribute)object);
                        }
                        level.setValueColumn((ContainedObject)object2);
                    } else {
                        importLogger.addWarning("Entity Attribute: " + (String)object5 + " Not Found", true);
                    }
                }
            }
            object6 = this.getAttributeRelationships(element);
            object5 = object6.iterator();
            while (object5.hasNext()) {
                Object object8;
                Object object9;
                ContainedObject containedObject;
                ContainerObject containerObject;
                String string2;
                String string3;
                Element element3;
                object4 = (Element)object5.next();
                object3 = this.getElementValue((Element)object4, "AttributeID");
                object2 = (Element)map.get(object3);
                if (object2 == null) continue;
                object = this.getKeyColumns((Element)object2);
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    element3 = (Element)iterator.next();
                    string3 = this.getElementValue(element3, "TableID");
                    string2 = this.getElementValue(element3, "ColumnID");
                    containerObject = (ContainerObject)this.handledObjects.get(string3);
                    if (containerObject == null) {
                        importLogger.addWarning("Entity: " + string3 + " Not Found", true);
                        continue;
                    }
                    if (level.getLevelEntity() == null) {
                        level.setLevelEntity(containerObject);
                    }
                    if ((containedObject = level.getLevelEntity().getElementByName(string2)) != null) {
                        if (level.getSlowChangingAttribute(containedObject, containedObject.getName()) != null) continue;
                        object9 = new SlowChangingAttribute(level, containedObject);
                        level.addDescriptiveAttribute((SlowChangingAttribute)object9);
                        continue;
                    }
                    if (this.handledObjects.get(string3 + ":" + string2) == null || !(this.handledObjects.get(string3 + ":" + string2) instanceof DummyObject) || (object9 = (DummyObject)this.handledObjects.get(string3 + ":" + string2)) == null || !((DummyObject)object9).hasProperty("msprop:IsLogical") || (object8 = (String)((DummyObject)object9).getProperty("msprop:ComputedColumnExpression")) == null || level.hasCalculatedAttribute(string2, (String)object8)) continue;
                    CalculatedAttribute calculatedAttribute = level.createCalculatedAttribute();
                    calculatedAttribute.setName(string2);
                    calculatedAttribute.setFunction(((String)object8).trim());
                    level.addCalculatedAttribute(calculatedAttribute);
                }
                element3 = this.getNameColumn((Element)object2);
                if (element3 == null) continue;
                string3 = this.getElementValue(element3, "TableID");
                string2 = this.getElementValue(element3, "ColumnID");
                containerObject = (ContainerObject)this.handledObjects.get(string3);
                containedObject = this.handledObjects.get(string3 + ":" + string2);
                if (containedObject != null && containedObject instanceof DummyObject && ((DummyObject)((Object)containedObject)).hasProperty("msprop:IsLogical")) {
                    object9 = (String)((DummyObject)((Object)containedObject)).getProperty("msprop:ComputedColumnExpression");
                    if (object9 == null || level.hasCalculatedAttribute(string2, ((String)object9).trim())) continue;
                    object8 = level.createCalculatedAttribute();
                    ((DesignObject)object8).setName(string2);
                    ((CalculatedAttribute)object8).setFunction(((String)object9).trim());
                    level.addCalculatedAttribute((CalculatedAttribute)object8);
                    continue;
                }
                if (containerObject == null) {
                    importLogger.addWarning("Entity: " + string3 + " Not Found", true);
                    continue;
                }
                if (level.getLevelEntity() == null) {
                    level.setLevelEntity(containerObject);
                } else if (level.getLevelEntity() != containerObject) break;
                if ((object9 = level.getLevelEntity().getElementByName(string2)) == null || level.getSlowChangingAttribute((ContainedObject)object9, ((ContainedObject)object9).getName()) != null) continue;
                object8 = new SlowChangingAttribute(level, (ContainedObject)object9);
                level.addDescriptiveAttribute((SlowChangingAttribute)object8);
            }
        } else {
            importLogger.addWarning("Attribute: " + element + " Not Found", true);
        }
    }

    private Element getNameColumn(Element element) {
        NodeList nodeList = element.getElementsByTagName("NameColumn");
        if (nodeList.getLength() > 0) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    private Element getValueColumn(Element element) {
        NodeList nodeList = element.getElementsByTagName("ValueColumn");
        if (nodeList.getLength() > 0) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    private List getKeyColumns(Element element) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NodeList nodeList = element.getElementsByTagName("KeyColumns");
        if (nodeList.getLength() > 0) {
            Element element2 = (Element)nodeList.item(0);
            NodeList nodeList2 = element2.getElementsByTagName("KeyColumn");
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Element element3 = (Element)nodeList2.item(i);
                arrayList.add(element3);
            }
        }
        return arrayList;
    }

    private List getAttributeRelationships(Element element) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NodeList nodeList = element.getElementsByTagName("AttributeRelationships");
        if (nodeList.getLength() > 0) {
            Element element2 = (Element)nodeList.item(0);
            NodeList nodeList2 = element2.getElementsByTagName("AttributeRelationship");
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Element element3 = (Element)nodeList2.item(i);
                arrayList.add(element3);
            }
        }
        return arrayList;
    }

    private List getDimensionAttributes(Element element) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NodeList nodeList = element.getElementsByTagName("Attributes");
        if (nodeList.getLength() > 0) {
            Element element2 = (Element)nodeList.item(0);
            NodeList nodeList2 = element2.getElementsByTagName("Attribute");
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Element element3 = (Element)nodeList2.item(i);
                arrayList.add(element3);
            }
        }
        return arrayList;
    }

    private String getAttributeIDByUsage(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName("Attributes");
        if (nodeList.getLength() > 0) {
            Element element2 = (Element)nodeList.item(0);
            NodeList nodeList2 = element2.getElementsByTagName("Attribute");
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Element element3 = (Element)nodeList2.item(i);
                String string2 = this.getElementValue(element3, "Usage");
                if (string2 == null || !string.equalsIgnoreCase(string2)) continue;
                return this.getElementValue(element3, "ID");
            }
        }
        return null;
    }

    private Level getKeyLevel(String string, List list, String string2, ImportLogger importLogger, Map map) {
        for (Element element : list) {
            List list2 = this.getHierachyLevels(element);
            for (int i = 0; i < list2.size(); ++i) {
                Element element2 = (Element)list2.get(i);
                String string3 = this.getElementValue(element2, "Name");
                String string4 = this.getElementValue(element2, "SourceAttributeID");
                if (!string.equalsIgnoreCase(string4)) continue;
                Level level = this.design.getMultidimensionalDesign().createLevel();
                level.setName(string3);
                this.addToHandledObjects(this.generateUniqueID(string, map), level);
                this.initLevelAttributes(level, string4, map, importLogger);
                return level;
            }
        }
        return null;
    }

    private List getDimensionHierachies(Element element) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NodeList nodeList = element.getElementsByTagName("Hierarchies");
        if (nodeList.getLength() > 0) {
            Element element2 = (Element)nodeList.item(0);
            NodeList nodeList2 = element2.getElementsByTagName("Hierarchy");
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Element element3 = (Element)nodeList2.item(i);
                arrayList.add(element3);
            }
        }
        return arrayList;
    }

    private List getHierachyLevels(Element element) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NodeList nodeList = element.getElementsByTagName("Levels");
        if (nodeList.getLength() > 0) {
            Element element2 = (Element)nodeList.item(0);
            NodeList nodeList2 = element2.getElementsByTagName("Level");
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Element element3 = (Element)nodeList2.item(i);
                arrayList.add(element3);
            }
        }
        return arrayList;
    }

    private void parseCubes(Element element, ImportLogger importLogger) {
        NodeList nodeList = element.getElementsByTagName("Cubes");
        if (nodeList.getLength() > 0) {
            Element element2 = (Element)nodeList.item(0);
            NodeList nodeList2 = element2.getElementsByTagName("Cube");
            int n = nodeList2.getLength();
            for (int i = 0; i < n; ++i) {
                Element element3 = (Element)nodeList2.item(i);
                this.parseCube(element3, importLogger);
            }
        }
    }

    private void parseCube(Element element, ImportLogger importLogger) {
        List list = this.getDimensionsElements(element);
        List list2 = this.getMeasureGroupElements(element);
        for (int i = 0; i < list2.size(); ++i) {
            Element element2 = (Element)list2.get(i);
            this.parseMeasureGroup(element2, list, importLogger);
        }
    }

    private boolean isRowBindingCube(Element element) {
        boolean bl = true;
        List list = this.getMeasuresElements(element);
        for (Element element2 : list) {
            bl = bl && this.isRowBindingMeasure(element2);
        }
        return bl && list.size() > 0;
    }

    private boolean isRowBindingMeasure(Element element) {
        NodeList nodeList = element.getElementsByTagName("Source");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            Element element2 = (Element)nodeList.item(i);
            if (!element2.hasAttribute("xsi:type") || !"RowBinding".equalsIgnoreCase(string = element2.getAttribute("xsi:type"))) continue;
            return true;
        }
        return false;
    }

    private boolean isLinkedCube(Element element) {
        NodeList nodeList = element.getElementsByTagName("Source");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            if (element2.getParentNode() != element) continue;
            return true;
        }
        return false;
    }

    private void parseMeasureGroup(Element element, List list, ImportLogger importLogger) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        ID_ObjectPropertyTranslator iD_ObjectPropertyTranslator;
        Object object7;
        Object object8;
        String string;
        Object object9;
        Object object102;
        String string2 = this.getElementValue(element, "ID");
        String string3 = this.getElementValue(element, "Name");
        if (this.isLinkedCube(element) || this.isRowBindingCube(element)) {
            return;
        }
        Cube cube = (Cube)this.handledObjects.get("MeasureGroup:" + string2);
        if (cube == null && (cube = (Cube)this.design.getMultidimensionalDesign().getCubeSet().getByName(string3)) == null) {
            cube = this.design.getMultidimensionalDesign().createCube();
            cube.setName(string3);
            this.addToHandledObjects("MeasureGroup:" + string2, cube);
        }
        List list2 = this.getMeasuresElements(element);
        for (Object object102 : list2) {
            object9 = this.getElementValue((Element)object102, "Name");
            string = this.getElementValue((Element)object102, "AggregateFunction");
            if (cube.getMeasureByName((String)object9) != null) continue;
            object8 = this.design.getMultidimensionalDesign().createMeasure();
            ((DesignObject)object8).setName((String)object9);
            cube.addMeasure((Measure)object8);
            object7 = "SUM";
            if (string != null) {
                object7 = string;
            }
            iD_ObjectPropertyTranslator = ((Measure)object8).createAggregateFunction((String)object7);
            ((Measure)object8).addAggregateFunction((Measure.AggregateFunction)iD_ObjectPropertyTranslator);
            ((Measure)object8).setDefaultAggregationFunction((Measure.AggregateFunction)iD_ObjectPropertyTranslator);
            object6 = this.getElementValue((Element)object102, "TableID");
            object5 = this.getElementValue((Element)object102, "ColumnID");
            if (object6 == null || object5 == null) continue;
            object4 = (ContainerObject)this.handledObjects.get(object6);
            if (object4 == null) {
                importLogger.addWarning("Entity: " + (String)object6 + " Not Found", true);
                continue;
            }
            cube.addFactEntity((ContainerObject)object4);
            object3 = ((ContainerObject)object4).getElementByName((String)object5);
            if (object3 != null) {
                ((Measure)object8).setMeasureFact((ContainedObject)object3);
                continue;
            }
            object2 = (DummyObject)this.handledObjects.get((String)object6 + ":" + (String)object5);
            if (object2 != null) {
                object = (String)((DummyObject)object2).getProperty("msprop:ComputedColumnExpression");
                if (object == null) continue;
                ((Measure)object8).setFormula(true);
                ((Measure)object8).setCustomFormula(true);
                ((Measure)object8).setFormula((String)object);
                ((Measure)object8).setOracleAWFormulaType(Measure.MS_COMPUTED_FORMULA);
                continue;
            }
            importLogger.addWarning("Entity Attribute: " + (String)object5 + " Not Found", true);
        }
        object102 = this.getDimensionsElements(element);
        Iterator iterator = object102.iterator();
        while (iterator.hasNext()) {
            Object object11;
            Object object12;
            Object object13;
            Object object14;
            object9 = (Element)iterator.next();
            string = this.getElementValue((Element)object9, "CubeDimensionID");
            object8 = object9.getAttribute("xsi:type");
            if (((String)object8).equalsIgnoreCase("RegularMeasureGroupDimension")) {
                object7 = this.getDimension(string, list);
                if (object7 == null) continue;
                iD_ObjectPropertyTranslator = (oracle.dbtools.crest.model.design.multidimensional.Dimension)((DummyObject)object7).getProperty("Dimension");
                object6 = (AbstractMDTV)cube.getTopView();
                object5 = (AbstractMDTV)((AbstractMDObject)iD_ObjectPropertyTranslator).getTopView();
                if (object6 == null || object5 == null) continue;
                object4 = cube.getName() + "-" + ((DesignObject)iD_ObjectPropertyTranslator).getName() + "." + ((DummyObject)object7).getName();
                if (this.design.getMultidimensionalDesign().getRollupLinkSet().getByName((String)object4) != null) continue;
                object3 = this.design.getMultidimensionalDesign().createLink();
                ((Link)object3).setSourceTV((AbstractMDTV)object6);
                ((Link)object3).setTargetTV((AbstractMDTV)object5);
                ((TVLink)((Link)object3).getTopView()).addConnection();
                if (((DummyObject)object7).getName() == null || "".equalsIgnoreCase(((DummyObject)object7).getName()) || ((Link)object3).getRollupLink() == null) continue;
                ((Link)object3).getRollupLink().setName(cube.getName() + "-" + ((DesignObject)iD_ObjectPropertyTranslator).getName() + "." + ((DummyObject)object7).getName());
                object2 = this.getGranularityAttribute((Element)object9, importLogger);
                if (object2 == null) continue;
                ((Link)object3).getRollupLink().addChildToParentAttribute((ContainedObject)object2);
                continue;
            }
            if (!((String)object8).equalsIgnoreCase("ReferenceMeasureGroupDimension") || (object7 = this.getDimension(string, list)) == null) continue;
            iD_ObjectPropertyTranslator = (oracle.dbtools.crest.model.design.multidimensional.Dimension)((DummyObject)object7).getProperty("Dimension");
            object6 = null;
            object5 = null;
            object4 = this.getGranularityAttributeID((Element)object9);
            if (object4 != null && (object3 = (Element)this.dimensionAttributes.get(string + ":" + (String)object4)) != null && (object2 = this.getKeyColumns((Element)object3)).size() > 0) {
                object = (Element)object2.get(0);
                object14 = this.getElementValue((Element)object, "TableID");
                object13 = this.getElementValue((Element)object, "ColumnID");
                if (object14 != null && object13 != null) {
                    object12 = (ContainerObject)this.handledObjects.get(object14);
                    if (object12 == null) {
                        importLogger.addWarning("Entity/View: " + (String)object14 + " Not Found", true);
                    } else {
                        object11 = ((ContainerObject)object12).getElementByName((String)object13);
                        if (object11 != null) {
                            object5 = this.getLevelForAttribute((oracle.dbtools.crest.model.design.multidimensional.Dimension)iD_ObjectPropertyTranslator, (ContainedObject)object11);
                        } else {
                            importLogger.addWarning("Entity/View Attribute: " + (String)object13 + " Not Found", true);
                        }
                    }
                }
            }
            if (object5 == null) continue;
            object3 = this.getElementValue((Element)object9, "IntermediateCubeDimensionID");
            object2 = this.getElementValue((Element)object9, "IntermediateGranularityAttributeID");
            if (object3 == null || object2 == null || (object = (oracle.dbtools.crest.model.design.multidimensional.Dimension)this.handledObjects.get(object3)) == null || (object14 = (Element)this.dimensionAttributes.get((String)object3 + ":" + (String)object2)) == null || (object13 = this.getKeyColumns((Element)object14)).size() <= 0) continue;
            object12 = (Element)object13.get(0);
            object11 = this.getElementValue((Element)object12, "TableID");
            String string4 = this.getElementValue((Element)object12, "ColumnID");
            if (object11 == null || string4 == null) continue;
            ContainerObject containerObject = (ContainerObject)this.handledObjects.get(object11);
            if (containerObject == null) {
                importLogger.addWarning("Entity/View: " + (String)object11 + " Not Found", true);
                continue;
            }
            ContainedObject containedObject = containerObject.getElementByName(string4);
            if (containedObject != null) {
                object6 = this.getLevelForAttribute((oracle.dbtools.crest.model.design.multidimensional.Dimension)object, containedObject);
                if (object6 == null || ((AbstractMDObject)object6).getFirstLinkToTarget((AbstractMDObject)object5) != null) continue;
                AbstractMDTV abstractMDTV = (AbstractMDTV)((AbstractMDObject)object6).getTopView();
                AbstractMDTV abstractMDTV2 = (AbstractMDTV)((AbstractMDObject)object5).getTopView();
                Link link = this.design.getMultidimensionalDesign().createLink();
                link.setSourceTV(abstractMDTV);
                link.setTargetTV(abstractMDTV2);
                ((TVLink)link.getTopView()).addConnection();
                if (link.getRollupLink() == null) continue;
                link.getRollupLink().addChildToParentAttribute(containedObject);
                continue;
            }
            importLogger.addWarning("Entity/View Attribute: " + string4 + " Not Found", true);
        }
    }

    private Level getLevelForAttribute(oracle.dbtools.crest.model.design.multidimensional.Dimension dimension, ContainedObject containedObject) {
        for (Level level : dimension.getAllLevels()) {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(level.getLevelKey());
            arrayList.addAll(level.getDescriptiveAttributes());
            if (!arrayList.contains(containedObject)) continue;
            return level;
        }
        return null;
    }

    private String getGranularityAttributeID(Element element) {
        List list = this.getDimensionAttributes(element);
        for (Element element2 : list) {
            String string = this.getElementValue(element2, "Type");
            if (string == null || !"Granularity".equalsIgnoreCase(string)) continue;
            return this.getElementValue(element2, "AttributeID");
        }
        return null;
    }

    private ContainedObject getGranularityAttribute(Element element, ImportLogger importLogger) {
        List list = this.getDimensionAttributes(element);
        for (Element element2 : list) {
            List list2;
            String string = this.getElementValue(element2, "Type");
            if (string == null || !"Granularity".equalsIgnoreCase(string) || (list2 = this.getKeyColumns(element2)).size() <= 0) continue;
            Element element3 = (Element)list2.get(0);
            String string2 = this.getElementValue(element3, "TableID");
            String string3 = this.getElementValue(element3, "ColumnID");
            if (string2 == null || string3 == null) continue;
            ContainerObject containerObject = (ContainerObject)this.handledObjects.get(string2);
            if (containerObject == null) {
                importLogger.addWarning("Entity/View: " + string2 + " Not Found", true);
                continue;
            }
            ContainedObject containedObject = containerObject.getElementByName(string3);
            if (containedObject != null) {
                return containedObject;
            }
            importLogger.addWarning("Entity/View Attribute: " + string3 + " Not Found", true);
        }
        return null;
    }

    private DummyObject getDimension(String string, List list) {
        for (Element element : list) {
            String string2 = this.getElementValue(element, "ID");
            if (!string.equals(string2)) continue;
            String string3 = this.getElementValue(element, "DimensionID");
            oracle.dbtools.crest.model.design.multidimensional.Dimension dimension = (oracle.dbtools.crest.model.design.multidimensional.Dimension)this.handledObjects.get(string3);
            DummyObject dummyObject = new DummyObject(this.getElementValue(element, "Name", true));
            dummyObject.setProperty("Dimension", dimension);
            return dummyObject;
        }
        return null;
    }

    private List getDimensionsElements(Element element) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NodeList nodeList = element.getElementsByTagName("Dimensions");
        if (nodeList.getLength() > 0) {
            Element element2 = (Element)nodeList.item(0);
            NodeList nodeList2 = element2.getElementsByTagName("Dimension");
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Element element3 = (Element)nodeList2.item(i);
                arrayList.add(element3);
            }
        }
        return arrayList;
    }

    private List getMeasuresElements(Element element) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NodeList nodeList = element.getElementsByTagName("Measures");
        if (nodeList.getLength() > 0) {
            Element element2 = (Element)nodeList.item(0);
            NodeList nodeList2 = element2.getElementsByTagName("Measure");
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Element element3 = (Element)nodeList2.item(i);
                arrayList.add(element3);
            }
        }
        return arrayList;
    }

    private List getMeasureGroupElements(Element element) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NodeList nodeList = element.getElementsByTagName("MeasureGroups");
        if (nodeList.getLength() > 0) {
            Element element2 = (Element)nodeList.item(0);
            NodeList nodeList2 = element2.getElementsByTagName("MeasureGroup");
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Element element3 = (Element)nodeList2.item(i);
                arrayList.add(element3);
            }
        }
        return arrayList;
    }

    private class DummyObject {
        Map map = new TreeMap();
        String name = "";

        public DummyObject(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public void setProperty(Object object, Object object2) {
            this.map.put(object, object2);
        }

        public Object getProperty(Object object) {
            return this.map.get(object);
        }

        public boolean hasProperty(Object object) {
            return this.map.containsKey(object);
        }
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                XMLAHandler.this.design.closeAllDiagrams();
                ImportLogger importLogger = new ImportLogger();
                try {
                    XMLAHandler.this.monitor = new ProgressDialog(XMLAHandler.this.appView, "", 0, 100);
                    try {
                        try {
                            XMLAHandler.this.monitor.setNote(Messages.getString("XMLAHandler.ParseFile"));
                            XMLAHandler.this.monitor.setProgress(10);
                            XMLAHandler.this.parseFile(XMLAHandler.this.currentFile, importLogger);
                            try {
                                XMLAHandler.this.monitor.setNote(Messages.getString("XMLAHandler.RearrangeLogicalModel"));
                                XMLAHandler.this.monitor.setProgress(80);
                                XMLAHandler.this.design.getLogicalDesign().rearrangeEntities();
                                XMLAHandler.this.design.getLogicalDesign().rearrangeViews();
                                XMLAHandler.this.monitor.setNote(Messages.getString("XMLAHandler.RearrangeMultidimentionalModel"));
                                XMLAHandler.this.monitor.setProgress(90);
                                ((DPVMultidimensional)XMLAHandler.this.design.getMultidimensionalDesign().getMainView()).rearrangeDiagram(true);
                                XMLAHandler.this.monitor.setNote(Messages.getString("XMLAHandler.GenerateMultidimentionalModelCompactDiagram"));
                                XMLAHandler.this.monitor.setProgress(95);
                                XMLAHandler.this.design.getMultidimensionalDesign().getCompactDiagram().generateDiagram();
                            }
                            catch (Exception exception) {
                                LOGGER.error("Unable to rearrange Layout", exception);
                            }
                            XMLAHandler.this.monitor.setProgress(100);
                            if (XMLAHandler.this.inExistingDesign) {
                                XMLAHandler.this.appView.getCurrentDesign().setDesignPath(XMLAHandler.this.oldDesignPath);
                            } else {
                                XMLAHandler.this.appView.getCurrentDesign().setDesignPath("");
                            }
                            XMLAHandler.this.appView.synchronizeTitle();
                            System.gc();
                        }
                        finally {
                            XMLAHandler.this.appView.setImporting(false);
                        }
                    }
                    finally {
                        XMLAHandler.this.monitor.close();
                    }
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            XMLAHandler.this.design.getLogicalDesign().setMainViewVisible(true);
                            XMLAHandler.this.design.getRelationalDesign().setMainViewVisible(true);
                            XMLAHandler.this.design.getMultidimensionalDesign().setMainViewVisible(true);
                            XMLAHandler.this.appView.centerDesign();
                            XMLAHandler.this.design.getMultidimensionalDesign().getMainView().centerDesign();
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                if (XMLAHandler.this.appView.getSettings().showImportLog()) {
                    LogReport logReport = new LogReport(XMLAHandler.this.appView);
                    logReport.setLog(importLogger.generateReport(XMLAHandler.this.appView));
                    logReport.showDialog(new Dimension(750, 550));
                }
            }
            catch (Exception exception) {
                XMLAHandler.this.design.destroyAll(false);
                XMLAHandler.this.design = null;
                LOGGER.error("Error Parsing File: " + XMLAHandler.this.designName, exception);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("XMLAHandler.UnableToImportTheFile"), Messages.getString("XMLAHandler.ErrorImportingFile"), 0);
            }
        }
    }
}

