/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.xmi;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.imports.Messages;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.StructuredTypeSet;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntitySet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.LogReport;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;

public class XMIHandler {
    private static final Map DATATYPE_MAP = new HashMap();
    private static final String XMI_DATATYPE_P_INTEGER = "P-INTEGER";
    private static final String XMI_DATATYPE_P_SMALLINT = "P-SMALLINT";
    private static final String XMI_DATATYPE_P_BYTE = "P-BYTE";
    private static final String XMI_DATATYPE_P_DOUBLE = "P-DOUBLE";
    private static final String XMI_DATATYPE_P_FLOAT = "P-FLOAT";
    private static final String XMI_DATATYPE_P_NUMERIC = "P-NUMERIC";
    private static final String XMI_DATATYPE_P_REAL = "P-REAL";
    private static final String XMI_DATATYPE_P_DECIMAL = "P-DECIMAL";
    private static final String XMI_DATATYPE_P_TIMESTAMP = "P-TIMESTAMP";
    private static final String XMI_DATATYPE_P_VARCHAR = "P-VARCHAR";
    private static final String XMI_DATATYPE_P_TEXT = "P-TEXT";
    private static final String XMI_DATATYPE_P_CHARACTER = "P-CHARACTER";
    private static final String XMI_DATATYPE_P_CURRENCY = "P-CURRENCY";
    private static final String XMI_DATATYPE_P_DATE = "P-DATE";
    private static final String XMI_DATATYPE_P_TIME = "P-TIME";
    private static final String XMI_DATATYPE_P_DATETIME = "P-DATETIME";
    private static final String XMI_DATATYPE_P_BINARY = "P-BINARY";
    private static final String XMI_DATATYPE_P_STRING = "P-STRING";
    private static final String XMI_DATATYPE_INTEGER = "INTEGER";
    private static final String XMI_DATATYPE_INT = "INT";
    private static final String XMI_DATATYPE_SMALLINT = "SMALLINT";
    private static final String XMI_DATATYPE_BYTE = "BYTE";
    private static final String XMI_DATATYPE_DOUBLE = "DOUBLE";
    private static final String XMI_DATATYPE_FLOAT = "FLOAT";
    private static final String XMI_DATATYPE_NUMERIC = "NUMERIC";
    private static final String XMI_DATATYPE_REAL = "REAL";
    private static final String XMI_DATATYPE_DECIMAL = "DECIMAL";
    private static final String XMI_DATATYPE_TIMESTAMP = "TIMESTAMP";
    private static final String XMI_DATATYPE_VARCHAR = "VARCHAR";
    private static final String XMI_DATATYPE_TEXT = "TEXT";
    private static final String XMI_DATATYPE_CHARACTER = "CHARACTER";
    private static final String XMI_DATATYPE_CURRENCY = "CURRENCY";
    private static final String XMI_DATATYPE_DATE = "DATE";
    private static final String XMI_DATATYPE_TIME = "TIME";
    private static final String XMI_DATATYPE_DATETIME = "DATETIME";
    private static final String XMI_DATATYPE_BINARY = "BINARY";
    private static final String XMI_DATATYPE_STRING = "STRING";
    private static final String XMI_DATATYPE_BOOLEAN = "BOOLEAN";
    private static final String XMI_DATATYPE_CHAR = "CHAR";
    private static final String XMI_DATATYPE_BLOB = "BLOB";
    private static final String XMI_DATATYPE_CLOB = "CLOB";
    private static final String XMI_DATATYPE_ROWID = "ROWID";
    private static final String INTEGER = "INTEGER";
    private static final String DATE_TIME = "datetime";
    private static final String ALPHANUMERIC = "alphanumeric";
    private static final String BIGINT = "BIGINT";
    private static final String DOUBLE = "Double";
    private static final String FLOAT = "Float";
    private static final String DECIMAL = "Decimal";
    private static final String NUMERIC = "Numeric";
    private static final String TEXT = "Text";
    private static final String REAL = "real";
    private static final String TIMESTAMP = "timestamp";
    private static final String DATE = "Date";
    private static final String BINARY = "Binary";
    private static final String LONG_ALPHANUMERIC = "long alphanumeric";
    private static final String BOOLEAN = "boolean";
    private static final String BLOB = "Blob";
    private static final String CLOB = "Clob";
    private static final String ROWID = "ROWID";
    private ApplicationView appView;
    private String designName;
    private Design design;
    private ProgressDialog monitor;
    private int left = 20;
    private int top = 20;
    private int width = 35;
    private int height = 25;
    private int count = 0;
    private static Logger LOGGER;
    private ImportLogger importLog;
    Map typeMap = new HashMap();

    public XMIHandler(ApplicationView applicationView) {
        this.appView = applicationView;
    }

    public void parse(File file, String string) {
        try {
            String string2 = this.appView.getCurrentDesign().getDesignPath();
            this.designName = string;
            if (this.designName != null) {
                this.appView.getCurrentDesign().setDesignPath(ApplicationView.TEMP_DIR);
                if (this.appView.designExists(this.designName)) {
                    this.appView.deleteDesign(this.designName);
                }
                this.appView.setDesignName(this.designName);
                this.design = this.appView.getCurrentDesign();
                this.design.setFileName(this.designName);
                new Thread(new Runner(file.getAbsolutePath())).start();
            } else {
                this.appView.getCurrentDesign().setDesignPath(string2);
            }
        }
        catch (Exception exception) {
            LOGGER.error("Error parsing file: " + file.getAbsolutePath(), exception);
        }
    }

    private void parseFile(String string) {
    }

    private void rearrangeEntities() {
        EntitySet entitySet;
        this.left = 20;
        this.top = 20;
        this.width = 35;
        this.height = 25;
        this.count = 0;
        if (this.design != null && (entitySet = this.design.getLogicalDesign().getEntitySet()).size() > 0) {
            Iterator iterator = entitySet.iterator();
            float f = (float)Math.sqrt(entitySet.size());
            long l = (int)f;
            if (Math.sqrt(f * f) != (double)f) {
                ++l;
            }
            ++l;
            while (iterator.hasNext()) {
                Entity entity = (Entity)iterator.next();
                TopView topView = entity.getTopView();
                if (topView == null) continue;
                ++this.count;
                Dimension dimension = this.getEntitySize(entity);
                this.width = dimension.width;
                this.height = Math.max(dimension.height, this.height);
                if (topView.getCellView() != null) {
                    topView.getCellView().setNewBounds(new Rectangle(new Point(this.left, this.top), dimension));
                } else {
                    topView.setBounds(new Rectangle(new Point(this.left, this.top), dimension));
                }
                this.left = this.left + this.width + 50;
                if ((long)this.count != l) continue;
                this.count = 0;
                this.left = 20;
                this.top = this.top + this.height + 50;
                this.height = 25;
            }
        }
    }

    private Dimension getEntitySize(Entity entity) {
        int n;
        int n2 = 35;
        int n3 = 25;
        int n4 = entity.getElements().length;
        n3 += n4 * 14;
        if (entity.getKeys().length > 0 && !this.allKeysAreFK(entity.getKeys())) {
            n3 += 4;
            for (n = 0; n < entity.getKeys().length; ++n) {
                if (entity.getKeys()[n].isFK()) continue;
                n3 += 14;
            }
        }
        n = 1;
        int n5 = 1;
        for (int i = 0; i < n4; ++i) {
            ContainedObjectWithDomain containedObjectWithDomain = (ContainedObjectWithDomain)entity.getElement(i);
            int n6 = containedObjectWithDomain.getName().length() * 7;
            int n7 = containedObjectWithDomain.getDataType().toString().length() * 7;
            n = Math.max(n6, n);
            n5 = Math.max(n7, n5);
        }
        if (n == 1) {
            n = entity.getName().length() * 7;
        }
        return new Dimension(n2 + n + n5, n3);
    }

    private void rearrangeTables() {
        TableSet tableSet;
        this.left = 20;
        this.top = 20;
        this.width = 35;
        this.height = 25;
        this.count = 0;
        if (this.design != null && (tableSet = this.design.getRelationalDesign().getTableSet()).size() > 0) {
            Iterator iterator = tableSet.iterator();
            float f = (float)Math.sqrt(tableSet.size());
            long l = (int)f;
            if (Math.sqrt(f * f) != (double)f) {
                ++l;
            }
            ++l;
            while (iterator.hasNext()) {
                Table table = (Table)iterator.next();
                TopView topView = table.getTopView();
                if (topView == null) continue;
                ++this.count;
                Dimension dimension = this.getTableSize(table);
                this.width = dimension.width;
                this.height = Math.max(dimension.height, this.height);
                if (topView.getCellView() != null) {
                    topView.getCellView().setNewBounds(new Rectangle(new Point(this.left, this.top), dimension));
                } else {
                    topView.setBounds(new Rectangle(new Point(this.left, this.top), dimension));
                }
                this.left = this.left + this.width + 50;
                if ((long)this.count != l) continue;
                this.count = 0;
                this.left = 20;
                this.top = this.top + this.height + 50;
                this.height = 25;
            }
        }
    }

    private void rearrangeTypes() {
        StructuredTypeSet structuredTypeSet;
        this.left = 20;
        this.top = 20;
        this.width = 35;
        this.height = 25;
        this.count = 0;
        if (this.design != null && (structuredTypeSet = this.design.getDataTypesDesign().getStructuredTypeSet()).size() > 0) {
            Iterator iterator = structuredTypeSet.iterator();
            float f = (float)Math.sqrt(structuredTypeSet.size());
            long l = (int)f;
            if (Math.sqrt(f * f) != (double)f) {
                ++l;
            }
            ++l;
            while (iterator.hasNext()) {
                StructuredType structuredType = (StructuredType)iterator.next();
                TopView topView = structuredType.getTopView();
                if (topView == null) continue;
                ++this.count;
                Dimension dimension = this.design.getDataTypesDesign().getTypeSize(structuredType);
                this.width = dimension.width;
                this.height = Math.max(dimension.height, this.height);
                if (topView.getCellView() != null) {
                    topView.getCellView().setNewBounds(new Rectangle(new Point(this.left, this.top), dimension));
                } else {
                    topView.setBounds(new Rectangle(new Point(this.left, this.top), dimension));
                }
                this.left = this.left + this.width + 50;
                if ((long)this.count != l) continue;
                this.count = 0;
                this.left = 20;
                this.top = this.top + this.height + 50;
                this.height = 25;
            }
        }
    }

    private Dimension getTableSize(Table table) {
        int n;
        int n2 = 35;
        int n3 = 25;
        int n4 = table.getElements().length;
        n3 += n4 * 14;
        if (table.getKeys().length > 0 && !this.allKeysAreFK(table.getKeys())) {
            n3 += 4;
            for (n = 0; n < table.getKeys().length; ++n) {
                if (table.getKeys()[n].isFK()) continue;
                n3 += 14;
            }
        }
        n = 1;
        int n5 = 1;
        for (int i = 0; i < n4; ++i) {
            ContainedObjectWithDomain containedObjectWithDomain = (ContainedObjectWithDomain)table.getElement(i);
            int n6 = containedObjectWithDomain.getName().length() * 7;
            int n7 = containedObjectWithDomain.getDataType().toString().length() * 7;
            n = Math.max(n6, n);
            n5 = Math.max(n7, n5);
        }
        if (n == 1) {
            n = table.getName().length() * 7;
        }
        return new Dimension(n2 + n + n5, n3);
    }

    private boolean allKeysAreFK(KeyObject[] keyObjectArray) {
        boolean bl = true;
        for (int i = 0; i < keyObjectArray.length; ++i) {
            if (keyObjectArray[i].isFK()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    static {
        DATATYPE_MAP.put(XMI_DATATYPE_P_INTEGER, BIGINT);
        DATATYPE_MAP.put(XMI_DATATYPE_P_SMALLINT, "INTEGER");
        DATATYPE_MAP.put(XMI_DATATYPE_P_BYTE, "INTEGER");
        DATATYPE_MAP.put(XMI_DATATYPE_P_DOUBLE, DOUBLE);
        DATATYPE_MAP.put(XMI_DATATYPE_P_FLOAT, FLOAT);
        DATATYPE_MAP.put(XMI_DATATYPE_P_NUMERIC, NUMERIC);
        DATATYPE_MAP.put(XMI_DATATYPE_P_REAL, REAL);
        DATATYPE_MAP.put(XMI_DATATYPE_P_DECIMAL, DECIMAL);
        DATATYPE_MAP.put(XMI_DATATYPE_P_TIMESTAMP, TIMESTAMP);
        DATATYPE_MAP.put(XMI_DATATYPE_P_VARCHAR, ALPHANUMERIC);
        DATATYPE_MAP.put(XMI_DATATYPE_P_TEXT, TEXT);
        DATATYPE_MAP.put(XMI_DATATYPE_P_CHARACTER, ALPHANUMERIC);
        DATATYPE_MAP.put(XMI_DATATYPE_P_CURRENCY, DECIMAL);
        DATATYPE_MAP.put(XMI_DATATYPE_P_DATE, DATE);
        DATATYPE_MAP.put(XMI_DATATYPE_P_TIME, DATE_TIME);
        DATATYPE_MAP.put(XMI_DATATYPE_P_DATETIME, DATE_TIME);
        DATATYPE_MAP.put(XMI_DATATYPE_P_BINARY, BINARY);
        DATATYPE_MAP.put(XMI_DATATYPE_P_STRING, LONG_ALPHANUMERIC);
        DATATYPE_MAP.put("INTEGER", BIGINT);
        DATATYPE_MAP.put(XMI_DATATYPE_INT, BIGINT);
        DATATYPE_MAP.put(XMI_DATATYPE_SMALLINT, "INTEGER");
        DATATYPE_MAP.put(XMI_DATATYPE_BYTE, "INTEGER");
        DATATYPE_MAP.put(XMI_DATATYPE_DOUBLE, DOUBLE);
        DATATYPE_MAP.put(XMI_DATATYPE_FLOAT, FLOAT);
        DATATYPE_MAP.put(XMI_DATATYPE_NUMERIC, NUMERIC);
        DATATYPE_MAP.put(XMI_DATATYPE_REAL, REAL);
        DATATYPE_MAP.put(XMI_DATATYPE_DECIMAL, DECIMAL);
        DATATYPE_MAP.put(XMI_DATATYPE_TIMESTAMP, TIMESTAMP);
        DATATYPE_MAP.put(XMI_DATATYPE_VARCHAR, ALPHANUMERIC);
        DATATYPE_MAP.put(XMI_DATATYPE_TEXT, TEXT);
        DATATYPE_MAP.put(XMI_DATATYPE_CHARACTER, ALPHANUMERIC);
        DATATYPE_MAP.put(XMI_DATATYPE_CURRENCY, DECIMAL);
        DATATYPE_MAP.put(XMI_DATATYPE_DATE, DATE);
        DATATYPE_MAP.put(XMI_DATATYPE_TIME, DATE_TIME);
        DATATYPE_MAP.put(XMI_DATATYPE_DATETIME, DATE_TIME);
        DATATYPE_MAP.put(XMI_DATATYPE_BINARY, BINARY);
        DATATYPE_MAP.put(XMI_DATATYPE_STRING, LONG_ALPHANUMERIC);
        DATATYPE_MAP.put(XMI_DATATYPE_BOOLEAN, BOOLEAN);
        DATATYPE_MAP.put(XMI_DATATYPE_CHAR, TEXT);
        DATATYPE_MAP.put(XMI_DATATYPE_BLOB, BLOB);
        DATATYPE_MAP.put(XMI_DATATYPE_CLOB, CLOB);
        DATATYPE_MAP.put("ROWID", "ROWID");
        LOGGER = new Logger(XMIHandler.class);
    }

    private class Runner
    implements Runnable {
        private String file;

        public Runner(String string) {
            this.file = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                XMIHandler.this.design.getLogicalDesign().setMainViewVisible(false);
                XMIHandler.this.design.getRelationalDesign().setMainViewVisible(false);
                XMIHandler.this.design.getDataTypesDesign().setMainViewVisible(false);
                XMIHandler.this.importLog = new ImportLogger();
                try {
                    XMIHandler.this.monitor = new ProgressDialog(XMIHandler.this.appView, "", 0, 100);
                    try {
                        try {
                            XMIHandler.this.monitor.setNote(Messages.getString("XMIHandler.ParseFile"));
                            XMIHandler.this.monitor.setProgress(10);
                            XMIHandler.this.parseFile(this.file);
                            XMIHandler.this.monitor.setNote(Messages.getString("XMIHandler.RearrangeLayout"));
                            XMIHandler.this.monitor.setProgress(80);
                            try {
                                XMIHandler.this.rearrangeTypes();
                                XMIHandler.this.rearrangeEntities();
                                XMIHandler.this.rearrangeTables();
                                XMIHandler.this.design.getDataTypesDesign().setMainViewVisible(true);
                            }
                            catch (Exception exception) {
                                LOGGER.error("Unable to rearrange Layout", exception);
                            }
                            XMIHandler.this.monitor.setProgress(100);
                            XMIHandler.this.appView.getCurrentDesign().setDesignPath("");
                            XMIHandler.this.appView.synchronizeTitle();
                            System.gc();
                        }
                        finally {
                            XMIHandler.this.appView.setImporting(false);
                        }
                    }
                    finally {
                        XMIHandler.this.monitor.close();
                    }
                }
                finally {
                    ApplicationView.loading = false;
                    XMIHandler.this.design.getLogicalDesign().setMainViewVisible(true);
                    XMIHandler.this.design.getRelationalDesign().setMainViewVisible(true);
                    if (XMIHandler.this.design.getRelationalDesign().getTableSet().size() > 0) {
                        XMIHandler.this.appView.setCurrentDPV(XMIHandler.this.design.getRelationalDesign().getMainView());
                    } else {
                        XMIHandler.this.appView.setCurrentDPV(XMIHandler.this.design.getLogicalDesign().getMainView());
                    }
                }
                LogReport logReport = new LogReport(XMIHandler.this.appView);
                logReport.setLog(XMIHandler.this.importLog.generateReport(XMIHandler.this.appView));
                if (XMIHandler.this.appView.getSettings().showImportLog()) {
                    logReport.showDialog(new Dimension(750, 550));
                }
            }
            catch (Exception exception) {
                XMIHandler.this.design.destroyAll(false);
                XMIHandler.this.design = null;
                LOGGER.error("Error Parsing File: " + this.file, exception);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("XMIHandler.UnableToImportTheFile"), Messages.getString("XMIHandler.ErrorImportingFile"), 0);
            }
        }
    }
}

