/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.MDUser;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.util.logging.Logger;

public class RowCollector {
    private List allSelectedLines;
    private List allForeignKeyLines;
    private List allPrimaryKeyLines;
    private List allColumnLines;
    private Map allCreatedObjects;
    private Map allReferences;
    private Fields constants;
    private Design design;
    private List commentLines;
    private static final Logger LOGGER = new Logger(RowCollector.class);

    public void initialize(Design design, Fields fields, List list, Map map, List list2, List list3, Map map2, List list4, List list5) {
        this.setDesign(design);
        this.setFieldConstants(fields);
        this.setAllSelectedLines(list);
        this.setAllCreatedObjects(map);
        this.setAllForeignKeyLines(list2);
        this.setAllPrimaryKeyLines(list3);
        this.setAllColumnLines(list4);
        this.setAllReferences(map2);
        this.setCommentLines(list5);
    }

    public void setAllCreatedObjects(Map map) {
        this.allCreatedObjects = map;
    }

    public Map getAllCreatedObjects() {
        return this.allCreatedObjects;
    }

    public Map getAllReferences() {
        return this.allReferences;
    }

    protected void addCreatedObject(String string, ModelIDObject modelIDObject) {
        this.allCreatedObjects.put(string, modelIDObject);
    }

    public ModelIDObject getCreatedObject(String string) {
        return (ModelIDObject)this.allCreatedObjects.get(string);
    }

    public void setAllSelectedLines(List list) {
        this.allSelectedLines = list;
    }

    public void setAllForeignKeyLines(List list) {
        this.allForeignKeyLines = list;
    }

    public void setAllPrimaryKeyLines(List list) {
        this.allPrimaryKeyLines = list;
    }

    public void setAllColumnLines(List list) {
        this.allColumnLines = list;
    }

    public void setAllReferences(Map map) {
        this.allReferences = map;
    }

    protected void addSelectedLine(VarFileLine varFileLine) {
        this.allSelectedLines.add(varFileLine);
    }

    protected void addForeignKeyLine(VarFileLine varFileLine) {
        this.allForeignKeyLines.add(varFileLine);
    }

    protected void addPrimaryKeyLine(VarFileLine varFileLine) {
        this.allPrimaryKeyLines.add(varFileLine);
    }

    protected void addColumnLine(VarFileLine varFileLine) {
        this.allColumnLines.add(varFileLine);
    }

    protected void addReferences(String string, Object object) {
        this.allReferences.put(string, object);
    }

    protected boolean contains(VarFileLine varFileLine) {
        return this.allSelectedLines.contains(varFileLine);
    }

    public List getAllSelectedLines() {
        return this.allSelectedLines;
    }

    public List getAllForeignKeyLines() {
        return this.allForeignKeyLines;
    }

    public List getAllPrimaryKeyLines() {
        return this.allPrimaryKeyLines;
    }

    public List getAllColumnLines() {
        return this.allColumnLines;
    }

    public VarFileLine getLastSelectedLine() {
        if (this.allSelectedLines.size() > 0) {
            return (VarFileLine)this.allSelectedLines.get(this.allSelectedLines.size() - 1);
        }
        return null;
    }

    public List getSelectedLinesOfType(String string) {
        ArrayList<VarFileLine> arrayList = new ArrayList<VarFileLine>();
        for (VarFileLine varFileLine : this.allSelectedLines) {
            if (!varFileLine.getType().equalsIgnoreCase(string)) continue;
            arrayList.add(varFileLine);
        }
        return arrayList;
    }

    public List getSelectedLinesOfType(String string, List list) {
        ArrayList<VarFileLine> arrayList = new ArrayList<VarFileLine>();
        for (VarFileLine varFileLine : list) {
            if (!varFileLine.getType().equalsIgnoreCase(string)) continue;
            arrayList.add(varFileLine);
        }
        return arrayList;
    }

    public List removeSelectedLinesOfType(String string) {
        ArrayList<VarFileLine> arrayList = new ArrayList<VarFileLine>();
        for (VarFileLine varFileLine : this.allSelectedLines) {
            if (!varFileLine.getType().equalsIgnoreCase(string)) continue;
            arrayList.add(varFileLine);
        }
        this.allSelectedLines.removeAll(arrayList);
        return this.allSelectedLines;
    }

    public void removeSelectedLine(VarFileLine varFileLine) {
        int n = this.allSelectedLines.indexOf(varFileLine);
        if (n > -1) {
            this.allSelectedLines.remove(n);
        }
    }

    public void removeSelectedLineObject(VarFileLine varFileLine) {
        this.allSelectedLines.remove(varFileLine);
    }

    public void removeAllSelectedLines() {
        this.allSelectedLines.clear();
    }

    public void setDesign(Design design) {
        this.design = design;
    }

    public Design getDesign() {
        return this.design;
    }

    public LogicalDesign getLogicalDesign() {
        return this.getDesign().getLogicalDesign();
    }

    public RelationalDesign getPhysicalDesign() {
        return this.getDesign().getRelationalDesign();
    }

    public DataFlowDesign getDataFlowDesign() {
        return this.getDesign().getProcessModel().getDataFlowDesign();
    }

    public ProcessModel getProcessModel() {
        return this.getDesign().getProcessModel();
    }

    public void setFieldConstants(Fields fields) {
        this.constants = fields;
    }

    protected String toTime(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.setLength(23);
        stringBuffer.setCharAt(10, ' ');
        stringBuffer.setCharAt(13, ':');
        stringBuffer.setCharAt(16, ':');
        return stringBuffer.toString();
    }

    protected void setCreatorChanger(ModelIDObject modelIDObject, VarFileLine varFileLine) {
        modelIDObject.getCreation().setUser(new MDUser(this.getField(varFileLine, "general_creator")));
        modelIDObject.getCreation().setTimeString(this.toTime(this.getField(varFileLine, "general_creation_time")));
        modelIDObject.getChange().setUser(new MDUser(this.getField(varFileLine, "general_changer")));
        modelIDObject.getChange().setTimeString(this.toTime(this.getField(varFileLine, "general_change_time")));
    }

    public Hashtable getFieldConstants() {
        return this.constants.getFields();
    }

    protected String getField(VarFileLine varFileLine, String string) {
        return this.getField(varFileLine.getLine(), this.getFieldConstants().get(string));
    }

    protected String getCommentField(VarFileLine varFileLine, String string) {
        return this.getCommentField(varFileLine.getLine(), this.getFieldConstants().get(string));
    }

    protected String getDefinitionField(String string, Object object) {
        String string2 = "";
        StringBuffer stringBuffer = new StringBuffer("");
        Integer n = (Integer)object;
        if (!"".equalsIgnoreCase(string)) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            for (int i = 0; stringTokenizer.hasMoreTokens() && i < n; ++i) {
                string2 = stringTokenizer.nextToken().trim();
            }
            stringBuffer = new StringBuffer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append(",\n   ");
                stringBuffer.append(stringTokenizer.nextToken().trim());
            }
            string2 = stringBuffer.toString();
            if (string2.startsWith("\"") && string2.endsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
        } else {
            LOGGER.error("Field cannot be found because there is no line");
        }
        return string2.trim();
    }

    protected String getCommentField(String string, Object object) {
        String string2 = "";
        StringBuffer stringBuffer = new StringBuffer("");
        Integer n = (Integer)object;
        if (!"".equalsIgnoreCase(string)) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            for (int i = 0; stringTokenizer.hasMoreTokens() && i < n; ++i) {
                string2 = stringTokenizer.nextToken().trim();
            }
            stringBuffer = new StringBuffer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append(stringTokenizer.nextToken().trim());
            }
            string2 = stringBuffer.toString();
            if (string2.startsWith("\"") && string2.endsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
        } else {
            LOGGER.error("Field cannot be found because there is no line");
        }
        return string2.trim();
    }

    protected String getField(String string, Object object) {
        try {
            boolean bl = false;
            StringBuffer stringBuffer = new StringBuffer();
            Integer n = (Integer)object;
            if (!"".equalsIgnoreCase(string)) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                int n2 = 1;
                while (stringTokenizer != null && stringTokenizer.hasMoreTokens() && n != null) {
                    String string2 = stringTokenizer.nextToken();
                    if (n2 == n) {
                        stringBuffer.append(string2);
                        if (stringBuffer.toString().trim().startsWith("\"") && !stringBuffer.toString().trim().endsWith("\"")) {
                            bl = true;
                        }
                    }
                    if (n2 > n && bl) {
                        String string3 = string2;
                        stringBuffer.append(string3);
                        if (string3.endsWith("\"")) {
                            bl = false;
                            break;
                        }
                    }
                    ++n2;
                }
                if (stringBuffer.toString().startsWith("\"") && stringBuffer.toString().endsWith("\"")) {
                    stringBuffer = new StringBuffer(stringBuffer.toString().substring(1, stringBuffer.length() - 1));
                }
            } else {
                LOGGER.error("Field cannot be found because there is no line");
            }
            return stringBuffer.toString();
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return "";
        }
    }

    public VarFileLine getCommentLine(String string, String string2) {
        List list = this.getSelectedLinesOfType(string2);
        for (VarFileLine varFileLine : list) {
            if (!this.getField(varFileLine, "general_id").equalsIgnoreCase(string)) continue;
            return varFileLine;
        }
        return null;
    }

    public VarFileLine getCommentLine(String string, String string2, List list) {
        List list2 = this.getSelectedLinesOfType(string2, list);
        for (VarFileLine varFileLine : list2) {
            if (!this.getField(varFileLine, "general_id").equalsIgnoreCase(string)) continue;
            return varFileLine;
        }
        return null;
    }

    public List getCommentLines() {
        return this.commentLines;
    }

    public void setCommentLines(List list) {
        this.commentLines = list;
    }
}

