/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.IndexPartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.PartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.util.logging.Logger;

public class RHTablespacePartitions
extends RowHandler {
    public static final String OBJECT_TYPE = "PARTITIONS";
    private static final Logger LOGGER = new Logger(RHTablespacePartitions.class);

    public RHTablespacePartitions(Design design, Fields fields, List list, Map map, List list2, List list3, Map map2, List list4, List list5) {
        super(design, fields, list, map, list2, list3, map2, list4, list5);
    }

    @Override
    public void read(VarFileLine varFileLine) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.addSelectedLine(varFileLine);
        } else {
            this.nextRead(varFileLine);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(OBJECT_TYPE);
        return arrayList;
    }

    @Override
    public void handle(VarFileLine varFileLine, boolean bl) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.createPartitions(varFileLine);
        } else {
            this.nextHandler(varFileLine, bl);
        }
    }

    private void createPartitions(VarFileLine varFileLine) {
        String string = this.getField(varFileLine, "TABLESPACE_PART_TABLESPACE_KEY");
        TableSpaceDB2 tableSpaceDB2 = (TableSpaceDB2)this.getCreatedObject(string);
        String string2 = this.getField(varFileLine, "TABLESPACE_PART_INDEX_KEY");
        Index index = (Index)this.getCreatedObject(string2);
        RDBMSSite rDBMSSite = this.getDesign().getSelectedRDBMSSite();
        StorageDesignDB2v70 storageDesignDB2v70 = (StorageDesignDB2v70)this.getDesign().getStorageDesign(rDBMSSite);
        if (storageDesignDB2v70 != null) {
            if (tableSpaceDB2 != null) {
                PartitionDB2 partitionDB2 = storageDesignDB2v70.getPartitionSet().createPartition();
                partitionDB2.setTableSpace(tableSpaceDB2);
                StorageTemplateDB2 storageTemplateDB2 = storageDesignDB2v70.getStorageTemplateSet().createStorageTemplate();
                partitionDB2.setStorageTemplate(storageTemplateDB2);
                this.fillPartNumber(varFileLine, partitionDB2, null);
                this.fillCommont(varFileLine, partitionDB2);
                this.fillCompressed(varFileLine, partitionDB2);
                this.fillEraseRule(varFileLine, storageTemplateDB2);
                this.fillFreepage(varFileLine, storageTemplateDB2);
                this.fillPercentageFree(varFileLine, storageTemplateDB2);
                this.fillPrimaryQuantity(varFileLine, storageTemplateDB2);
                this.fillSecundaryQuantity(varFileLine, storageTemplateDB2);
                StorageGroupDB2 storageGroupDB2 = (StorageGroupDB2)this.getCreatedObject(this.getField(varFileLine, "TABLESPACE_PART_STORAGEGROUP_KEY"));
                VCatDB2 vCatDB2 = (VCatDB2)this.getCreatedObject(this.getField(varFileLine, "TABLESPACE_PART_VCAT_KEY"));
                if (storageGroupDB2 != null) {
                    storageTemplateDB2.setStorageGroup(storageGroupDB2);
                } else if (vCatDB2 != null) {
                    storageTemplateDB2.setVCat(vCatDB2);
                }
                this.addCreatedObject(this.getField(varFileLine, "general_id"), partitionDB2);
                this.removeSelectedLine(varFileLine);
                StorageTemplateDB2 storageTemplateDB22 = storageDesignDB2v70.getStorageTemplateSet().removeIfExistEqual(partitionDB2.getStorageTemplate());
                if (storageTemplateDB22 != partitionDB2.getStorageTemplate()) {
                    partitionDB2.setStorageTemplate(storageTemplateDB22);
                }
            } else if (index != null) {
                IndexPartitionDB2 indexPartitionDB2 = storageDesignDB2v70.getIndexPartitionSet().createIndexPartition();
                IndexProxyDB2 indexProxyDB2 = (IndexProxyDB2)storageDesignDB2v70.getIndexProxySet().getProxy(index.getObjectID());
                indexPartitionDB2.setIndex(indexProxyDB2);
                StorageTemplateDB2 storageTemplateDB2 = storageDesignDB2v70.getStorageTemplateSet().createStorageTemplate();
                indexPartitionDB2.setStorageTemplate(storageTemplateDB2);
                this.fillPartNumber(varFileLine, null, indexPartitionDB2);
                this.fillPartConstants(varFileLine, indexPartitionDB2);
                this.fillEraseRule(varFileLine, storageTemplateDB2);
                this.fillFreepage(varFileLine, storageTemplateDB2);
                this.fillPercentageFree(varFileLine, storageTemplateDB2);
                this.fillPrimaryQuantity(varFileLine, storageTemplateDB2);
                this.fillSecundaryQuantity(varFileLine, storageTemplateDB2);
                this.addCreatedObject(this.getField(varFileLine, "general_id"), indexPartitionDB2);
                this.removeSelectedLine(varFileLine);
                StorageTemplateDB2 storageTemplateDB23 = storageDesignDB2v70.getStorageTemplateSet().removeIfExistEqual(indexPartitionDB2.getStorageTemplate());
                if (storageTemplateDB23 != indexPartitionDB2.getStorageTemplate()) {
                    indexPartitionDB2.setStorageTemplate(storageTemplateDB23);
                }
            }
        }
    }

    private void fillPartNumber(VarFileLine varFileLine, PartitionDB2 partitionDB2, IndexPartitionDB2 indexPartitionDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "TABLESPACE_PART_NUMBER"));
            if (partitionDB2 != null) {
                partitionDB2.setPartNumber(n);
            } else if (indexPartitionDB2 != null) {
                indexPartitionDB2.setPartNumber(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong format in RHTablespacePartitions.fillDeletePercentage :");
            stringBuffer.append(numberFormatException.getMessage());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong PART NUMBER format for partition " + partitionDB2.getName());
        }
    }

    private void fillCommont(VarFileLine varFileLine, PartitionDB2 partitionDB2) {
        String string = this.getField(varFileLine, "TABLESPACE_PART_TEXT");
        for (VarFileLine varFileLine2 : this.getAllSelectedLines()) {
            if (!varFileLine2.getType().equalsIgnoreCase("TEXT") || !this.getField(varFileLine2, "general_id").equalsIgnoreCase(string)) continue;
            String string2 = this.getField(varFileLine2, "text_comment");
            partitionDB2.setCommentInRDBMS(string2);
            partitionDB2.setComment(string2);
        }
    }

    private void fillCompressed(VarFileLine varFileLine, PartitionDB2 partitionDB2) {
        String string = this.getField(varFileLine, "TABLESPACE_PART_COMPRESSED").trim();
        if (string.equals("1")) {
            partitionDB2.setCompress(true);
        }
    }

    private void fillEraseRule(VarFileLine varFileLine, StorageTemplateDB2 storageTemplateDB2) {
        String string = this.getField(varFileLine, "TABLESPACE_PART_ERASE_RULE");
        if (string.equals("1")) {
            storageTemplateDB2.setSgErase(true);
        }
    }

    private void fillFreepage(VarFileLine varFileLine, StorageTemplateDB2 storageTemplateDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "TABLESPACE_PART_FREEPAGE"));
            if (n > 0 && n < 256) {
                storageTemplateDB2.setFreePage(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong format in RHTablespacePartitions.fillFreepage :");
            stringBuffer.append(numberFormatException.getMessage());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FREE PAGE format for storage template " + storageTemplateDB2.getName());
        }
    }

    private void fillPercentageFree(VarFileLine varFileLine, StorageTemplateDB2 storageTemplateDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "TABLESPACE_PART_PCTFREE"));
            if (n > 0) {
                storageTemplateDB2.setPctFree(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong format in RHTablespacePartitions.fillPercentageFree :");
            stringBuffer.append(numberFormatException.getMessage());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong PERCENTAGE FREE format for storage template " + storageTemplateDB2.getName());
        }
    }

    private void fillPrimaryQuantity(VarFileLine varFileLine, StorageTemplateDB2 storageTemplateDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "TABLESPACE_PART_PRIQTY"));
            if (n > -1) {
                storageTemplateDB2.setSgPriqty(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong format in RHTablespacePartitions.fillPrimaryQuantity :");
            stringBuffer.append(numberFormatException.getMessage());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong PRIMARY QUANTITY format for storage template " + storageTemplateDB2.getName());
        }
    }

    private void fillSecundaryQuantity(VarFileLine varFileLine, StorageTemplateDB2 storageTemplateDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "TABLESPACE_PART_SECQTY"));
            if (n > -1) {
                storageTemplateDB2.setSgSeqty(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong format in RHTablespacePartitions.fillSecundaryQuantity :");
            stringBuffer.append(numberFormatException.getMessage());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong SECONDARY QUANTITY format for storage template " + storageTemplateDB2.getName());
        }
    }

    private void fillPartConstants(VarFileLine varFileLine, IndexPartitionDB2 indexPartitionDB2) {
        String string = this.getField(varFileLine, "general_id");
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.getAllSelectedLines().iterator();
        while (iterator.hasNext()) {
            String string2;
            VarFileLine varFileLine2 = (VarFileLine)iterator.next();
            if (!varFileLine2.getType().equalsIgnoreCase("PARTITION_BOUNDARY") || !string.equalsIgnoreCase(string2 = this.getField(varFileLine2, "PARTITION_BOUNDARY_PARTID"))) continue;
            stringBuffer.append(this.getField(varFileLine2, "PARTITION_BOUNDARY_VALUE"));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        indexPartitionDB2.setPartConstants(stringBuffer.toString());
    }
}

