/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.util.logging.Logger;

public class RHTableSpace
extends RowHandler {
    public static final String OBJECT_TYPE = "TABLESPACE";
    public static final String OBJECT_TYPE_COOL = "TABLE_SPACES";
    private static final Logger LOGGER = new Logger(RHTableSpace.class);
    private Integer nactive = new Integer(46);
    private Integer max_rows = new Integer(58);
    private String CCSID_DEF_NUM = "4294967295";
    private Integer ccsid1 = new Integer(14);
    private Integer ccsid2 = new Integer(53);

    public RHTableSpace(Design design, Fields fields, List list, Map map, List list2, List list3, Map map2, List list4, List list5) {
        super(design, fields, list, map, list2, list3, map2, list4, list5);
    }

    @Override
    public void read(VarFileLine varFileLine) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE) || varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE_COOL)) {
            this.addSelectedLine(varFileLine);
        } else {
            this.nextRead(varFileLine);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(OBJECT_TYPE);
        arrayList.add(OBJECT_TYPE_COOL);
        return arrayList;
    }

    @Override
    public void handle(VarFileLine varFileLine, boolean bl) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE) || varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE_COOL)) {
            this.createTableSpace(varFileLine);
        } else {
            this.nextHandler(varFileLine, bl);
        }
    }

    private void createTableSpace(VarFileLine varFileLine) {
        String string = this.getField(varFileLine, "TABLESPACE_DATABASES");
        DataBaseDB2 dataBaseDB2 = (DataBaseDB2)this.getCreatedObject(string);
        String string2 = this.getField(varFileLine, "TABLESPACE_STORAGE_GROUP");
        StorageGroupDB2 storageGroupDB2 = (StorageGroupDB2)this.getCreatedObject(string2);
        VCatDB2 vCatDB2 = (VCatDB2)this.getCreatedObject(this.getField(varFileLine, "TABLESPACE_VCAT"));
        RDBMSSite rDBMSSite = this.getDesign().getSelectedRDBMSSite();
        StorageDesignDB2v70 storageDesignDB2v70 = (StorageDesignDB2v70)this.getDesign().getStorageDesign(rDBMSSite);
        if (dataBaseDB2 == null) {
            dataBaseDB2 = (DataBaseDB2)storageDesignDB2v70.getDataBaseSet().getByName("DSNDB04");
        }
        TableSpaceDB2 tableSpaceDB2 = storageDesignDB2v70.getTableSpaceSet().createTableSpace();
        StorageTemplateDB2 storageTemplateDB2 = storageDesignDB2v70.getStorageTemplateSet().createStorageTemplate();
        tableSpaceDB2.setName(this.getField(varFileLine, "TABLESPACE_TSPACE_NAME"));
        tableSpaceDB2.setComment(this.getComment(varFileLine));
        tableSpaceDB2.setStorageTemplate(storageTemplateDB2);
        if (storageGroupDB2 != null) {
            storageTemplateDB2.setStorageGroup(storageGroupDB2);
        } else if (vCatDB2 != null) {
            storageTemplateDB2.setVCat(vCatDB2);
        }
        this.fillBufferpool(varFileLine, tableSpaceDB2);
        this.fillLockSize(varFileLine, tableSpaceDB2);
        this.fillLockMax(varFileLine, tableSpaceDB2);
        this.fillGbpCache(varFileLine, storageTemplateDB2);
        this.fillSegSize(varFileLine, tableSpaceDB2);
        this.fillCloseRule(varFileLine, tableSpaceDB2);
        this.fillMaxRows(varFileLine, tableSpaceDB2);
        this.fillCCSID(varFileLine, tableSpaceDB2);
        this.fillEraseRule(varFileLine, storageTemplateDB2);
        this.fillFreePage(varFileLine, storageTemplateDB2);
        this.fillMaintInterval(varFileLine, tableSpaceDB2);
        this.fillNActive(varFileLine, tableSpaceDB2);
        this.fillPctFree(varFileLine, storageTemplateDB2);
        this.fillPriqty(varFileLine, storageTemplateDB2);
        this.fillSecqty(varFileLine, storageTemplateDB2);
        this.fillSpaceAlloc(varFileLine, tableSpaceDB2);
        this.fillCatSpace(varFileLine, tableSpaceDB2);
        this.fillObid(varFileLine, tableSpaceDB2);
        this.fillPsid(varFileLine, tableSpaceDB2);
        this.fillCreateBy(varFileLine, tableSpaceDB2);
        tableSpaceDB2.setDataBase(dataBaseDB2);
        this.fillCompress(varFileLine, tableSpaceDB2);
        this.fillCompressRatio(varFileLine, tableSpaceDB2);
        this.fillPageSave(varFileLine, tableSpaceDB2);
        this.addCreatedObject(this.getField(varFileLine, "general_id"), tableSpaceDB2);
        this.removeSelectedLine(varFileLine);
        StorageTemplateDB2 storageTemplateDB22 = storageDesignDB2v70.getStorageTemplateSet().removeIfExistEqual(tableSpaceDB2.getStorageTemplate());
        if (storageTemplateDB22 != tableSpaceDB2.getStorageTemplate()) {
            tableSpaceDB2.setStorageTemplate(storageTemplateDB22);
        }
    }

    private void fillLockSize(VarFileLine varFileLine, TableSpaceDB2 tableSpaceDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "TABLESPACE_LOCKSIZE"));
            String[] stringArray = TableSpaceDB2.getLockSizeValues();
            switch (n) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    tableSpaceDB2.setLockSize(stringArray[n - 1]);
                    break;
                }
                default: {
                    tableSpaceDB2.setLockSize(stringArray[0]);
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHTableSpace.fillLockSize: ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL LOCK SIZE format near " + varFileLine);
        }
    }

    private void fillLockMax(VarFileLine varFileLine, TableSpaceDB2 tableSpaceDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "TABLESPACE_LOCKMAX"));
            tableSpaceDB2.setLockMax(n);
        }
        catch (NumberFormatException numberFormatException) {
            tableSpaceDB2.setLockMax(-1);
        }
    }

    private void fillGbpCache(VarFileLine varFileLine, StorageTemplateDB2 storageTemplateDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "TABLESPACE_GBPCACHE"));
            if (n == 1) {
                storageTemplateDB2.setGbCache(StorageTemplateDB2.GBCACHE[1]);
            } else if (n == 2) {
                storageTemplateDB2.setGbCache(StorageTemplateDB2.GBCACHE[2]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHTableSpace.fillGbpCache : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL GBP SIZE format near " + varFileLine);
        }
    }

    private void fillSegSize(VarFileLine varFileLine, TableSpaceDB2 tableSpaceDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "TABLESPACE_SEGSIZE"));
            if (n > 0) {
                tableSpaceDB2.setSegSize(String.valueOf(n));
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHTableSpace.fillSegSize: ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL SEGMENT SIZE format near " + varFileLine);
        }
    }

    private void fillCloseRule(VarFileLine varFileLine, TableSpaceDB2 tableSpaceDB2) {
        String string = this.getField(varFileLine, "TABLESPACE_CLOSERULE");
        if (string.equals("1")) {
            tableSpaceDB2.setClose(true);
        } else {
            tableSpaceDB2.setClose(false);
        }
    }

    private void fillEraseRule(VarFileLine varFileLine, StorageTemplateDB2 storageTemplateDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "TABLESPACE_ERASERULE"));
            if (n == 0) {
                storageTemplateDB2.setSgErase(false);
            } else if (n == 1) {
                storageTemplateDB2.setSgErase(true);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHTableSpace.fillEraseRule : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL ERASE RULE format near " + varFileLine);
        }
    }

    private void fillFreePage(VarFileLine varFileLine, StorageTemplateDB2 storageTemplateDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "TABLESPACE_FREEPAGE"));
            if (n >= 0) {
                storageTemplateDB2.setFreePage(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHTableSpace.fillFreepage : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL FREE PAGE format near " + varFileLine);
        }
    }

    private void fillMaintInterval(VarFileLine varFileLine, TableSpaceDB2 tableSpaceDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "TABLESPACE_MAINT_INTERVAL"));
            tableSpaceDB2.setMaintenanceInterval(n);
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHTableSpace.fillMaintInterval: ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL MAINT INTERVAL format near " + varFileLine);
        }
    }

    private void fillNActive(VarFileLine varFileLine, TableSpaceDB2 tableSpaceDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine.getLine(), this.nactive));
            if (n > 0) {
                tableSpaceDB2.setNactive(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHTableSpace.fillNactive : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL NACTIVE format near " + varFileLine);
        }
    }

    private void fillPctFree(VarFileLine varFileLine, StorageTemplateDB2 storageTemplateDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "TABLESPACE_PCTFREE"));
            if (n >= 0) {
                storageTemplateDB2.setPctFree(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHTableSpace.fillPctfree : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL PCTFREE format near " + varFileLine);
        }
    }

    private void fillPriqty(VarFileLine varFileLine, StorageTemplateDB2 storageTemplateDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "TABLESPACE_PRIQTY"));
            if (n > -1) {
                storageTemplateDB2.setSgPriqty(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHTableSpace.fillPriqty : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL PRIQTY format near " + varFileLine);
        }
    }

    private void fillSecqty(VarFileLine varFileLine, StorageTemplateDB2 storageTemplateDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "TABLESPACE_SECQTY"));
            if (n > -1) {
                storageTemplateDB2.setSgSeqty(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHTableSpace.fillSecqty : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL SECQTY format near " + varFileLine);
        }
    }

    private void fillSpaceAlloc(VarFileLine varFileLine, TableSpaceDB2 tableSpaceDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "TABLESPACE_SPACE_ALLOC"));
            if (n > 0) {
                tableSpaceDB2.setSpaceAllocationInterval(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHTableSpace.fillSpaceAlloc: ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL SPACE ALLOC format near " + varFileLine);
        }
    }

    private void fillCreateBy(VarFileLine varFileLine, TableSpaceDB2 tableSpaceDB2) {
        String string = this.getField(varFileLine, "TABLESPACE_CREATE_BY");
        tableSpaceDB2.setCreatedBy(string);
    }

    private void fillCatSpace(VarFileLine varFileLine, TableSpaceDB2 tableSpaceDB2) {
        try {
            long l = Long.parseLong(this.getField(varFileLine, "TABLESPACE_CAT_SPACE"));
            if (l > 0L) {
                tableSpaceDB2.setSpace((int)l);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHTableSpace.fillCatSpace: ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL CAT SPACE format near " + varFileLine);
        }
    }

    private void fillObid(VarFileLine varFileLine, TableSpaceDB2 tableSpaceDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "TABLESPACE_OBID"));
            if (n > 0) {
                tableSpaceDB2.setObid(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHTableSpace.fillObid: ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL OBID format near " + varFileLine);
        }
    }

    private void fillPsid(VarFileLine varFileLine, TableSpaceDB2 tableSpaceDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "TABLESPACE_PSID"));
            if (n > 0) {
                tableSpaceDB2.setPsid(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHTableSpace.fillPsid: ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL PSID format near " + varFileLine);
        }
    }

    private void fillCompress(VarFileLine varFileLine, TableSpaceDB2 tableSpaceDB2) {
        String string = this.getField(varFileLine, "TABLESPACE_COMPRESS");
        if (string.equals("0")) {
            tableSpaceDB2.setCompress(false);
        } else if (string.equals("1")) {
            tableSpaceDB2.setCompress(true);
        }
    }

    private void fillCompressRatio(VarFileLine varFileLine, TableSpaceDB2 tableSpaceDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "TABLESPACE_COMPRESS_RATIO"));
            if (n > 0) {
                tableSpaceDB2.setCompressionRatio(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHTableSpace.fillCompressRatio: ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL COMPRESS RATIO format near " + varFileLine);
        }
    }

    private void fillPageSave(VarFileLine varFileLine, TableSpaceDB2 tableSpaceDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "TABLESPACE_PAGESAVE"));
            if (n > 0) {
                tableSpaceDB2.setPageSave(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHTableSpace.fillPageSave: ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL PAGE SAVE format near " + varFileLine);
        }
    }

    private void fillBufferpool(VarFileLine varFileLine, TableSpaceDB2 tableSpaceDB2) {
        String string = this.getField(varFileLine, "TABLESPACE_BUFFER_POOL");
        BufferPoolDB2 bufferPoolDB2 = (BufferPoolDB2)this.getCreatedObject(string);
        if (bufferPoolDB2 != null) {
            tableSpaceDB2.setBufferPool(bufferPoolDB2);
        }
    }

    private String getComment(VarFileLine varFileLine) {
        String string = null;
        if (!this.getField(varFileLine, "TABLESPACE_TEXT_ID").equalsIgnoreCase("0")) {
            VarFileLine varFileLine2 = this.getCommentLine(this.getField(varFileLine, "TABLESPACE_TEXT_ID"), "TEXT");
            if (varFileLine2 != null) {
                string = this.getField(varFileLine2, "text_comment");
            }
        } else {
            string = "";
        }
        return string;
    }

    private void fillMaxRows(VarFileLine varFileLine, TableSpaceDB2 tableSpaceDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine.getLine(), this.max_rows));
            tableSpaceDB2.setMaxRows(n);
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHTableSpace.fillMaxRows : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong Max Rows format near " + varFileLine);
        }
    }

    private void fillCCSID(VarFileLine varFileLine, TableSpaceDB2 tableSpaceDB2) {
        String string = this.getField(varFileLine.getLine(), this.ccsid1);
        if (!string.equalsIgnoreCase(this.CCSID_DEF_NUM)) {
            String string2 = this.getField(varFileLine.getLine(), this.ccsid2);
            if ("1".equalsIgnoreCase(string2)) {
                tableSpaceDB2.setCcsid("EBCDIC");
            } else if ("0".equalsIgnoreCase(string2)) {
                tableSpaceDB2.setCcsid("ASCII");
            }
        }
    }
}

