/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxySetDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.util.logging.Logger;

public class RHTable
extends RowHandler {
    public static final String OBJECT_TYPE = "TABLES";
    public static final String OBJECT_TYPE_COOL = "TABLE";
    private static final Logger LOGGER = new Logger(RHTable.class);

    public RHTable(Design design, Fields fields, List list, Map map, List list2, List list3, Map map2, List list4, List list5) {
        super(design, fields, list, map, list2, list3, map2, list4, list5);
    }

    @Override
    public void read(VarFileLine varFileLine) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE) || varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE_COOL)) {
            this.addSelectedLine(varFileLine);
        } else {
            this.nextRead(varFileLine);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(OBJECT_TYPE);
        arrayList.add(OBJECT_TYPE_COOL);
        return arrayList;
    }

    @Override
    public void handle(VarFileLine varFileLine, boolean bl) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE) || varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE_COOL)) {
            this.createTable(varFileLine, bl);
        } else {
            this.nextHandler(varFileLine, bl);
        }
    }

    private void createTable(VarFileLine varFileLine, boolean bl) {
        String string = this.getField(varFileLine, "table_TABLE_SPACES");
        TableSpaceDB2 tableSpaceDB2 = (TableSpaceDB2)this.getCreatedObject(string);
        if (!bl) {
            Table table = this.getPhysicalDesign().getTableSet().createTable(null);
            this.fillElements(varFileLine, table, tableSpaceDB2);
            this.addCreatedObject(this.getField(varFileLine, "general_id"), table);
            this.removeSelectedLine(varFileLine);
        } else {
            String string2 = this.getField(varFileLine, "general_id");
            Table table = (Table)this.getAllCreatedObjects().get(string2);
            if (table == null) {
                String string3 = this.getField(varFileLine, "table_name");
                table = (Table)this.getDesign().getRelationalDesign().getTableSet().getByName(string3);
                if (table != null) {
                    this.addCreatedObject(this.getField(varFileLine, "general_id"), table);
                } else {
                    table = this.getPhysicalDesign().getTableSet().createTable(null);
                    this.addCreatedObject(this.getField(varFileLine, "general_id"), table);
                }
            }
            if (table != null) {
                this.fillElements(varFileLine, table, tableSpaceDB2);
                this.removeSelectedLine(varFileLine);
            }
        }
    }

    private void fillRows(VarFileLine varFileLine, TableProxyDB2 tableProxyDB2) {
        this.fillMaxRows(varFileLine, tableProxyDB2);
        this.fillInitRows(varFileLine, tableProxyDB2);
    }

    private String getComment(VarFileLine varFileLine) {
        String string = null;
        if (!this.getField(varFileLine, "table_text").equalsIgnoreCase("0")) {
            VarFileLine varFileLine2 = this.getCommentLine(this.getField(varFileLine, "table_text"), "TEXT");
            if (varFileLine2 != null) {
                string = this.getField(varFileLine2, "text_comment");
            }
        } else {
            string = "";
        }
        return string;
    }

    private void fillDataCapture(VarFileLine varFileLine, TableProxyDB2 tableProxyDB2) {
        String string = this.getField(varFileLine, "table_DATA_CAPTURE");
        if (string.equalsIgnoreCase("0")) {
            tableProxyDB2.setDataCapture(false);
        } else {
            tableProxyDB2.setDataCapture(true);
        }
    }

    private void fillObid(VarFileLine varFileLine, TableProxyDB2 tableProxyDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "table_OBID"));
            if (n > 0) {
                tableProxyDB2.setObid(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHTable.fillObid : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL OBID format near " + varFileLine);
        }
    }

    private void fillAudit(VarFileLine varFileLine, TableProxyDB2 tableProxyDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "table_AUDIT"));
            String[] stringArray = TableProxyDB2.getAuditChoices();
            switch (n) {
                case 1: 
                case 2: 
                case 3: {
                    tableProxyDB2.setAudit(stringArray[n - 1]);
                    break;
                }
                default: {
                    tableProxyDB2.setAudit(stringArray[0]);
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHTable.fillAudit : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL AUDIT format near " + varFileLine);
        }
    }

    private void fillInitRows(VarFileLine varFileLine, TableProxyDB2 tableProxyDB2) {
        try {
            long l = Long.parseLong(this.getField(varFileLine, "table_INIT_ROWS"));
            if (l >= 1L) {
                tableProxyDB2.setInitialRowNumber(l);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHTable.fillInitRows : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL INIT ROWS format near " + varFileLine);
        }
    }

    private void fillMaxRows(VarFileLine varFileLine, TableProxyDB2 tableProxyDB2) {
        try {
            long l = Long.parseLong(this.getField(varFileLine, "table_MAX_ROWS"));
            if (l >= 1L) {
                tableProxyDB2.setMaxRowNumber(l);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHTable.fillMaxRows : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL MAX ROWS format near " + varFileLine);
        }
    }

    private void fillInsertRate(VarFileLine varFileLine, TableProxyDB2 tableProxyDB2) {
        try {
            float f = Float.parseFloat(this.getField(varFileLine, "table_INSERT_RATE"));
            if ((double)f >= -3.4E38) {
                tableProxyDB2.setAnnualUpdateRateInsert(f);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHTable.fillInsertRate : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL INSERT RATE format near " + varFileLine);
        }
    }

    private void fillDeleteRate(VarFileLine varFileLine, TableProxyDB2 tableProxyDB2) {
        try {
            float f = Float.parseFloat(this.getField(varFileLine, "table_DELETE_RATE"));
            if ((double)f >= -3.4E38) {
                tableProxyDB2.setAnnualUpdateRateDelete(f);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHTable.fillDeleteRate : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL DELETE RATE format near " + varFileLine);
        }
    }

    private void fillGrowthHorizon(VarFileLine varFileLine, TableProxyDB2 tableProxyDB2) {
        try {
            float f = Float.parseFloat(this.getField(varFileLine, "table_GROWTH_HORIZON"));
            if ((double)f >= -3.4E38) {
                tableProxyDB2.setGrowthHorizon((int)f);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHTable.fillGrowthHorizon : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL GROWTH HORIZON format near " + varFileLine);
        }
    }

    private void fillActiveInserts(VarFileLine varFileLine, TableProxyDB2 tableProxyDB2) {
        try {
            float f = Float.parseFloat(this.getField(varFileLine, "table_ACTIVE_INSERTS"));
            if ((double)f >= -3.4E38) {
                tableProxyDB2.setActiveGroupInsert(f);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHTable.fillActiveInserts : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL ACTIVE INSERTS format near " + varFileLine);
        }
    }

    private void fillActiveDel(VarFileLine varFileLine, TableProxyDB2 tableProxyDB2) {
        try {
            float f = Float.parseFloat(this.getField(varFileLine, "table_ACTIVE_DEL"));
            if ((double)f >= -3.4E38) {
                tableProxyDB2.setActiveGroupDelete(f);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHTable.fillActiveDel : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL ACTIVE DEL format near " + varFileLine);
        }
    }

    private void fillActiveData(VarFileLine varFileLine, TableProxyDB2 tableProxyDB2) {
        try {
            float f = Float.parseFloat(this.getField(varFileLine, "table_ACTIVE_DATA"));
            if ((double)f >= -3.4E38) {
                tableProxyDB2.setActiveGroupData(f);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHTable.fillActiveData : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL ACTIVE DATA format near " + varFileLine);
        }
    }

    private void fillGrowthMethod(VarFileLine varFileLine, TableProxyDB2 tableProxyDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "table_GROWTH_METHOD"));
            String[] stringArray = TableProxyDB2.getGrowthMethodChoices();
            switch (n) {
                case 1: 
                case 2: 
                case 3: {
                    tableProxyDB2.setGrowthMethod(stringArray[n - 1]);
                    break;
                }
                default: {
                    tableProxyDB2.setGrowthMethod(stringArray[0]);
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHTable.fillGrowthMethod : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
        }
    }

    private void fillExcludeFreespace(VarFileLine varFileLine, TableProxyDB2 tableProxyDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "table_EXCLUDE_FREESPACE"));
            if (n == 0) {
                tableProxyDB2.setFreepageExcluded(false);
            } else if (n == 1) {
                tableProxyDB2.setFreepageExcluded(true);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHTable.fillExcludeFreespace : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL EXCLUDE FREESPACE format near " + varFileLine);
        }
    }

    private void fillCatalogCard(VarFileLine varFileLine, TableProxyDB2 tableProxyDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "table_catalog_card"));
            if (n > 0) {
                tableProxyDB2.setNumberOfRows(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHTable.fillCatalogCard : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL CATALOG CARD format near " + varFileLine);
        }
    }

    private void fillCatalogRecLength(VarFileLine varFileLine, TableProxyDB2 tableProxyDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "table_CATALOG_REC_LENGTH"));
            if (n > 0) {
                tableProxyDB2.setRecordLength(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHTable.fillCatalogRecLength : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL CATALOG REC LENGTH format near " + varFileLine);
        }
    }

    private void fillCatalogNpages(VarFileLine varFileLine, TableProxyDB2 tableProxyDB2) {
        try {
            float f = Float.parseFloat(this.getField(varFileLine, "table_CATALOG_NPAGES"));
            if (f > 0.0f) {
                tableProxyDB2.setNumberOfPages((int)f);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHTable.fillCatalogNpages : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL CATALOG NPAGES format near " + varFileLine);
        }
    }

    private void fillPctPages(VarFileLine varFileLine, TableProxyDB2 tableProxyDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "table_PCTPAGES"));
            if (n > 0) {
                tableProxyDB2.setPercentageOfPages(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHTable.fillPctPages : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL PCT PAGES format near " + varFileLine);
        }
    }

    private void fillLabelOn(VarFileLine varFileLine, TableProxyDB2 tableProxyDB2) {
        String string = this.getField(varFileLine, "table_LABEL_ON");
        tableProxyDB2.setLabel(string);
    }

    private void fillCreatedBy(VarFileLine varFileLine, TableProxyDB2 tableProxyDB2) {
        String string = this.getField(varFileLine, "TABLE_CREATED_BY");
        tableProxyDB2.setCreatedBy(string);
    }

    private void fillCommontOn(VarFileLine varFileLine, TableProxyDB2 tableProxyDB2) {
        String string = this.getField(varFileLine, "table_description");
        for (VarFileLine varFileLine2 : this.getAllSelectedLines()) {
            if (!varFileLine2.getType().equalsIgnoreCase("TEXT") || !this.getField(varFileLine2, "general_id").equalsIgnoreCase(string)) continue;
            String string2 = this.getField(varFileLine2, "text_comment");
            tableProxyDB2.setCommentInRDBMS(string2);
        }
    }

    private void fillOwner(VarFileLine varFileLine, TableProxyDB2 tableProxyDB2) {
        int n = (Integer)this.getFieldConstants().get("IS_COOL");
        if (n == 1000) {
            String string = this.getField(varFileLine, "table_AUTHID");
            Owner owner = (Owner)this.getAllCreatedObjects().get(string);
            if (owner == null) {
                owner = (Owner)((AbstractStorageDesignDB2)tableProxyDB2.getStorageDesign()).getOwnerSet().createElement(null);
                owner.setName(string);
                this.addCreatedObject(string, owner);
            }
            tableProxyDB2.setOwner(owner);
        } else {
            String string = this.getField(varFileLine, "table_AUTHID");
            Owner owner = (Owner)this.getAllCreatedObjects().get(string);
            tableProxyDB2.setOwner(owner);
        }
    }

    protected void fillElements(VarFileLine varFileLine, Table table, TableSpaceDB2 tableSpaceDB2) {
        String string = this.getField(varFileLine, "table_name");
        table.setName(string);
        this.setCreatorChanger(table, varFileLine);
        table.setComment(this.getComment(varFileLine));
        RDBMSSite rDBMSSite = this.getDesign().getSelectedRDBMSSite();
        StorageDesignDB2v70 storageDesignDB2v70 = (StorageDesignDB2v70)this.getDesign().getStorageDesign(rDBMSSite);
        TableProxySetDB2 tableProxySetDB2 = (TableProxySetDB2)storageDesignDB2v70.getTableProxySet();
        TableProxyDB2 tableProxyDB2 = (TableProxyDB2)tableProxySetDB2.getProxy(table.getObjectID());
        if (tableProxyDB2 != null) {
            this.fillOwner(varFileLine, tableProxyDB2);
            this.fillDataCapture(varFileLine, tableProxyDB2);
            this.fillObid(varFileLine, tableProxyDB2);
            tableProxyDB2.setTableSpace(tableSpaceDB2);
            tableProxyDB2.setEditProc(this.getField(varFileLine, "table_EDITPROC"));
            tableProxyDB2.setValidProc(this.getField(varFileLine, "table_EDITPROC"));
            this.fillAudit(varFileLine, tableProxyDB2);
            this.fillRows(varFileLine, tableProxyDB2);
            this.fillInsertRate(varFileLine, tableProxyDB2);
            this.fillDeleteRate(varFileLine, tableProxyDB2);
            this.fillGrowthHorizon(varFileLine, tableProxyDB2);
            this.fillActiveInserts(varFileLine, tableProxyDB2);
            this.fillActiveDel(varFileLine, tableProxyDB2);
            this.fillActiveData(varFileLine, tableProxyDB2);
            this.fillGrowthMethod(varFileLine, tableProxyDB2);
            this.fillExcludeFreespace(varFileLine, tableProxyDB2);
            this.fillCatalogCard(varFileLine, tableProxyDB2);
            this.fillCatalogRecLength(varFileLine, tableProxyDB2);
            this.fillCatalogNpages(varFileLine, tableProxyDB2);
            this.fillPctPages(varFileLine, tableProxyDB2);
            this.fillLabelOn(varFileLine, tableProxyDB2);
            this.fillCreatedBy(varFileLine, tableProxyDB2);
            this.fillCommontOn(varFileLine, tableProxyDB2);
        }
    }
}

