/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.v70.IndexProxyDB2v70;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.util.logging.Logger;

public class RHPrimaryKey
extends RowHandler {
    private boolean columnsAreAdded = true;
    public static final String OBJECT_TYPE = "PRIMARY_KEY";
    public static final String OBJECT_TYPE_COOL = "PRIMARY_KEYS";
    private static final String NAME_PRIMARY = "PRIMARY";
    private static final String NAME_PKEY = "PKEY";
    private static final Logger LOGGER = new Logger(RHPrimaryKey.class);

    public RHPrimaryKey(Design design, Fields fields, List list, Map map, List list2, List list3, Map map2, List list4, List list5) {
        super(design, fields, list, map, list2, list3, map2, list4, list5);
    }

    @Override
    public void read(VarFileLine varFileLine) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE) || varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE_COOL)) {
            this.addSelectedLine(varFileLine);
            this.addPrimaryKeyLine(varFileLine);
        } else {
            this.nextRead(varFileLine);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(OBJECT_TYPE);
        arrayList.add(OBJECT_TYPE_COOL);
        return arrayList;
    }

    @Override
    public void handle(VarFileLine varFileLine, boolean bl) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE) || varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE_COOL)) {
            this.createPrimaryKey(varFileLine, bl);
        } else {
            this.nextHandler(varFileLine, bl);
        }
    }

    private void createPrimaryKey(VarFileLine varFileLine, boolean bl) {
        if (!bl) {
            Index index = this.getIndexForPK(varFileLine);
            if (index != null) {
                String string = this.getField(varFileLine, "index_name");
                if (NAME_PRIMARY.equalsIgnoreCase(string)) {
                    string = NAME_PKEY;
                }
                index.setName(string);
                String string2 = this.getField(varFileLine, "pk_or_ak");
                if (string2.equals("1")) {
                    index.makePK();
                } else {
                    index.setUnique(true);
                }
                this.fillElements(varFileLine, index);
                this.addCreatedObject(this.getField(varFileLine, "general_id"), index);
                String string3 = this.getField(varFileLine, "PK_COLJCT_5_INDEX");
                List list = this.getColumnFromSelected(string3);
                int n = 0;
                for (Column column : list) {
                    if (!index.contains(column)) {
                        index.add(column);
                    }
                    index.moveToIndex(column, n);
                    ++n;
                }
                this.removeSelectedLine(varFileLine);
            }
        } else {
            String string = this.getField(varFileLine, "general_id");
            Index index = (Index)this.getAllCreatedObjects().get(string);
            if (index != null && index.isPK()) {
                String string4 = this.getField(varFileLine, "index_name");
                if (NAME_PRIMARY.equalsIgnoreCase(string4)) {
                    string4 = NAME_PKEY;
                }
                index.setName(string4);
                this.fillElements(varFileLine, index);
                String string5 = this.getField(varFileLine, "PK_COLJCT_5_INDEX");
                List list = this.getColumnFromSelected(string5);
                int n = 0;
                for (Column column : list) {
                    if (!index.contains(column)) {
                        index.add(column);
                    }
                    index.moveToIndex(column, n);
                    ++n;
                }
                this.removeSelectedLine(varFileLine);
            } else {
                index = this.getIndexForPK(varFileLine);
                if (index != null) {
                    index.setName(this.getField(varFileLine, "index_name"));
                    String string6 = this.getField(varFileLine, "pk_or_ak");
                    if (string6.equals("1")) {
                        index.makePK();
                    } else {
                        index.setUnique(true);
                    }
                    this.fillElements(varFileLine, index);
                    this.addCreatedObject(this.getField(varFileLine, "general_id"), index);
                    this.removeSelectedLine(varFileLine);
                } else {
                    LOGGER.error("Index is not found in getAllCreatedObjects() for RHPrimaryKey.createPrimaryKey()");
                    this.importLog.addError("Unknown primary key index near " + varFileLine);
                }
            }
        }
    }

    private List getColumnFromSelected(String string) {
        ContainedObject containedObject;
        TreeMap<Integer, ContainedObject> treeMap = new TreeMap<Integer, ContainedObject>();
        Integer n = new Integer(3);
        ArrayList<ContainedObject> arrayList = new ArrayList<ContainedObject>();
        for (Object object : this.getAllSelectedLines()) {
            if (!((VarFileLine)object).getType().equalsIgnoreCase("COLJCT") || !this.getField((VarFileLine)object, "COLJCT_5_KEY").equalsIgnoreCase(string) || (containedObject = (Column)this.getCreatedObject(this.getField((VarFileLine)object, "COLJCT_COLUMN_KEY"))) == null) continue;
            String string2 = this.getField(((VarFileLine)object).getLine(), n);
            int n2 = Integer.parseInt(string2);
            treeMap.put(new Integer(n2), containedObject);
        }
        for (Object object : treeMap.keySet()) {
            containedObject = (ContainedObject)treeMap.get(object);
            if (containedObject == null) continue;
            arrayList.add(containedObject);
        }
        return arrayList;
    }

    private Index getIndexForPK(VarFileLine varFileLine) {
        this.columnsAreAdded = true;
        Index index = null;
        int n = (Integer)this.getFieldConstants().get("IS_COOL");
        if (n == 1000) {
            String string = this.getField(varFileLine, "primarykey_index_id").trim();
            if (string.equals("0")) {
                Object object2;
                String string2 = this.getField(varFileLine, "primarykey_column_set").trim();
                String string3 = null;
                for (Object object2 : this.getAllSelectedLines()) {
                    if (!((VarFileLine)object2).getType().equals("COLUMN_SET") || !this.getField((VarFileLine)object2, "general_id").trim().equals(string2)) continue;
                    string3 = this.getField((VarFileLine)object2, "COLUMNSET_table").trim();
                }
                object2 = (Table)this.getAllCreatedObjects().get(string3);
                List list = this.getColumnsToPutOnIndex(varFileLine);
                if (this.columnsAreAdded && object2 != null) {
                    index = ((Table)object2).createIndex();
                    for (Column column : list) {
                        index.add(column);
                    }
                }
            } else {
                index = (Index)this.getAllCreatedObjects().get(string);
            }
        } else {
            String string = this.getField(varFileLine, "primarykey_index_id").trim();
            if (string.equals("0")) {
                String string4 = this.getField(varFileLine, "primarykey_cool_tableid");
                Table table = (Table)this.getAllCreatedObjects().get(string4);
                List list = this.getColumnsToPutOnIndex(varFileLine);
                if (this.columnsAreAdded && table != null) {
                    index = table.createIndex();
                    for (Column column : list) {
                        index.add(column);
                    }
                }
            } else {
                index = (Index)this.getAllCreatedObjects().get(string);
            }
        }
        return index;
    }

    private List getColumnsToPutOnIndex(VarFileLine varFileLine) {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        String string = this.getField(varFileLine, "primarykey_coljct5");
        int n = (Integer)this.getFieldConstants().get("IS_COOL");
        if (n == 1000) {
            for (VarFileLine varFileLine2 : this.getAllSelectedLines()) {
                String string2;
                if (!varFileLine2.getType().equals("COLUMN_SETTABLE_CO") || !(string2 = this.getField(varFileLine2, "general_id").trim()).equals(string)) continue;
                String string3 = this.getField(varFileLine2, "COLUMNSETTABLE_TABLECOLUMN");
                Column column = (Column)this.getAllCreatedObjects().get(string3);
                if (column != null) {
                    arrayList.add(column);
                    continue;
                }
                this.columnsAreAdded = false;
            }
        } else {
            for (VarFileLine varFileLine3 : this.getAllSelectedLines()) {
                String string4;
                if (!varFileLine3.getType().equals("COLJCT") || !(string4 = this.getField(varFileLine3, "COLJCT_5_KEY").trim()).equals(string)) continue;
                String string5 = this.getField(varFileLine3, "COLJCT_COLUMN_KEY");
                Column column = (Column)this.getAllCreatedObjects().get(string5);
                if (column != null) {
                    arrayList.add(column);
                    continue;
                }
                this.columnsAreAdded = false;
            }
        }
        return arrayList;
    }

    protected void fillElements(VarFileLine varFileLine, Index index) {
        index.makeValidPKIfNotEmpty();
        RDBMSSite rDBMSSite = this.getDesign().getSelectedRDBMSSite();
        StorageDesignDB2v70 storageDesignDB2v70 = (StorageDesignDB2v70)this.getDesign().getStorageDesign(rDBMSSite);
        IndexProxyDB2v70 indexProxyDB2v70 = (IndexProxyDB2v70)storageDesignDB2v70.getIndexProxySet().getProxy(index.getObjectID());
        if (indexProxyDB2v70 != null) {
            indexProxyDB2v70.setNoIntegrity(true);
            try {
                int n = Integer.parseInt(this.getField(varFileLine, "primarykey_generate"));
                if (n == 0) {
                    indexProxyDB2v70.setGeneratedInRDBMS(false);
                } else if (n == 1) {
                    indexProxyDB2v70.setGeneratedInRDBMS(true);
                }
            }
            catch (NumberFormatException numberFormatException) {
                StringBuffer stringBuffer = new StringBuffer("wrong Format in RHPrimaryKey.createPrimaryKey : ");
                stringBuffer.append(varFileLine.getLine());
                LOGGER.error(stringBuffer.toString(), numberFormatException);
                this.importLog.addWarning("Wrong primary key syntax near " + varFileLine);
            }
        }
    }
}

