/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.util.logging.Logger;

public class RHIndex
extends RowHandler {
    public static final String OBJECT_TYPE = "INDEX";
    private boolean columnNotExist = false;
    private Hashtable mapColumnSortType;
    private Index index;
    private static final Logger LOGGER = new Logger(RHIndex.class);

    public RHIndex(Design design, Fields fields, List list, Map map, List list2, List list3, Map map2, List list4, List list5) {
        super(design, fields, list, map, list2, list3, map2, list4, list5);
    }

    @Override
    public void read(VarFileLine varFileLine) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.addSelectedLine(varFileLine);
        } else {
            this.nextRead(varFileLine);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(OBJECT_TYPE);
        return arrayList;
    }

    @Override
    public void handle(VarFileLine varFileLine, boolean bl) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.createIndex(varFileLine, bl);
        } else {
            this.nextHandler(varFileLine, bl);
        }
    }

    private void createIndex(VarFileLine varFileLine, boolean bl) {
        this.columnNotExist = false;
        this.mapColumnSortType = new Hashtable();
        StorageGroupDB2 storageGroupDB2 = (StorageGroupDB2)this.getCreatedObject(this.getField(varFileLine, "STORAGEGROUP"));
        VCatDB2 vCatDB2 = (VCatDB2)this.getCreatedObject(this.getField(varFileLine, "VCAT"));
        Table table = (Table)this.getCreatedObject(this.getField(varFileLine, "index_table_id"));
        List list = this.getColumnFromSelected(this.getField(varFileLine, "coljct5"));
        boolean bl2 = false;
        if (table != null && !this.columnNotExist) {
            if (!bl) {
                Object object2;
                this.index = null;
                String string = null;
                String string2 = this.getField(varFileLine, "coljct5").trim();
                for (Object object2 : this.getAllPrimaryKeyLines()) {
                    String string3 = this.getField((VarFileLine)object2, "primarykey_coljct5").trim();
                    if (!string2.equalsIgnoreCase(string3)) continue;
                    string = this.getField((VarFileLine)object2, "general_id").trim();
                    break;
                }
                this.index = (Index)this.getAllCreatedObjects().get(string);
                object2 = this.getField(varFileLine, "index_name");
                if (this.index == null || !((String)object2).equalsIgnoreCase(this.index.getName())) {
                    this.index = table.createIndex();
                    for (Column column : list) {
                        String string4 = (String)this.mapColumnSortType.get(column);
                        this.index.add(column);
                        if (!"1".equalsIgnoreCase(string4)) continue;
                        this.index.setColumnSortOrder(column, "DESC");
                    }
                    this.index.setName((String)object2);
                }
                this.fillElements(varFileLine, this.index, table, storageGroupDB2, vCatDB2, true);
                this.addCreatedObject(this.getField(varFileLine, "general_id"), this.index);
                this.removeSelectedLine(varFileLine);
            } else {
                String string = this.getField(varFileLine, "general_id");
                this.index = (Index)this.getAllCreatedObjects().get(string);
                if (this.index != null) {
                    if (table.getKeyObject(this.index.getObjectID()) == null) {
                        this.index = table.createIndex();
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            CharSequence charSequence;
                            try {
                                Column column = (Column)iterator.next();
                                charSequence = (String)this.mapColumnSortType.get(column);
                                this.index.add(column);
                                if (!"1".equalsIgnoreCase((String)charSequence)) continue;
                                this.index.setColumnSortOrder(column, "DESC");
                            }
                            catch (Exception exception) {
                                charSequence = new StringBuffer("1 error adding columns in RHIndex.createIndex() ");
                                ((StringBuffer)charSequence).append(varFileLine.getLine());
                                LOGGER.error(((StringBuffer)charSequence).toString(), exception);
                                this.importLog.addError("Error adding column to index " + this.index.toString());
                            }
                        }
                    }
                } else {
                    this.index = table.createIndex();
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        CharSequence charSequence;
                        try {
                            Column column = (Column)iterator.next();
                            charSequence = (String)this.mapColumnSortType.get(column);
                            this.index.add(column);
                            if (!"1".equalsIgnoreCase((String)charSequence)) continue;
                            this.index.setColumnSortOrder(column, "DESC");
                        }
                        catch (Exception exception) {
                            charSequence = new StringBuffer("2 error adding columns in RHIndex.createIndex() ");
                            ((StringBuffer)charSequence).append(varFileLine.getLine());
                            LOGGER.error(((StringBuffer)charSequence).toString(), exception);
                            this.importLog.addError("Error adding column to index " + this.index.toString());
                        }
                    }
                    this.fillElements(varFileLine, this.index, table, storageGroupDB2, vCatDB2, bl2);
                    this.addCreatedObject(this.getField(varFileLine, "general_id"), this.index);
                    this.removeSelectedLine(varFileLine);
                }
            }
        }
    }

    private List getColumnFromSelected(String string) {
        ContainedObject containedObject;
        TreeMap<Integer, ContainedObject> treeMap = new TreeMap<Integer, ContainedObject>();
        Integer n = new Integer(3);
        ArrayList<ContainedObject> arrayList = new ArrayList<ContainedObject>();
        for (Object object : this.getAllSelectedLines()) {
            if (!((VarFileLine)object).getType().equalsIgnoreCase("COLJCT") || !this.getField((VarFileLine)object, "COLJCT_5_KEY").equalsIgnoreCase(string)) continue;
            containedObject = (Column)this.getCreatedObject(this.getField((VarFileLine)object, "COLJCT_COLUMN_KEY"));
            String string2 = this.getField((VarFileLine)object, "COLJCT_5_SORT_TYPE");
            String string3 = this.getField(((VarFileLine)object).getLine(), n);
            int n2 = Integer.parseInt(string3);
            if (containedObject != null) {
                treeMap.put(new Integer(n2), containedObject);
                this.mapColumnSortType.put(containedObject, string2);
                continue;
            }
            this.columnNotExist = true;
        }
        for (Object object : treeMap.keySet()) {
            containedObject = (ContainedObject)treeMap.get(object);
            if (containedObject == null) continue;
            arrayList.add(containedObject);
        }
        return arrayList;
    }

    protected int getPosition(String string) {
        List list = this.getAllColumnLines();
        for (VarFileLine varFileLine : list) {
            String string2 = this.getField(varFileLine, "general_id");
            if (!string2.equals(string)) continue;
            try {
                int n = Integer.parseInt(this.getField(varFileLine, "COLUMN_ORDNUM"));
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                StringBuffer stringBuffer = new StringBuffer("wrong Format in RHIndex.getPosition : ");
                stringBuffer.append(varFileLine.getLine());
                LOGGER.error(stringBuffer.toString(), numberFormatException);
                this.importLog.addError("Wrong column position format near " + varFileLine);
            }
        }
        return 0;
    }

    private void fillClustered(VarFileLine varFileLine, IndexProxyDB2 indexProxyDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "CLUSTERED"));
            switch (n) {
                case 0: {
                    indexProxyDB2.setClustered(false);
                    break;
                }
                case 1: {
                    indexProxyDB2.setClustered(true);
                    break;
                }
                default: {
                    indexProxyDB2.setClustered(false);
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHIndex.fillClustered : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL CLUSTER format near " + varFileLine);
        }
    }

    private void fillClusterType(VarFileLine varFileLine, IndexProxyDB2 indexProxyDB2) {
        try {
            String string = this.getField(varFileLine, "CLUSTERED").trim();
            if (string.equals("1")) {
                List list = this.getPartIndexKeys(this.getField(varFileLine, "general_id"));
                if (list.size() > 0) {
                    indexProxyDB2.setClusterType(IndexProxyDB2.CLUSTER_TYPES[2]);
                } else {
                    indexProxyDB2.setClusterType(IndexProxyDB2.CLUSTER_TYPES[1]);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHIndex.fillClusterType : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong CLUSTER TYPE format near " + varFileLine);
        }
    }

    private List getPartIndexKeys(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = null;
        for (VarFileLine varFileLine : this.getAllSelectedLines()) {
            if (!varFileLine.getType().equalsIgnoreCase("PARTITION_BOUNDARY")) continue;
            string2 = this.getField(varFileLine, "PARTITION_BOUNDARY_PARTID");
            Iterator iterator = this.getAllSelectedLines().iterator();
            String string3 = null;
            while (iterator.hasNext()) {
                VarFileLine varFileLine2 = (VarFileLine)iterator.next();
                if (!varFileLine2.getType().equalsIgnoreCase("PARTITIONS") || !this.getField(varFileLine2, "general_id").equalsIgnoreCase(string2) || !string.equalsIgnoreCase(string3 = this.getField(varFileLine2, "TABLESPACE_PART_INDEX_KEY"))) continue;
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    private void fillClusteredRatio(VarFileLine varFileLine, IndexProxyDB2 indexProxyDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "CLUSTEREDRATIO"));
            if (n > 0) {
                indexProxyDB2.setClusterRatio(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHIndex.fillClusterdRatio : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong CLUSTER RATIO format near " + varFileLine);
        }
    }

    private void fillCloseRule(VarFileLine varFileLine, IndexProxyDB2 indexProxyDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "CLOSERULE"));
            if (n == 0) {
                indexProxyDB2.setClose(false);
            } else if (n == 1) {
                indexProxyDB2.setClose(true);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHIndex.fillCloseRule : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL CLOSE RULE format near " + varFileLine);
        }
    }

    private void fillEraseRule(VarFileLine varFileLine, IndexProxyDB2 indexProxyDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "ERASERULE"));
            if (n == 0) {
                indexProxyDB2.getStorageTemplate().setSgErase(false);
            } else if (n == 1) {
                indexProxyDB2.getStorageTemplate().setSgErase(true);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHIndex.fillEraseRule : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL ERASE RULE format near " + varFileLine);
        }
    }

    private void fillFreepage(VarFileLine varFileLine, IndexProxyDB2 indexProxyDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "FREEPAGE"));
            if (n >= 0) {
                indexProxyDB2.getStorageTemplate().setFreePage(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHIndex.fillFreepage : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL FREE PAGE format near " + varFileLine);
        }
    }

    private void fillInterval(VarFileLine varFileLine, IndexProxyDB2 indexProxyDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "INTERVAL"));
            if (n > 0) {
                indexProxyDB2.setMaintenanceInterval(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHIndex.fillInterval : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL INTERVAL format near " + varFileLine);
        }
    }

    private void fillPctfree(VarFileLine varFileLine, IndexProxyDB2 indexProxyDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "PCTFREE"));
            if (n >= 0) {
                indexProxyDB2.getStorageTemplate().setPctFree(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHIndex.fillPctfree : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL PCT FREE format near " + varFileLine);
        }
    }

    private void fillPriqty(VarFileLine varFileLine, IndexProxyDB2 indexProxyDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "PRIQTY"));
            if (n > -1) {
                indexProxyDB2.getStorageTemplate().setSgPriqty(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHIndex.fillPriqty : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL PRIQTY format near " + varFileLine);
        }
    }

    private void fillSecqty(VarFileLine varFileLine, IndexProxyDB2 indexProxyDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "SECQTY"));
            if (n > -1) {
                indexProxyDB2.getStorageTemplate().setSgSeqty(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHIndex.fillSecqty : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL SECQTY format near " + varFileLine);
        }
    }

    private void fillSpaceAlloc(VarFileLine varFileLine, IndexProxyDB2 indexProxyDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "SPACE_ALLOC"));
            if (n >= 0) {
                indexProxyDB2.setSpaceAllocationInterval(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHIndex.fillSpaceAlloc : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL SPACE ALLOC format near " + varFileLine);
        }
    }

    private void fillPieceSize(VarFileLine varFileLine, IndexProxyDB2 indexProxyDB2) {
        try {
            String string = this.getField(varFileLine, "PIECESIZE");
            if (Integer.parseInt(string) > 0) {
                indexProxyDB2.setPieceSize(string + " K");
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHIndex.fillPieceSize : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL PIECE SIZE format near " + varFileLine);
        }
    }

    private void fillGBCache(VarFileLine varFileLine, IndexProxyDB2 indexProxyDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "BG_CACHE"));
            if (n == 1) {
                indexProxyDB2.getStorageTemplate().setGbCache(StorageTemplateDB2.GBCACHE[1]);
            } else if (n == 2) {
                indexProxyDB2.getStorageTemplate().setGbCache(StorageTemplateDB2.GBCACHE[2]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHIndex.fillGBCache : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL GB CACHE format near " + varFileLine);
        }
    }

    private void fillDefer(VarFileLine varFileLine, IndexProxyDB2 indexProxyDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "DEFER"));
            if (n == 0) {
                indexProxyDB2.setDefer(false);
            } else if (n == 1) {
                indexProxyDB2.setDefer(true);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHIndex.fillDefer : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL DEFER format near " + varFileLine);
        }
    }

    private void fillUnique(IndexProxyDB2 indexProxyDB2, Index index, VarFileLine varFileLine) {
        String string = null;
        String string2 = null;
        int n = (Integer)this.getFieldConstants().get("IS_COOL");
        if (n == 1000) {
            String string3 = this.getField(varFileLine, "COLUMNSET_KEY").trim();
            List list = this.getAllSelectedLines();
            for (VarFileLine varFileLine2 : list) {
                if (!varFileLine2.getType().equalsIgnoreCase("COLUMN_SET") || !string3.equalsIgnoreCase(this.getField(varFileLine2, "general_id"))) continue;
                string = this.getField(varFileLine2, "COLUMNSET_COLSET_UNIQUE").trim();
                if (string.equals("1")) {
                    index.setIndexState("Unique Plain Index");
                    continue;
                }
                if (!string.equals("2")) continue;
                index.setIndexState("Unique Plain Index");
                indexProxyDB2.setWhereNotNull(true);
            }
        } else {
            String string4 = this.getField(varFileLine, "cool_where_not_null").trim();
            string = this.getField(varFileLine, "cool_unique").trim();
            string2 = this.getField(varFileLine, "constraint").trim();
            if (string.equals("1")) {
                if (string2.equals("1")) {
                    index.setIndexState("Unique Plain Index");
                } else {
                    index.setIndexState("Unique Plain Index");
                }
            }
            if (string4.equals("1")) {
                indexProxyDB2.setWhereNotNull(true);
            }
        }
    }

    private void fillBufferpool(VarFileLine varFileLine, IndexProxyDB2 indexProxyDB2) {
        String string = this.getField(varFileLine, "BUFFERPOOL");
        BufferPoolDB2 bufferPoolDB2 = (BufferPoolDB2)this.getCreatedObject(string);
        if (bufferPoolDB2 != null) {
            indexProxyDB2.setBufferPool(bufferPoolDB2);
        }
    }

    private void fillCommentOn(VarFileLine varFileLine, IndexProxyDB2 indexProxyDB2) {
        String string = this.getField(varFileLine, "TEXT");
        for (VarFileLine varFileLine2 : this.getAllSelectedLines()) {
            if (!varFileLine2.getType().equalsIgnoreCase("TEXT") || !this.getField(varFileLine2, "general_id").equalsIgnoreCase(string)) continue;
            String string2 = this.getField(varFileLine2, "text_comment");
            indexProxyDB2.setCommentInRDBMS(string2);
        }
    }

    private void fillOwner(VarFileLine varFileLine, IndexProxyDB2 indexProxyDB2, Table table) {
        int n = (Integer)this.getFieldConstants().get("IS_COOL");
        if (n == 1000) {
            String string = this.getField(varFileLine, "CREATE_BY");
            Owner owner = (Owner)this.getAllCreatedObjects().get(string);
            if (owner == null) {
                owner = (Owner)((AbstractStorageDesignDB2)indexProxyDB2.getStorageDesign()).getOwnerSet().createElement(null);
                owner.setName(string);
                this.addCreatedObject(string, owner);
            }
            indexProxyDB2.setOwner(owner);
        } else {
            TableProxyDB2 tableProxyDB2 = (TableProxyDB2)indexProxyDB2.getStorageDesign().getTableProxySet().getProxy(table.getObjectID());
            indexProxyDB2.setOwner(tableProxyDB2.getOwner());
        }
    }

    private void fillUpdateRate(VarFileLine varFileLine, IndexProxyDB2 indexProxyDB2) {
        try {
            float f = Float.parseFloat(this.getField(varFileLine, "UPDATE_RATE"));
            indexProxyDB2.setUpdateRatePercent(f *= 100.0f);
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHIndex.fillUpdateRate : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL UPDATE RATE format near " + varFileLine);
        }
    }

    protected void fillElements(VarFileLine varFileLine, Index index, Table table, StorageGroupDB2 storageGroupDB2, VCatDB2 vCatDB2, boolean bl) {
        index.setComment(this.getComment(varFileLine));
        this.setCreatorChanger(index, varFileLine);
        RDBMSSite rDBMSSite = this.getDesign().getSelectedRDBMSSite();
        StorageDesignDB2v70 storageDesignDB2v70 = (StorageDesignDB2v70)this.getDesign().getStorageDesign(rDBMSSite);
        IndexProxyDB2 indexProxyDB2 = (IndexProxyDB2)storageDesignDB2v70.getIndexProxySet().getProxy(index.getObjectID());
        if (indexProxyDB2 != null) {
            indexProxyDB2.setAllowIntegrityIndexNR(false);
            if (bl) {
                indexProxyDB2.setName(this.getField(varFileLine, "index_name"));
            }
            indexProxyDB2.setNoIntegrity(true);
            StorageTemplateDB2 storageTemplateDB2 = storageDesignDB2v70.getStorageTemplateSet().createStorageTemplate();
            indexProxyDB2.setStorageTemplate(storageTemplateDB2);
            if (storageGroupDB2 != null) {
                indexProxyDB2.getStorageTemplate().setStorageGroup(storageGroupDB2);
            } else if (vCatDB2 != null) {
                indexProxyDB2.getStorageTemplate().setVCat(vCatDB2);
            }
            this.fillOwner(varFileLine, indexProxyDB2, table);
            if (!index.isPK() && !index.isUnique()) {
                this.fillUnique(indexProxyDB2, index, varFileLine);
            }
            this.fillClustered(varFileLine, indexProxyDB2);
            this.fillClusterType(varFileLine, indexProxyDB2);
            this.fillClusteredRatio(varFileLine, indexProxyDB2);
            indexProxyDB2.setCreatedBy(this.getField(varFileLine, "CREATE_BY"));
            this.fillCloseRule(varFileLine, indexProxyDB2);
            this.fillEraseRule(varFileLine, indexProxyDB2);
            this.fillFreepage(varFileLine, indexProxyDB2);
            this.fillInterval(varFileLine, indexProxyDB2);
            this.fillPctfree(varFileLine, indexProxyDB2);
            this.fillPriqty(varFileLine, indexProxyDB2);
            this.fillSecqty(varFileLine, indexProxyDB2);
            this.fillSpaceAlloc(varFileLine, indexProxyDB2);
            this.fillPieceSize(varFileLine, indexProxyDB2);
            this.fillDefer(varFileLine, indexProxyDB2);
            this.fillGBCache(varFileLine, indexProxyDB2);
            this.fillBufferpool(varFileLine, indexProxyDB2);
            this.fillUpdateRate(varFileLine, indexProxyDB2);
            this.fillCommentOn(varFileLine, indexProxyDB2);
            StorageTemplateDB2 storageTemplateDB22 = storageDesignDB2v70.getStorageTemplateSet().removeIfExistEqual(indexProxyDB2.getStorageTemplate());
            if (storageTemplateDB22 != indexProxyDB2.getStorageTemplate()) {
                indexProxyDB2.setStorageTemplate(storageTemplateDB22);
            }
        }
    }

    private String getComment(VarFileLine varFileLine) {
        String string = null;
        if (!this.getField(varFileLine, "INDEX_TEXT_ID").equalsIgnoreCase("0")) {
            VarFileLine varFileLine2 = this.getCommentLine(this.getField(varFileLine, "INDEX_TEXT_ID"), "TEXT");
            if (varFileLine2 != null) {
                string = this.getField(varFileLine2, "text_comment");
            }
        } else {
            string = "";
        }
        return string;
    }
}

