/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationReference;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.swingui.relational.TVTable;
import oracle.dbtools.crest.util.logging.Logger;

public class RHForeignKey
extends RowHandler {
    public static final String OBJECT_TYPE = "FOREIGN_KEY";
    public static final String OBJECT_TYPE_COOL = "FOREIGN_KEYS";
    public List lines = new ArrayList();
    private static final Logger LOGGER = new Logger(RHForeignKey.class);

    public RHForeignKey(Design design, Fields fields, List list, Map map, List list2, List list3, Map map2, List list4, List list5) {
        super(design, fields, list, map, list2, list3, map2, list4, list5);
    }

    @Override
    public void read(VarFileLine varFileLine) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE) || varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE_COOL)) {
            this.addSelectedLine(varFileLine);
            this.addForeignKeyLine(varFileLine);
        } else {
            this.nextRead(varFileLine);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(OBJECT_TYPE);
        arrayList.add(OBJECT_TYPE_COOL);
        return arrayList;
    }

    @Override
    public void handle(VarFileLine varFileLine, boolean bl) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE) || varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE_COOL)) {
            this.collectLines(varFileLine);
            this.createForeignKey(varFileLine, bl);
        } else {
            this.nextHandler(varFileLine, bl);
        }
    }

    private void collectLines(VarFileLine varFileLine) {
        int n = (Integer)this.getFieldConstants().get("IS_COOL");
        if (n != 1000 && !this.lines.contains(varFileLine)) {
            this.lines.add(varFileLine);
        }
    }

    @Override
    public List getOwnLines() {
        return this.lines;
    }

    private void createForeignKey(VarFileLine varFileLine, boolean bl) {
        Table table = (Table)this.getCreatedObject(this.getField(varFileLine, "foreignkey_table_id"));
        Index index = (Index)this.getCreatedObject(this.getField(varFileLine, "foreignkey_primarykey_id"));
        if (!bl) {
            String string = null;
            int n = (Integer)this.getFieldConstants().get("IS_COOL");
            string = n == 1000 ? this.getField(varFileLine, "FOREIGNKEY_COLUMNSET") : this.getField(varFileLine, "FOREIGNKEY_COLJCT5");
            if (table != null && index != null) {
                FKIndexAssociation fKIndexAssociation = table.addFK(index, null, null);
                fKIndexAssociation.setName(this.getField(varFileLine, "foreignkey_NAME"));
                this.fillElements(varFileLine, fKIndexAssociation, table);
                this.processFKColumns(fKIndexAssociation, string);
                if (fKIndexAssociation.getTopView() == null) {
                    this.getDesign().getRelationalDesign().getMainView().createViewFor(fKIndexAssociation);
                }
                if (fKIndexAssociation.getRemoteTable().getTopView() == null) {
                    this.getDesign().getRelationalDesign().getMainView().createViewFor(fKIndexAssociation.getRemoteTable());
                }
                if (fKIndexAssociation.getContainerWithKeyObject().getTopView() == null) {
                    this.getDesign().getRelationalDesign().getMainView().createViewFor(fKIndexAssociation.getContainerWithKeyObject());
                }
                fKIndexAssociation.setSourceTVTable((TVTable)fKIndexAssociation.getRemoteTable().getTopView());
                fKIndexAssociation.setTargetTVTable((TVTable)fKIndexAssociation.getContainerWithKeyObject().getTopView());
                this.addCreatedObject(this.getField(varFileLine, "general_id"), fKIndexAssociation);
                this.removeSelectedLine(varFileLine);
            }
        } else {
            String string = this.getField(varFileLine, "general_id");
            FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)this.getAllCreatedObjects().get(string);
            if (fKIndexAssociation != null) {
                this.fillElements(varFileLine, fKIndexAssociation, table);
                this.getDesign().getRelationalDesign().getMainView().createViewFor(fKIndexAssociation);
                this.getDesign().getRelationalDesign().getMainView().createViewFor(fKIndexAssociation.getRemoteTable());
                this.getDesign().getRelationalDesign().getMainView().createViewFor(fKIndexAssociation.getContainerWithKeyObject());
                fKIndexAssociation.setSourceTVTable((TVTable)fKIndexAssociation.getRemoteTable().getTopView());
                fKIndexAssociation.setTargetTVTable((TVTable)fKIndexAssociation.getContainerWithKeyObject().getTopView());
                this.removeSelectedLine(varFileLine);
            } else {
                String string2 = null;
                int n = (Integer)this.getFieldConstants().get("IS_COOL");
                string2 = n == 1000 ? this.getField(varFileLine, "FOREIGNKEY_COLUMNSET") : this.getField(varFileLine, "FOREIGNKEY_COLJCT5");
                FKIndexAssociationReference fKIndexAssociationReference = (FKIndexAssociationReference)this.getAllReferences().get(string2);
                if (table != null && index != null && fKIndexAssociationReference != null) {
                    fKIndexAssociation = table.addFK(index, null, fKIndexAssociationReference);
                    fKIndexAssociation.setName(this.getField(varFileLine, "foreignkey_NAME"));
                    this.fillElements(varFileLine, fKIndexAssociation, table);
                    this.getDesign().getRelationalDesign().getMainView().createViewFor(fKIndexAssociation);
                    this.getDesign().getRelationalDesign().getMainView().createViewFor(fKIndexAssociation.getRemoteTable());
                    this.getDesign().getRelationalDesign().getMainView().createViewFor(fKIndexAssociation.getContainerWithKeyObject());
                    fKIndexAssociation.setSourceTVTable((TVTable)fKIndexAssociation.getRemoteTable().getTopView());
                    fKIndexAssociation.setTargetTVTable((TVTable)fKIndexAssociation.getContainerWithKeyObject().getTopView());
                    this.addCreatedObject(this.getField(varFileLine, "general_id"), fKIndexAssociation);
                    this.removeSelectedLine(varFileLine);
                } else {
                    LOGGER.error("FKIndexAssociation is not found in getAllCreatedObjects() for RHForeignKey.createForeignKey()");
                    this.importLog.addError("Foreign key reference i snot found near " + varFileLine);
                }
            }
        }
    }

    private void fillCommontOn(VarFileLine varFileLine, FKIndexAssociation fKIndexAssociation) {
        String string = this.getField(varFileLine, "FOREIGNKEY_text");
        for (VarFileLine varFileLine2 : this.getAllSelectedLines()) {
            if (!varFileLine2.getType().equalsIgnoreCase("TEXT") || !this.getField(varFileLine2, "general_id").equalsIgnoreCase(string)) continue;
            String string2 = this.getField(varFileLine2, "text_comment");
            fKIndexAssociation.setComment(string2);
        }
    }

    private void fillDeleteRule(VarFileLine varFileLine, FKIndexAssociation fKIndexAssociation) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "FOREIGNKEY_DELETE"));
            String[] stringArray = fKIndexAssociation.getDeleteRuleChoices();
            switch (n) {
                case 0: {
                    fKIndexAssociation.setDeleteRule(stringArray[3]);
                    break;
                }
                case 1: {
                    fKIndexAssociation.setDeleteRule(stringArray[2]);
                    break;
                }
                case 2: {
                    fKIndexAssociation.setDeleteRule(stringArray[1]);
                    break;
                }
                default: {
                    fKIndexAssociation.setDeleteRule(stringArray[0]);
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong format in RHForeignKey.fillDeleteRule :");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong FILL DELETE RULE format near " + varFileLine);
        }
    }

    protected void fillElements(VarFileLine varFileLine, FKIndexAssociation fKIndexAssociation, Table table) {
        Index index = fKIndexAssociation.getLocalFKIndex();
        index.setName(this.getField(varFileLine, "foreignkey_NAME"));
        RDBMSSite rDBMSSite = this.getDesign().getSelectedRDBMSSite();
        String string = index.getObjectID();
        IndexProxyDB2 indexProxyDB2 = (IndexProxyDB2)this.getDesign().getStorageDesign(rDBMSSite).getIndexProxySet().getProxy(string);
        if (indexProxyDB2 != null) {
            indexProxyDB2.setMarkedGenerate(false);
            this.fillOwner(varFileLine, indexProxyDB2, table);
        }
        this.fillCommontOn(varFileLine, fKIndexAssociation);
        this.fillDeleteRule(varFileLine, fKIndexAssociation);
    }

    private void fillOwner(VarFileLine varFileLine, IndexProxyDB2 indexProxyDB2, Table table) {
        int n = (Integer)this.getFieldConstants().get("IS_COOL");
        if (n == 1000) {
            String string = this.getField(varFileLine, "CREATE_BY");
            Owner owner = (Owner)this.getAllCreatedObjects().get(string);
            if (owner == null) {
                owner = (Owner)((AbstractStorageDesignDB2)indexProxyDB2.getStorageDesign()).getOwnerSet().createElement(null);
                owner.setName(string);
                this.addCreatedObject(string, owner);
            }
            indexProxyDB2.setOwner(owner);
        } else {
            TableProxyDB2 tableProxyDB2 = (TableProxyDB2)indexProxyDB2.getStorageDesign().getTableProxySet().getProxy(table.getObjectID());
            indexProxyDB2.setOwner(tableProxyDB2.getOwner());
        }
    }

    private List getFkColumns(String string) {
        Object object;
        TreeMap<Integer, Column> treeMap = new TreeMap<Integer, Column>();
        Integer n = new Integer(3);
        ArrayList<ContainedObject> arrayList = new ArrayList<ContainedObject>();
        for (Object object2 : this.getAllSelectedLines()) {
            Object object3 = this.getField((VarFileLine)object2, "COLJCT_5_KEY").trim();
            if (!((VarFileLine)object2).getType().equalsIgnoreCase("COLJCT") || !((String)object3).equalsIgnoreCase(string)) continue;
            object = this.getField((VarFileLine)object2, "COLJCT_COLUMN_KEY");
            String string2 = this.getField(((VarFileLine)object2).getLine(), n);
            int n2 = Integer.parseInt(string2);
            if (object == null) continue;
            Column column = (Column)this.getAllCreatedObjects().get(object);
            treeMap.put(new Integer(n2), column);
        }
        for (Object object3 : treeMap.keySet()) {
            object = (ContainedObject)treeMap.get(object3);
            if (object == null) continue;
            arrayList.add((ContainedObject)object);
        }
        return arrayList;
    }

    private void processFKColumns(FKIndexAssociation fKIndexAssociation, String string) {
        List list = this.getFkColumns(string);
        Column[] columnArray = (Column[])fKIndexAssociation.getKeyObject().getElements();
        if (columnArray.length != list.size()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("RHForeignKey different number of columns in PK and FK local table = ").append(fKIndexAssociation.getContainerWithKeyObject().getName()).append(" remote table - > ").append(fKIndexAssociation.getRemoteTable().getName());
            LOGGER.error(stringBuffer.toString());
            this.importLog.addError(stringBuffer.toString());
        } else {
            Iterator iterator = list.iterator();
            Index index = fKIndexAssociation.getLocalFKIndex();
            for (int i = 0; i < columnArray.length; ++i) {
                Column column = (Column)iterator.next();
                column.addFKAssociation(columnArray[i], fKIndexAssociation);
                index.add(column);
            }
        }
    }
}

