/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.relational.TVFKRelation;

public class RHFKPoints
extends RowHandler {
    public static final String OBJECT_TYPE = "POINT";
    private Fields constants;
    List lines = new ArrayList();
    List fkList;
    List assList;

    public RHFKPoints(Design design, Fields fields, List list, Map map, List list2, List list3, Map map2, List list4, List list5) {
        super(design, fields, list, map, list2, list3, map2, list4, list5);
        this.constants = fields;
    }

    @Override
    public void read(VarFileLine varFileLine) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.addSelectedLine(varFileLine);
        } else {
            this.nextRead(varFileLine);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(OBJECT_TYPE);
        return arrayList;
    }

    @Override
    public void handle(VarFileLine varFileLine, boolean bl) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.collectLines(varFileLine);
            this.removeSelectedLine(varFileLine);
        } else {
            this.nextHandler(varFileLine, bl);
        }
    }

    private void collectLines(VarFileLine varFileLine) {
        int n = (Integer)this.getFieldConstants().get("IS_COOL");
        if (n != 1000 && !this.lines.contains(varFileLine)) {
            this.lines.add(varFileLine);
        }
    }

    @Override
    public List getOwnLines() {
        return this.lines;
    }

    public void processPointsForPhysical(List list, List list2) {
        this.fkList = list;
        this.assList = list2;
        String string = this.constants.getPhysicalDesignID();
        for (VarFileLine varFileLine : this.fkList) {
            String string2;
            String string3 = this.getField(varFileLine, "general_id");
            FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)this.getAllCreatedObjects().get(string3);
            if (fKIndexAssociation == null || (string2 = this.getAssId(string3, string)) == null) continue;
            List list3 = this.getAssPoints(string2);
            this.addFKPoints(fKIndexAssociation, list3, fKIndexAssociation.getDesignPart().getMainView());
        }
    }

    public void processPointsForPhysicalSubViews(List list, List list2, Map map) {
        this.fkList = list;
        this.assList = list2;
        String string = this.constants.getPhysicalDesignID();
        Set set = map.keySet();
        for (String string2 : set) {
            DesignPartView designPartView;
            if (string.equalsIgnoreCase(string2) || (designPartView = (DesignPartView)map.get(string2)) == null) continue;
            designPartView.setVisible(true);
            for (VarFileLine varFileLine : this.fkList) {
                String string3;
                String string4 = this.getField(varFileLine, "general_id");
                FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)this.getAllCreatedObjects().get(string4);
                if (fKIndexAssociation == null || (string3 = this.getAssId(string4, string2)) == null) continue;
                List list3 = this.getAssPoints(string3);
                this.addFKPoints(fKIndexAssociation, list3, designPartView);
            }
        }
    }

    private void addFKPoints(FKIndexAssociation fKIndexAssociation, List list, DesignPartView designPartView) {
        if (list.size() > 1) {
            TVFKRelation tVFKRelation;
            if (list.size() > 2) {
                TVFKRelation tVFKRelation2 = (TVFKRelation)fKIndexAssociation.getViewFor(designPartView);
                if (tVFKRelation2 != null) {
                    EdgeView edgeView = (EdgeView)tVFKRelation2.getCellView();
                    for (int i = 1; i < list.size() - 1; ++i) {
                        Point point = (Point)list.get(i);
                        tVFKRelation2.getEdgePoints().add(DiagramConstants.createPoint(point));
                    }
                    if (edgeView != null) {
                        tVFKRelation2.getDesignPartView().getWorkSpace().addPoints((DefaultEdge)edgeView.getCell(), tVFKRelation2.getEdgePoints());
                        edgeView.update();
                    }
                }
            } else if (list.size() == 2 && (tVFKRelation = (TVFKRelation)fKIndexAssociation.getViewFor(designPartView)) != null) {
                Point point = (Point)list.get(0);
                Point point2 = (Point)list.get(1);
                if (point.x == point2.x) {
                    int n = (point.y + point2.y) / 2;
                    tVFKRelation.getEdgePoints().add(DiagramConstants.createPoint(new Point(point.x, n)));
                    EdgeView edgeView = (EdgeView)tVFKRelation.getCellView();
                    if (edgeView != null) {
                        tVFKRelation.getDesignPartView().getWorkSpace().addPoints((DefaultEdge)edgeView.getCell(), tVFKRelation.getEdgePoints());
                        edgeView.update();
                    }
                } else if (point.y == point2.y) {
                    int n = (point.x + point2.x) / 2;
                    tVFKRelation.getEdgePoints().add(DiagramConstants.createPoint(new Point(n, point.y)));
                    EdgeView edgeView = (EdgeView)tVFKRelation.getCellView();
                    if (edgeView != null) {
                        tVFKRelation.getDesignPartView().getWorkSpace().addPoints((DefaultEdge)edgeView.getCell(), tVFKRelation.getEdgePoints());
                        edgeView.update();
                    }
                }
            }
        }
    }

    private String getAssId(String string, String string2) {
        for (VarFileLine varFileLine : this.assList) {
            if (!string2.equalsIgnoreCase(this.getField(varFileLine, "POINT_CDBA_ASS_DIAGRAMID")) || !string.equalsIgnoreCase(this.getField(varFileLine, "POINT_CDBA_ASS_FKID"))) continue;
            return this.getField(varFileLine, "general_id");
        }
        return null;
    }

    private List getAssPoints(String string) {
        int n;
        int n2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object : this.lines) {
            if (!string.equalsIgnoreCase(this.getField((VarFileLine)object, "POINT_CDBA_ASSID"))) continue;
            n2 = Integer.parseInt(this.getField((VarFileLine)object, "POINT_CDBA_X"));
            n = Integer.parseInt(this.getField((VarFileLine)object, "POINT_CDBA_Y"));
            int n3 = Integer.parseInt(this.getField((VarFileLine)object, "POINT_CDBA_ORDNUM"));
            arrayList.add(new HelpPoint(n2, n, n3));
        }
        if (arrayList.size() > 0) {
            Object object;
            object = new ArrayList();
            object.addAll(arrayList);
            arrayList.clear();
            block1: for (n2 = 0; n2 < object.size(); ++n2) {
                for (n = 0; n < object.size(); ++n) {
                    HelpPoint helpPoint = (HelpPoint)object.get(n);
                    if (helpPoint.ord != n2) continue;
                    arrayList.add(new Point(helpPoint.x, helpPoint.y));
                    continue block1;
                }
            }
        }
        return arrayList;
    }

    class HelpPoint {
        int x;
        int y;
        int ord;

        HelpPoint() {
        }

        HelpPoint(int n, int n2, int n3) {
            this.x = n;
            this.y = n2;
            this.ord = n3;
        }
    }
}

