/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RHEntitySynonym;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.logical.Entity;

public class RHEntity
extends RowHandler {
    public static final String OBJECT_TYPE = "ENTITY";

    public RHEntity(Design design, Fields fields, List list, Map map, List list2, List list3, Map map2, List list4, List list5) {
        super(design, fields, list, map, list2, list3, map2, list4, list5);
    }

    @Override
    public void read(VarFileLine varFileLine) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.addSelectedLine(varFileLine);
        } else {
            this.nextRead(varFileLine);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(OBJECT_TYPE);
        return arrayList;
    }

    @Override
    public void handle(VarFileLine varFileLine, boolean bl) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.createEntity(varFileLine);
        } else {
            this.nextHandler(varFileLine, bl);
        }
    }

    private void createEntity(VarFileLine varFileLine) {
        String string = this.getComment(varFileLine);
        String string2 = this.getField(varFileLine, "general_id");
        Entity entity = (Entity)this.getAllCreatedObjects().get(string2);
        if (entity != null) {
            return;
        }
        String string3 = this.getField(varFileLine, "super_entity").trim();
        Entity entity2 = null;
        if (!string3.equals("0") && (entity2 = (Entity)this.getAllCreatedObjects().get(string3)) == null) {
            return;
        }
        entity = this.getLogicalDesign().createEntity(this.getField(varFileLine, "entity_name"));
        if (entity2 != null) {
            entity.setHierarchicalParent(entity2);
        }
        this.setCreatorChanger(entity, varFileLine);
        if (string != null) {
            entity.setComment(string);
        }
        entity.setNotes(this.getNotes(varFileLine, "note_ent_id"));
        String string4 = "Table for each entity";
        entity.setFwdEngineeringStrategyName(string4);
        entity.setSynonym(this.getSynonym(varFileLine));
        this.setVolumeInfo(varFileLine, entity);
        this.addCreatedObject(string2, entity);
        this.removeSelectedLine(varFileLine);
    }

    private String getComment(VarFileLine varFileLine) {
        String string = null;
        String string2 = this.getField(varFileLine, "ENTITY_TEXT_ID");
        if (!"0".equalsIgnoreCase(string2)) {
            VarFileLine varFileLine2 = this.getCommentLine(string2, "ANLTEXT");
            if (varFileLine2 != null) {
                string = this.getField(varFileLine2, "TEXT_COMMENT_2");
                this.removeSelectedLine(varFileLine2);
            }
        } else {
            string = "";
        }
        return string;
    }

    private String getSynonym(VarFileLine varFileLine) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = this.getField(varFileLine, "general_id");
        for (VarFileLine varFileLine2 : this.getSpecificRowHandler(RHEntitySynonym.class).getOwnLines()) {
            VarFileLine varFileLine3;
            String string2;
            String string3 = this.getField(varFileLine2, "general_id");
            if (!string.equalsIgnoreCase(string3) || "0".equalsIgnoreCase(string2 = this.getField(varFileLine2, "SYNONYM_ID")) || (varFileLine3 = this.getCommentLine(string2, "SYNONYM_OBJECT")) == null) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.getField(varFileLine3, "SYNONYM_OBJ_NAME"));
        }
        return stringBuffer.toString();
    }

    private boolean check(String string) {
        return !"".equalsIgnoreCase(string);
    }

    private void setVolumeInfo(VarFileLine varFileLine, Entity entity) {
        String string = this.getField(varFileLine, "ENTITY_VOLUMES_MIN");
        String string2 = this.getField(varFileLine, "ENTITY_VOLUMES_MAX");
        String string3 = this.getField(varFileLine, "ENTITY_VOLUMES_EXPECTED");
        String string4 = this.getField(varFileLine, "ENTITY_GR_PERCENT");
        String string5 = this.getField(varFileLine, "ENTITY_GR_YMD");
        String string6 = this.getField(varFileLine, "ENTITY_NORMAL_FORM");
        String string7 = this.getField(varFileLine, "ENTITY_NORMALIZED");
        if (this.check(string)) {
            entity.setMinVolumes(string);
        }
        if (this.check(string2)) {
            entity.setMaxVolumes(string2);
        }
        if (this.check(string3)) {
            entity.setExpectedVolumes(string3);
        }
        if (this.check(string4)) {
            entity.setGrowthPercent(string4);
        }
        if (this.check(string5)) {
            if ("D".equalsIgnoreCase(string5)) {
                entity.setGrowthType(Entity.GROWTH_TYPES[0]);
            } else if ("M".equalsIgnoreCase(string5)) {
                entity.setGrowthType(Entity.GROWTH_TYPES[1]);
            } else if ("Y".equalsIgnoreCase(string5)) {
                entity.setGrowthType(Entity.GROWTH_TYPES[2]);
            }
        }
        if (this.check(string6)) {
            if ("C".equalsIgnoreCase(string6)) {
                entity.setNormalForm(Entity.NORMAL_FORMS[0]);
            } else if ("1".equalsIgnoreCase(string6)) {
                entity.setNormalForm(Entity.NORMAL_FORMS[1]);
            } else if ("2".equalsIgnoreCase(string6)) {
                entity.setNormalForm(Entity.NORMAL_FORMS[2]);
            } else if ("3".equalsIgnoreCase(string6)) {
                entity.setNormalForm(Entity.NORMAL_FORMS[3]);
            } else if ("4".equalsIgnoreCase(string6)) {
                entity.setNormalForm(Entity.NORMAL_FORMS[4]);
            }
        }
        if (this.check(string7)) {
            if ("Y".equalsIgnoreCase(string7)) {
                entity.setAdequatelyNormalized(Entity.YES_NO_STATES[0]);
            } else {
                entity.setAdequatelyNormalized(Entity.YES_NO_STATES[1]);
            }
        }
    }
}

