/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RHAttributeSynonym;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;

public class RHAttribute
extends RowHandler {
    public static final String OBJECT_TYPE = "ATTRIBUTE";
    List lines = new ArrayList();

    public RHAttribute(Design design, Fields fields, List list, Map map, List list2, List list3, Map map2, List list4, List list5) {
        super(design, fields, list, map, list2, list3, map2, list4, list5);
    }

    @Override
    public void read(VarFileLine varFileLine) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.addSelectedLine(varFileLine);
            this.lines.add(varFileLine);
        } else {
            this.nextRead(varFileLine);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(OBJECT_TYPE);
        return arrayList;
    }

    @Override
    public void handle(VarFileLine varFileLine, boolean bl) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.createAttribute(varFileLine);
        } else {
            this.nextHandler(varFileLine, bl);
        }
    }

    private void createAttribute(VarFileLine varFileLine) {
        String string = this.getField(varFileLine, "attribute_entity_id").trim();
        if (string.equalsIgnoreCase("0")) {
            this.removeSelectedLine(varFileLine);
        } else {
            Entity entity = (Entity)this.getCreatedObject(string);
            if (entity != null) {
                Domain domain;
                Attribute attribute = entity.createAttribute(this.getField(varFileLine, "attribute_name"));
                this.setCreatorChanger(attribute, varFileLine);
                if (this.getField(varFileLine, "attribute_nulls_allowed").equalsIgnoreCase("Y")) {
                    attribute.setNullsAllowed(true);
                } else {
                    attribute.setNullsAllowed(false);
                }
                String string2 = this.getField(varFileLine, "attribute_domain").trim();
                if ("0".equalsIgnoreCase(string2)) {
                    string2 = this.getDomainKeyFromDimension(varFileLine);
                }
                if ((domain = this.getDomain(string2)) != null) {
                    attribute.setDomain(domain);
                }
                attribute.setComment(this.getComment(varFileLine));
                attribute.setNotes(this.getNotes(varFileLine, "note_attr_id"));
                attribute.setSynonym(this.getSynonym(varFileLine));
                attribute.setSource(this.getField(varFileLine, "ATTRIBUTE_SOURCE"));
                String string3 = this.getField(varFileLine, "ATTRIBUTE_TYPE");
                if ("S".equalsIgnoreCase(string3)) {
                    attribute.setSourceType("System");
                } else if ("M".equalsIgnoreCase(string3)) {
                    attribute.setSourceType("Manual");
                } else if ("D".equalsIgnoreCase(string3)) {
                    attribute.setSourceType("Derived");
                } else if ("A".equalsIgnoreCase(string3)) {
                    attribute.setSourceType("Aggregate");
                }
                this.addCreatedObject(this.getField(varFileLine, "general_id").trim(), attribute);
                this.removeSelectedLine(varFileLine);
            }
        }
    }

    private Domain getDomain(String string) {
        return (Domain)this.getAllCreatedObjects().get(string);
    }

    private String getComment(VarFileLine varFileLine) {
        String string = null;
        String string2 = this.getField(varFileLine, "ATTRIBUTE_TEXT_ID");
        if (!"0".equalsIgnoreCase(string2)) {
            VarFileLine varFileLine2 = this.getCommentLine(string2, "ANLTEXT");
            if (varFileLine2 != null) {
                string = this.getField(varFileLine2, "TEXT_COMMENT_2");
                this.removeSelectedLine(varFileLine2);
            }
        } else {
            string = "";
        }
        return string;
    }

    private String getSynonym(VarFileLine varFileLine) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = this.getField(varFileLine, "general_id");
        for (VarFileLine varFileLine2 : this.getSpecificRowHandler(RHAttributeSynonym.class).getOwnLines()) {
            VarFileLine varFileLine3;
            String string2;
            String string3 = this.getField(varFileLine2, "general_id");
            if (!string.equalsIgnoreCase(string3) || "0".equalsIgnoreCase(string2 = this.getField(varFileLine2, "SYNONYM_ID")) || (varFileLine3 = this.getCommentLine(string2, "SYNONYM_OBJECT")) == null) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.getField(varFileLine3, "SYNONYM_OBJ_NAME"));
        }
        return stringBuffer.toString();
    }

    private String getDomainKeyFromDimension(VarFileLine varFileLine) {
        String string = "0";
        String string2 = this.getField(varFileLine, "ATTRIBUTE_DIMENSION");
        VarFileLine varFileLine2 = this.getCommentLine(string2, "DIMENSION");
        if (varFileLine2 != null) {
            string = this.getField(varFileLine2, "DIMENSION_DOMAIN_ID");
        }
        return string;
    }

    @Override
    public List getOwnLines() {
        return this.lines;
    }
}

