/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.imports.Messages;
import oracle.dbtools.crest.imports.var.ChainBuilderSeperate;
import oracle.dbtools.crest.imports.var.DomainHandlerVarConversie;
import oracle.dbtools.crest.imports.var.RHAnlextRteObj;
import oracle.dbtools.crest.imports.var.RHAttribute;
import oracle.dbtools.crest.imports.var.RHDataModel;
import oracle.dbtools.crest.imports.var.RHDataModelDiagram;
import oracle.dbtools.crest.imports.var.RHDiagram;
import oracle.dbtools.crest.imports.var.RHDiagramObjectPro;
import oracle.dbtools.crest.imports.var.RHEntityDiagramObj;
import oracle.dbtools.crest.imports.var.RHFKPoints;
import oracle.dbtools.crest.imports.var.RHForeignKey;
import oracle.dbtools.crest.imports.var.RHPartnership;
import oracle.dbtools.crest.imports.var.RHPartnershipDiagram;
import oracle.dbtools.crest.imports.var.RHPlacement;
import oracle.dbtools.crest.imports.var.RHcdbaAssociations;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.imports.var.VarFileReader;
import oracle.dbtools.crest.imports.var.process.RHAPODiagramObj;
import oracle.dbtools.crest.imports.var.process.RHProcessModel;
import oracle.dbtools.crest.imports.var.process.RHProcessModelDiagram;
import oracle.dbtools.crest.model.StatusBarOwner;
import oracle.dbtools.crest.model.View;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.LogReport;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;
import oracle.ide.Ide;

public class ParserSeperateVar {
    private static final String[] SEQUENCE = new String[]{"TEXT", "ANLTEXT", "SYNONYM_OBJECT", "ENTITYSYNONYM_OBJE", "ENT_KEYSYNONYM_OBJ", "PARTNERSHIP_SETSYN", "ATTRIBUTESYNONYM_O", "NOTES", "DIMENSION", "DOMAINS", "DOMAINSSYNONYM_OBJ", "ENTITY", "ENTITY", "ATTRIBUTE", "ENT_KEY", "ATTRIBUTEENT_KEY", "PARTNERSHIP_SET", "PARTNERSHIP", "PARTNERSHIP_SETENT", "PARTNERSHIPFOREIGN", "PARTNERSHIPFOREIG2", "FOREIGN_KEY_ATTR", "BUFFER_POOLS", "VOLUMES", "VCATS", "VOL_SG_MAP", "STORAGE_GROUPS", "DATABASES", "DATABASE", "USER", "TABLESPACE", "TABLE_SPACES", "PARTITIONS", "DIAGRAM", "TABLES", "TABLE", "COLUMN_SETTABLE_CO", "COL_DEFAULT", "COLUMN_SET", "KEY_COL_JUNC", "TABLE_COLUMNS", "COLUMN", "COLJCT", "CHECK_CONSTRAINT", "PRIMARY_KEY", "PRIMARY_KEYS", "FOREIGN_KEY", "FOREIGN_KEYS", "INDEX", "VIEWDEPENDE2", "VIEWDEPENDENT", "VIEW_DEPENDENT", "VIEW", "VIEWS", "ALIASES", "SYNONYM", "PARTITION_BOUNDARY", "PLACEMENT", "ENTITYDIAGRAM_OBJE", "ANLEXT_RTE_OBJ", "DATA_MODEL", "PROCESS_MODEL", "PROCESSSYNONYM_OBJ", "EXTERNAL_AGENTSYNO", "INFO_STORESYNONYM_", "INFO_FLOWSYNONYM_O", "STORAGE_EVENTSYNON", "FLOW_EVENTSYNONYM_", "PERSON_EVENTSYNONY", "CLOCK_EVENTSYNONYM", "STRUCTURESYNONYM_O", "PROCESS_MODELCLOCK", "PROCESS_MODELPERSO", "PROCESS_MODELSTORA", "PROCESS_MODELFLOW_", "FLOW_EVENT", "CLOCK_EVENT", "PERSON_EVENT", "STORAGE_EVENT", "PROCESS", "PROCESSCLOCK_EVENT", "PROCESSPERSON_EVEN", "PROCESSSTORAGE_EVE", "EXTERNAL_AGENT", "INFO_STORE", "PROCESSINFO_FLOW", "EXTERNAL_AGENTINFO", "INFO_STOREINFO_FLO", "INFO_FLOWEXTERNAL_", "INFO_FLOWINFO_STOR", "INFO_FLOWPROCESS", "INFO_FLOW", "STRUCTUREPROCESS_M", "STRUCTUREINFO_FLOW", "STRUCTURE", "STRUCT_ENT", "STRUCT_ATTR", "PROCESSDIAGRAM_OBJ", "EXTERNAL_AGENTDIAG", "INFO_STOREDIAGRAM_", "PROCESS_MODELDIAGR", "DATA_MODELDIAGRAM_", "DIAGRAM_OBJECT_PRO", "ASSOCIATION", "POINT", "PARTNERSHIPDIAGRAM"};
    private static final String[] SEQUENCE_NO_PM = new String[]{"TEXT", "ANLTEXT", "SYNONYM_OBJECT", "ENTITYSYNONYM_OBJE", "ENT_KEYSYNONYM_OBJ", "PARTNERSHIP_SETSYN", "ATTRIBUTESYNONYM_O", "NOTES", "DIMENSION", "DOMAINS", "DOMAINSSYNONYM_OBJ", "ENTITY", "ENTITY", "ATTRIBUTE", "ENT_KEY", "ATTRIBUTEENT_KEY", "PARTNERSHIP_SET", "PARTNERSHIP", "PARTNERSHIP_SETENT", "PARTNERSHIPFOREIGN", "PARTNERSHIPFOREIG2", "FOREIGN_KEY_ATTR", "BUFFER_POOLS", "VOLUMES", "VCATS", "VOL_SG_MAP", "STORAGE_GROUPS", "DATABASES", "DATABASE", "USER", "TABLESPACE", "TABLE_SPACES", "PARTITIONS", "DIAGRAM", "TABLES", "TABLE", "COLUMN_SETTABLE_CO", "COL_DEFAULT", "COLUMN_SET", "KEY_COL_JUNC", "TABLE_COLUMNS", "COLUMN", "COLJCT", "CHECK_CONSTRAINT", "PRIMARY_KEY", "PRIMARY_KEYS", "FOREIGN_KEY", "FOREIGN_KEYS", "INDEX", "VIEWDEPENDE2", "VIEWDEPENDENT", "VIEW_DEPENDENT", "VIEW", "VIEWS", "ALIASES", "SYNONYM", "PARTITION_BOUNDARY", "PLACEMENT", "ENTITYDIAGRAM_OBJE", "ANLEXT_RTE_OBJ", "DATA_MODEL", "DATA_MODELDIAGRAM_", "DIAGRAM_OBJECT_PRO", "ASSOCIATION", "POINT", "PARTNERSHIPDIAGRAM"};
    private VarFileReader reader;
    private VarFileReader readerForDomains;
    private Design design;
    private Design designForDomains;
    private ChainBuilderSeperate chainBuilder;
    private List allSelectedLines = new ArrayList();
    private Map allCreatedObjects = new HashMap();
    private Map allReferences = new HashMap();
    private List allForeignKeyLines = new ArrayList();
    private List allPrimaryKeyLines = new ArrayList();
    private List allColumnLines = new ArrayList();
    private ApplicationView view = null;
    private ProgressDialog monitor;
    private String designName;
    private List commentLines = new ArrayList();
    private double scale = 0.5;
    private StatusBarOwner statusBarOwner = StatusBarOwner.NULL_INSTANCE;
    private boolean hasMapping = false;
    private RDBMSSite site;
    private boolean importPM;
    private static final Logger LOGGER = new Logger(ParserSeperateVar.class);
    int minLeft = Integer.MAX_VALUE;
    int maxTop = -2147483647;

    public void parseContent(File file, View view, RDBMSSite rDBMSSite, String string, boolean bl) {
        this.reader = new VarFileReader(file.getAbsolutePath());
        this.site = rDBMSSite;
        this.importPM = bl;
        if (this.isRightVersion(string)) {
            if (this.canParse()) {
                if (view instanceof ApplicationView) {
                    this.view = (ApplicationView)view;
                }
                this.readerForDomains = new VarFileReader(file.getAbsolutePath());
                this.design = this.view.getCurrentDesign();
                String string2 = this.view.getCurrentDesign().getDesignPath();
                this.designName = this.reader.getName();
                if (this.designName != null) {
                    this.view.getCurrentDesign().setDesignPath(ApplicationView.TEMP_DIR);
                    if (this.view.designExists(this.designName)) {
                        this.view.deleteDesign(this.designName);
                    }
                    this.design.setFileName(this.designName);
                    ((ApplicationView)view).setDesignName(this.designName);
                    this.design.setSelectedRDBMSSite(rDBMSSite);
                    this.designForDomains = this.design;
                    StringBuffer stringBuffer = new StringBuffer(this.design.getDesign().getFileName());
                    stringBuffer.append("_Domains");
                    this.designForDomains.setFileName(stringBuffer.toString());
                    this.designForDomains.setSelectedRDBMSSite(rDBMSSite);
                    if (view != null && view instanceof StatusBarOwner) {
                        this.statusBarOwner = (StatusBarOwner)((Object)view);
                    }
                    this.chainBuilder = new ChainBuilderSeperate();
                    if (bl) {
                        this.chainBuilder.buildChain(this.design, this.reader.getConstants(), this.allSelectedLines, this.allCreatedObjects, this.allForeignKeyLines, this.allPrimaryKeyLines, this.allReferences, this.allColumnLines, this.commentLines);
                    } else {
                        this.chainBuilder.buildChainNoPM(this.design, this.reader.getConstants(), this.allSelectedLines, this.allCreatedObjects, this.allForeignKeyLines, this.allPrimaryKeyLines, this.allReferences, this.allColumnLines, this.commentLines);
                    }
                    new Thread(new Runner()).start();
                } else {
                    this.view.getCurrentDesign().setDesignPath(string2);
                    this.design = null;
                    System.gc();
                }
            }
        } else {
            JOptionPane.showMessageDialog(null, MessageFormat.format(Messages.getString("ParserSeperateVar.TheVersionOfSelectedVARFileNot"), string), Messages.getString("ParserSeperateVar.Warning"), 2);
        }
    }

    public boolean canParse() {
        return this.reader.isSupportedVersion();
    }

    private boolean isRightVersion(String string) {
        return this.reader.getVersion().startsWith(string);
    }

    private void constructDomains() {
        try {
            ApplicationView.log(Messages.getString("ParserSeperateVar.OpeningFileForDomainConstruction"));
            List list = this.collectLinesForDomains();
            DomainHandlerVarConversie domainHandlerVarConversie = new DomainHandlerVarConversie(this.designForDomains, this.readerForDomains.getConstants(), this.allSelectedLines, this.allCreatedObjects, this.allForeignKeyLines, this.allPrimaryKeyLines, this.allReferences, this.allColumnLines, this.commentLines);
            domainHandlerVarConversie.createDomains(list, this.commentLines, this.statusBarOwner);
            this.designForDomains.setFileName(this.designName);
            this.designForDomains.resetDomains();
        }
        catch (Exception exception) {
            LOGGER.error("Unable to create domains!", exception);
        }
    }

    private void parseFile() {
        VarFileLine varFileLine;
        this.design.setSelectedRDBMSSite(this.site);
        ApplicationView.log(Messages.getString("ParserSeperateVar.OpeningFileForParsing"));
        while ((varFileLine = this.reader.readLine()) != null) {
            try {
                RowHandler rowHandler = (RowHandler)this.chainBuilder.getObjectMap().get(varFileLine.getType());
                if (rowHandler == null) continue;
                rowHandler.read(varFileLine);
            }
            catch (Exception exception) {
                LOGGER.error("Unable to read the line: " + varFileLine.getLine(), exception);
                this.chainBuilder.getChain().nextRead(varFileLine);
            }
        }
        this.reader.closeReader();
        this.parseInRightSequence();
    }

    private void parsePoints() {
        RowHandler rowHandler = this.chainBuilder.getSpecificRowHandler(RHForeignKey.class);
        RowHandler rowHandler2 = this.chainBuilder.getSpecificRowHandler(RHcdbaAssociations.class);
        RHDiagram rHDiagram = (RHDiagram)this.chainBuilder.getSpecificRowHandler(RHDiagram.class);
        RHFKPoints rHFKPoints = (RHFKPoints)this.chainBuilder.getSpecificRowHandler(RHFKPoints.class);
        rHFKPoints.processPointsForPhysical(rowHandler.getOwnLines(), rowHandler2.getOwnLines());
        rHFKPoints.processPointsForPhysicalSubViews(rowHandler.getOwnLines(), rowHandler2.getOwnLines(), rHDiagram.getDiagramsMap());
    }

    private void parseList() {
        int n;
        int n2 = this.allSelectedLines.size();
        int n3 = n2 - 1;
        while (n2 - n3 > 0) {
            this.parseInRightSequence();
            n2 = n3;
            n3 = this.allSelectedLines.size();
        }
        if (this.importPM) {
            for (n = 0; n < SEQUENCE.length; ++n) {
                this.chainBuilder.getChain().removeSelectedLinesOfType(SEQUENCE[n]);
            }
        } else {
            for (n = 0; n < SEQUENCE_NO_PM.length; ++n) {
                this.chainBuilder.getChain().removeSelectedLinesOfType(SEQUENCE_NO_PM[n]);
            }
        }
        for (VarFileLine varFileLine : this.allSelectedLines) {
            StringBuffer stringBuffer = new StringBuffer("!!! UNHANDLED : ");
            stringBuffer.append(varFileLine.getType());
            stringBuffer.append(" : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString());
        }
    }

    private void arrangeColumnPositionInTable() {
        Object object;
        Hashtable hashtable = this.reader.getConstants().getFields();
        Integer n = (Integer)hashtable.get("COLUMN_ORDNUM");
        int n2 = n != null ? n : 10;
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        for (Object object2 : this.allColumnLines) {
            String string = null;
            object = new StringTokenizer(((VarFileLine)object2).getLine(), ",");
            string = ((StringTokenizer)object).nextToken().trim();
            Object v = this.allCreatedObjects.get(string);
            Column column = null;
            if (v instanceof Column) {
                column = (Column)v;
            }
            if (column == null) continue;
            Table table = (Table)column.getParent();
            try {
                Object object3;
                StringTokenizer stringTokenizer = new StringTokenizer(((VarFileLine)object2).getLine(), ",");
                int n3 = 0;
                int n4 = 0;
                while (stringTokenizer.hasMoreElements()) {
                    object3 = stringTokenizer.nextToken().trim();
                    if (++n4 != n2) continue;
                    n3 = Integer.parseInt((String)object3);
                    break;
                }
                if ((object3 = (Holder)treeMap.get(table.getObjectID())) == null) {
                    object3 = new Holder();
                    ((Holder)object3).container = table;
                    ((Holder)object3).map = new TreeMap();
                    treeMap.put(table.getObjectID(), object3);
                }
                ((Holder)object3).map.put(new Integer(n3 - 1), column);
            }
            catch (NumberFormatException numberFormatException) {
                StringBuffer stringBuffer = new StringBuffer("Wrong Format in ParserJointVars.arrangeColumnPositionInTable() : ");
                stringBuffer.append(((VarFileLine)object2).getLine());
                LOGGER.error(stringBuffer.toString(), numberFormatException);
            }
        }
        for (String string : treeMap.keySet()) {
            object = (Holder)treeMap.get(string);
            this.sortAttributes(((Holder)object).container, ((Holder)object).map);
        }
    }

    private void createArcs() {
        RHPartnership rHPartnership = (RHPartnership)this.chainBuilder.getSpecificRowHandler(RHPartnership.class);
        rHPartnership.createArcs();
    }

    private void arrangeAttributePositionInEntity() {
        Object object;
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        for (Object object2 : this.chainBuilder.getSpecificRowHandler(RHAttribute.class).getOwnLines()) {
            String string = null;
            object = new StringTokenizer(((VarFileLine)object2).getLine(), ",");
            string = ((StringTokenizer)object).nextToken().trim();
            Object v = this.allCreatedObjects.get(string);
            Attribute attribute = null;
            if (v instanceof Attribute) {
                attribute = (Attribute)v;
            }
            if (attribute == null) continue;
            Entity entity = (Entity)attribute.getParent();
            int n = 10;
            try {
                Object object3;
                StringTokenizer stringTokenizer = new StringTokenizer(((VarFileLine)object2).getLine(), ",");
                int n2 = 0;
                int n3 = 0;
                while (stringTokenizer.hasMoreElements()) {
                    object3 = stringTokenizer.nextToken().trim();
                    if (++n3 != n) continue;
                    n2 = Integer.parseInt((String)object3);
                    break;
                }
                if ((object3 = (Holder)treeMap.get(entity.getObjectID())) == null) {
                    object3 = new Holder();
                    ((Holder)object3).container = entity;
                    ((Holder)object3).map = new TreeMap();
                    treeMap.put(entity.getObjectID(), object3);
                }
                ((Holder)object3).map.put(new Integer(n2 - 1), attribute);
            }
            catch (NumberFormatException numberFormatException) {
                StringBuffer stringBuffer = new StringBuffer("Wrong Format in ParserJointVars.arrangeColumnPositionInTable() : ");
                stringBuffer.append(((VarFileLine)object2).getLine());
                LOGGER.error(stringBuffer.toString(), numberFormatException);
            }
        }
        for (String string : treeMap.keySet()) {
            object = (Holder)treeMap.get(string);
            this.sortAttributes(((Holder)object).container, ((Holder)object).map);
        }
    }

    private void sortAttributes(ContainerObject containerObject, Map map) {
        Iterator iterator = map.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Integer n2 = (Integer)iterator.next();
            ContainedObject containedObject = (ContainedObject)map.get(n2);
            if (containedObject != null) {
                containerObject.moveToIndex(containedObject, n2);
            }
            ++n;
        }
    }

    public void rearrangePhysDes() {
        RHPlacement rHPlacement = (RHPlacement)this.chainBuilder.getSpecificRowHandler(RHPlacement.class);
        rHPlacement.rearrangePhysDes();
    }

    public void createObjectsInSubViews() {
        RHDiagram rHDiagram = (RHDiagram)this.chainBuilder.getSpecificRowHandler(RHDiagram.class);
        RHPlacement rHPlacement = (RHPlacement)this.chainBuilder.getSpecificRowHandler(RHPlacement.class);
        rHPlacement.createObjectsInSubViews(rHDiagram.getDiagramsMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse() {
        try {
            this.monitor = new ProgressDialog(this.view, "", 0, 100);
            try {
                this.view.setImporting(true);
                this.design.closeAllDiagrams();
                this.design.setDisableTreeUpdate(true);
                try {
                    ParserSeperateVar.initialSettings(this.design);
                    this.monitor.setNote(Messages.getString("ParserSeperateVar.ConstructDomains"));
                    this.monitor.setProgress(10);
                    this.constructDomains();
                    this.design.setPropagatePKChahges(false);
                    this.monitor.setNote(Messages.getString("ParserSeperateVar.ParseFile"));
                    this.monitor.setProgress(30);
                    this.parseFile();
                    this.monitor.setNote(Messages.getString("ParserSeperateVar.RearrangeGraphicalObjects"));
                    this.monitor.setProgress(80);
                    try {
                        this.rearrangeEntitiesAndPartnerships();
                    }
                    catch (Exception exception) {
                        LOGGER.error("Unable to rearrange Entities and Partnerships", exception);
                    }
                    try {
                        this.parseList();
                    }
                    catch (Exception exception) {
                        LOGGER.error("Unable to parse List", exception);
                    }
                    try {
                        this.createArcs();
                    }
                    catch (Exception exception) {
                        LOGGER.error("Unable to create Arcs", exception);
                    }
                    this.design.getLogicalDesign().resetIdentifyingRelationships();
                    try {
                        this.arrangeColumnPositionInTable();
                    }
                    catch (Exception exception) {
                        LOGGER.error("Unable to arrange Column Position in Table", exception);
                    }
                    try {
                        this.arrangeAttributePositionInEntity();
                    }
                    catch (Exception exception) {
                        LOGGER.error("Unable to arrange Attribute positions in Entity", exception);
                    }
                    this.monitor.setNote(Messages.getString("ParserSeperateVar.CreateSubViews"));
                    this.monitor.setProgress(84);
                    try {
                        this.createObjectsInSubViews();
                    }
                    catch (Exception exception) {
                        LOGGER.error("Unable to create Objects in SubViews", exception);
                    }
                    this.monitor.setNote(Messages.getString("ParserSeperateVar.RearrangeForeignKeyLines"));
                    this.monitor.setProgress(86);
                    try {
                        this.parsePoints();
                    }
                    catch (Exception exception) {
                        LOGGER.error("Unable to parse Points", exception);
                    }
                    ParserSeperateVar.createDetailsDisplay(this.design);
                    this.monitor.setNote(Messages.getString("ParserSeperateVar.RearrangeRelationalModel"));
                    this.monitor.setProgress(88);
                    try {
                        this.rearrangePhysDes();
                    }
                    catch (Exception exception) {
                        LOGGER.error("Unable to Rearrange Relational Model", exception);
                    }
                    this.nullifyAll1();
                    this.nullifyAll2();
                    this.design.setPropagatePKChahges(true);
                    this.monitor.setNote(MessageFormat.format(Messages.getString("ParserSeperateVar.OpenDesign"), this.designName));
                    this.monitor.setProgress(90);
                    this.design.getStorageDesign(this.design.getSelectedRDBMSSite()).setOpen(true);
                    this.design.getStorageDesign(this.design.getSelectedRDBMSSite()).setTempModel(false);
                    this.design.getStorageDesign(this.design.getSelectedRDBMSSite()).setDirty(true);
                    this.monitor.setProgress(100);
                    this.designName = this.design.getName();
                    this.view.getCurrentDesign().setDesignPath("");
                    this.view.synchronizeTitle();
                }
                finally {
                    this.view.setImporting(false);
                    this.design.getLogicalDesign().setMainViewVisible(true);
                    this.design.showAllRelationalDesigns();
                    this.design.setDisableTreeUpdate(false);
                    this.view.clearTree();
                    this.resetDirty(this.design);
                }
            }
            finally {
                this.monitor.close();
            }
        }
        finally {
            ApplicationView.loading = false;
        }
    }

    private void resetDirty(Design design) {
        Iterator iterator = design.getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
            relationalDesign.setDirty(true);
        }
    }

    public List getSelectedLines() {
        return this.allSelectedLines;
    }

    public List getPrimaryKeyLines() {
        return this.allPrimaryKeyLines;
    }

    public List getForeignKeyLines() {
        return this.allForeignKeyLines;
    }

    public List getColumnLines() {
        return this.allColumnLines;
    }

    private List collectLinesForDomains() {
        ArrayList<VarFileLine> arrayList = new ArrayList<VarFileLine>();
        VarFileLine varFileLine = this.readerForDomains.readLine();
        int n = 1;
        while (varFileLine != null) {
            String string = varFileLine.getType();
            if (string.equalsIgnoreCase("TABLE_COLUMNS") || string.equalsIgnoreCase("COLUMN") || string.equalsIgnoreCase("DOMAINS")) {
                arrayList.add(varFileLine);
            } else if (string.equalsIgnoreCase("ANLTEXT") || string.equalsIgnoreCase("SYNONYM_OBJECT") || string.equalsIgnoreCase("DOMAINSSYNONYM_OBJ") || string.equalsIgnoreCase("DIMENSION") || string.equalsIgnoreCase("ALLOWED_VAL_TBL") || string.equalsIgnoreCase("ALLOWABLE_VALUE")) {
                this.commentLines.add(varFileLine);
            }
            varFileLine = this.readerForDomains.readLine();
            ++n;
        }
        this.chainBuilder.getChain().setCommentLines(this.commentLines);
        this.readerForDomains.closeReader();
        return arrayList;
    }

    private void parseInRightSequence() {
        String string = this.getDataHierarchyStyle(this.chainBuilder.getSpecificRowHandler(RHDataModel.class).getOwnLines());
        if ("1".equals(string)) {
            this.view.getSettings().setBoxInBox(false);
        } else {
            this.view.getSettings().setBoxInBox(true);
        }
        ArrayList arrayList = new ArrayList(this.allSelectedLines);
        double d = 50.0;
        int n = this.importPM ? SEQUENCE.length : SEQUENCE_NO_PM.length;
        for (int i = 0; i < n; ++i) {
            d += 50.0 / (double)n;
            if (this.importPM) {
                this.monitor.setNote(MessageFormat.format(Messages.getString("ParserSeperateVar.Processing"), SEQUENCE[i].toString()));
            } else {
                this.monitor.setNote(MessageFormat.format(Messages.getString("ParserSeperateVar.Processing"), SEQUENCE_NO_PM[i].toString()));
            }
            this.monitor.setProgress((int)d);
            int n2 = arrayList.size();
            for (int j = 0; j < n2; ++j) {
                VarFileLine varFileLine = (VarFileLine)arrayList.get(j);
                boolean bl = this.importPM ? varFileLine.getType().equalsIgnoreCase(SEQUENCE[i]) : varFileLine.getType().equalsIgnoreCase(SEQUENCE_NO_PM[i]);
                if (!bl) continue;
                try {
                    RowHandler rowHandler = (RowHandler)this.chainBuilder.getObjectMap().get(varFileLine.getType());
                    if (rowHandler == null) continue;
                    rowHandler.handle(varFileLine, this.hasMapping);
                    continue;
                }
                catch (Exception exception) {
                    LOGGER.error("Unable to handle the line: " + varFileLine.getLine(), exception);
                    this.chainBuilder.getChain().nextHandler(varFileLine, this.hasMapping);
                }
            }
        }
    }

    private void nullifyAll1() {
        this.allCreatedObjects = null;
        this.allReferences = null;
        this.allForeignKeyLines = null;
        this.allPrimaryKeyLines = null;
        this.allColumnLines = null;
        this.commentLines = null;
    }

    private void nullifyAll2() {
        this.allSelectedLines = null;
        this.chainBuilder = null;
    }

    private String getDataModelId(List list) {
        String string;
        RowHandler rowHandler = this.chainBuilder.getChain();
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            VarFileLine varFileLine = (VarFileLine)iterator.next();
            string = rowHandler.getField(varFileLine.getLine(), new Integer(1));
        } else {
            string = null;
        }
        return string;
    }

    private String getDataHierarchyStyle(List list) {
        String string;
        RowHandler rowHandler = this.chainBuilder.getChain();
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            VarFileLine varFileLine = (VarFileLine)iterator.next();
            string = rowHandler.getField(varFileLine.getLine(), new Integer(15));
        } else {
            string = null;
        }
        return string;
    }

    private String getDataModelDiagramId(List list, String string) {
        String string2 = null;
        RowHandler rowHandler = this.chainBuilder.getChain();
        for (VarFileLine varFileLine : list) {
            string2 = rowHandler.getField(varFileLine.getLine(), new Integer(1));
            if (!string.equalsIgnoreCase(string2)) continue;
            return rowHandler.getField(varFileLine.getLine(), new Integer(2));
        }
        return null;
    }

    private String getProcessModelDiagramId(List list, String string) {
        String string2 = null;
        RowHandler rowHandler = this.chainBuilder.getChain();
        for (VarFileLine varFileLine : list) {
            string2 = rowHandler.getField(varFileLine.getLine(), new Integer(1));
            if (!string.equalsIgnoreCase(string2)) continue;
            return rowHandler.getField(varFileLine.getLine(), new Integer(2));
        }
        return null;
    }

    private void rearrangeEntitiesAndPartnerships() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        List list = this.chainBuilder.getSpecificRowHandler(RHPartnership.class).getOwnLines();
        List list2 = this.chainBuilder.getSpecificRowHandler(RHPartnershipDiagram.class).getOwnLines();
        List list3 = this.chainBuilder.getSpecificRowHandler(RHEntityDiagramObj.class).getOwnLines();
        List list4 = null;
        if (this.importPM) {
            list4 = this.chainBuilder.getSpecificRowHandler(RHAPODiagramObj.class).getOwnLines();
        }
        List list5 = this.chainBuilder.getSpecificRowHandler(RHAnlextRteObj.class).getOwnLines();
        String string = this.getDataModelId(this.chainBuilder.getSpecificRowHandler(RHDataModel.class).getOwnLines());
        String string2 = this.getDataModelDiagramId(this.chainBuilder.getSpecificRowHandler(RHDataModelDiagram.class).getOwnLines(), string);
        if (string2 != null && (object4 = (List)this.chainBuilder.getSpecificRowHandler(RHDiagramObjectPro.class).getMap().get(string2)) != null) {
            this.initMinleftMaxtop((List)object4, list5);
            this.rearrangeEntities(list3, (List)object4);
            this.rearrangePartnerships(list, list2, (List)object4, list5, this.minLeft, this.maxTop);
        }
        if (this.importPM) {
            object4 = this.chainBuilder.getSpecificRowHandler(RHProcessModel.class).getOwnLines();
            object3 = object4.iterator();
            object2 = this.chainBuilder.getChain();
            while (object3.hasNext()) {
                List list6;
                object = (VarFileLine)object3.next();
                String string3 = ((RowHandler)object2).getField(((VarFileLine)object).getLine(), new Integer(1));
                String string4 = this.getProcessModelDiagramId(this.chainBuilder.getSpecificRowHandler(RHProcessModelDiagram.class).getOwnLines(), string3);
                if (string4 == null || (list6 = (List)this.chainBuilder.getSpecificRowHandler(RHDiagramObjectPro.class).getMap().get(string4)) == null) continue;
                this.initMinleftMaxtop(list6, list5);
                this.rearrangeProcessObjects(list4, list6);
            }
            object3 = this.design.getProcessModel().getDataFlowDesigns().iterator();
            while (object3.hasNext()) {
                object = (DataFlowDesign)object3.next();
                ((DataFlowDesign)object).getMainView().getWorkSpace().alignDiagram();
            }
        }
        object4 = this.design.getLogicalDesign().getRelationSet().iterator();
        object3 = this.design.getLogicalDesign().getMainView();
        while (object4.hasNext()) {
            object2 = (Relation)object4.next();
            object = (TVRelation)((Relation)object2).getViewFor((DesignPartView)object3);
            if (object == null) continue;
            ((TVRelation)object).resetEdgeParams();
        }
    }

    private void rearrangePartnerships(List list, List list2, List list3, List list4, int n, int n2) {
        RowHandler rowHandler = this.chainBuilder.getChain();
        Iterator iterator = list.iterator();
        Integer n3 = new Integer(1);
        Integer n4 = new Integer(2);
        while (iterator.hasNext()) {
            String string;
            VarFileLine varFileLine = (VarFileLine)iterator.next();
            String string2 = rowHandler.getField(varFileLine, "general_id");
            Relation relation = (Relation)rowHandler.getAllCreatedObjects().get(string2);
            if (relation.getTopView() == null) {
                rowHandler.getDesign().getLogicalDesign().getMainView().createViewFor(relation);
            }
            if ((string = this.getIdFromList(list2, string2, n3, n4, rowHandler)) == null) continue;
            List list5 = this.getPartnershipPoints(list3, string, list4, n, n2, rowHandler);
            this.addRelPoints(relation, list5);
        }
    }

    private List getPartnershipPoints(List list, String string, List list2, int n, int n2, RowHandler rowHandler) {
        ArrayList<Point> arrayList = new ArrayList<Point>();
        Iterator iterator = list.iterator();
        Integer n3 = new Integer(1);
        int n4 = 19;
        Integer n5 = new Integer(n4);
        while (iterator.hasNext()) {
            int n6;
            VarFileLine varFileLine = (VarFileLine)iterator.next();
            String string2 = varFileLine.getLine();
            String string3 = rowHandler.getField(string2, n3);
            if (!string.equalsIgnoreCase(string3)) continue;
            int n7 = n6 = Integer.parseInt(rowHandler.getField(string2, n5));
            if (n6 > 1) {
                if (n7 > 5) {
                    n7 = 5;
                }
                for (int i = n4; i < n4 + n7 * 2; i += 2) {
                    String string4 = rowHandler.getField(string2, new Integer(i + 1));
                    String string5 = rowHandler.getField(string2, new Integer(i + 2));
                    int n8 = Integer.parseInt(string4);
                    int n9 = Integer.parseInt(string5);
                    n8 = n < 0 ? 20 + n8 + n * -1 : 20 + n8 - n;
                    n9 = n2 > 0 ? 20 + n2 - n9 : 20 + n9 * -1 + n2;
                    arrayList.add(new Point(n8, n9));
                }
            }
            if (n6 == n7) break;
            this.addPointsFromAnlextRteObj(arrayList, string, list2, n, n2, rowHandler);
            break;
        }
        return arrayList;
    }

    private void addPointsFromAnlextRteObj(List list, String string, List list2, int n, int n2, RowHandler rowHandler) {
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = list2.iterator();
        Integer n3 = new Integer(8);
        while (iterator.hasNext()) {
            VarFileLine varFileLine = (VarFileLine)iterator.next();
            string2 = varFileLine.getLine();
            String string3 = rowHandler.getField(string2, n3);
            if (!string.equalsIgnoreCase(string3)) continue;
            arrayList.add(string2);
        }
        iterator = arrayList.iterator();
        int n4 = 8;
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            for (int i = n4; i < n4 + 10; i += 2) {
                String string4 = rowHandler.getField(string2, new Integer(i + 1));
                String string5 = rowHandler.getField(string2, new Integer(i + 2));
                if (string4.equalsIgnoreCase("0") && string5.equalsIgnoreCase("0")) continue;
                int n5 = Integer.parseInt(string4);
                int n6 = Integer.parseInt(string5);
                n5 = n < 0 ? 20 + n5 + n * -1 : 20 + n5 - n;
                n6 = n2 > 0 ? 20 + n2 - n6 : 20 + n6 * -1 + n2;
                list.add(new Point(n5, n6));
            }
        }
    }

    private String getIdFromList(List list, String string, Integer n, Integer n2, RowHandler rowHandler) {
        String string2 = null;
        for (VarFileLine varFileLine : list) {
            String string3 = rowHandler.getField(varFileLine.getLine(), n);
            if (!string.equalsIgnoreCase(string3)) continue;
            string2 = rowHandler.getField(varFileLine.getLine(), n2);
            return string2;
        }
        return string2;
    }

    private void addRelPoints(Relation relation, List list) {
        try {
            if (list.size() > 1) {
                TVRelation tVRelation;
                if (list.size() > 2) {
                    TVRelation tVRelation2 = (TVRelation)relation.getTopView();
                    if (tVRelation2 != null) {
                        EdgeView edgeView = (EdgeView)tVRelation2.getCellView();
                        for (int i = 1; i < list.size() - 1; ++i) {
                            Point point = (Point)list.get(i);
                            point.x = (int)((double)point.x * this.scale);
                            point.y = (int)((double)point.y * this.scale);
                            tVRelation2.getEdgePoints().add(DiagramConstants.createPoint(point));
                        }
                        tVRelation2.getDesignPartView().getWorkSpace().addPoints((DefaultEdge)edgeView.getCell(), tVRelation2.getEdgePoints());
                        edgeView.update();
                    }
                } else if (list.size() == 2 && (tVRelation = (TVRelation)relation.getTopView()) != null) {
                    Point point = (Point)list.get(0);
                    Point point2 = (Point)list.get(1);
                    if (point.x == point2.x) {
                        int n = (point.y + point2.y) / 2;
                        tVRelation.getEdgePoints().add(DiagramConstants.createPoint(new Point((int)((double)point.x * this.scale), (int)((double)n * this.scale))));
                        EdgeView edgeView = (EdgeView)tVRelation.getCellView();
                        tVRelation.getDesignPartView().getWorkSpace().addPoints((DefaultEdge)edgeView.getCell(), tVRelation.getEdgePoints());
                        edgeView.update();
                    } else if (point.y == point2.y) {
                        int n = (point.x + point2.x) / 2;
                        tVRelation.getEdgePoints().add(DiagramConstants.createPoint(new Point((int)((double)n * this.scale), (int)((double)point.y * this.scale))));
                        EdgeView edgeView = (EdgeView)tVRelation.getCellView();
                        tVRelation.getDesignPartView().getWorkSpace().addPoints((DefaultEdge)edgeView.getCell(), tVRelation.getEdgePoints());
                        edgeView.update();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initMinleftMaxtop(List list, List list2) {
        this.minLeft = Integer.MAX_VALUE;
        this.maxTop = -2147483647;
        RowHandler rowHandler = this.chainBuilder.getChain();
        Iterator iterator = list.iterator();
        int n = 19;
        Integer n2 = new Integer(1);
        Integer n3 = new Integer(n);
        while (iterator.hasNext()) {
            VarFileLine varFileLine = (VarFileLine)iterator.next();
            String string = varFileLine.getLine();
            String string2 = rowHandler.getField(string, n2);
            int n4 = Integer.parseInt(rowHandler.getField(string, n3));
            int n5 = n4;
            if (n5 > 5) {
                n5 = 5;
            }
            for (int i = n; i < n + n5 * 2; i += 2) {
                String string3 = rowHandler.getField(string, new Integer(i + 1));
                String string4 = rowHandler.getField(string, new Integer(i + 2));
                int n6 = Integer.parseInt(string3);
                int n7 = Integer.parseInt(string4);
                if (n6 < this.minLeft) {
                    this.minLeft = n6;
                }
                if (n7 <= this.maxTop) continue;
                this.maxTop = n7;
            }
            if (n4 == n5) continue;
            this.scanPointsFromAnlextRteObj(string2, list2, rowHandler);
        }
    }

    private void scanPointsFromAnlextRteObj(String string, List list, RowHandler rowHandler) {
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = list.iterator();
        Integer n = new Integer(8);
        while (iterator.hasNext()) {
            VarFileLine varFileLine = (VarFileLine)iterator.next();
            string2 = varFileLine.getLine();
            String string3 = rowHandler.getField(string2, n);
            if (!string.equalsIgnoreCase(string3)) continue;
            arrayList.add(string2);
        }
        iterator = arrayList.iterator();
        int n2 = 8;
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            for (int i = n2; i < n2 + 10; i += 2) {
                String string4 = rowHandler.getField(string2, new Integer(i + 1));
                String string5 = rowHandler.getField(string2, new Integer(i + 2));
                if (string4.equalsIgnoreCase("0") && string5.equalsIgnoreCase("0")) continue;
                int n3 = Integer.parseInt(string4);
                int n4 = Integer.parseInt(string5);
                if (n3 < this.minLeft) {
                    this.minLeft = n3;
                }
                if (n4 <= this.maxTop) continue;
                this.maxTop = n4;
            }
        }
    }

    private void rearrangeProcessObjects(List list, List list2) {
        RowHandler rowHandler = this.chainBuilder.getChain();
        int n = list2.size();
        block2: for (int i = 0; i < n; ++i) {
            VarFileLine varFileLine = (VarFileLine)list2.get(i);
            String string = rowHandler.getField(varFileLine, "general_id");
            int n2 = list.size();
            for (int j = n2 - 1; j >= 0; --j) {
                VarFileLine varFileLine2 = (VarFileLine)list.get(j);
                String string2 = rowHandler.getField(varFileLine2, "DIAGRAM_ID");
                if (!string.equalsIgnoreCase(string2)) continue;
                String string3 = rowHandler.getField(varFileLine2, "general_id");
                AbstractProcessObject abstractProcessObject = (AbstractProcessObject)rowHandler.getAllCreatedObjects().get(string3);
                if (abstractProcessObject == null) continue;
                try {
                    int n3 = Integer.parseInt(rowHandler.getField(varFileLine, "DIAGRAM_LEFT"));
                    int n4 = Integer.parseInt(rowHandler.getField(varFileLine, "DIAGRAM_TOP"));
                    int n5 = Integer.parseInt(rowHandler.getField(varFileLine, "DIAGRAM_WIDTH"));
                    int n6 = Integer.parseInt(rowHandler.getField(varFileLine, "DIAGRAM_HEIGHT"));
                    n5 = this.minLeft < 0 ? n5 + this.minLeft * -1 - (n3 += this.minLeft * -1) : n5 - this.minLeft - (n3 -= this.minLeft);
                    if (this.maxTop > 0) {
                        n4 = this.maxTop - n4;
                        n6 = this.maxTop - n6 - n4;
                    } else {
                        n4 = n4 * -1 + this.maxTop;
                        n6 = n6 * -1 + this.maxTop - n4;
                    }
                    Rectangle rectangle = new Rectangle(n3 / 2 + 20, n4 / 2 + 20, n5 / 2, n6 / 2);
                    List list3 = abstractProcessObject.getAllViews();
                    for (TopView topView : list3) {
                        if (topView == null) continue;
                        if (topView.getCellView() != null) {
                            topView.getCellView().setNewBounds(rectangle);
                            continue;
                        }
                        topView.setBounds(rectangle);
                    }
                    list.remove(varFileLine2);
                }
                catch (NumberFormatException numberFormatException) {
                    StringBuffer stringBuffer = new StringBuffer("wrong Format in rearrangeProcessObjects: ");
                    stringBuffer.append(varFileLine.getLine());
                    LOGGER.error(stringBuffer.toString(), numberFormatException);
                }
                continue block2;
            }
        }
    }

    private void rearrangeEntities(List list, List list2) {
        RowHandler rowHandler = this.chainBuilder.getChain();
        Iterator iterator = list.iterator();
        String string = "";
        block2: while (iterator.hasNext()) {
            VarFileLine varFileLine = (VarFileLine)iterator.next();
            if (!varFileLine.getType().equalsIgnoreCase("ENTITYDIAGRAM_OBJE") || string.equalsIgnoreCase(rowHandler.getField(varFileLine, "general_id"))) continue;
            string = rowHandler.getField(varFileLine, "general_id");
            Entity entity = (Entity)rowHandler.getAllCreatedObjects().get(string);
            if (entity == null) continue;
            String string2 = rowHandler.getField(varFileLine, "DIAGRAM_ID");
            for (VarFileLine varFileLine2 : list2) {
                String string3;
                if (!varFileLine2.getType().equalsIgnoreCase("DIAGRAM_OBJECT_PRO") || !string2.equalsIgnoreCase(string3 = rowHandler.getField(varFileLine2, "general_id"))) continue;
                try {
                    TopView topView;
                    int n = Integer.parseInt(rowHandler.getField(varFileLine2, "DIAGRAM_LEFT"));
                    int n2 = Integer.parseInt(rowHandler.getField(varFileLine2, "DIAGRAM_TOP"));
                    int n3 = Integer.parseInt(rowHandler.getField(varFileLine2, "DIAGRAM_WIDTH"));
                    int n4 = Integer.parseInt(rowHandler.getField(varFileLine2, "DIAGRAM_HEIGHT"));
                    int n5 = Integer.parseInt(rowHandler.getField(varFileLine2, "DIAGRAM_ENT_COLOR"));
                    n3 = this.minLeft < 0 ? n3 + this.minLeft * -1 - (n += this.minLeft * -1) : n3 - this.minLeft - (n -= this.minLeft);
                    if (this.maxTop > 0) {
                        n2 = this.maxTop - n2;
                        n4 = this.maxTop - n4 - n2;
                    } else {
                        n2 = n2 * -1 + this.maxTop;
                        n4 = n4 * -1 + this.maxTop - n2;
                    }
                    if ((topView = entity.getTopView()) == null) continue block2;
                    if (topView.getCellView() != null) {
                        topView.getCellView().setNewBounds(new Rectangle((int)((double)n * this.scale + 20.0), (int)((double)n2 * this.scale + 20.0), (int)((double)n3 * this.scale), (int)((double)n4 * this.scale)));
                    } else {
                        topView.setBounds(new Rectangle((int)((double)n * this.scale + 20.0), (int)((double)n2 * this.scale + 20.0), (int)((double)n3 * this.scale), (int)((double)n4 * this.scale)));
                    }
                    RHPlacement.setColor(topView, n5);
                }
                catch (NumberFormatException numberFormatException) {
                    StringBuffer stringBuffer = new StringBuffer("wrong Format in rearrangeEntities: ");
                    stringBuffer.append(varFileLine2.getLine());
                    LOGGER.error(stringBuffer.toString(), numberFormatException);
                }
                continue block2;
            }
        }
    }

    static void initialSettings(Design design) {
        Settings settings = design.getAppView().getSettings();
        settings.setNotation(0);
        design.getAppView().updateSettings(true, true);
    }

    static void createDetailsDisplay(Design design) {
    }

    class Holder {
        Map map;
        ContainerObject container;

        Holder() {
        }
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        @Override
        public void run() {
            TimeLog.log("Start");
            try {
                ImportLogger importLogger = new ImportLogger();
                ParserSeperateVar.this.parse();
                if (ParserSeperateVar.this.design.getRelationalDesign().getTableSet().size() > 0) {
                    ParserSeperateVar.this.view.setCurrentDPV(ParserSeperateVar.this.design.getRelationalDesign().getMainView());
                } else {
                    ParserSeperateVar.this.view.setCurrentDPV(ParserSeperateVar.this.design.getLogicalDesign().getMainView());
                }
                ParserSeperateVar.this.view.centerDesign();
                ParserSeperateVar.this.design.getDataTypesDesign().setDirty(false);
                if (ParserSeperateVar.this.view.getSettings().showImportLog()) {
                    LogReport logReport = new LogReport(ParserSeperateVar.this.view);
                    logReport.setLog(importLogger.generateVARReport(ParserSeperateVar.this.view));
                    logReport.showDialog(new Dimension(750, 550));
                }
                System.gc();
            }
            catch (Exception exception) {
                ParserSeperateVar.this.design.destroyAll(false);
                ParserSeperateVar.this.design.destroyAll(true);
                ParserSeperateVar.this.design = null;
                LOGGER.error("Error Parsing File: " + ParserSeperateVar.this.designName, exception);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("ParserSeperateVar.UnabletoImPortTheFile"), Messages.getString("ParserSeperateVar.ErrorImportingFile"), 0);
            }
            TimeLog.log("End");
        }
    }
}

