/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.MappingBachmannPhysicalDatatype;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.SectionConstants;
import oracle.dbtools.crest.imports.var.ConstantsForDomainCreation;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.LogicalDataTypesVersusBachman;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.StatusBarOwner;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.DomainFactory;
import oracle.dbtools.crest.model.design.LogicalDataTypeStrings;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.LogicalDatatypeFactory;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.util.logging.Logger;

public class DomainHandlerVarConversie
extends RowHandler
implements ConstantsForDomainCreation,
LogicalDataTypeStrings,
SectionConstants {
    private DomainFactory factory = new DomainFactory();
    private LogicalDatatypeFactory factoryLogicalDatatype = new LogicalDatatypeFactory();
    private Map avtMap = new TreeMap();
    private List notes = new ArrayList();
    private static final Logger LOGGER = new Logger(DomainHandlerVarConversie.class);

    public DomainHandlerVarConversie(Design design, Fields fields, List list, Map map, List list2, List list3, Map map2, List list4, List list5) {
        super(design, fields, list, map, list2, list3, map2, list4, list5);
    }

    public void createDomains(List list, List list2, StatusBarOwner statusBarOwner) {
        this.createDomains(list, list2);
    }

    private void collectAVTandNotes(List list) {
        this.avtMap.clear();
        this.notes.clear();
        for (int i = list.size() - 1; i >= 0; --i) {
            VarFileLine varFileLine = (VarFileLine)list.get(i);
            if (varFileLine.getType().equalsIgnoreCase("ALLOWED_VAL_TBL")) {
                String string = this.getField(varFileLine, "general_id");
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Object object;
                    String string2;
                    String string3 = "";
                    String string4 = "";
                    String string5 = "";
                    VarFileLine varFileLine2 = (VarFileLine)iterator.next();
                    if (!varFileLine2.getType().equalsIgnoreCase("ALLOWABLE_VALUE") || !string.equalsIgnoreCase(string2 = this.getField(varFileLine2, "AVT_ID"))) continue;
                    String string6 = this.getField(varFileLine2, "AVT_TEXT_ID_2");
                    if (!"0".equalsIgnoreCase(string6) && (object = this.getCommentLine(string6, "ANLTEXT", list)) != null) {
                        string3 = this.getField((VarFileLine)object, "TEXT_COMMENT_2");
                    }
                    string4 = this.getField(varFileLine2, "AVT_START_VALUE");
                    string5 = this.getField(varFileLine2, "AVT_END_VALUE");
                    if ("".equalsIgnoreCase(string4) && "".equalsIgnoreCase(string5) && "".equalsIgnoreCase(string3)) continue;
                    object = new AVTObj(string3, string4, string5);
                    ArrayList<Object> arrayList = (ArrayList<Object>)this.avtMap.get(string);
                    if (arrayList == null) {
                        arrayList = new ArrayList<Object>();
                        this.avtMap.put(string, arrayList);
                    }
                    arrayList.add(object);
                }
                list.remove(i);
                continue;
            }
            if (!varFileLine.getType().equalsIgnoreCase("NOTES")) continue;
            this.notes.add(varFileLine);
            list.remove(i);
        }
    }

    public void createDomains(List list, List list2) {
        this.collectAVTandNotes(list2);
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            String[] stringArray;
            String[] stringArray2;
            Object object2;
            CharSequence charSequence;
            VarFileLine varFileLine = (VarFileLine)list.get(i);
            if (varFileLine.getType().equalsIgnoreCase("DOMAINS")) {
                String string = this.getField(varFileLine, "DOMAIN_DATATYPE");
                charSequence = LogicalDataTypesVersusBachman.getNameLogDataTypeFromBachName(string);
                object2 = this.factoryLogicalDatatype.searchLogicalDatatype(this.getDesign(), (String)charSequence);
                stringArray2 = this.fillParametersDomains(varFileLine, (String)charSequence);
                stringArray = this.getField(varFileLine, "DOMAIN_NAME");
                object = this.factory.getInstance(this.getDesign(), (LogicalDatatype)object2, null, 1, stringArray2, (String)stringArray);
                ((ModelIDObject)object).setComment(this.getComment(varFileLine, list2));
                ((ModelIDObject)object).setNotes(this.getNotes(varFileLine, list2));
                ((Domain)object).setSynonym(this.getSynonym(varFileLine, list2));
                this.setAVT(varFileLine, (Domain)object);
                ((Domain)object).setDimension(this.getDimension(varFileLine, list2));
                continue;
            }
            try {
                int n = Integer.parseInt(this.getField(varFileLine, "COLUMN_TYPE"));
                charSequence = MappingBachmannPhysicalDatatype.getNamePhysicalDatatype(n);
                object2 = StandardDatatypeNames.getUsedDatatypeName((String)charSequence);
                stringArray2 = MappingDatatypeNameLogicalDataType.getLogicalDatatype(StorageDesignDB2v70.RDBMS_TYPE, (String)object2);
                stringArray = new String[3];
                object = this.getField(varFileLine, "COLUMN_SCALE");
                if (((String)object).equalsIgnoreCase("0")) {
                    if (((String)object2).equals("real") || ((String)object2).equals("NUMERIC") || ((String)object2).equals("DECIMAL")) {
                        stringArray[2] = object;
                        stringArray[1] = object;
                        stringArray[0] = this.getField(varFileLine, "COLUMN_LENGTH");
                    } else {
                        stringArray[2] = this.getField(varFileLine, "COLUMN_LENGTH");
                        stringArray[1] = object;
                        stringArray[0] = object;
                    }
                } else {
                    stringArray[2] = "0";
                    stringArray[1] = object;
                    stringArray[0] = this.getField(varFileLine, "COLUMN_LENGTH");
                }
                this.factory.getInstance(this.getDesign(), (LogicalDatatype)stringArray2, null, 0, stringArray, null);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                charSequence = new StringBuffer("wrong Format in DomainHandlerVarConversie.createDomains : ");
                ((StringBuffer)charSequence).append(varFileLine.getLine());
                LOGGER.error(((StringBuffer)charSequence).toString(), numberFormatException);
            }
        }
    }

    private String[] fillParametersDomains(VarFileLine varFileLine, String string) {
        String[] stringArray = new String[3];
        if (string.equals("alphabetic") || string.equals("long alphabetic") || string.equals("alphanumeric") || string.equals("long alphanumeric") || string.equals("mixed") || string.equals("doublebyte") || string.equals("VARCHAR") || string.equals("CHAR") || string.equals("GRAPHIC") || string.equals("VARGRAPHIC")) {
            stringArray[2] = this.getField(varFileLine, "DOMAIN_MAXLEN");
        } else if (string.equals("real") || string.equals("NUMERIC") || string.equals("DECIMAL")) {
            stringArray[1] = this.getField(varFileLine, "DOMAIN_SCALE");
            stringArray[0] = this.getField(varFileLine, "DOMAIN_PRECISION");
        }
        return stringArray;
    }

    private String getComment(VarFileLine varFileLine, List list) {
        String string = null;
        String string2 = this.getField(varFileLine, "DOMAIN_TEXT_ID");
        if (!"0".equalsIgnoreCase(string2)) {
            VarFileLine varFileLine2 = this.getCommentLine(string2, "ANLTEXT", list);
            if (varFileLine2 != null) {
                string = this.getField(varFileLine2, "TEXT_COMMENT_2");
                this.removeSelectedLine(varFileLine2);
            }
        } else {
            string = "";
        }
        return string;
    }

    private String getNotes(VarFileLine varFileLine, List list) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = this.getField(varFileLine, "general_id");
        ArrayList<VarFileLine> arrayList = new ArrayList<VarFileLine>();
        for (VarFileLine varFileLine2 : this.notes) {
            VarFileLine varFileLine3;
            String string2 = this.getField(varFileLine2, "NOTE_DOMAIN_ID");
            if (!string.equalsIgnoreCase(string2)) continue;
            String string3 = this.getField(varFileLine2, "note_text_id");
            if (!"0".equalsIgnoreCase(string3) && (varFileLine3 = this.getCommentLine(string3, "ANLTEXT", list)) != null) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("\n");
                }
                stringBuffer.append(this.getField(varFileLine3, "TEXT_COMMENT_2"));
            }
            arrayList.add(varFileLine2);
        }
        this.notes.removeAll(arrayList);
        return stringBuffer.toString();
    }

    private String getSynonym(VarFileLine varFileLine, List list) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = this.getField(varFileLine, "general_id");
        for (VarFileLine varFileLine2 : list) {
            VarFileLine varFileLine3;
            String string2;
            String string3;
            if (!varFileLine2.getType().equalsIgnoreCase("DOMAINSSYNONYM_OBJ") || !string.equalsIgnoreCase(string3 = this.getField(varFileLine2, "general_id")) || "0".equalsIgnoreCase(string2 = this.getField(varFileLine2, "SYNONYM_ID")) || (varFileLine3 = this.getCommentLine(string2, "SYNONYM_OBJECT", list)) == null) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.getField(varFileLine3, "SYNONYM_OBJ_NAME"));
        }
        return stringBuffer.toString();
    }

    private void setAVT(VarFileLine varFileLine, Domain domain) {
        List list;
        String string = this.getField(varFileLine, "DOMAIN_ALLOWED_VAL_TBL");
        if (!"0".equalsIgnoreCase(string) && (list = (List)this.avtMap.get(string)) != null) {
            for (AVTObj aVTObj : list) {
                if (aVTObj == null) continue;
                AVT aVT = new AVT(aVTObj.getAvtStart(), aVTObj.getAvtEnd(), aVTObj.getComment());
                domain.addAVT(aVT);
            }
        }
    }

    private String getDimension(VarFileLine varFileLine, List list) {
        VarFileLine varFileLine2;
        String string = "";
        String string2 = this.getField(varFileLine, "DOMAIN_DIMENSION");
        if (!"0".equalsIgnoreCase(string2) && (varFileLine2 = this.getCommentLine(string2, "DIMENSION", list)) != null) {
            string = this.getField(varFileLine2, "DIMENSION_NAME");
        }
        return string;
    }

    class AVTObj {
        private String comment = "";
        private String avtStart = "";
        private String avtEnd = "";

        public AVTObj(String string, String string2, String string3) {
            this.comment = string;
            this.avtStart = string2;
            this.avtEnd = string3;
        }

        public String getAvtEnd() {
            return this.avtEnd;
        }

        public String getAvtStart() {
            return this.avtStart;
        }

        public String getComment() {
            return this.comment;
        }
    }
}

