/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.parser;

import java.util.Properties;

public class SQLCommand {
    public static final String PROP_STATUS_BOOLEAN = "prop_status_boolean";
    public static final String PROP_STRING = "prop_file_string";
    public static final String PROP_ERROR_STRING = "prop_error_string";
    private StmtType m_stmtType = null;
    private StmtSubType m_stmtSubType = null;
    private StmtResultType m_stmtResultType = null;
    private boolean m_isExecutable = true;
    private int m_startLine = -1;
    private int m_endLine = -1;
    private String m_sql = null;
    private Properties m_properties = new Properties();

    public SQLCommand(String string) {
        this.m_sql = string;
    }

    public SQLCommand(StmtType stmtType, StmtSubType stmtSubType, StmtResultType stmtResultType, boolean bl) {
        this.m_stmtType = stmtType;
        this.m_stmtSubType = stmtSubType;
        this.m_stmtResultType = stmtResultType;
        this.m_isExecutable = bl;
    }

    public SQLCommand(SQLCommand sQLCommand) {
        this.m_stmtType = sQLCommand.getStmtType();
        this.m_stmtSubType = sQLCommand.getStmtSubType();
        this.m_stmtResultType = sQLCommand.getStmtResultType();
        this.m_isExecutable = sQLCommand.isExecutable();
    }

    public StmtResultType getStmtResultType() {
        return this.m_stmtResultType;
    }

    public void setStmtResultType(StmtResultType stmtResultType) {
        this.m_stmtResultType = stmtResultType;
    }

    public StmtSubType getStmtSubType() {
        return this.m_stmtSubType;
    }

    public void setStmtSubType(StmtSubType stmtSubType) {
        this.m_stmtSubType = stmtSubType;
    }

    public StmtType getStmtType() {
        return this.m_stmtType;
    }

    public void setStmtType(StmtType stmtType) {
        this.m_stmtType = stmtType;
    }

    public boolean isExecutable() {
        return this.m_isExecutable;
    }

    public void setExecutable(boolean bl) {
        this.m_isExecutable = bl;
    }

    public int getEndLine() {
        return this.m_endLine;
    }

    public int getLines() {
        return this.getEndLine() - this.getStartLine();
    }

    public String getSql() {
        return this.m_sql;
    }

    public int getStartLine() {
        return this.m_startLine;
    }

    public void setEndLine(int n) {
        this.m_endLine = n;
    }

    public void setSql(String string) {
        this.m_sql = string;
    }

    public void setStartLine(int n) {
        this.m_startLine = n;
    }

    public boolean isComment() {
        return this.getStmtSubType().toString().equals("G_S_COMMENT_PLUS");
    }

    public boolean isSqlPlusSetCmd() {
        return this.getStmtType() == StmtType.G_C_SQLPLUS && this.getStmtSubType().toString().startsWith("G_S_SET_");
    }

    public boolean isCreateSQLCmd() {
        return this.getStmtType() == StmtType.G_C_SQL && this.getStmtSubType().toString().startsWith("G_S_CREATE_");
    }

    public boolean isCreatePLSQLCmd() {
        return this.getStmtType() == StmtType.G_C_PLSQL && this.getStmtSubType().toString().startsWith("G_S_CREATE_");
    }

    public boolean isCreateCmd() {
        return this.getStmtSubType().toString().startsWith("G_S_CREATE_");
    }

    public Object getProperty(String string) {
        return this.m_properties.get(string);
    }

    public void setProperty(String string, Object object) {
        this.m_properties.put(string, object);
    }

    public static enum StmtResultType {
        G_R_QUERY,
        G_R_DML,
        G_R_THREE_WORD,
        G_R_ONE_WORD,
        G_R_PERMISSION,
        G_R_NONE,
        G_R_UNKNOWN;

    }

    public static enum StmtSubType {
        G_S_UNKNOWN,
        G_S_ACCEPT,
        G_S_ALTER,
        G_S_ANALYZE,
        G_S_APPEND,
        G_S_ARCHIVE,
        G_S_ASSOCIATE,
        G_S_AT,
        G_S_ATNESTED,
        G_S_ATTRIBUTE,
        G_S_AUDIT,
        G_S_BEGIN,
        G_S_BLOCKTERMINATOR,
        G_S_BREAK,
        G_S_BTITLE,
        G_S_CALL,
        G_S_CHANGE,
        G_S_CLEAR,
        G_S_COLUMN,
        G_S_COMMENT_SQL,
        G_S_COMMIT,
        G_S_COMMENT_PLUS,
        G_S_COMPUTE,
        G_S_CONNECT,
        G_S_COPY,
        G_S_DECLARE,
        G_S_DEFINE,
        G_S_DEL_PLUS,
        G_S_DELETE,
        G_S_DESCRIBE,
        G_S_DISASSOCIATE,
        G_S_DISCONNECT,
        G_S_DROP,
        G_S_EDIT,
        G_S_EXECUTE,
        G_S_EXPAND,
        G_S_EXIT,
        G_S_EXPLAIN,
        G_S_FLASHBACK,
        G_S_GET,
        G_S_GRANT,
        G_S_HOST,
        G_S_HOSTALIAS,
        G_S_HELP,
        G_S_INPUT,
        G_S_INSERT,
        G_S_LIST,
        G_S_LOCK,
        G_S_MERGE,
        G_S_NEWPAGE,
        G_S_NOAUDIT,
        G_S_ORADEBUG,
        G_S_PASSWORD,
        G_S_PLSQLLABEL,
        G_S_PAUSE,
        G_S_PRINT,
        G_S_PROMPT,
        G_S_PURGE,
        G_S_QUIT,
        G_S_RENAME,
        G_S_RECOVER,
        G_S_REPFOOTER,
        G_S_REPHEADER,
        G_S_REVOKE,
        G_S_ROLLBACK_PLUS,
        G_S_ROLLBACK_SQL,
        G_S_RUN,
        G_S_SAVE,
        G_S_SAVEPOINT,
        G_S_SELECT,
        G_S_SHOW,
        G_S_SHUTDOWN,
        G_S_SLASH,
        G_S_SPOOL,
        G_S_SQLPLUSPREFIX,
        G_S_SQLTERMINATOR,
        G_S_START,
        G_S_STARTUP,
        G_S_STORE,
        G_S_TIMING,
        G_S_TRUNCATE,
        G_S_TTITLE,
        G_S_UNDEFINE,
        G_S_UPDATE,
        G_S_VALIDATE,
        G_S_VARIABLE,
        G_S_WHENEVER,
        G_S_WITH,
        G_S_XQUERY,
        G_S_SETLOGLEVEL,
        G_S_LOADQUERYFILE,
        G_S_SET_AUTOPRINT,
        G_S_SET_AUTOTRACE,
        G_S_SET_ESCAPE,
        G_S_SET_FEEDBACK,
        G_S_SET_OWA,
        G_S_SET_GETPAGE,
        G_S_SET_SERVEROUTPUT,
        G_S_SET_SPOOL,
        G_S_SET_TERM,
        G_S_SET_TIMING,
        G_S_SET_VERIFY,
        G_S_SET_XQUERY,
        G_S_SET_CONSTRAINT,
        G_S_SET_ROLE,
        G_S_SET_TRANSACTION,
        G_S_SET_PAUSE,
        G_S_SET_ECHO,
        G_S_SET_DEFINE,
        G_S_SET_SCAN,
        G_S_SET_UNKNOWN,
        G_S_CREATE_PACKAGE_HEADER,
        G_S_CREATE_PACKAGE_BODY,
        G_S_CREATE_PROCEDURE,
        G_S_CREATE_TRIGGER,
        G_S_CREATE_FUNCTION,
        G_S_CREATE_TYPE,
        G_S_CREATE_LIBRARY,
        G_S_CREATE_JAVA,
        G_S_CREATE_TABLE,
        G_S_CREATE_DATABASE,
        G_S_CREATE_UNKNOWN,
        G_S_FORALLEVENTS_STMTSUBTYPE,
        G_S_FORALLSTMTS_STMTSUBTYPE,
        G_S_BEFOREAFTER_SCRIPT,
        G_S_SET_WORKSHEETNAME;

    }

    public static enum StmtType {
        G_C_UNKNOWN,
        G_C_SQL,
        G_C_PLSQL,
        G_C_SQLPLUS,
        G_C_COMMENT,
        G_C_EMPTYLINE,
        G_C_MULTILINECOMMENT,
        G_C_OLDCOMMENT,
        G_C_USERDEFINED;

    }
}

