/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.oracledesigner.relational;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.oracledesigner.AbstractObjectHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODExtractionHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.relational.DPVRelationalSubView;
import oracle.dbtools.crest.swingui.relational.TVTable;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class ODRelationalDiagram
extends AbstractObjectHandler {
    public static final String OBJECT_TYPE = "DIAGRAM";
    private static final Logger LOGGER = new Logger(ODRelationalDiagram.class);
    PreparedStatement t_statement;

    public ODRelationalDiagram(ODExtractionHandler oDExtractionHandler, ApplicationView applicationView) {
        super(oDExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        Iterator iterator = this.getExtractionHandler().getSelectedAppSystems().iterator();
        Statement statement = null;
        this.t_statement = null;
        while (iterator.hasNext()) {
            CharSequence charSequence;
            Object object;
            ODObject oDObject = (ODObject)iterator.next();
            ODExtractionHandler.Branch branch = oDObject.branch;
            if (branch == null) {
                if (statement == null) {
                    object = "SELECT d.NAME, d.ID,d.ivid from ci_diagrams d,sdd_folder_members b , i$sdd_wa_context cc where d.ID = b.member_object and b.folder_reference = ?  and b.PARENT_IVID = ? and cc.workarea_irid = ? and d.ivid = cc.object_ivid and cc.wastebasket ='N'  and DIAGRAM_TYPE = 'DSD' and exists (select 1 from CI_DIAGRAM_ELEMENT_USAGES u where u.DIAGRAM_REFERENCE = d.id and u.ELEMENT_TYPE_FOR in ('SNP','TBL','VW') and rownum<2) order by name";
                    statement = connection.prepareStatement((String)object);
                }
                statement.setString(1, oDObject.getIrid());
                statement.setString(2, oDObject.ivid);
                statement.setString(3, oDObject.wa_irid);
            } else {
                if (statement == null) {
                    object = "SELECT d.NAME, d.ID,d.ivid from ci_diagrams d,sdd_folder_members b , i$sdd_wa_context cc where d.ID = b.member_object and b.folder_reference = ?  and b.PARENT_IVID = ? and cc.workarea_irid = ? and d.ivid = cc.object_ivid and cc.wastebasket ='N'  and DIAGRAM_TYPE = 'DSD' and exists (select 1 from CI_DIAGRAM_ELEMENT_USAGES u where u.DIAGRAM_REFERENCE = d.id and u.ELEMENT_TYPE_FOR in ('SNP','TBL','VW') and rownum<2) ";
                    charSequence = new StringBuffer((String)object);
                    statement = connection.prepareStatement(charSequence.toString());
                }
                statement.setString(1, oDObject.getIrid());
                statement.setString(2, oDObject.ivid);
                statement.setString(3, oDObject.wa_irid);
            }
            object = null;
            try {
                object = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("ODRelationalDiagram.extract(): " + sQLException.getMessage());
            }
            if (object == null) continue;
            while (object.next()) {
                charSequence = object.getString("NAME");
                String string = object.getString("ID");
                String string2 = object.getString("ivid");
                DesignPartView designPartView = this.getDesign().getRelationalDesign().createDesignPartSubView();
                designPartView.setName((String)charSequence);
                designPartView.setMustBeVisible(false);
                if (!this.addTableToDiagram(connection, designPartView, string, string2)) {
                    this.getDesign().getRelationalDesign().deleteSubview(designPartView);
                    continue;
                }
                this.setNotesAndComments(connection, designPartView.getPlaceHolder(), string, oDObject.ivid);
                ((DPVRelationalSubView)designPartView).rearrangeNewDiagram();
            }
            object.close();
        }
        if (statement != null) {
            statement.close();
        }
        if (this.t_statement != null) {
            this.t_statement.close();
        }
    }

    private boolean addTableToDiagram(Connection connection, DesignPartView designPartView, String string, String string2) throws Exception {
        Object object;
        boolean bl = false;
        if (this.t_statement == null) {
            object = "SELECT CIELEMENT_REFERENCE id, d.ELEMENT_TYPE_FOR from CI_DIAGRAM_ELEMENT_USAGES d where DIAGRAM_REFERENCE = ?  and ELEMENT_TYPE_FOR in ('SNP','TBL','VW') and d.PARENT_IVID = ? ";
            this.t_statement = connection.prepareStatement((String)object);
        }
        object = null;
        try {
            this.t_statement.setString(1, string);
            this.t_statement.setString(2, string2);
            object = this.t_statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("ODRelationalDiagram.addTableToDiagram(): " + sQLException.getMessage());
        }
        if (object != null) {
            while (object.next()) {
                ContainerView containerView;
                ContainerObject containerObject;
                String string3 = object.getString("ID");
                String string4 = object.getString("ELEMENT_TYPE_FOR");
                if ("TBL".equalsIgnoreCase(string4)) {
                    containerObject = (Table)this.getExtractionHandler().getImportedObject(string3);
                    if (containerObject == null) continue;
                    bl = true;
                    containerView = (ContainerView)designPartView.createTopViewFor(containerObject);
                    ((TVTable)containerView).addTVFKRelations();
                    containerView.addTVTypeSubstitutions();
                    continue;
                }
                if (!"VW".equalsIgnoreCase(string4) || (containerObject = (TableView)this.getExtractionHandler().getImportedObject(string3)) == null) continue;
                bl = true;
                containerView = (ContainerView)designPartView.createTopViewFor(containerObject);
                containerView.addTVTypeSubstitutions();
            }
            object.close();
        }
        return bl;
    }
}

