/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.oracledesigner.physical;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.oracledesigner.AbstractObjectHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODExtractionHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODObject;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class ODOSnapshot
extends AbstractObjectHandler {
    public static final String OBJECT_TYPE = "SNAPSHOT";
    private static final Logger LOGGER = new Logger(ODOSnapshot.class);
    PreparedStatement col_statement;
    PreparedStatement sel_statement;
    PreparedStatement wh_statement;

    public ODOSnapshot(ODExtractionHandler oDExtractionHandler, ApplicationView applicationView) {
        super(oDExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        Statement statement = null;
        Statement statement2 = null;
        ArrayList<ODObject> arrayList = new ArrayList<ODObject>();
        for (ODObject oDObject : list) {
            ODObject oDObject2;
            String string;
            String string2;
            CharSequence charSequence;
            ResultSet resultSet;
            if (!oDObject.isSelected()) continue;
            if (oDObject.branches.size() == 0) {
                resultSet = null;
                if (statement2 == null) {
                    charSequence = new StringBuffer();
                    ((StringBuffer)charSequence).append("select  a.NAME,a.ID,a.ivid    ");
                    ((StringBuffer)charSequence).append("from CI_SNAPSHOT_DEFINITIONS a,sdd_folder_members b , i$sdd_wa_context cc ");
                    ((StringBuffer)charSequence).append("where ");
                    ((StringBuffer)charSequence).append(" a.ID = b.member_object and b.folder_reference = ? ");
                    ((StringBuffer)charSequence).append(" and b.PARENT_IVID = ? ");
                    ((StringBuffer)charSequence).append("and cc.workarea_irid = ?  and a.ivid = cc.object_ivid and cc.wastebasket ='N' ");
                    ((StringBuffer)charSequence).append(" order by name ");
                    statement2 = connection.prepareStatement(((StringBuffer)charSequence).toString());
                }
                try {
                    statement2.setString(1, oDObject.getIrid());
                    statement2.setString(2, oDObject.ivid);
                    statement2.setString(3, oDObject.wa_irid);
                    resultSet = statement2.executeQuery();
                }
                catch (SQLException sQLException) {
                    LOGGER.error("ODOTable.extract(): " + sQLException.getMessage());
                }
                if (resultSet == null) continue;
                while (resultSet.next()) {
                    charSequence = resultSet.getString(1);
                    string2 = resultSet.getString(2);
                    string = resultSet.getString(3);
                    oDObject2 = new ODObject(false, (String)charSequence, OBJECT_TYPE, string2);
                    oDObject2.ivid = string;
                    oDObject2.setParentName(oDObject.getName());
                    oDObject2.setParentID(oDObject.getIrid());
                    arrayList.add(oDObject2);
                }
                resultSet.close();
                continue;
            }
            if (oDObject.branch == null) continue;
            resultSet = null;
            if (statement == null) {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("select  a.NAME,a.ID,a.ivid    ");
                ((StringBuffer)charSequence).append("from CI_SNAPSHOT_DEFINITIONS a,sdd_folder_members b ");
                ((StringBuffer)charSequence).append("where ");
                ((StringBuffer)charSequence).append(" a.ID = b.member_object and b.folder_reference = ? ");
                ((StringBuffer)charSequence).append(" and b.PARENT_IVID = ? ");
                ((StringBuffer)charSequence).append("AND EXISTS \n");
                ((StringBuffer)charSequence).append("(SELECT 1 \n");
                ((StringBuffer)charSequence).append("FROM CI_SNAPSHOT_DEFINITIONS F, \n");
                ((StringBuffer)charSequence).append("  I$sdd_Wa_Context C \n");
                ((StringBuffer)charSequence).append("WHERE a.Irid        = F.Irid \n");
                ((StringBuffer)charSequence).append("AND F.Ivid          = C.Object_Ivid \n");
                ((StringBuffer)charSequence).append("AND C.Workarea_Irid = ? \n");
                ((StringBuffer)charSequence).append(")");
                ((StringBuffer)charSequence).append(" and a.ivid = ");
                ((StringBuffer)charSequence).append(" (select ivid from i$sdd_object_versions v ");
                ((StringBuffer)charSequence).append("  where ");
                ((StringBuffer)charSequence).append("  a.id = v.irid and ");
                ((StringBuffer)charSequence).append("  branch_id = ? ");
                ((StringBuffer)charSequence).append("  and sequence_in_branch  is not null");
                ((StringBuffer)charSequence).append("  and wastebasket='N' ");
                ((StringBuffer)charSequence).append("  and sequence_in_branch = ");
                ((StringBuffer)charSequence).append("   ( ");
                ((StringBuffer)charSequence).append("   select max(sequence_in_branch) from i$sdd_object_versions v2 ");
                ((StringBuffer)charSequence).append("     where ");
                ((StringBuffer)charSequence).append("     v2.irid = a.id");
                ((StringBuffer)charSequence).append("     and branch_id = ? ");
                ((StringBuffer)charSequence).append("     and sequence_in_branch  is not null ");
                ((StringBuffer)charSequence).append("     and wastebasket='N' ");
                ((StringBuffer)charSequence).append("   ) ");
                ((StringBuffer)charSequence).append("  )");
                ((StringBuffer)charSequence).append(" order by name ");
                statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
            }
            try {
                statement.setString(1, oDObject.getIrid());
                statement.setString(2, oDObject.ivid);
                statement.setString(3, oDObject.wa_irid);
                statement.setString(4, oDObject.branch.getId());
                statement.setString(5, oDObject.branch.getId());
                resultSet = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("ODOTable.extract(): " + sQLException.getMessage());
            }
            if (resultSet == null) continue;
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                string2 = resultSet.getString(2);
                string = resultSet.getString(3);
                oDObject2 = new ODObject(false, (String)charSequence, OBJECT_TYPE, string2);
                oDObject2.ivid = string;
                oDObject2.branch = oDObject.branch;
                oDObject2.setParentName(oDObject.getName());
                oDObject2.setParentID(oDObject.getIrid());
                oDObject2.branch = oDObject.branch;
                arrayList.add(oDObject2);
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
        if (statement2 != null) {
            statement2.close();
        }
        return arrayList;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        Statement statement = null;
        this.col_statement = null;
        this.sel_statement = null;
        this.wh_statement = null;
        for (ODObject oDObject : list) {
            Object object;
            if (!OBJECT_TYPE.equalsIgnoreCase(oDObject.getType())) continue;
            String string = oDObject.getIrid();
            if (statement == null) {
                object = "SELECT CLUSTER_REFERENCE,OVERRIDE_SELECT_TEXT_FLAG,UPDATABLE_FLAG, REMARK FROM CI_SNAPSHOT_DEFINITIONS WHERE ivid = ? ";
                statement = connection.prepareStatement((String)object);
            }
            object = null;
            try {
                statement.setString(1, oDObject.ivid);
                object = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("ODOSnapshot.generate():", sQLException);
            }
            if (object != null) {
                if (object.next()) {
                    Object object2;
                    String string2 = object.getString("CLUSTER_REFERENCE");
                    String string3 = object.getString("OVERRIDE_SELECT_TEXT_FLAG");
                    String string4 = object.getString("UPDATABLE_FLAG");
                    String string5 = object.getString("REMARK");
                    Table table = this.getDesign().getRelationalDesign().createTable();
                    table.setName(oDObject.getName());
                    table.setTypeID(this.getView().getCurrentDesign().getDLSettings().getClassificationTypeByName(ContainerObject.TYPE_SUMMARY).getTypeID());
                    SnapshotOracle snapshotOracle = ((StorageDesignOracle)this.getStorageDesign()).getSnapshotSet().createSnapshot();
                    snapshotOracle.setName(oDObject.getName());
                    this.getExtractionHandler().addToImportedObjects(string, snapshotOracle);
                    this.setNotesAndComments(connection, snapshotOracle, string);
                    snapshotOracle.setCommentInRDBMS(string5);
                    if ("Y".equalsIgnoreCase(string4)) {
                        snapshotOracle.setForUpdate("YES");
                    } else {
                        snapshotOracle.setForUpdate("NO");
                    }
                    TableProxyOracle tableProxyOracle = (TableProxyOracle)this.getStorageDesign().getTableProxySet().getProxy(table.getObjectID());
                    if (tableProxyOracle != null) {
                        tableProxyOracle.setSnapshot(snapshotOracle);
                    }
                    this.initColumns(connection, table, string, tableProxyOracle, oDObject.ivid, snapshotOracle);
                    this.createDBSynonyms(connection, oDObject.getName(), oDObject.ivid);
                    if ("Y".equalsIgnoreCase(string3)) {
                        object2 = this.getSelectStatement(connection, string, oDObject.ivid) + "\n" + this.getWhereStatement(connection, string, oDObject.ivid);
                        snapshotOracle.setSubquery((String)object2);
                    }
                    if (string2 != null && (object2 = (ClusterOracle)this.getExtractionHandler().getImportedObject(string2)) != null) {
                        snapshotOracle.setCluster((ClusterOracle)object2);
                        tableProxyOracle.setCluster((ClusterOracle)object2);
                    }
                }
                object.close();
            }
            importLogger.incrementImportedStatements();
        }
        if (statement != null) {
            statement.close();
        }
        if (this.col_statement != null) {
            this.col_statement.close();
        }
        if (this.sel_statement != null) {
            this.sel_statement.close();
        }
        if (this.wh_statement != null) {
            this.wh_statement.close();
        }
    }

    private void initColumns(Connection connection, Table table, String string, TableProxyOracle tableProxyOracle, String string2, SnapshotOracle snapshotOracle) throws Exception {
        Object object;
        if (this.col_statement == null) {
            object = "SELECT c.name,c.id,  c.DATATYPE, DECIMAL_PLACES,CLUSTER_COLUMN_REFERENCE,c.DOMAIN_REFERENCE,NULL_INDICATOR,c.DEFAULT_VALUE,c.MAXIMUM_LENGTH, OBJECT_TYPE_INCLUSION,ORACLE_TYPE_REFERENCE from ci_columns c where parent_ivid = ? order by c.SEQUENCE_NUMBER";
            this.col_statement = connection.prepareStatement((String)object);
        }
        object = null;
        try {
            this.col_statement.setString(1, string2);
            object = this.col_statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("ODOSnapshot.initColumns():", sQLException);
        }
        if (object != null) {
            String string3 = null;
            boolean bl = true;
            while (object.next()) {
                Object object2;
                String string4 = object.getString("NAME");
                String string5 = object.getString("ID");
                String string6 = object.getString("DATATYPE");
                int n = object.getInt("DECIMAL_PLACES");
                String string7 = object.getString("CLUSTER_COLUMN_REFERENCE");
                String string8 = object.getString("domain_reference");
                String string9 = object.getString("NULL_INDICATOR");
                String string10 = object.getString("DEFAULT_VALUE");
                int n2 = object.getInt("MAXIMUM_LENGTH");
                String string11 = object.getString("OBJECT_TYPE_INCLUSION");
                String string12 = object.getString("ORACLE_TYPE_REFERENCE");
                Column column = table.createColumn();
                column.setDefaultValue(string10);
                column.setName(string4);
                this.getExtractionHandler().addToImportedObjects(string5, column);
                if ("NOT NULL".equalsIgnoreCase(string9)) {
                    column.setNullsAllowed(false);
                } else {
                    column.setNullsAllowed(true);
                }
                if (tableProxyOracle != null && string7 != null) {
                    if (bl) {
                        string3 = column.getName();
                        bl = false;
                    } else {
                        string3 = string3 + " , " + column.getName();
                    }
                    object2 = (ColumnProxy)this.getStorageDesign().getColumnProxySet().getProxy(column.getObjectID());
                    if (object2 != null) {
                        tableProxyOracle.setClusterColumns(((RelationalObjectProxy)object2).getObjectID());
                    }
                }
                if (string8 != null) {
                    object2 = this.getExtractionHandler().getImportedObject(string8);
                    if (object2 != null && object2 instanceof Domain) {
                        column.setUse((short)0);
                        column.setDomain((Domain)object2);
                    }
                } else if (string12 != null) {
                    object2 = (DesignObject)this.getExtractionHandler().getImportedObject(string12);
                    if (object2 != null) {
                        if (object2 instanceof StructuredType) {
                            column.setUse((short)3);
                            column.setStructuredType((StructuredType)object2);
                        } else if (object2 instanceof CollectionType) {
                            column.setUse((short)4);
                            column.setCollectionType((CollectionType)object2);
                        }
                        if ("REF".equalsIgnoreCase(string11)) {
                            column.setReference(true);
                        }
                    }
                } else {
                    object2 = StandardDatatypeNames.getUsedDatatypeName(string6);
                    LogicalDatatype logicalDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), (String)object2);
                    if (logicalDatatype != null) {
                        column.setUse((short)1);
                        column.setLogicalDatatype(logicalDatatype);
                        if (n > 0) {
                            column.setDataTypeParameter("precision", String.valueOf(n2));
                            column.setDataTypeParameter("scale", String.valueOf(n));
                        } else {
                            column.setDataTypeParameter("size", String.valueOf(n2));
                        }
                    } else {
                        LOGGER.warn("ODOSnapshot.initColumns() - Unable to find Logical DataType for: " + string6);
                    }
                }
                this.setNotesAndComments(connection, column, string5, string2);
            }
            object.close();
            if (string3 != null) {
                snapshotOracle.setClusterColumns(string3);
            }
        }
    }

    private String getSelectStatement(Connection connection, String string, String string2) throws Exception {
        Object object;
        String string3 = "";
        if (this.sel_statement == null) {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT").append(' ');
            ((StringBuffer)object).append("txt_text").append(' ');
            ((StringBuffer)object).append("FROM").append(' ');
            ((StringBuffer)object).append("rm_text_lines").append(' ');
            ((StringBuffer)object).append("WHERE").append(' ');
            ((StringBuffer)object).append("parent_ivid = ? ");
            ((StringBuffer)object).append("AND").append(' ');
            ((StringBuffer)object).append("txt_type").append('=').append("'LGEXPR'").append(' ');
            ((StringBuffer)object).append("ORDER BY").append(' ').append("TXT_SEQ");
            this.sel_statement = connection.prepareStatement(((StringBuffer)object).toString());
        }
        object = null;
        try {
            this.sel_statement.setString(1, string2);
            object = this.sel_statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("ODOSnapshot.getSelectStatement(): " + sQLException.getMessage());
        }
        if (object != null) {
            while (object.next()) {
                String string4 = object.getString("txt_text");
                if ("".equalsIgnoreCase(string3)) {
                    string3 = string4;
                    continue;
                }
                string3 = string3 + "\n" + string4;
            }
            object.close();
        }
        if (!"".equalsIgnoreCase(string3) && !string3.trim().toUpperCase().startsWith("SELECT")) {
            string3 = "SELECT " + string3.trim();
        }
        return string3;
    }

    private String getWhereStatement(Connection connection, String string, String string2) throws Exception {
        Object object;
        String string3 = "";
        if (this.wh_statement == null) {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT").append(' ');
            ((StringBuffer)object).append("txt_text").append(' ');
            ((StringBuffer)object).append("FROM").append(' ');
            ((StringBuffer)object).append("rm_text_lines").append(' ');
            ((StringBuffer)object).append("WHERE").append(' ');
            ((StringBuffer)object).append("parent_ivid = ? ");
            ((StringBuffer)object).append("AND").append(' ');
            ((StringBuffer)object).append("txt_type").append('=').append("'CDWHCL'").append(' ');
            ((StringBuffer)object).append("ORDER BY").append(' ').append("TXT_SEQ");
            this.wh_statement = connection.prepareStatement(((StringBuffer)object).toString());
        }
        object = null;
        try {
            this.wh_statement.setString(1, string2);
            object = this.wh_statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("ODOSnapshot.getWhereStatement(): " + sQLException.getMessage());
        }
        if (object != null) {
            while (object.next()) {
                String string4 = object.getString("txt_text");
                if ("".equalsIgnoreCase(string3)) {
                    string3 = string4;
                    continue;
                }
                string3 = string3 + "\n" + string4;
            }
            object.close();
        }
        if (!"".equalsIgnoreCase(string3) && !string3.trim().toUpperCase().startsWith("WHERE")) {
            string3 = "WHERE " + string3.trim();
        }
        return string3;
    }
}

