/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.oracledesigner.physical;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.oracledesigner.AbstractObjectHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODExtractionHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODObject;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class ODOSequence
extends AbstractObjectHandler {
    public static final String OBJECT_TYPE = "SEQUENCE";
    private static final Logger LOGGER = new Logger(ODOSequence.class);

    public ODOSequence(ODExtractionHandler oDExtractionHandler, ApplicationView applicationView) {
        super(oDExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        Statement statement = null;
        Statement statement2 = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (ODObject oDObject : list) {
            Object object;
            String string;
            String string2;
            CharSequence charSequence;
            ResultSet resultSet;
            if (!oDObject.isSelected()) continue;
            if (oDObject.branches.size() == 0) {
                resultSet = null;
                if (statement2 == null) {
                    charSequence = new StringBuffer();
                    ((StringBuffer)charSequence).append("select  a.NAME,a.ID,a.ivid    ");
                    ((StringBuffer)charSequence).append("from CI_SEQUENCES a,sdd_folder_members b , i$sdd_wa_context cc ");
                    ((StringBuffer)charSequence).append("where ");
                    ((StringBuffer)charSequence).append(" a.ID = b.member_object and b.folder_reference = ? ");
                    ((StringBuffer)charSequence).append(" and b.PARENT_IVID = ? ");
                    ((StringBuffer)charSequence).append("and cc.workarea_irid = ?  and a.ivid = cc.object_ivid and cc.wastebasket ='N' ");
                    ((StringBuffer)charSequence).append(" order by name ");
                    statement2 = connection.prepareStatement(((StringBuffer)charSequence).toString());
                }
                try {
                    statement2.setString(1, oDObject.getIrid());
                    statement2.setString(2, oDObject.ivid);
                    statement2.setString(3, oDObject.wa_irid);
                    resultSet = statement2.executeQuery();
                }
                catch (SQLException sQLException) {
                    LOGGER.error("ODOSequence.extract(): " + sQLException.getMessage());
                }
                if (resultSet == null) continue;
                while (resultSet.next()) {
                    charSequence = resultSet.getString(1);
                    string2 = resultSet.getString(2);
                    string = resultSet.getString(3);
                    object = new ODObject(false, (String)charSequence, OBJECT_TYPE, string2);
                    ((ODObject)object).ivid = string;
                    ((ODObject)object).setParentName(oDObject.getName());
                    ((ODObject)object).setParentID(oDObject.getIrid());
                    arrayList.add(object);
                }
                resultSet.close();
                continue;
            }
            if (oDObject.branch == null) continue;
            resultSet = null;
            if (statement == null) {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("select  a.NAME,a.ID,a.ivid, a.REMARK ");
                ((StringBuffer)charSequence).append("from CI_SEQUENCES a,sdd_folder_members b ");
                ((StringBuffer)charSequence).append("where ");
                ((StringBuffer)charSequence).append(" a.ID = b.member_object and b.folder_reference = ? ");
                ((StringBuffer)charSequence).append(" and b.PARENT_IVID = ? ");
                ((StringBuffer)charSequence).append("AND EXISTS \n");
                ((StringBuffer)charSequence).append("(SELECT 1 \n");
                ((StringBuffer)charSequence).append("FROM CI_SEQUENCES F, \n");
                ((StringBuffer)charSequence).append("  I$sdd_Wa_Context C \n");
                ((StringBuffer)charSequence).append("WHERE a.Irid        = F.Irid \n");
                ((StringBuffer)charSequence).append("AND F.Ivid          = C.Object_Ivid \n");
                ((StringBuffer)charSequence).append("AND C.Workarea_Irid = ? \n");
                ((StringBuffer)charSequence).append(")");
                ((StringBuffer)charSequence).append(" and a.ivid = ");
                ((StringBuffer)charSequence).append(" (select ivid from i$sdd_object_versions v ");
                ((StringBuffer)charSequence).append("  where ");
                ((StringBuffer)charSequence).append("  a.id = v.irid and ");
                ((StringBuffer)charSequence).append("  branch_id = ? ");
                ((StringBuffer)charSequence).append("  and sequence_in_branch  is not null");
                ((StringBuffer)charSequence).append("  and wastebasket='N' ");
                ((StringBuffer)charSequence).append("  and sequence_in_branch = ");
                ((StringBuffer)charSequence).append("   ( ");
                ((StringBuffer)charSequence).append("   select max(sequence_in_branch) from i$sdd_object_versions v2 ");
                ((StringBuffer)charSequence).append("     where ");
                ((StringBuffer)charSequence).append("     v2.irid = a.id");
                ((StringBuffer)charSequence).append("     and branch_id = ? ");
                ((StringBuffer)charSequence).append("     and sequence_in_branch  is not null ");
                ((StringBuffer)charSequence).append("     and wastebasket='N' ");
                ((StringBuffer)charSequence).append("   ) ");
                ((StringBuffer)charSequence).append("  )");
                ((StringBuffer)charSequence).append(" order by name ");
                statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
            }
            try {
                statement.setString(1, oDObject.getIrid());
                statement.setString(2, oDObject.ivid);
                statement.setString(3, oDObject.wa_irid);
                statement.setString(4, oDObject.branch.getId());
                statement.setString(5, oDObject.branch.getId());
                resultSet = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("ODOSequence.extract(): " + sQLException.getMessage());
            }
            if (resultSet == null) continue;
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                string2 = resultSet.getString(2);
                string = resultSet.getString(3);
                object = resultSet.getString(4);
                ODObject oDObject2 = new ODObject(false, (String)charSequence, OBJECT_TYPE, string2);
                oDObject2.ivid = string;
                oDObject2.branch = oDObject.branch;
                oDObject2.setParentName(oDObject.getName());
                oDObject2.setParentID(oDObject.getIrid());
                oDObject2.setDescription((String)object);
                oDObject2.branch = oDObject.branch;
                arrayList.add(oDObject2);
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
        if (statement2 != null) {
            statement2.close();
        }
        return arrayList;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        for (ODObject oDObject : list) {
            if (!OBJECT_TYPE.equalsIgnoreCase(oDObject.getType())) continue;
            SequenceOracle sequenceOracle = ((StorageDesignOracle)this.getStorageDesign()).getSequenceSet().createSequence();
            sequenceOracle.setName(oDObject.getName());
            sequenceOracle.setCommentInRDBMS(oDObject.getDescription());
            this.createDBSynonyms(connection, oDObject.getName(), oDObject.ivid);
            this.setNotesAndComments(connection, sequenceOracle, oDObject.getIrid(), oDObject.ivid);
            this.getExtractionHandler().addToImportedObjects(oDObject.getIrid(), sequenceOracle);
            importLogger.incrementImportedStatements();
        }
    }
}

