/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.oracledesigner.physical;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.oracledesigner.AbstractObjectHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODExtractionHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODObject;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterColumnOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterIndexOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class ODOCluster
extends AbstractObjectHandler {
    public static final String OBJECT_TYPE = "CLUSTER";
    private static final Logger LOGGER = new Logger(ODOCluster.class);
    PreparedStatement col_statement;
    PreparedStatement ind_statement;

    public ODOCluster(ODExtractionHandler oDExtractionHandler, ApplicationView applicationView) {
        super(oDExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection connection, List list) throws Exception {
        Statement statement = null;
        Statement statement2 = null;
        ArrayList<ODObject> arrayList = new ArrayList<ODObject>();
        for (ODObject oDObject : list) {
            ODObject oDObject2;
            String string;
            String string2;
            CharSequence charSequence;
            ResultSet resultSet;
            if (!oDObject.isSelected()) continue;
            if (oDObject.branches.size() == 0) {
                resultSet = null;
                if (statement2 == null) {
                    charSequence = new StringBuffer();
                    ((StringBuffer)charSequence).append("select  a.NAME,a.ID,a.ivid    ");
                    ((StringBuffer)charSequence).append("from CI_CLUSTERS a,sdd_folder_members b , i$sdd_wa_context cc ");
                    ((StringBuffer)charSequence).append("where ");
                    ((StringBuffer)charSequence).append(" a.ID = b.member_object and b.folder_reference = ? ");
                    ((StringBuffer)charSequence).append(" and b.PARENT_IVID = ? ");
                    ((StringBuffer)charSequence).append("and cc.workarea_irid = ?  and a.ivid = cc.object_ivid and cc.wastebasket ='N' ");
                    ((StringBuffer)charSequence).append(" order by name ");
                    statement2 = connection.prepareStatement(((StringBuffer)charSequence).toString());
                }
                try {
                    statement2.setString(1, oDObject.getIrid());
                    statement2.setString(2, oDObject.ivid);
                    statement2.setString(3, oDObject.wa_irid);
                    resultSet = statement2.executeQuery();
                }
                catch (SQLException sQLException) {
                    LOGGER.error("ODOCluster.extract(): " + sQLException.getMessage());
                }
                if (resultSet == null) continue;
                while (resultSet.next()) {
                    charSequence = resultSet.getString(1);
                    string2 = resultSet.getString(2);
                    string = resultSet.getString(3);
                    oDObject2 = new ODObject(false, (String)charSequence, OBJECT_TYPE, string2);
                    oDObject2.ivid = string;
                    oDObject2.setParentName(oDObject.getName());
                    oDObject2.setParentID(oDObject.getIrid());
                    arrayList.add(oDObject2);
                }
                resultSet.close();
                continue;
            }
            if (oDObject.branch == null) continue;
            resultSet = null;
            if (statement == null) {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("select  a.NAME,a.ID,a.ivid ");
                ((StringBuffer)charSequence).append("from CI_CLUSTERS a,sdd_folder_members b ");
                ((StringBuffer)charSequence).append("where ");
                ((StringBuffer)charSequence).append(" a.ID = b.member_object and b.folder_reference = ? ");
                ((StringBuffer)charSequence).append(" and b.PARENT_IVID = ? ");
                ((StringBuffer)charSequence).append("AND EXISTS \n");
                ((StringBuffer)charSequence).append("(SELECT 1 \n");
                ((StringBuffer)charSequence).append("FROM CI_CLUSTERS F, \n");
                ((StringBuffer)charSequence).append("  I$sdd_Wa_Context C \n");
                ((StringBuffer)charSequence).append("WHERE a.Irid        = F.Irid \n");
                ((StringBuffer)charSequence).append("AND F.Ivid          = C.Object_Ivid \n");
                ((StringBuffer)charSequence).append("AND C.Workarea_Irid = ? \n");
                ((StringBuffer)charSequence).append(")");
                ((StringBuffer)charSequence).append(" and a.ivid = ");
                ((StringBuffer)charSequence).append(" (select ivid from i$sdd_object_versions v ");
                ((StringBuffer)charSequence).append("  where ");
                ((StringBuffer)charSequence).append("  a.id = v.irid and ");
                ((StringBuffer)charSequence).append("  branch_id = ? ");
                ((StringBuffer)charSequence).append("  and sequence_in_branch  is not null");
                ((StringBuffer)charSequence).append("  and wastebasket='N' ");
                ((StringBuffer)charSequence).append("  and sequence_in_branch = ");
                ((StringBuffer)charSequence).append("   ( ");
                ((StringBuffer)charSequence).append("   select max(sequence_in_branch) from i$sdd_object_versions v2 ");
                ((StringBuffer)charSequence).append("     where ");
                ((StringBuffer)charSequence).append("     v2.irid = a.id");
                ((StringBuffer)charSequence).append("     and branch_id = ? ");
                ((StringBuffer)charSequence).append("     and sequence_in_branch  is not null ");
                ((StringBuffer)charSequence).append("     and wastebasket='N' ");
                ((StringBuffer)charSequence).append("   ) ");
                ((StringBuffer)charSequence).append("  )");
                ((StringBuffer)charSequence).append(" order by name ");
                statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
            }
            try {
                statement.setString(1, oDObject.getIrid());
                statement.setString(2, oDObject.ivid);
                statement.setString(3, oDObject.wa_irid);
                statement.setString(4, oDObject.branch.getId());
                statement.setString(5, oDObject.branch.getId());
                resultSet = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("ODOCluster.extract(): " + sQLException.getMessage());
            }
            if (resultSet == null) continue;
            while (resultSet.next()) {
                charSequence = resultSet.getString(1);
                string2 = resultSet.getString(2);
                string = resultSet.getString(3);
                oDObject2 = new ODObject(false, (String)charSequence, OBJECT_TYPE, string2);
                oDObject2.ivid = string;
                oDObject2.branch = oDObject.branch;
                oDObject2.setParentName(oDObject.getName());
                oDObject2.setParentID(oDObject.getIrid());
                oDObject2.branch = oDObject.branch;
                arrayList.add(oDObject2);
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
        if (statement2 != null) {
            statement2.close();
        }
        return arrayList;
    }

    @Override
    public void generate(Connection connection, List list, ImportLogger importLogger) throws Exception {
        Statement statement = null;
        this.col_statement = null;
        this.ind_statement = null;
        for (ODObject oDObject : list) {
            Object object;
            if (!OBJECT_TYPE.equalsIgnoreCase(oDObject.getType())) continue;
            String string = oDObject.getIrid();
            if (statement == null) {
                object = new StringBuffer();
                ((StringBuffer)object).append("SELECT").append(' ');
                ((StringBuffer)object).append("CLUSTER_SIZE").append(',');
                ((StringBuffer)object).append("CLUSTER_TYPE").append(',');
                ((StringBuffer)object).append("HASH_IS").append(',');
                ((StringBuffer)object).append("HASHKEYS").append(',');
                ((StringBuffer)object).append("REMARK").append(' ');
                ((StringBuffer)object).append("FROM").append(' ');
                ((StringBuffer)object).append("CI_CLUSTERS").append(' ');
                ((StringBuffer)object).append("WHERE").append(' ');
                ((StringBuffer)object).append("ivid").append('=').append(" ? ");
                statement = connection.prepareStatement(((StringBuffer)object).toString());
            }
            object = null;
            try {
                statement.setString(1, oDObject.ivid);
                object = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                LOGGER.error("ODOCluster.generate():", sQLException);
            }
            if (object != null) {
                if (object.next()) {
                    int n = object.getInt("CLUSTER_SIZE");
                    String string2 = object.getString("CLUSTER_TYPE");
                    String string3 = object.getString("HASH_IS");
                    String string4 = object.getString("REMARK");
                    int n2 = object.getInt("HASHKEYS");
                    String string5 = oDObject.ivid;
                    ClusterOracle clusterOracle = ((StorageDesignOracle)this.getStorageDesign()).getClusterSet().createCluster();
                    clusterOracle.setName(oDObject.getName());
                    this.getExtractionHandler().addToImportedObjects(string, clusterOracle);
                    this.setNotesAndComments(connection, clusterOracle, string, string5);
                    clusterOracle.setCommentInRDBMS(string4);
                    clusterOracle.setSize(n);
                    if ("ICL".equalsIgnoreCase(string2)) {
                        clusterOracle.setIndexed("YES");
                    } else {
                        clusterOracle.setIndexed("NO");
                        clusterOracle.setHashExpression(string3);
                        clusterOracle.setHashKeys(n2);
                    }
                    this.initIndexes(connection, clusterOracle, string, string5);
                    this.initColumns(connection, clusterOracle, string, string5);
                }
                object.close();
            }
            importLogger.incrementImportedStatements();
        }
        if (statement != null) {
            statement.close();
        }
        if (this.col_statement != null) {
            this.col_statement.close();
        }
        if (this.ind_statement != null) {
            this.ind_statement.close();
        }
    }

    public void initIndexes(Connection connection, ClusterOracle clusterOracle, String string, String string2) throws Exception {
        Object object;
        if (this.ind_statement == null) {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT").append(' ');
            ((StringBuffer)object).append("NAME").append(',');
            ((StringBuffer)object).append("COMPUTE_STATISTICS_FLAG").append(',');
            ((StringBuffer)object).append("REMARK").append(' ');
            ((StringBuffer)object).append("FROM").append(' ');
            ((StringBuffer)object).append("ci_indexes").append(' ');
            ((StringBuffer)object).append("WHERE").append(' ');
            ((StringBuffer)object).append(" parent_ivid = ? ");
            this.ind_statement = connection.prepareStatement(((StringBuffer)object).toString());
        }
        object = null;
        try {
            this.ind_statement.setString(1, string2);
            object = this.ind_statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("ODOCluster.initIndexes(): " + sQLException.getMessage());
        }
        if (object != null) {
            while (object.next()) {
                String string3 = object.getString("NAME");
                String string4 = object.getString("COMPUTE_STATISTICS_FLAG");
                String string5 = object.getString("REMARK");
                ClusterIndexOracle clusterIndexOracle = ((StorageDesignOracle)this.getStorageDesign()).getClusterIndexSet().createClusterIndex();
                clusterIndexOracle.setName(string3);
                clusterIndexOracle.setCluster(clusterOracle);
                clusterIndexOracle.setComment(string5);
                if ("Y".equalsIgnoreCase(string4)) {
                    clusterIndexOracle.setComputeStatistics("YES");
                    continue;
                }
                clusterIndexOracle.setComputeStatistics("NO");
            }
            object.close();
        }
    }

    public void initColumns(Connection connection, ClusterOracle clusterOracle, String string, String string2) throws Exception {
        Object object;
        if (this.col_statement == null) {
            object = new StringBuffer();
            ((StringBuffer)object).append("SELECT").append(' ');
            ((StringBuffer)object).append("NAME").append(',');
            ((StringBuffer)object).append("ID").append(',');
            ((StringBuffer)object).append("DATATYPE").append(',');
            ((StringBuffer)object).append("LENGTH").append(',');
            ((StringBuffer)object).append("SCALE").append(' ').append("DECIMAL_PLACES").append(' ');
            ((StringBuffer)object).append("FROM").append(' ');
            ((StringBuffer)object).append("CI_CLUSTER_COLUMNS").append(' ');
            ((StringBuffer)object).append("WHERE").append(' ');
            ((StringBuffer)object).append(" parent_ivid = ? ");
            ((StringBuffer)object).append("ORDER BY").append(' ').append("SEQUENCE_NUMBER");
            this.col_statement = connection.prepareStatement(((StringBuffer)object).toString());
        }
        object = null;
        try {
            this.col_statement.setString(1, string2);
            object = this.col_statement.executeQuery();
        }
        catch (SQLException sQLException) {
            LOGGER.error("ODOCluster.initColumns(): " + sQLException.getMessage());
        }
        if (object != null) {
            int n = 0;
            while (object.next()) {
                ++n;
                String string3 = object.getString("NAME");
                String string4 = object.getString("ID");
                String string5 = object.getString("DATATYPE");
                int n2 = object.getInt("LENGTH");
                int n3 = object.getInt("DECIMAL_PLACES");
                ClusterColumnOracle clusterColumnOracle = ((StorageDesignOracle)this.getStorageDesign()).getClusterColumnSet().createClusterColumn();
                clusterColumnOracle.setName(string3);
                clusterColumnOracle.setCluster(clusterOracle);
                clusterColumnOracle.setPosition(n);
                clusterColumnOracle.setDataType(string5);
                if (n2 > 0) {
                    if (n3 > 0) {
                        clusterColumnOracle.setLengthPrecision(String.valueOf(n2) + ", " + String.valueOf(n3));
                    } else if (!"NUMBER".equals(string5.trim())) {
                        clusterColumnOracle.setLengthPrecision(String.valueOf(n2));
                    }
                }
                this.setNotesAndComments(connection, clusterColumnOracle, string4);
            }
            object.close();
        }
    }
}

